/*
 * Decompiled with CFR 0.152.
 */
package com.basgeekball.awesomevalidation.validators;

import android.content.Context;
import android.content.res.ColorStateList;
import android.support.constraint.ConstraintLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.basgeekball.awesomevalidation.AwesomeValidation;
import com.basgeekball.awesomevalidation.ValidationHolder;
import com.basgeekball.awesomevalidation.exception.MissingContextException;
import com.basgeekball.awesomevalidation.exception.UnsupportedLayoutException;
import com.basgeekball.awesomevalidation.utility.ValidationCallback;
import com.basgeekball.awesomevalidation.utility.ViewsInfo;
import com.basgeekball.awesomevalidation.validators.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;

public class UnderlabelValidator
extends Validator {
    private Context mContext;
    private ArrayList<ViewsInfo> mViewsInfos = new ArrayList();
    private int mColor;
    private boolean mHasFailed = false;
    private ValidationCallback mValidationCallback;
    private HashMap<EditText, TextWatcher> mTextWatcherForEditText = new HashMap();

    private void init() {
        this.mValidationCallback = new ValidationCallback(){

            @Override
            public void execute(ValidationHolder validationHolder, Matcher matcher) {
                TextView textView = UnderlabelValidator.this.replaceView(validationHolder);
                if (AwesomeValidation.isAutoFocusOnFirstFailureEnabled() && !UnderlabelValidator.this.mHasFailed) {
                    textView.setFocusable(true);
                    textView.setFocusableInTouchMode(true);
                    textView.setClickable(true);
                    textView.requestFocus();
                    UnderlabelValidator.this.mHasFailed = true;
                }
                ViewCompat.setBackgroundTintList((View)validationHolder.getEditText(), (ColorStateList)ColorStateList.valueOf((int)UnderlabelValidator.this.mColor));
            }
        };
    }

    public void setContext(Context context) {
        this.mContext = context;
        this.setColorByResource(0x1060016);
        this.init();
    }

    public void setColor(int n) {
        this.mColor = n;
    }

    public void setColorByResource(int n) {
        if (this.mContext == null) {
            throw new MissingContextException("Context should be set before setting color for Underlabel style.");
        }
        this.mColor = ContextCompat.getColor((Context)this.mContext, (int)n);
    }

    @Override
    public boolean trigger() {
        this.halt();
        return this.checkFields(this.mValidationCallback);
    }

    @Override
    public void halt() {
        for (ViewsInfo object : this.mViewsInfos) {
            object.restoreViews();
        }
        Iterator<Map.Entry<EditText, TextWatcher>> iterator = this.mValidationHolderList.iterator();
        while (iterator.hasNext()) {
            ValidationHolder validationHolder = (ValidationHolder)((Object)iterator.next());
            if (!validationHolder.isSomeSortOfView()) continue;
            validationHolder.resetCustomError();
        }
        if (AwesomeValidation.isAutoFocusOnFirstFailureEnabled() && this.mValidationHolderList.size() > 0 && !((ValidationHolder)((Object)(iterator = (ValidationHolder)this.mValidationHolderList.get(0)))).isSomeSortOfView()) {
            ((ValidationHolder)((Object)iterator)).getEditText().requestFocus();
        }
        this.mViewsInfos.clear();
        this.mHasFailed = false;
        for (Map.Entry<EditText, TextWatcher> entry : this.mTextWatcherForEditText.entrySet()) {
            entry.getKey().removeTextChangedListener(entry.getValue());
        }
    }

    private TextView replaceView(ValidationHolder validationHolder) {
        final EditText editText = validationHolder.getEditText();
        ViewGroup viewGroup = (ViewGroup)editText.getParent();
        if (viewGroup instanceof ConstraintLayout) {
            throw new UnsupportedLayoutException("UnderlabelValidator doesn't support ConstraintLayout, please use TextInputLayoutValidator or other any other validator.");
        }
        int n = viewGroup.indexOfChild((View)editText);
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setLayoutParams(editText.getLayoutParams());
        linearLayout.setOrientation(1);
        TextView textView = new TextView(this.mContext);
        textView.setText((CharSequence)validationHolder.getErrMsg());
        textView.setTextColor(this.mColor);
        textView.setPadding(editText.getPaddingLeft(), 0, editText.getPaddingRight(), 0);
        textView.startAnimation(AnimationUtils.loadAnimation((Context)this.mContext, (int)0x10A0000));
        viewGroup.removeView((View)editText);
        linearLayout.addView((View)editText);
        linearLayout.addView((View)textView);
        viewGroup.addView((View)linearLayout, n);
        final ViewsInfo viewsInfo = new ViewsInfo(n, viewGroup, linearLayout, editText);
        this.mViewsInfos.add(viewsInfo);
        TextWatcher textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                editText.removeTextChangedListener((TextWatcher)this);
                viewsInfo.restoreViews();
                editText.requestFocus();
            }

            public void afterTextChanged(Editable editable) {
            }
        };
        editText.addTextChangedListener(textWatcher);
        this.mTextWatcherForEditText.put(editText, textWatcher);
        return textView;
    }
}

