/*
 * Decompiled with CFR 0.152.
 */
package com.basgeekball.awesomevalidation.validators;

import android.app.Activity;
import android.support.design.widget.TextInputLayout;
import android.view.View;
import android.widget.EditText;
import com.basgeekball.awesomevalidation.AwesomeValidation;
import com.basgeekball.awesomevalidation.ValidationHolder;
import com.basgeekball.awesomevalidation.model.NumericRange;
import com.basgeekball.awesomevalidation.utility.ValidationCallback;
import com.basgeekball.awesomevalidation.utility.custom.CustomErrorReset;
import com.basgeekball.awesomevalidation.utility.custom.CustomValidation;
import com.basgeekball.awesomevalidation.utility.custom.CustomValidationCallback;
import com.basgeekball.awesomevalidation.utility.custom.SimpleCustomValidation;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Validator {
    protected ArrayList<ValidationHolder> mValidationHolderList = new ArrayList();
    private boolean mHasFailed = false;

    Validator() {
    }

    public void set(EditText editText, String string, String string2) {
        Pattern pattern = Pattern.compile(string);
        ValidationHolder validationHolder = new ValidationHolder(editText, pattern, string2);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(TextInputLayout textInputLayout, String string, String string2) {
        Pattern pattern = Pattern.compile(string);
        ValidationHolder validationHolder = new ValidationHolder(textInputLayout, pattern, string2);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(Activity activity, int n, String string, int n2) {
        View view = activity.findViewById(n);
        String string2 = activity.getResources().getString(n2);
        if (view instanceof EditText) {
            this.set((EditText)view, string, string2);
        } else if (view instanceof TextInputLayout) {
            this.set((TextInputLayout)view, string, string2);
        }
    }

    public void set(EditText editText, Pattern pattern, String string) {
        ValidationHolder validationHolder = new ValidationHolder(editText, pattern, string);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(TextInputLayout textInputLayout, Pattern pattern, String string) {
        ValidationHolder validationHolder = new ValidationHolder(textInputLayout, pattern, string);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(Activity activity, int n, Pattern pattern, int n2) {
        View view = activity.findViewById(n);
        String string = activity.getResources().getString(n2);
        if (view instanceof EditText) {
            this.set((EditText)view, pattern, string);
        } else if (view instanceof TextInputLayout) {
            this.set((TextInputLayout)view, pattern, string);
        }
    }

    public void set(EditText editText, NumericRange numericRange, String string) {
        ValidationHolder validationHolder = new ValidationHolder(editText, numericRange, string);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(TextInputLayout textInputLayout, NumericRange numericRange, String string) {
        ValidationHolder validationHolder = new ValidationHolder(textInputLayout, numericRange, string);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(Activity activity, int n, NumericRange numericRange, int n2) {
        View view = activity.findViewById(n);
        String string = activity.getResources().getString(n2);
        if (view instanceof EditText) {
            this.set((EditText)view, numericRange, string);
        } else if (view instanceof TextInputLayout) {
            this.set((TextInputLayout)view, numericRange, string);
        }
    }

    public void set(EditText editText, EditText editText2, String string) {
        ValidationHolder validationHolder = new ValidationHolder(editText, editText2, string);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(TextInputLayout textInputLayout, TextInputLayout textInputLayout2, String string) {
        ValidationHolder validationHolder = new ValidationHolder(textInputLayout, textInputLayout2, string);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(Activity activity, int n, int n2, int n3) {
        View view = activity.findViewById(n);
        View view2 = activity.findViewById(n2);
        String string = activity.getResources().getString(n3);
        if (view2 instanceof EditText) {
            this.set((EditText)view, (EditText)view2, string);
        } else if (view2 instanceof TextInputLayout) {
            this.set((TextInputLayout)view, (TextInputLayout)view2, string);
        }
    }

    public void set(EditText editText, SimpleCustomValidation simpleCustomValidation, String string) {
        ValidationHolder validationHolder = new ValidationHolder(editText, simpleCustomValidation, string);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(TextInputLayout textInputLayout, SimpleCustomValidation simpleCustomValidation, String string) {
        ValidationHolder validationHolder = new ValidationHolder(textInputLayout, simpleCustomValidation, string);
        this.mValidationHolderList.add(validationHolder);
    }

    public void set(Activity activity, int n, SimpleCustomValidation simpleCustomValidation, int n2) {
        View view = activity.findViewById(n);
        String string = activity.getResources().getString(n2);
        if (view instanceof EditText) {
            this.set((EditText)view, simpleCustomValidation, string);
        } else if (view instanceof TextInputLayout) {
            this.set((TextInputLayout)view, simpleCustomValidation, string);
        }
    }

    public void set(Activity activity, int n, CustomValidation customValidation, CustomValidationCallback customValidationCallback, CustomErrorReset customErrorReset, int n2) {
        View view = activity.findViewById(n);
        String string = activity.getResources().getString(n2);
        this.set(view, customValidation, customValidationCallback, customErrorReset, string);
    }

    public void set(View view, CustomValidation customValidation, CustomValidationCallback customValidationCallback, CustomErrorReset customErrorReset, String string) {
        ValidationHolder validationHolder = new ValidationHolder(view, customValidation, customValidationCallback, customErrorReset, string);
        this.mValidationHolderList.add(validationHolder);
    }

    protected boolean checkFields(ValidationCallback validationCallback) {
        boolean bl = true;
        this.mHasFailed = false;
        for (ValidationHolder validationHolder : this.mValidationHolderList) {
            if (!validationHolder.isVisible()) continue;
            if (validationHolder.isRegexType()) {
                bl = this.checkRegexTypeField(validationHolder, validationCallback) && bl;
                continue;
            }
            if (validationHolder.isRangeType()) {
                bl = this.checkRangeTypeField(validationHolder, validationCallback) && bl;
                continue;
            }
            if (validationHolder.isConfirmationType()) {
                bl = this.checkConfirmationTypeField(validationHolder, validationCallback) && bl;
                continue;
            }
            if (validationHolder.isSimpleCustomType()) {
                bl = this.checkSimpleCustomTypeField(validationHolder, validationCallback) && bl;
                continue;
            }
            if (!validationHolder.isCustomType()) continue;
            bl = this.checkCustomTypeField(validationHolder, validationHolder.getCustomValidationCallback()) && bl;
        }
        return bl;
    }

    private boolean checkRegexTypeField(ValidationHolder validationHolder, ValidationCallback validationCallback) {
        Matcher matcher = validationHolder.getPattern().matcher(validationHolder.getText());
        if (!matcher.matches()) {
            this.executeCallback(validationCallback, validationHolder, matcher);
            return false;
        }
        return true;
    }

    private boolean checkRangeTypeField(ValidationHolder validationHolder, ValidationCallback validationCallback) {
        boolean bl;
        try {
            bl = validationHolder.getNumericRange().isValid(validationHolder.getText());
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl) {
            Matcher matcher = Pattern.compile("\u00b1*~=").matcher(validationHolder.getText());
            this.executeCallback(validationCallback, validationHolder, matcher);
            return false;
        }
        return true;
    }

    private boolean checkConfirmationTypeField(ValidationHolder validationHolder, ValidationCallback validationCallback) {
        boolean bl = validationHolder.getText().equals(validationHolder.getConfirmationText());
        if (!bl) {
            this.executeCallback(validationCallback, validationHolder, null);
            return false;
        }
        return true;
    }

    private boolean checkSimpleCustomTypeField(ValidationHolder validationHolder, ValidationCallback validationCallback) {
        boolean bl = validationHolder.getSimpleCustomValidation().compare(validationHolder.getText());
        if (!bl) {
            this.executeCallback(validationCallback, validationHolder, null);
            return false;
        }
        return true;
    }

    private boolean checkCustomTypeField(ValidationHolder validationHolder, CustomValidationCallback customValidationCallback) {
        boolean bl = validationHolder.getCustomValidation().compare(validationHolder);
        if (!bl) {
            this.executeCustomCallback(customValidationCallback, validationHolder);
            return false;
        }
        return true;
    }

    private void executeCallback(ValidationCallback validationCallback, ValidationHolder validationHolder, Matcher matcher) {
        validationCallback.execute(validationHolder, matcher);
        this.requestFocus(validationHolder);
    }

    private void executeCustomCallback(CustomValidationCallback customValidationCallback, ValidationHolder validationHolder) {
        customValidationCallback.execute(validationHolder);
    }

    private void requestFocus(ValidationHolder validationHolder) {
        if (AwesomeValidation.isAutoFocusOnFirstFailureEnabled() && !this.mHasFailed) {
            EditText editText = validationHolder.getEditText();
            editText.requestFocus();
            editText.setSelection(editText.getText().length());
            this.mHasFailed = true;
        }
    }

    public abstract boolean trigger();

    public abstract void halt();
}

