/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.bucket;

import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.bucket.TunableCAPProps;
import com.basho.riak.client.bucket.VClockPruneProps;
import com.basho.riak.client.builders.BucketPropertiesBuilder;
import com.basho.riak.client.cap.Quorum;
import com.basho.riak.client.query.functions.NamedErlangFunction;
import com.basho.riak.client.query.functions.NamedFunction;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBucketProperties
implements BucketProperties {
    private final Boolean allowSiblings;
    private final Boolean lastWriteWins;
    private final Integer nVal;
    private final String backend;
    private final VClockPruneProps vclockProps;
    private final Collection<NamedFunction> precommitHooks;
    private final Collection<NamedErlangFunction> postcommitHooks;
    private final TunableCAPProps capProps;
    private final NamedErlangFunction chashKeyFunction;
    private final NamedErlangFunction linkWalkFunction;
    private final Boolean search;

    public DefaultBucketProperties(Boolean allowSiblings, Boolean lastWriteWins, Integer nVal, String backend, VClockPruneProps vclockProps, Collection<NamedFunction> precommitHooks, Collection<NamedErlangFunction> postcommitHooks, TunableCAPProps capProps, NamedErlangFunction chashKeyFunction, NamedErlangFunction linkWalkFunction, Boolean search) {
        this.allowSiblings = allowSiblings;
        this.lastWriteWins = lastWriteWins;
        this.nVal = nVal;
        this.backend = backend;
        this.vclockProps = vclockProps;
        this.precommitHooks = precommitHooks;
        this.postcommitHooks = postcommitHooks;
        this.capProps = capProps;
        this.chashKeyFunction = chashKeyFunction;
        this.linkWalkFunction = linkWalkFunction;
        this.search = search;
    }

    @Override
    public Boolean getAllowSiblings() {
        return this.allowSiblings;
    }

    @Override
    public Boolean getLastWriteWins() {
        return this.lastWriteWins;
    }

    @Override
    public Integer getNVal() {
        return this.nVal;
    }

    @Override
    public String getBackend() {
        return this.backend;
    }

    @Override
    public Integer getSmallVClock() {
        return this.vclockProps.getSmallVClock();
    }

    @Override
    public Integer getBigVClock() {
        return this.vclockProps.getBigVClock();
    }

    @Override
    public Long getYoungVClock() {
        return this.vclockProps.getYoungVClock();
    }

    @Override
    public Long getOldVClock() {
        return this.vclockProps.getOldVClock();
    }

    @Override
    public Collection<NamedFunction> getPrecommitHooks() {
        return this.precommitHooks;
    }

    @Override
    public Collection<NamedErlangFunction> getPostcommitHooks() {
        return this.postcommitHooks;
    }

    @Override
    public Quorum getR() {
        return this.capProps.getR();
    }

    @Override
    public Quorum getW() {
        return this.capProps.getW();
    }

    @Override
    public Quorum getRW() {
        return this.capProps.getRW();
    }

    @Override
    public Quorum getDW() {
        return this.capProps.getDW();
    }

    @Override
    public Quorum getPR() {
        return this.capProps.getPR();
    }

    @Override
    public Quorum getPW() {
        return this.capProps.getPW();
    }

    @Override
    public Boolean getBasicQuorum() {
        return this.capProps.getBasicQuorum();
    }

    @Override
    public Boolean getNotFoundOK() {
        return this.capProps.getNotFoundOK();
    }

    @Override
    public NamedErlangFunction getChashKeyFunction() {
        return this.chashKeyFunction;
    }

    @Override
    public NamedErlangFunction getLinkWalkFunction() {
        return this.linkWalkFunction;
    }

    public BucketPropertiesBuilder fromMe() {
        return DefaultBucketProperties.from(this);
    }

    public static BucketPropertiesBuilder from(DefaultBucketProperties properties) {
        return BucketPropertiesBuilder.from(properties);
    }

    @Override
    public Boolean getSearch() {
        return this.search;
    }

    @Override
    public boolean isSearchEnabled() {
        return Boolean.TRUE.equals(this.search) || this.precommitHooks != null && this.precommitHooks.contains(NamedErlangFunction.SEARCH_PRECOMMIT_HOOK);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowSiblings == null ? 0 : this.allowSiblings.hashCode());
        result = 31 * result + (this.backend == null ? 0 : this.backend.hashCode());
        result = 31 * result + (this.capProps == null ? 0 : this.capProps.hashCode());
        result = 31 * result + (this.chashKeyFunction == null ? 0 : this.chashKeyFunction.hashCode());
        result = 31 * result + (this.lastWriteWins == null ? 0 : this.lastWriteWins.hashCode());
        result = 31 * result + (this.linkWalkFunction == null ? 0 : this.linkWalkFunction.hashCode());
        result = 31 * result + (this.nVal == null ? 0 : this.nVal.hashCode());
        result = 31 * result + (this.postcommitHooks == null ? 0 : this.postcommitHooks.hashCode());
        result = 31 * result + (this.precommitHooks == null ? 0 : this.precommitHooks.hashCode());
        result = 31 * result + (this.search == null ? 0 : this.search.hashCode());
        result = 31 * result + (this.vclockProps == null ? 0 : this.vclockProps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultBucketProperties)) {
            return false;
        }
        DefaultBucketProperties other = (DefaultBucketProperties)obj;
        if (this.allowSiblings == null ? other.allowSiblings != null : !this.allowSiblings.equals(other.allowSiblings)) {
            return false;
        }
        if (this.backend == null ? other.backend != null : !this.backend.equals(other.backend)) {
            return false;
        }
        if (this.capProps == null ? other.capProps != null : !this.capProps.equals(other.capProps)) {
            return false;
        }
        if (this.chashKeyFunction == null ? other.chashKeyFunction != null : !this.chashKeyFunction.equals(other.chashKeyFunction)) {
            return false;
        }
        if (this.lastWriteWins == null ? other.lastWriteWins != null : !this.lastWriteWins.equals(other.lastWriteWins)) {
            return false;
        }
        if (this.linkWalkFunction == null ? other.linkWalkFunction != null : !this.linkWalkFunction.equals(other.linkWalkFunction)) {
            return false;
        }
        if (this.nVal == null ? other.nVal != null : !this.nVal.equals(other.nVal)) {
            return false;
        }
        if (this.postcommitHooks == null ? other.postcommitHooks != null : !this.postcommitHooks.equals(other.postcommitHooks)) {
            return false;
        }
        if (this.precommitHooks == null ? other.precommitHooks != null : !this.precommitHooks.equals(other.precommitHooks)) {
            return false;
        }
        if (this.search == null ? other.search != null : !this.search.equals(other.search)) {
            return false;
        }
        return !(this.vclockProps == null ? other.vclockProps != null : !this.vclockProps.equals(other.vclockProps));
    }

    public String toString() {
        return String.format("DefaultBucketProperties [allowSiblings=%s, lastWriteWins=%s, nVal=%s, backend=%s, vclockProps=%s, precommitHooks=%s, postcommitHooks=%s, capProps=%s, chashKeyFunction=%s, linkWalkFunction=%s, search=%s]", this.allowSiblings, this.lastWriteWins, this.nVal, this.backend, this.vclockProps, this.precommitHooks, this.postcommitHooks, this.capProps, this.chashKeyFunction, this.linkWalkFunction, this.search);
    }
}

