/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.bucket;

import com.basho.riak.client.RiakException;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.builders.DomainBucketBuilder;
import com.basho.riak.client.cap.ConflictResolver;
import com.basho.riak.client.cap.Mutation;
import com.basho.riak.client.cap.MutationProducer;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.Converter;
import com.basho.riak.client.convert.KeyUtil;
import com.basho.riak.client.convert.VClockUtil;
import com.basho.riak.client.operations.DeleteObject;
import com.basho.riak.client.operations.FetchObject;
import com.basho.riak.client.operations.MultiFetchObject;
import com.basho.riak.client.operations.StoreObject;
import com.basho.riak.client.query.MultiFetchFuture;
import com.basho.riak.client.raw.DeleteMeta;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.StoreMeta;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainBucket<T> {
    private final Bucket bucket;
    private final ConflictResolver<T> resolver;
    private final Converter<T> converter;
    private final MutationProducer<T> mutationProducer;
    private final StoreMeta storeMeta;
    private final FetchMeta fetchMeta;
    private final DeleteMeta deleteMeta;
    private final Class<T> clazz;
    private final Retrier retrier;
    private final boolean withoutFetch;

    public DomainBucket(Bucket bucket, ConflictResolver<T> resolver, Converter<T> converter, MutationProducer<T> mutationProducer, StoreMeta storeMeta, FetchMeta fetchMeta, DeleteMeta deleteMeta, Class<T> clazz, Retrier retrier, boolean withoutFetch) {
        this.bucket = bucket;
        this.resolver = resolver;
        this.converter = converter;
        this.mutationProducer = mutationProducer;
        this.storeMeta = storeMeta;
        this.fetchMeta = fetchMeta;
        this.deleteMeta = deleteMeta;
        this.clazz = clazz;
        this.retrier = retrier;
        this.withoutFetch = withoutFetch;
    }

    public DomainBucket(Bucket bucket, ConflictResolver<T> resolver, Converter<T> converter, MutationProducer<T> mutationProducer, StoreMeta storeMeta, FetchMeta fetchMeta, DeleteMeta deleteMeta, Class<T> clazz, Retrier retrier) {
        this(bucket, resolver, converter, mutationProducer, storeMeta, fetchMeta, deleteMeta, clazz, retrier, false);
    }

    public T store(T o) throws RiakException {
        Mutation<T> mutation = this.mutationProducer.produce(o);
        StoreObject<T> so = this.bucket.store(o).withConverter(this.converter).withMutator(mutation).withResolver(this.resolver).withRetrier(this.retrier);
        if (this.withoutFetch) {
            so.withoutFetch();
        }
        if (this.fetchMeta.getR() != null) {
            so.r(this.fetchMeta.getR());
        }
        if (this.storeMeta.hasW()) {
            so.w(this.storeMeta.getW());
        }
        if (this.storeMeta.hasDw()) {
            so.dw(this.storeMeta.getDw());
        }
        if (this.fetchMeta.hasPr()) {
            so.pr(this.fetchMeta.getPr());
        }
        if (this.storeMeta.hasPw()) {
            so.pw(this.storeMeta.getPw());
        }
        if (this.fetchMeta.hasBasicQuorum()) {
            so.basicQuorum(this.fetchMeta.getBasicQuorum());
        }
        if (this.fetchMeta.hasNotFoundOk()) {
            so.notFoundOK(this.fetchMeta.getNotFoundOK());
        }
        if (this.storeMeta.hasIfNotModified()) {
            so.ifNotModified(this.storeMeta.isIfNotModified());
        }
        if (this.storeMeta.hasIfNoneMatch()) {
            so.ifNoneMatch(this.storeMeta.isIfNoneMatch());
        }
        if (this.fetchMeta.hasReturnDeletedVClock()) {
            so.returnDeletedVClock(this.fetchMeta.getReturnDeletedVClock());
        }
        if (this.storeMeta.hasReturnBody()) {
            so.returnBody(this.storeMeta.getReturnBody());
        }
        return so.execute();
    }

    public T fetch(String key) throws RiakException {
        FetchObject<T> fo = this.bucket.fetch(key, this.clazz).withConverter(this.converter).withResolver(this.resolver).withRetrier(this.retrier);
        if (this.fetchMeta.hasR()) {
            fo.r(this.fetchMeta.getR());
        }
        if (this.fetchMeta.hasPr()) {
            fo.pr(this.fetchMeta.getPr());
        }
        if (this.fetchMeta.hasBasicQuorum()) {
            fo.basicQuorum(this.fetchMeta.getBasicQuorum());
        }
        if (this.fetchMeta.hasNotFoundOk()) {
            fo.notFoundOK(this.fetchMeta.getNotFoundOK());
        }
        if (this.fetchMeta.hasReturnDeletedVClock()) {
            fo.returnDeletedVClock(this.fetchMeta.getReturnDeletedVClock());
        }
        return fo.execute();
    }

    public T fetch(T o) throws RiakException {
        FetchObject<T> fo = this.bucket.fetch(o).withConverter(this.converter).withResolver(this.resolver).withRetrier(this.retrier);
        if (this.fetchMeta.hasR()) {
            fo.r(this.fetchMeta.getR());
        }
        if (this.fetchMeta.hasPr()) {
            fo.pr(this.fetchMeta.getPr());
        }
        if (this.fetchMeta.hasBasicQuorum()) {
            fo.basicQuorum(this.fetchMeta.getBasicQuorum());
        }
        if (this.fetchMeta.hasNotFoundOk()) {
            fo.notFoundOK(this.fetchMeta.getNotFoundOK());
        }
        if (this.fetchMeta.hasReturnDeletedVClock()) {
            fo.returnDeletedVClock(this.fetchMeta.getReturnDeletedVClock());
        }
        return fo.execute();
    }

    public List<MultiFetchFuture<T>> multiFetch(String[] keys) {
        MultiFetchObject<T> fo = this.bucket.multiFetch(Arrays.asList(keys), this.clazz).withConverter(this.converter).withResolver(this.resolver).withRetrier(this.retrier);
        if (this.fetchMeta.hasR()) {
            fo.r(this.fetchMeta.getR());
        }
        if (this.fetchMeta.hasPr()) {
            fo.pr(this.fetchMeta.getPr());
        }
        if (this.fetchMeta.hasBasicQuorum()) {
            fo.basicQuorum(this.fetchMeta.getBasicQuorum());
        }
        if (this.fetchMeta.hasNotFoundOk()) {
            fo.notFoundOK(this.fetchMeta.getNotFoundOK());
        }
        if (this.fetchMeta.hasReturnDeletedVClock()) {
            fo.returnDeletedVClock(this.fetchMeta.getReturnDeletedVClock());
        }
        return fo.execute();
    }

    public List<MultiFetchFuture<T>> multiFetch(List<T> objs) {
        MultiFetchObject<T> fo = this.bucket.multiFetch(objs).withConverter(this.converter).withResolver(this.resolver).withRetrier(this.retrier);
        if (this.fetchMeta.hasR()) {
            fo.r(this.fetchMeta.getR());
        }
        if (this.fetchMeta.hasPr()) {
            fo.pr(this.fetchMeta.getPr());
        }
        if (this.fetchMeta.hasBasicQuorum()) {
            fo.basicQuorum(this.fetchMeta.getBasicQuorum());
        }
        if (this.fetchMeta.hasNotFoundOk()) {
            fo.notFoundOK(this.fetchMeta.getNotFoundOK());
        }
        if (this.fetchMeta.hasReturnDeletedVClock()) {
            fo.returnDeletedVClock(this.fetchMeta.getReturnDeletedVClock());
        }
        return fo.execute();
    }

    public void delete(T o) throws RiakException {
        String key = KeyUtil.getKey(o);
        VClock vclock = VClockUtil.getVClock(o);
        this.delete(key, vclock);
    }

    @Deprecated
    public void delete(String key) throws RiakException {
        this.delete(key, null);
    }

    public void delete(String key, VClock vclock) throws RiakException {
        DeleteObject delete = this.bucket.delete(key).withRetrier(this.retrier);
        if (this.deleteMeta.hasR()) {
            delete.r(this.deleteMeta.getR());
        }
        if (this.deleteMeta.hasPr()) {
            delete.pr(this.deleteMeta.getPr());
        }
        if (this.deleteMeta.hasW()) {
            delete.w(this.deleteMeta.getW());
        }
        if (this.deleteMeta.hasDw()) {
            delete.dw(this.deleteMeta.getDw());
        }
        if (this.deleteMeta.hasPw()) {
            delete.pw(this.deleteMeta.getPw());
        }
        if (null == vclock) {
            delete.fetchBeforeDelete(true);
        } else {
            delete.vclock(vclock);
        }
        delete.execute();
    }

    public static <T> DomainBucketBuilder<T> builder(Bucket b, Class<T> clazz) {
        return new DomainBucketBuilder<T>(b, clazz);
    }
}

