/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.builders;

import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.bucket.DomainBucket;
import com.basho.riak.client.cap.ClobberMutation;
import com.basho.riak.client.cap.ConflictResolver;
import com.basho.riak.client.cap.DefaultResolver;
import com.basho.riak.client.cap.DefaultRetrier;
import com.basho.riak.client.cap.Mutation;
import com.basho.riak.client.cap.MutationProducer;
import com.basho.riak.client.cap.Quora;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.convert.Converter;
import com.basho.riak.client.convert.JSONConverter;
import com.basho.riak.client.raw.DeleteMeta;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.StoreMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainBucketBuilder<T> {
    private final Bucket bucket;
    private final Class<T> clazz;
    private ConflictResolver<T> resolver = new DefaultResolver();
    private Converter<T> converter;
    private Mutation<T> mutation;
    private MutationProducer<T> mutationProducer;
    private Retrier retrier = DefaultRetrier.attempts(3);
    private boolean withoutFetch;
    private FetchMeta.Builder fetchMetaBuilder = new FetchMeta.Builder();
    private StoreMeta.Builder storeMetaBuilder = new StoreMeta.Builder();
    private DeleteMeta.Builder deleteMetaBuilder = new DeleteMeta.Builder();
    private boolean returnBody = false;

    public DomainBucketBuilder(Bucket bucket, Class<T> clazz) {
        this.bucket = bucket;
        this.clazz = clazz;
        this.converter = new JSONConverter<T>(clazz, bucket.getName());
    }

    public DomainBucket<T> build() {
        if (this.mutation != null && this.mutationProducer == null) {
            this.mutationProducer = new MutationProducer<T>(){

                @Override
                public Mutation<T> produce(T o) {
                    return DomainBucketBuilder.this.mutation;
                }
            };
        } else if (this.mutation == null && this.mutationProducer == null) {
            this.mutationProducer = new MutationProducer<T>(){

                @Override
                public Mutation<T> produce(T o) {
                    return new ClobberMutation(o);
                }
            };
        }
        return new DomainBucket<T>(this.bucket, this.resolver, this.converter, this.mutationProducer, this.storeMetaBuilder.returnBody(this.returnBody).build(), this.fetchMetaBuilder.build(), this.deleteMetaBuilder.build(), this.clazz, this.retrier, this.withoutFetch);
    }

    public DomainBucketBuilder<T> withResolver(ConflictResolver<T> resolver) {
        this.resolver = resolver;
        return this;
    }

    public DomainBucketBuilder<T> returnBody(boolean returnBody) {
        this.returnBody = returnBody;
        return this;
    }

    public DomainBucketBuilder<T> retrier(Retrier retrier) {
        this.retrier = retrier;
        return this;
    }

    public DomainBucketBuilder<T> w(int w) {
        this.storeMetaBuilder.w(w);
        this.deleteMetaBuilder.w(w);
        return this;
    }

    public DomainBucketBuilder<T> w(Quora w) {
        this.storeMetaBuilder.w(w);
        this.deleteMetaBuilder.w(w);
        return this;
    }

    public DomainBucketBuilder<T> r(int r) {
        this.fetchMetaBuilder.r(r);
        this.deleteMetaBuilder.r(r);
        return this;
    }

    public DomainBucketBuilder<T> r(Quora r) {
        this.fetchMetaBuilder.r(r);
        this.deleteMetaBuilder.r(r);
        return this;
    }

    public DomainBucketBuilder<T> rw(int rw) {
        this.deleteMetaBuilder.rw(rw);
        return this;
    }

    public DomainBucketBuilder<T> rw(Quora rw) {
        this.deleteMetaBuilder.rw(rw);
        return this;
    }

    public DomainBucketBuilder<T> dw(int dw) {
        this.storeMetaBuilder.dw(dw);
        this.deleteMetaBuilder.dw(dw);
        return this;
    }

    public DomainBucketBuilder<T> dw(Quora dw) {
        this.storeMetaBuilder.dw(dw);
        this.deleteMetaBuilder.dw(dw);
        return this;
    }

    public DomainBucketBuilder<T> notFoundOK(boolean notFoundOK) {
        this.fetchMetaBuilder.notFoundOK(notFoundOK);
        return this;
    }

    public DomainBucketBuilder<T> basicQuorum(boolean basicQuorum) {
        this.fetchMetaBuilder.basicQuorum(basicQuorum);
        return this;
    }

    public DomainBucketBuilder<T> returnDeletedVClock(boolean returnDeletedVClock) {
        this.fetchMetaBuilder.returnDeletedVClock(returnDeletedVClock);
        return this;
    }

    public DomainBucketBuilder<T> ifNotModified(boolean ifNotModified) {
        this.storeMetaBuilder.ifNotModified(ifNotModified);
        return this;
    }

    public DomainBucketBuilder<T> ifNoneMatch(boolean ifNoneMatch) {
        this.storeMetaBuilder.ifNoneMatch(ifNoneMatch);
        return this;
    }

    public DomainBucketBuilder<T> pr(int pr) {
        this.deleteMetaBuilder.pr(pr);
        this.fetchMetaBuilder.pr(pr);
        return this;
    }

    public DomainBucketBuilder<T> pr(Quora pr) {
        this.deleteMetaBuilder.pr(pr);
        this.fetchMetaBuilder.pr(pr);
        return this;
    }

    public DomainBucketBuilder<T> pw(int pw) {
        this.deleteMetaBuilder.pw(pw);
        this.storeMetaBuilder.pw(pw);
        return this;
    }

    public DomainBucketBuilder<T> pw(Quora pw) {
        this.deleteMetaBuilder.pw(pw);
        this.storeMetaBuilder.pw(pw);
        return this;
    }

    public DomainBucketBuilder<T> timeout(int timeout) {
        this.deleteMetaBuilder.timeout(timeout);
        this.storeMetaBuilder.timeout(timeout);
        this.fetchMetaBuilder.timeout(timeout);
        return this;
    }

    public DomainBucketBuilder<T> mutationProducer(MutationProducer<T> mutationProducer) {
        this.mutationProducer = mutationProducer;
        return this;
    }

    public DomainBucketBuilder<T> withConverter(Converter<T> converter) {
        this.converter = converter;
        return this;
    }

    public DomainBucketBuilder<T> withoutFetch(boolean withoutFetch) {
        this.withoutFetch = withoutFetch;
        return this;
    }
}

