/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.convert.reflect;

import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.RiakIndex;
import com.basho.riak.client.convert.RiakKey;
import com.basho.riak.client.convert.RiakLinks;
import com.basho.riak.client.convert.RiakTombstone;
import com.basho.riak.client.convert.RiakUsermeta;
import com.basho.riak.client.convert.RiakVClock;
import com.basho.riak.client.convert.UsermetaField;
import com.basho.riak.client.convert.reflect.AnnotationInfo;
import com.basho.riak.client.convert.reflect.ClassUtil;
import com.basho.riak.client.convert.reflect.RiakIndexField;
import com.basho.riak.client.convert.reflect.RiakIndexMethod;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScanner
implements Callable<AnnotationInfo> {
    private final Class classToScan;

    public AnnotationScanner(Class clazz) {
        this.classToScan = clazz;
    }

    @Override
    public AnnotationInfo call() throws Exception {
        Field riakKeyField = null;
        Method riakKeyGetterMethod = null;
        Method riakKeySetterMethod = null;
        Field riakVClockField = null;
        Field riakTombstoneField = null;
        Field usermetaMapField = null;
        Field linksField = null;
        ArrayList<UsermetaField> usermetaItemFields = new ArrayList<UsermetaField>();
        ArrayList<RiakIndexField> indexFields = new ArrayList<RiakIndexField>();
        ArrayList<RiakIndexMethod> indexMethods = new ArrayList<RiakIndexMethod>();
        for (Class currentClass = this.classToScan; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] fields = currentClass.getDeclaredFields();
            for (AccessibleObject accessibleObject : fields) {
                if (riakKeyField == null && accessibleObject.isAnnotationPresent(RiakKey.class)) {
                    riakKeyField = (Field)ClassUtil.checkAndFixAccess(accessibleObject);
                }
                if (riakVClockField == null && accessibleObject.isAnnotationPresent(RiakVClock.class)) {
                    if (!(((Field)accessibleObject).getType().isArray() && ((Field)accessibleObject).getType().getComponentType().equals(Byte.TYPE) || ((Field)accessibleObject).getType().isAssignableFrom(VClock.class))) {
                        throw new IllegalArgumentException(((Field)accessibleObject).getType().toString());
                    }
                    riakVClockField = (Field)ClassUtil.checkAndFixAccess(accessibleObject);
                }
                if (riakTombstoneField == null && accessibleObject.isAnnotationPresent(RiakTombstone.class)) {
                    if (!((Field)accessibleObject).getType().equals(Boolean.TYPE)) {
                        throw new IllegalArgumentException(((Field)accessibleObject).getType().toString());
                    }
                    riakTombstoneField = (Field)ClassUtil.checkAndFixAccess(accessibleObject);
                }
                if (accessibleObject.isAnnotationPresent(RiakUsermeta.class)) {
                    RiakUsermeta a = ((Field)accessibleObject).getAnnotation(RiakUsermeta.class);
                    String key = a.key();
                    if (!"".equals(key)) {
                        usermetaItemFields.add(new UsermetaField((Field)ClassUtil.checkAndFixAccess(accessibleObject)));
                    } else if (usermetaMapField == null) {
                        usermetaMapField = (Field)ClassUtil.checkAndFixAccess(accessibleObject);
                    }
                }
                if (accessibleObject.isAnnotationPresent(RiakIndex.class)) {
                    indexFields.add(new RiakIndexField((Field)ClassUtil.checkAndFixAccess(accessibleObject)));
                }
                if (linksField != null || !accessibleObject.isAnnotationPresent(RiakLinks.class)) continue;
                linksField = (Field)ClassUtil.checkAndFixAccess(accessibleObject);
            }
        }
        Method[] methods = this.classToScan.getDeclaredMethods();
        for (AccessibleObject accessibleObject : methods) {
            if (accessibleObject.isAnnotationPresent(RiakIndex.class)) {
                indexMethods.add(new RiakIndexMethod((Method)ClassUtil.checkAndFixAccess(accessibleObject)));
                continue;
            }
            if (!accessibleObject.isAnnotationPresent(RiakKey.class)) continue;
            if (((Method)accessibleObject).getReturnType().equals(String.class)) {
                riakKeyGetterMethod = (Method)ClassUtil.checkAndFixAccess(accessibleObject);
                continue;
            }
            if (!((Method)accessibleObject).getReturnType().equals(Void.TYPE) || ((Method)accessibleObject).getParameterTypes().length != 1 || !((Method)accessibleObject).getParameterTypes()[0].equals(String.class)) continue;
            riakKeySetterMethod = (Method)ClassUtil.checkAndFixAccess(accessibleObject);
        }
        return new AnnotationInfo(riakKeyField, riakKeyGetterMethod, riakKeySetterMethod, usermetaItemFields, usermetaMapField, indexFields, indexMethods, linksField, riakVClockField, riakTombstoneField);
    }
}

