/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.request;

import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.mapreduce.LinkFunction;
import com.basho.riak.client.http.mapreduce.MapReduceFunction;
import com.basho.riak.client.http.mapreduce.filter.MapReduceFilter;
import com.basho.riak.client.http.request.RequestMeta;
import com.basho.riak.client.http.response.MapReduceResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceBuilder {
    private String bucket = null;
    private String search = null;
    private Map<String, Set<String>> objects = new LinkedHashMap<String, Set<String>>();
    private List<MapReduceFilter> keyFilters = new ArrayList<MapReduceFilter>();
    private List<MapReducePhase> phases = new LinkedList<MapReducePhase>();
    private int timeout = -1;
    private RiakClient riak = null;

    public MapReduceBuilder(RiakClient riak) {
        this.riak = riak;
    }

    public MapReduceBuilder() {
    }

    public RiakClient getRiakClient() {
        return this.riak;
    }

    public MapReduceBuilder setRiakClient(RiakClient client) {
        this.riak = client;
        return this;
    }

    public String getBucket() {
        return this.bucket;
    }

    public MapReduceBuilder setBucket(String newBucket) {
        if (this.objects.size() > 0) {
            throw new IllegalStateException("Cannot map/reduce over buckets and objects");
        }
        this.bucket = newBucket;
        return this;
    }

    public String getSearch() {
        return this.search;
    }

    public MapReduceBuilder setSearch(String search) {
        if (this.objects.size() > 0) {
            throw new IllegalStateException("Cannot map/reduce over objects and search");
        }
        if (this.keyFilters.size() > 0) {
            throw new IllegalStateException("Cannot combine keyfilters and search");
        }
        this.search = search;
        return this;
    }

    public void addRiakObject(String bucket, String key) {
        if (this.search != null) {
            throw new IllegalStateException("Cannot map/reduce over objects and search");
        }
        if (this.bucket != null) {
            throw new IllegalStateException("Cannot map/reduce over buckets and objects");
        }
        Set<String> keys = this.objects.get(bucket);
        if (keys == null) {
            keys = new LinkedHashSet<String>();
            this.objects.put(bucket, keys);
        }
        keys.add(key);
    }

    public void removeRiakObject(String bucket, String key) {
        Set<String> keys = this.objects.get(bucket);
        if (keys != null) {
            keys.remove(key);
            if (keys.size() == 0) {
                this.objects.remove(bucket);
            }
        }
    }

    public Map<String, Set<String>> getRiakObjects() {
        return new HashMap<String, Set<String>>(this.objects);
    }

    public MapReduceBuilder setRiakObjects(Map<String, Set<String>> objects) {
        if (this.search != null) {
            throw new IllegalStateException("Cannot map/reduce over objects and search");
        }
        if (this.bucket != null) {
            throw new IllegalStateException("Cannot map/reduce over buckets and objects");
        }
        if (objects == null) {
            this.clearRiakObjects();
        } else {
            this.objects = new HashMap<String, Set<String>>(objects);
        }
        return this;
    }

    public MapReduceBuilder setRiakObjects(Collection<RiakObject> objects) {
        if (this.search != null) {
            throw new IllegalStateException("Cannot map/reduce over objects and search");
        }
        if (this.bucket != null) {
            throw new IllegalStateException("Cannot map/reduce over buckets and objects");
        }
        this.clearRiakObjects();
        if (objects != null) {
            for (RiakObject o : objects) {
                this.addRiakObject(o.getBucket(), o.getKey());
            }
        }
        return this;
    }

    public void clearRiakObjects() {
        this.objects.clear();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public MapReduceBuilder keyFilter(MapReduceFilter ... filters) {
        if (this.search != null) {
            throw new IllegalStateException("Cannot map/reduce over objects and search");
        }
        for (MapReduceFilter filter : filters) {
            this.keyFilters.add(filter);
        }
        return this;
    }

    public MapReduceBuilder map(MapReduceFunction function, boolean keep) {
        return this.map(function, null, keep);
    }

    public MapReduceBuilder map(MapReduceFunction function, Object arg, boolean keep) {
        this.addPhase(Types.MAP, function, arg, keep);
        return this;
    }

    public MapReduceBuilder reduce(MapReduceFunction function, boolean keep) {
        return this.reduce(function, null, keep);
    }

    public MapReduceBuilder reduce(MapReduceFunction function, Object arg, boolean keep) {
        this.addPhase(Types.REDUCE, function, arg, keep);
        return this;
    }

    public MapReduceBuilder link(String bucket, boolean keep) {
        this.addPhase(Types.LINK, new LinkFunction(bucket), keep);
        return this;
    }

    public MapReduceBuilder link(String bucket, String tag, boolean keep) {
        this.addPhase(Types.LINK, new LinkFunction(bucket, tag), keep);
        return this;
    }

    public MapReduceResponse submit(RequestMeta meta) {
        if (this.riak == null) {
            throw new IllegalStateException("Cannot perform map reduce without a RiakClient");
        }
        return this.riak.mapReduce(this.toJSON().toString(), meta);
    }

    public MapReduceResponse submit() throws JSONException {
        return this.submit(null);
    }

    public JSONObject toJSON() {
        JSONObject job = new JSONObject();
        JSONArray query = new JSONArray();
        for (MapReducePhase phase : this.phases) {
            this.renderPhase(phase, query);
        }
        this.buildInputs(job);
        try {
            job.put("query", (Object)query);
        }
        catch (JSONException e) {
            throw new RuntimeException("Can always map a string to a valid JSONArray");
        }
        if (this.timeout > 0) {
            try {
                job.put("timeout", this.timeout);
            }
            catch (JSONException e) {
                throw new RuntimeException("Can always map a string to an int");
            }
        }
        return job;
    }

    private MapReduceBuilder addPhase(Types phaseType, MapReduceFunction function, boolean keep) {
        return this.addPhase(phaseType, function, null, keep);
    }

    private MapReduceBuilder addPhase(Types phaseType, MapReduceFunction function, Object arg, boolean keep) {
        MapReducePhase phase = new MapReducePhase();
        phase.type = phaseType;
        phase.function = function;
        phase.arg = arg;
        phase.keep = keep;
        this.phases.add(phase);
        return this;
    }

    private JSONArray buildFilters(List<MapReduceFilter> filterList) {
        JSONArray filters = new JSONArray();
        for (MapReduceFilter filter : filterList) {
            filters.put((Object)filter.toJson());
        }
        return filters;
    }

    private void buildInputs(JSONObject job) {
        if (this.search != null) {
            try {
                JSONObject jobInputs = new JSONObject();
                jobInputs.put("module", (Object)"riak_search");
                jobInputs.put("function", (Object)"mapred_search");
                JSONArray jobArgs = new JSONArray();
                jobArgs.put((Object)this.bucket);
                jobArgs.put((Object)this.search);
                jobInputs.put("arg", (Object)jobArgs);
                job.put("inputs", (Object)jobInputs);
            }
            catch (JSONException e) {
                throw new RuntimeException("Can always assemble a query");
            }
        }
        if (this.bucket != null) {
            if (this.keyFilters.size() > 0) {
                try {
                    JSONObject jobInputs = new JSONObject();
                    jobInputs.put("bucket", (Object)this.bucket);
                    jobInputs.put("key_filters", (Object)this.buildFilters(this.keyFilters));
                    job.put("inputs", (Object)jobInputs);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Can always map a collection of MapReduceFilter objects to a JSONArray");
                }
            } else {
                try {
                    job.put("inputs", (Object)this.bucket);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Can always map a string to a string");
                }
            }
        } else {
            JSONArray inputs = new JSONArray();
            for (String bucket : this.objects.keySet()) {
                Set<String> keys = this.objects.get(bucket);
                for (String key : keys) {
                    String[] pair = new String[]{bucket, key};
                    inputs.put((Object)pair);
                }
            }
            try {
                job.put("inputs", (Object)inputs);
            }
            catch (JSONException e) {
                throw new RuntimeException("Can always map a string to a valid JSONArray");
            }
        }
    }

    private void renderPhase(MapReducePhase phase, JSONArray query) {
        JSONObject phaseJson = new JSONObject();
        JSONObject functionJson = phase.function.toJson();
        try {
            functionJson.put("keep", phase.keep);
        }
        catch (JSONException e) {
            throw new RuntimeException("Can always map a string to a boolean");
        }
        try {
            if (phase.arg != null) {
                functionJson.put("arg", phase.arg);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Cannot convert phase arg to JSON");
        }
        String type = null;
        switch (phase.type) {
            case MAP: {
                type = "map";
                break;
            }
            case REDUCE: {
                type = "reduce";
                break;
            }
            case LINK: {
                type = "link";
            }
        }
        try {
            phaseJson.put(type, (Object)functionJson);
        }
        catch (JSONException e) {
            throw new RuntimeException("Can always map a string to a valid JSONObject");
        }
        query.put((Object)phaseJson);
    }

    private class MapReducePhase {
        Types type;
        MapReduceFunction function;
        Object arg;
        boolean keep;

        private MapReducePhase() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Types {
        MAP,
        REDUCE,
        LINK;

    }
}

