/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.response;

import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakIndex;
import com.basho.riak.client.http.RiakLink;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.response.HttpResponse;
import com.basho.riak.client.http.response.HttpResponseDecorator;
import com.basho.riak.client.http.response.RiakIORuntimeException;
import com.basho.riak.client.http.response.RiakResponseRuntimeException;
import com.basho.riak.client.http.response.StreamedSiblingsCollection;
import com.basho.riak.client.http.response.WithBodyResponse;
import com.basho.riak.client.http.util.ClientUtils;
import com.basho.riak.client.http.util.StreamedMultipart;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchResponse
extends HttpResponseDecorator
implements WithBodyResponse {
    private RiakObject object = null;
    private Collection<RiakObject> siblings = new ArrayList<RiakObject>();
    private String vclock;

    public FetchResponse(HttpResponse r, RiakClient riak) throws RiakResponseRuntimeException, RiakIORuntimeException {
        super(r);
        if (r == null) {
            return;
        }
        Map<String, String> headers = r.getHttpHeaders();
        List<RiakLink> links = ClientUtils.parseLinkHeader(headers.get("link"));
        List<RiakIndex> indexes = ClientUtils.parseIndexHeaders(headers);
        Map<String, String> usermeta = ClientUtils.parseUsermeta(headers);
        this.vclock = headers.get("x-riak-vclock");
        if (r.getStatusCode() == 300) {
            String contentType = headers.get("content-type");
            if (contentType == null || !contentType.trim().toLowerCase().startsWith("multipart/mixed")) {
                throw new RiakResponseRuntimeException(r, "multipart/mixed content expected when object has siblings");
            }
            if (r.isStreamed()) {
                try {
                    StreamedMultipart multipart = new StreamedMultipart(headers, r.getStream());
                    this.siblings = new StreamedSiblingsCollection(riak, r.getBucket(), r.getKey(), multipart);
                }
                catch (IOException e) {
                    throw new RiakIORuntimeException("Error finding initial boundary", e);
                }
            } else {
                this.siblings = ClientUtils.parseMultipart(riak, r.getBucket(), r.getKey(), headers, r.getBody());
            }
            this.object = this.siblings.iterator().next();
        } else if (r.isSuccess()) {
            byte[] body = r.getBody();
            if (r.getStatusCode() == 404) {
                headers.put("x-riak-deleted", "true");
                body = new byte[]{};
            }
            this.object = new RiakObject(riak, r.getBucket(), r.getKey(), body, headers.get("content-type"), links, usermeta, headers.get("x-riak-vclock"), headers.get("last-modified"), headers.get("etag"), indexes, headers.get("x-riak-deleted") != null);
            Long contentLength = null;
            try {
                contentLength = Long.parseLong(headers.get("content-length"));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            this.object.setValueStream(r.getStream(), contentLength);
        } else if (r.isError() && r.getStatusCode() != 404 && r.getStatusCode() != 412) {
            throw new RiakResponseRuntimeException(r, r.getBodyAsString());
        }
    }

    public FetchResponse(HttpResponse r) throws RiakResponseRuntimeException {
        this(r, null);
    }

    @Override
    public boolean hasObject() {
        return this.getObject() != null;
    }

    @Override
    public RiakObject getObject() {
        return this.object;
    }

    public void setObject(RiakObject object) {
        this.object = object;
    }

    @Override
    public boolean hasSiblings() {
        return this.getSiblings().size() > 0;
    }

    @Override
    public Collection<RiakObject> getSiblings() {
        return this.siblings;
    }

    @Override
    public String getVclock() {
        return this.vclock;
    }
}

