/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.response;

import com.basho.riak.client.http.response.HttpResponse;
import com.basho.riak.client.http.response.HttpResponseDecorator;
import com.basho.riak.client.http.response.StreamedBucketsCollection;
import com.basho.riak.client.http.util.ClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBucketsResponse
extends HttpResponseDecorator
implements HttpResponse {
    private Collection<String> buckets;

    public ListBucketsResponse(HttpResponse r) throws JSONException, IOException {
        super(r);
        if (r != null && r.isSuccess()) {
            if (!r.isStreamed()) {
                JSONObject json = new JSONObject(r.getBodyAsString());
                JSONArray jsonBuckets = json.optJSONArray("buckets");
                this.buckets = ClientUtils.jsonArrayAsList(jsonBuckets);
            } else {
                InputStream stream = r.getStream();
                JSONTokener tokens = new JSONTokener((Reader)new InputStreamReader(stream));
                this.buckets = new StreamedBucketsCollection(tokens);
            }
        } else {
            this.buckets = new HashSet<String>();
        }
    }

    public Set<String> getBuckets() {
        return new HashSet<String>(this.buckets);
    }
}

