/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.operations;

import com.basho.riak.client.RiakException;
import com.basho.riak.client.cap.Quora;
import com.basho.riak.client.cap.Quorum;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.StoreMeta;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterObject
implements RiakOperation<Long> {
    private final RawClient client;
    private final String bucket;
    private final String counter;
    private Long increment;
    private final StoreMeta.Builder storeMetaBuilder = new StoreMeta.Builder();
    private final FetchMeta.Builder fetchMetaBuilder = new FetchMeta.Builder();

    public CounterObject(RawClient rawClient, String bucket, String counter) {
        this.client = rawClient;
        this.bucket = bucket;
        this.counter = counter;
    }

    public CounterObject increment(Long increment) {
        this.increment = increment;
        return this;
    }

    public CounterObject pw(int pw) {
        this.storeMetaBuilder.pw(pw);
        return this;
    }

    public CounterObject pw(Quora pw) {
        this.storeMetaBuilder.pw(pw);
        return this;
    }

    public CounterObject pw(Quorum pw) {
        this.storeMetaBuilder.pw(pw);
        return this;
    }

    public CounterObject w(int w) {
        this.storeMetaBuilder.w(w);
        return this;
    }

    public CounterObject w(Quora w) {
        this.storeMetaBuilder.w(w);
        return this;
    }

    public CounterObject w(Quorum w) {
        this.storeMetaBuilder.w(w);
        return this;
    }

    public CounterObject dw(int dw) {
        this.storeMetaBuilder.dw(dw);
        return this;
    }

    public CounterObject dw(Quora dw) {
        this.storeMetaBuilder.dw(dw);
        return this;
    }

    public CounterObject dw(Quorum dw) {
        this.storeMetaBuilder.dw(dw);
        return this;
    }

    public CounterObject returnValue(boolean returnValue) {
        this.storeMetaBuilder.returnBody(returnValue);
        return this;
    }

    public CounterObject r(int r) {
        this.fetchMetaBuilder.r(r);
        return this;
    }

    public CounterObject r(Quora r) {
        this.fetchMetaBuilder.r(r);
        return this;
    }

    public CounterObject r(Quorum r) {
        this.fetchMetaBuilder.r(r);
        return this;
    }

    public CounterObject pr(int pr) {
        this.fetchMetaBuilder.pr(pr);
        return this;
    }

    public CounterObject pr(Quora pr) {
        this.fetchMetaBuilder.pr(pr);
        return this;
    }

    public CounterObject pr(Quorum pr) {
        this.fetchMetaBuilder.pr(pr);
        return this;
    }

    public CounterObject notFoundOK(boolean notFoundOK) {
        this.fetchMetaBuilder.notFoundOK(notFoundOK);
        return this;
    }

    public CounterObject basicQuorum(boolean basicQuorum) {
        this.fetchMetaBuilder.basicQuorum(basicQuorum);
        return this;
    }

    @Override
    public Long execute() throws RiakException {
        try {
            if (this.increment != null) {
                return this.client.incrementCounter(this.bucket, this.counter, this.increment, this.storeMetaBuilder.build());
            }
            return this.client.fetchCounter(this.bucket, this.counter, this.fetchMetaBuilder.build());
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }
}

