/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.http;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.builders.BucketPropertiesBuilder;
import com.basho.riak.client.builders.RiakObjectBuilder;
import com.basho.riak.client.cap.Quorum;
import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.http.BinIndex;
import com.basho.riak.client.http.IntIndex;
import com.basho.riak.client.http.RiakBucketInfo;
import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakIndex;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.request.IndexRequest;
import com.basho.riak.client.http.request.RequestMeta;
import com.basho.riak.client.http.request.RiakWalkSpec;
import com.basho.riak.client.http.response.BucketResponse;
import com.basho.riak.client.http.response.IndexResponse;
import com.basho.riak.client.http.response.MapReduceResponse;
import com.basho.riak.client.http.response.WalkResponse;
import com.basho.riak.client.query.LinkWalkStep;
import com.basho.riak.client.query.MapReduceResult;
import com.basho.riak.client.query.WalkResult;
import com.basho.riak.client.query.functions.NamedErlangFunction;
import com.basho.riak.client.query.functions.NamedFunction;
import com.basho.riak.client.query.functions.NamedJSFunction;
import com.basho.riak.client.raw.DeleteMeta;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.JSONErrorParser;
import com.basho.riak.client.raw.StoreMeta;
import com.basho.riak.client.raw.http.NamedErlangFunctionDeserializer;
import com.basho.riak.client.raw.http.NamedJSFunctionDeserializer;
import com.basho.riak.client.raw.http.QuorumDeserializer;
import com.basho.riak.client.raw.query.IndexSpec;
import com.basho.riak.client.raw.query.LinkWalkSpec;
import com.basho.riak.client.raw.query.MapReduceTimeoutException;
import com.basho.riak.client.util.CharsetUtils;
import com.basho.riak.client.util.UnmodifiableIterator;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.impl.cookie.DateUtils;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversionUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ConversionUtil() {
    }

    static IRiakObject[] convert(Collection<RiakObject> siblings) {
        ArrayList<IRiakObject> results = new ArrayList<IRiakObject>();
        for (RiakObject object : siblings) {
            results.add(ConversionUtil.convert(object));
        }
        return results.toArray(new IRiakObject[results.size()]);
    }

    static IRiakObject convert(RiakObject o) {
        RiakObjectBuilder builder = RiakObjectBuilder.newBuilder(o.getBucket(), o.getKey());
        builder.withValue(o.getValueAsBytes());
        builder.withVClock(ConversionUtil.nullSafeGetBytes(o.getVclock()));
        builder.withVtag(o.getVtag());
        builder.withDeleted(o.isDeleted());
        String lastModified = o.getLastmod();
        if (lastModified != null) {
            Date lastModDate = o.getLastmodAsDate();
            builder.withLastModified(lastModDate.getTime());
        }
        ArrayList<RiakLink> links = new ArrayList<RiakLink>();
        for (com.basho.riak.client.http.RiakLink link : o.iterableLinks()) {
            links.add(ConversionUtil.convert(link));
        }
        builder.withLinks(links);
        List<RiakIndex> indexes = o.getIndexes();
        for (RiakIndex i : indexes) {
            if (i instanceof IntIndex) {
                builder.addIndex(i.getName(), (Long)i.getValue());
            }
            if (!(i instanceof BinIndex)) continue;
            builder.addIndex(i.getName(), (String)i.getValue());
        }
        builder.withContentType(o.getContentType());
        HashMap<String, String> userMetaData = new HashMap<String, String>();
        for (String key : o.usermetaKeys()) {
            userMetaData.put(key, o.getUsermetaItem(key));
        }
        builder.withUsermeta(userMetaData);
        return builder.build();
    }

    static RiakLink convert(com.basho.riak.client.http.RiakLink link) {
        return new RiakLink(link.getBucket(), link.getKey(), link.getTag());
    }

    static byte[] nullSafeGetBytes(String vclock) {
        return vclock == null ? null : CharsetUtils.utf8StringToBytes(vclock);
    }

    static RequestMeta convert(StoreMeta storeMeta) {
        RequestMeta requestMeta = RequestMeta.writeParams(storeMeta.getW(), storeMeta.getDw());
        if (storeMeta.hasReturnBody() && storeMeta.getReturnBody().booleanValue()) {
            requestMeta.setQueryParam("returnbody", Boolean.toString(true));
            requestMeta.setQueryParam("returnvalue", Boolean.toString(true));
        } else {
            requestMeta.setQueryParam("returnbody", Boolean.toString(false));
            requestMeta.setQueryParam("returnvalue", Boolean.toString(false));
        }
        if (storeMeta.hasPw()) {
            if (storeMeta.getPw().isSymbolic()) {
                requestMeta.setQueryParam("pw", storeMeta.getPw().getName());
            } else {
                requestMeta.setQueryParam("pw", Integer.toString(storeMeta.getPw().getIntValue()));
            }
        }
        if (storeMeta.hasIfNoneMatch() && storeMeta.getIfNoneMatch().booleanValue()) {
            requestMeta.setIfNoneMatch(storeMeta.getEtags());
        }
        if (storeMeta.hasIfNotModified() && storeMeta.getIfNotModified().booleanValue()) {
            requestMeta.setIfUnmodifiedSince(storeMeta.getLastModified());
        }
        if (storeMeta.hasAsis()) {
            requestMeta.setAsis(storeMeta.getAsis());
        }
        if (storeMeta.hasTimeout()) {
            requestMeta.setTimeout(storeMeta.getTimeout());
        }
        return requestMeta;
    }

    static RiakObject convert(IRiakObject object, RiakClient client) {
        List<RiakIndex<Long>> intIndexes = ConversionUtil.convertIntIndexes(object.allIntIndexesV2());
        List<RiakIndex<String>> binIndexes = ConversionUtil.convertBinIndexes(object.allBinIndexes());
        ArrayList<RiakIndex> allIndexes = new ArrayList<RiakIndex>(intIndexes);
        allIndexes.addAll(binIndexes);
        RiakObject riakObject = new RiakObject(client, object.getBucket(), object.getKey(), object.getValue(), object.getContentType(), ConversionUtil.getLinks(object), ConversionUtil.getUserMetaData(object), object.getVClockAsString(), ConversionUtil.formatDate(object.getLastModified()), object.getVtag(), allIndexes, false);
        return riakObject;
    }

    private static List<RiakIndex<String>> convertBinIndexes(Map<com.basho.riak.client.query.indexes.BinIndex, Set<String>> binIndexes) {
        ArrayList<RiakIndex<String>> converted = new ArrayList<RiakIndex<String>>();
        for (Map.Entry<com.basho.riak.client.query.indexes.BinIndex, Set<String>> index : binIndexes.entrySet()) {
            String name = index.getKey().getFullname();
            for (String v : index.getValue()) {
                converted.add(new BinIndex(name, v));
            }
        }
        return converted;
    }

    private static List<RiakIndex<Long>> convertIntIndexes(Map<com.basho.riak.client.query.indexes.IntIndex, Set<Long>> intIndexes) {
        ArrayList<RiakIndex<Long>> converted = new ArrayList<RiakIndex<Long>>();
        for (Map.Entry<com.basho.riak.client.query.indexes.IntIndex, Set<Long>> index : intIndexes.entrySet()) {
            String name = index.getKey().getFullname();
            for (Long v : index.getValue()) {
                converted.add(new IntIndex(name, v));
            }
        }
        return converted;
    }

    static String formatDate(Date lastModified) {
        if (lastModified == null) {
            return null;
        }
        return DateUtils.formatDate((Date)lastModified);
    }

    static Map<String, String> getUserMetaData(IRiakObject object) {
        HashMap<String, String> userMetaData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : object.userMetaEntries()) {
            userMetaData.put(entry.getKey(), entry.getValue());
        }
        return userMetaData;
    }

    static List<com.basho.riak.client.http.RiakLink> getLinks(IRiakObject object) {
        ArrayList<com.basho.riak.client.http.RiakLink> links = new ArrayList<com.basho.riak.client.http.RiakLink>();
        for (RiakLink link : object) {
            links.add(ConversionUtil.convert(link));
        }
        return links;
    }

    static com.basho.riak.client.http.RiakLink convert(RiakLink link) {
        return new com.basho.riak.client.http.RiakLink(link.getBucket(), link.getKey(), link.getTag());
    }

    static BucketProperties convert(BucketResponse response) throws IOException {
        String schema = response.getBodyAsString();
        JsonNode root = (JsonNode)OBJECT_MAPPER.readValue(schema, JsonNode.class);
        BucketPropertiesBuilder builder = new BucketPropertiesBuilder();
        JsonNode props = root.path("props");
        if (props.isMissingNode()) {
            throw new JsonMappingException("no 'props' field found");
        }
        builder.allowSiblings(props.path("allow_mult").asBoolean());
        builder.lastWriteWins(props.path("last_write_wins").asBoolean());
        builder.nVal(props.path("n_val").asInt());
        builder.backend(props.path("backend").textValue());
        builder.smallVClock(props.path("small_vclock").asInt());
        builder.bigVClock(props.path("big_vclock").asInt());
        builder.youngVClock(props.path("young_vclock").asLong());
        builder.oldVClock(props.path("old_vclock").asLong());
        for (JsonNode n : props.path("precommit")) {
            if (n.path("name").isMissingNode()) {
                builder.addPrecommitHook((NamedFunction)OBJECT_MAPPER.treeToValue((TreeNode)n, NamedErlangFunction.class));
                continue;
            }
            builder.addPrecommitHook((NamedFunction)OBJECT_MAPPER.treeToValue((TreeNode)n, NamedJSFunction.class));
        }
        for (JsonNode n : props.path("postcommit")) {
            builder.addPostcommitHook((NamedErlangFunction)OBJECT_MAPPER.treeToValue((TreeNode)n, NamedErlangFunction.class));
        }
        builder.r((Quorum)OBJECT_MAPPER.treeToValue((TreeNode)props.path("r"), Quorum.class));
        builder.w((Quorum)OBJECT_MAPPER.treeToValue((TreeNode)props.path("w"), Quorum.class));
        builder.dw((Quorum)OBJECT_MAPPER.treeToValue((TreeNode)props.path("dw"), Quorum.class));
        builder.rw((Quorum)OBJECT_MAPPER.treeToValue((TreeNode)props.path("rw"), Quorum.class));
        if (!props.path("pr").isMissingNode()) {
            builder.pr((Quorum)OBJECT_MAPPER.treeToValue((TreeNode)props.path("pr"), Quorum.class));
        }
        if (!props.path("pw").isMissingNode()) {
            builder.pw((Quorum)OBJECT_MAPPER.treeToValue((TreeNode)props.path("pw"), Quorum.class));
        }
        if (!props.path("basic_quorum").isMissingNode()) {
            builder.basicQuorum(props.path("basic_quorum").asBoolean());
        }
        if (!props.path("notfound_ok").isMissingNode()) {
            builder.notFoundOK(props.path("notfound_ok").asBoolean());
        }
        builder.chashKeyFunction((NamedErlangFunction)OBJECT_MAPPER.treeToValue((TreeNode)props.path("chash_keyfun"), NamedErlangFunction.class));
        builder.linkWalkFunction((NamedErlangFunction)OBJECT_MAPPER.treeToValue((TreeNode)props.path("linkfun"), NamedErlangFunction.class));
        builder.search(props.path("search").asBoolean());
        return builder.build();
    }

    static NamedErlangFunction convert(String funString) {
        if (funString == null) {
            return null;
        }
        String[] fun = funString.split(":");
        if (fun.length != 2) {
            return null;
        }
        return new NamedErlangFunction(fun[0], fun[1]);
    }

    static RiakBucketInfo convert(BucketProperties bucketProperties) throws IOException {
        RiakBucketInfo rbi;
        String bucketSchemaJson = ConversionUtil.toJSON(bucketProperties);
        try {
            rbi = new RiakBucketInfo(new JSONObject(bucketSchemaJson), null);
        }
        catch (JSONException e) {
            throw new IOException("Failed to create bucket schema JSON from JSON string: " + bucketSchemaJson, e);
        }
        return rbi;
    }

    private static String toJSON(BucketProperties bp) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator jg = new JsonFactory().createJsonGenerator((OutputStream)out, JsonEncoding.UTF8);
        jg.writeStartObject();
        ConversionUtil.writeIfNotNull(jg, bp.getAllowSiblings(), "allow_mult");
        ConversionUtil.writeIfNotNull(jg, bp.getNVal(), "n_val");
        ConversionUtil.writeIfNotNull(jg, bp.getLastWriteWins(), "last_write_wins");
        ConversionUtil.writeIfNotNull(jg, bp.getBackend(), "backend");
        ConversionUtil.writeIfNotNull(jg, bp.getSmallVClock(), "small_vclock");
        ConversionUtil.writeIfNotNull(jg, bp.getBigVClock(), "big_vclock");
        ConversionUtil.writeIfNotNull(jg, bp.getYoungVClock(), "young_vclock");
        ConversionUtil.writeIfNotNull(jg, bp.getOldVClock(), "old_vclock");
        ConversionUtil.writeIfNotNull(jg, bp.getR(), "r");
        ConversionUtil.writeIfNotNull(jg, bp.getRW(), "rw");
        ConversionUtil.writeIfNotNull(jg, bp.getW(), "w");
        ConversionUtil.writeIfNotNull(jg, bp.getDW(), "dw");
        ConversionUtil.writeIfNotNull(jg, bp.getPR(), "pr");
        ConversionUtil.writeIfNotNull(jg, bp.getPW(), "pw");
        ConversionUtil.writeIfNotNull(jg, bp.getBasicQuorum(), "basic_quorum");
        ConversionUtil.writeIfNotNull(jg, bp.getNotFoundOK(), "notfound_ok");
        ConversionUtil.writeIfNotNull(jg, bp.getChashKeyFunction(), "chash_keyfun");
        ConversionUtil.writeIfNotNull(jg, bp.getLinkWalkFunction(), "linkfun");
        ConversionUtil.writeIfNotNull(jg, bp.getPostcommitHooks(), "postcommit");
        ConversionUtil.writeIfNotNull(jg, bp.getPrecommitHooks(), "precommit");
        ConversionUtil.writeIfNotNull(jg, bp.getSearch(), "search");
        jg.writeEndObject();
        jg.flush();
        return CharsetUtils.asUTF8String(out.toByteArray());
    }

    private static void writeIfNotNull(JsonGenerator jg, Boolean value, String fieldName) throws IOException {
        if (value != null) {
            jg.writeBooleanField(fieldName, value.booleanValue());
        }
    }

    private static void writeIfNotNull(JsonGenerator jg, String value, String fieldName) throws IOException {
        if (value != null) {
            jg.writeStringField(fieldName, value);
        }
    }

    private static void writeIfNotNull(JsonGenerator jg, NamedErlangFunction value, String fieldName) throws IOException {
        if (value != null) {
            jg.writeFieldName(fieldName);
            ConversionUtil.writeNamedFun(jg, value);
        }
    }

    private static void writeNamedFun(JsonGenerator jg, NamedFunction nf) throws IOException {
        jg.writeStartObject();
        if (nf instanceof NamedErlangFunction) {
            NamedErlangFunction nef = (NamedErlangFunction)nf;
            jg.writeStringField("mod", nef.getMod());
            jg.writeStringField("fun", nef.getFun());
        } else {
            NamedJSFunction njsf = (NamedJSFunction)nf;
            jg.writeStringField("name", njsf.getFunction());
        }
        jg.writeEndObject();
    }

    private static void writeIfNotNull(JsonGenerator jg, Quorum q, String fieldName) throws IOException {
        if (q != null) {
            if (q.isSymbolic()) {
                jg.writeStringField(fieldName, q.getName());
            } else {
                jg.writeNumberField(fieldName, q.getIntValue());
            }
        }
    }

    private static void writeIfNotNull(JsonGenerator jg, Integer value, String fieldName) throws IOException {
        if (value != null) {
            jg.writeNumberField(fieldName, value.intValue());
        }
    }

    private static void writeIfNotNull(JsonGenerator jg, Long value, String fieldName) throws IOException {
        if (value != null) {
            jg.writeNumberField(fieldName, value.longValue());
        }
    }

    private static void writeIfNotNull(JsonGenerator jg, Collection<? extends NamedFunction> value, String fieldName) throws IOException {
        if (value != null) {
            jg.writeArrayFieldStart(fieldName);
            for (NamedFunction namedFunction : value) {
                ConversionUtil.writeNamedFun(jg, namedFunction);
            }
            jg.writeEndArray();
        }
    }

    static MapReduceResult convert(final MapReduceResponse resp) throws IOException, MapReduceTimeoutException {
        if (resp.isError()) {
            if (JSONErrorParser.isTimeoutException(resp.getBodyAsString())) {
                throw new MapReduceTimeoutException();
            }
            throw new IOException(resp.getBodyAsString());
        }
        MapReduceResult result = new MapReduceResult(){

            @Override
            public String getResultRaw() {
                return resp.getBodyAsString();
            }

            @Override
            public <T> Collection<T> getResult(Class<T> resultType) throws ConversionException {
                try {
                    return (Collection)OBJECT_MAPPER.readValue(this.getResultRaw(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(Collection.class, resultType));
                }
                catch (IOException e) {
                    throw new ConversionException(e);
                }
            }
        };
        return result;
    }

    static String convert(LinkWalkSpec linkWalkSpec) {
        RiakWalkSpec riakWalkSpec = new RiakWalkSpec();
        for (LinkWalkStep step : linkWalkSpec) {
            riakWalkSpec.addStep(step.getBucket(), step.getTag(), step.getKeep().toString());
        }
        return riakWalkSpec.toString();
    }

    static WalkResult convert(WalkResponse walkResponse) {
        final LinkedList convertedSteps = new LinkedList();
        for (List<RiakObject> list : walkResponse.getSteps()) {
            LinkedList<IRiakObject> objects = new LinkedList<IRiakObject>();
            for (RiakObject o : list) {
                objects.add(ConversionUtil.convert(o));
            }
            convertedSteps.add(objects);
        }
        return new WalkResult(){

            @Override
            public Iterator<Collection<IRiakObject>> iterator() {
                return new UnmodifiableIterator<Collection<IRiakObject>>(convertedSteps.iterator());
            }
        };
    }

    static List<String> convert(IndexResponse response) throws IOException {
        if (response.isSuccess()) {
            return response.getKeys();
        }
        throw new IOException(response.getBodyAsString());
    }

    static RequestMeta convert(FetchMeta fetchMeta) {
        RequestMeta rm = new RequestMeta();
        if (fetchMeta.getR() != null) {
            if (fetchMeta.getR().isSymbolic()) {
                rm.setQueryParam("r", fetchMeta.getR().getName());
            } else {
                rm.setQueryParam("r", Integer.toString(fetchMeta.getR().getIntValue()));
            }
        }
        if (fetchMeta.getPr() != null) {
            if (fetchMeta.getPr().isSymbolic()) {
                rm.setQueryParam("pr", fetchMeta.getPr().getName());
            } else {
                rm.setQueryParam("pr", Integer.toString(fetchMeta.getPr().getIntValue()));
            }
        }
        if (fetchMeta.getNotFoundOK() != null) {
            rm.setQueryParam("notfound_ok", fetchMeta.getNotFoundOK().toString());
        }
        if (fetchMeta.getBasicQuorum() != null) {
            rm.setQueryParam("basic_quorum", fetchMeta.getBasicQuorum().toString());
        }
        if (fetchMeta.getIfModifiedSince() != null) {
            rm.setIfModifiedSince(fetchMeta.getIfModifiedSince());
        }
        if (fetchMeta.hasTimeout()) {
            rm.setTimeout(fetchMeta.getTimeout());
        }
        return rm;
    }

    static RequestMeta convert(DeleteMeta deleteMeta) {
        if (deleteMeta == null) {
            return null;
        }
        RequestMeta rm = ConversionUtil.convert(new FetchMeta(deleteMeta.getR(), deleteMeta.getPr(), null, null, null, null, null, null, deleteMeta.getTimeout()));
        if (deleteMeta.hasW()) {
            if (deleteMeta.getW().isSymbolic()) {
                rm.setQueryParam("w", deleteMeta.getW().getName());
            } else {
                rm.setQueryParam("w", String.valueOf(deleteMeta.getW().getIntValue()));
            }
        }
        if (deleteMeta.hasPw()) {
            if (deleteMeta.getPw().isSymbolic()) {
                rm.setQueryParam("pw", deleteMeta.getPw().getName());
            } else {
                rm.setQueryParam("pw", String.valueOf(deleteMeta.getPw().getIntValue()));
            }
        }
        if (deleteMeta.hasDw()) {
            if (deleteMeta.getDw().isSymbolic()) {
                rm.setQueryParam("dw", deleteMeta.getDw().getName());
            } else {
                rm.setQueryParam("dw", String.valueOf(deleteMeta.getDw().getIntValue()));
            }
        }
        if (deleteMeta.hasRw()) {
            if (deleteMeta.getRw().isSymbolic()) {
                rm.setQueryParam("rw", deleteMeta.getRw().getName());
            } else {
                rm.setQueryParam("rw", String.valueOf(deleteMeta.getRw().getIntValue()));
            }
        }
        if (deleteMeta.hasVclock()) {
            rm.setHeader("x-riak-vclock", deleteMeta.getVclock().asString());
        }
        return rm;
    }

    static IndexRequest convert(IndexSpec indexSpec) {
        return new IndexRequest.Builder(indexSpec.getBucketName(), indexSpec.getIndexName()).withIndexKey(indexSpec.getIndexKey()).withRangeStart(indexSpec.getRangeStart()).withRangeEnd(indexSpec.getRangeEnd()).withReturnKeyAndIndex(indexSpec.isReturnTerms()).withMaxResults(indexSpec.getMaxResults()).withContinuation(indexSpec.getContinuation()).build();
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new SimpleModule("http.ConversionUtil", Version.unknownVersion()).addDeserializer(Quorum.class, (JsonDeserializer)new QuorumDeserializer()).addDeserializer(NamedErlangFunction.class, (JsonDeserializer)new NamedErlangFunctionDeserializer()).addDeserializer(NamedJSFunction.class, (JsonDeserializer)new NamedJSFunctionDeserializer()));
    }
}

