/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.http;

import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakConfig;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.RiakClientFactory;
import com.basho.riak.client.raw.config.Configuration;
import com.basho.riak.client.raw.http.HTTPClientAdapter;
import com.basho.riak.client.raw.http.HTTPClientConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPRiakClientFactory
implements RiakClientFactory {
    private static final HTTPRiakClientFactory instance = new HTTPRiakClientFactory();

    private HTTPRiakClientFactory() {
    }

    public static HTTPRiakClientFactory getInstance() {
        return instance;
    }

    @Override
    public boolean accepts(Class<? extends Configuration> configClass) {
        if (configClass == null) {
            return false;
        }
        return configClass.equals(HTTPClientConfig.class);
    }

    @Override
    public RawClient newClient(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf cannot be null");
        }
        HTTPClientConfig config = (HTTPClientConfig)conf;
        RiakConfig riakConfig = new RiakConfig();
        riakConfig.setUrl(config.getUrl());
        riakConfig.setHttpClient(config.getHttpClient());
        riakConfig.setMapReducePath(config.getMapreducePath());
        riakConfig.setMaxConnections(config.getMaxConnections());
        riakConfig.setTimeout(config.getTimeout());
        riakConfig.setRetryHandler(config.getRetryHandler());
        return new HTTPClientAdapter(new RiakClient(riakConfig));
    }
}

