/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.pbc;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.bucket.BucketProperties;
import com.basho.riak.client.builders.BucketPropertiesBuilder;
import com.basho.riak.client.builders.RiakObjectBuilder;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.http.BinIndex;
import com.basho.riak.client.http.IntIndex;
import com.basho.riak.client.http.RiakIndex;
import com.basho.riak.client.http.util.ClientUtils;
import com.basho.riak.client.query.LinkWalkStep;
import com.basho.riak.client.query.MapReduceResult;
import com.basho.riak.client.query.WalkResult;
import com.basho.riak.client.query.functions.NamedErlangFunction;
import com.basho.riak.client.query.functions.NamedFunction;
import com.basho.riak.client.query.functions.NamedJSFunction;
import com.basho.riak.client.raw.DeleteMeta;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.RiakResponse;
import com.basho.riak.client.raw.StoreMeta;
import com.basho.riak.client.raw.pbc.PBMapReduceResult;
import com.basho.riak.client.raw.query.IndexSpec;
import com.basho.riak.client.util.CharsetUtils;
import com.basho.riak.client.util.UnmodifiableIterator;
import com.basho.riak.pbc.CommitHook;
import com.basho.riak.pbc.FetchResponse;
import com.basho.riak.pbc.IndexRequest;
import com.basho.riak.pbc.MapReduceResponseSource;
import com.basho.riak.pbc.ModuleFunction;
import com.basho.riak.pbc.RequestMeta;
import com.basho.riak.pbc.RiakObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import shaded.com.google.protobuf.ByteString;

public final class ConversionUtil {
    private static final String CHARSET = "; charset=";

    private ConversionUtil() {
    }

    static RiakResponse convert(RiakObject[] pbcObjects) {
        RiakResponse response = RiakResponse.empty();
        if (pbcObjects != null && pbcObjects.length > 0) {
            IRiakObject[] converted = new IRiakObject[pbcObjects.length];
            for (int i = 0; i < pbcObjects.length; ++i) {
                converted[i] = ConversionUtil.convert(pbcObjects[i]);
            }
            response = new RiakResponse(pbcObjects[0].getVclock().toByteArray(), converted);
        }
        return response;
    }

    static RiakResponse convert(FetchResponse fetchResponse) {
        if (fetchResponse.isUnchanged()) {
            return RiakResponse.unmodified();
        }
        return ConversionUtil.convert(fetchResponse.getObjects());
    }

    static IRiakObject convert(RiakObject o) {
        RiakObjectBuilder builder = RiakObjectBuilder.newBuilder(o.getBucket(), o.getKey());
        builder.withValue(ConversionUtil.nullSafeToBytes(o.getValue()));
        builder.withVClock(ConversionUtil.nullSafeToBytes(o.getVclock()));
        builder.withVtag(o.getVtag());
        builder.withDeleted(o.getDeleted());
        Date lastModified = o.getLastModified();
        if (lastModified != null) {
            builder.withLastModified(lastModified.getTime());
        }
        ArrayList<RiakLink> links = new ArrayList<RiakLink>();
        for (com.basho.riak.pbc.RiakLink link : o.getLinks()) {
            links.add(ConversionUtil.convert(link));
        }
        builder.withLinks(links);
        List<RiakIndex> indexes = o.getIndexes();
        for (RiakIndex i : indexes) {
            if (i instanceof IntIndex) {
                builder.addIndex(i.getName(), (Long)i.getValue());
            }
            if (!(i instanceof BinIndex)) continue;
            builder.addIndex(i.getName(), (String)i.getValue());
        }
        String ctype = o.getContentType();
        String charset = o.getCharset();
        if (CharsetUtils.hasCharset(ctype) || charset == null || "".equals(charset.trim())) {
            builder.withContentType(ctype);
        } else {
            builder.withContentType(ctype + CHARSET + charset);
        }
        HashMap<String, String> userMetaData = new HashMap<String, String>(o.getUsermeta());
        builder.withUsermeta(userMetaData);
        return builder.build();
    }

    private static RiakLink convert(com.basho.riak.pbc.RiakLink link) {
        return new RiakLink(ConversionUtil.nullSafeToStringUtf8(link.getBucket()), ConversionUtil.nullSafeToStringUtf8(link.getKey()), ConversionUtil.nullSafeToStringUtf8(link.getTag()));
    }

    static byte[] nullSafeToBytes(ByteString value) {
        return value == null ? null : value.toByteArray();
    }

    static String nullSafeToStringUtf8(ByteString value) {
        return value == null ? null : value.toStringUtf8();
    }

    static ByteString nullSafeToByteString(String value) {
        return value == null ? null : ByteString.copyFromUtf8(value);
    }

    static byte[] nullSafeToBytes(VClock vclock) {
        return vclock == null ? null : vclock.getBytes();
    }

    static RequestMeta convert(StoreMeta storeMeta, IRiakObject riakObject) {
        String contentType;
        RequestMeta requestMeta = new RequestMeta();
        if (storeMeta.hasW()) {
            requestMeta.w(storeMeta.getW().getIntValue());
        }
        if (storeMeta.hasDw()) {
            requestMeta.dw(storeMeta.getDw().getIntValue());
        }
        if (storeMeta.hasReturnBody()) {
            requestMeta.returnBody(storeMeta.getReturnBody());
        }
        if (storeMeta.hasReturnHead()) {
            requestMeta.returnHead(storeMeta.getReturnHead());
        }
        if (riakObject != null && (contentType = riakObject.getContentType()) != null) {
            requestMeta.contentType(contentType);
        }
        if (storeMeta.hasPw()) {
            requestMeta.pw(storeMeta.getPw().getIntValue());
        }
        if (storeMeta.hasIfNoneMatch()) {
            requestMeta.ifNoneMatch(storeMeta.getIfNoneMatch());
        }
        if (storeMeta.hasIfNotModified()) {
            requestMeta.ifNotModified(storeMeta.getIfNotModified());
        }
        if (storeMeta.hasAsis()) {
            requestMeta.asis(storeMeta.getAsis());
        }
        return requestMeta;
    }

    static RiakObject convert(IRiakObject riakObject) {
        String name;
        VClock vc = riakObject.getVClock();
        ByteString bucketName = ConversionUtil.nullSafeToByteString(riakObject.getBucket());
        ByteString key = ConversionUtil.nullSafeToByteString(riakObject.getKey());
        ByteString content = ByteString.copyFrom(riakObject.getValue());
        ByteString vclock = null;
        if (vc != null) {
            vclock = ConversionUtil.nullSafeFromBytes(vc.getBytes());
        }
        RiakObject result = new RiakObject(vclock, bucketName, key, content);
        for (RiakLink riakLink : riakObject) {
            result.addLink(riakLink.getTag(), riakLink.getBucket(), riakLink.getKey());
        }
        for (Map.Entry entry : riakObject.userMetaEntries()) {
            result.addUsermetaItem((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : riakObject.allIntIndexesV2().entrySet()) {
            name = ((com.basho.riak.client.query.indexes.IntIndex)entry.getKey()).getFullname();
            for (Object v : (Set)entry.getValue()) {
                result.addIndex(name, (Long)v);
            }
        }
        for (Map.Entry entry : riakObject.allBinIndexes().entrySet()) {
            name = ((com.basho.riak.client.query.indexes.BinIndex)entry.getKey()).getFullname();
            for (Object v : (Set)entry.getValue()) {
                result.addIndex(name, (String)v);
            }
        }
        String ctype = riakObject.getContentType();
        if (CharsetUtils.hasCharset(ctype)) {
            result.setCharset(CharsetUtils.getDeclaredCharset(ctype));
            ctype = ctype.split(";")[0];
        }
        result.setContentType(ctype);
        return result;
    }

    static ByteString nullSafeFromBytes(byte[] bytes) {
        return ByteString.copyFrom(bytes);
    }

    static com.basho.riak.pbc.BucketProperties convert(BucketProperties p) {
        ArrayList<CommitHook> hooklist;
        com.basho.riak.pbc.BucketProperties props = new com.basho.riak.pbc.BucketProperties().nValue(p.getNVal()).allowMult(p.getAllowSiblings()).lastWriteWins(p.getLastWriteWins()).backend(p.getBackend()).smallVClock(p.getSmallVClock()).bigVClock(p.getBigVClock()).youngVClock(p.getYoungVClock()).oldVclock(p.getOldVClock()).r(p.getR() == null ? null : Integer.valueOf(p.getR().getIntValue())).w(p.getW() == null ? null : Integer.valueOf(p.getW().getIntValue())).rw(p.getRW() == null ? null : Integer.valueOf(p.getRW().getIntValue())).dw(p.getDW() == null ? null : Integer.valueOf(p.getDW().getIntValue())).pr(p.getPR() == null ? null : Integer.valueOf(p.getPR().getIntValue())).pw(p.getPW() == null ? null : Integer.valueOf(p.getPW().getIntValue())).basicQuorum(p.getBasicQuorum()).notFoundOk(p.getNotFoundOK()).searchEnabled(p.getSearch());
        if (p.getPrecommitHooks() != null) {
            hooklist = new ArrayList<CommitHook>();
            for (NamedFunction namedFunction : p.getPrecommitHooks()) {
                if (namedFunction instanceof NamedJSFunction) {
                    hooklist.add(new CommitHook(((NamedJSFunction)namedFunction).getFunction()));
                    continue;
                }
                hooklist.add(new CommitHook(((NamedErlangFunction)namedFunction).getMod(), ((NamedErlangFunction)namedFunction).getFun()));
            }
            props.precommitHooks(hooklist);
        }
        if (p.getPostcommitHooks() != null) {
            hooklist = new ArrayList();
            for (NamedErlangFunction namedErlangFunction : p.getPostcommitHooks()) {
                hooklist.add(new CommitHook(namedErlangFunction.getMod(), namedErlangFunction.getFun()));
            }
            props.postcommitHooks(hooklist);
        }
        if (p.getLinkWalkFunction() != null) {
            props.linkFun(new ModuleFunction(p.getLinkWalkFunction().getMod(), p.getLinkWalkFunction().getFun()));
        }
        if (p.getChashKeyFunction() != null) {
            props.cHashFun(new ModuleFunction(p.getChashKeyFunction().getMod(), p.getChashKeyFunction().getFun()));
        }
        return props;
    }

    static BucketProperties convert(com.basho.riak.pbc.BucketProperties properties) {
        BucketPropertiesBuilder builder = new BucketPropertiesBuilder().allowSiblings(properties.getAllowMult()).nVal(properties.getNValue()).lastWriteWins(properties.getLastWriteWins()).backend(properties.getBackend()).smallVClock(properties.getSmallVClock()).bigVClock(properties.getBigVClock()).youngVClock(properties.getYoungVClock()).oldVClock(properties.getOldVClock()).r(properties.getR()).w(properties.getW()).rw(properties.getRw()).dw(properties.getDw()).pr(properties.getPr()).pw(properties.getPw()).basicQuorum(properties.getBasicQuorum()).notFoundOK(properties.getNotFoundOk()).search(properties.getSearchEnabled());
        for (CommitHook hook : properties.getPrecommitHooks()) {
            if (hook.isJavascript()) {
                builder.addPrecommitHook(new NamedJSFunction(hook.getJsName()));
                continue;
            }
            builder.addPrecommitHook(new NamedErlangFunction(hook.getErlModule(), hook.getErlFunction()));
        }
        for (CommitHook hook : properties.getPostcommitHooks()) {
            if (hook.isJavascript()) {
                throw new IllegalArgumentException("Post-commit hooks can only be erlang");
            }
            builder.addPostcommitHook(new NamedErlangFunction(hook.getErlModule(), hook.getErlFunction()));
        }
        if (properties.getcHashFun() != null) {
            builder.chashKeyFunction(new NamedErlangFunction(properties.getcHashFun().getModule(), properties.getcHashFun().getFunction()));
        }
        if (properties.getLinkFun() != null) {
            builder.linkWalkFunction(new NamedErlangFunction(properties.getLinkFun().getModule(), properties.getLinkFun().getFunction()));
        }
        return builder.build();
    }

    static MapReduceResult convert(MapReduceResponseSource response) throws IOException {
        return PBMapReduceResult.newResult(response);
    }

    static boolean linkAccumulateToLinkPhaseKeep(LinkWalkStep.Accumulate accumulate, boolean isFinalStep) {
        boolean keep = true;
        if (!isFinalStep) {
            switch (accumulate) {
                case YES: {
                    keep = true;
                    break;
                }
                case NO: 
                case DEFAULT: {
                    keep = false;
                    break;
                }
            }
        }
        return keep;
    }

    static WalkResult convert(MapReduceResult secondPhaseResult) throws IOException {
        final TreeMap steps = new TreeMap();
        try {
            Collection<Map> results = secondPhaseResult.getResult(Map.class);
            for (Map o : results) {
                int step = Integer.parseInt((String)o.get("step"));
                ArrayList<IRiakObject> stepAccumulator = (ArrayList<IRiakObject>)steps.get(step);
                if (stepAccumulator == null) {
                    stepAccumulator = new ArrayList<IRiakObject>();
                    steps.put(step, stepAccumulator);
                }
                Map data = (Map)o.get("v");
                stepAccumulator.add(ConversionUtil.mapToRiakObject(data));
            }
        }
        catch (ConversionException e) {
            throw new IOException(e.getMessage());
        }
        return new WalkResult(){

            @Override
            public Iterator<Collection<IRiakObject>> iterator() {
                return new UnmodifiableIterator<Collection<IRiakObject>>(steps.values().iterator());
            }
        };
    }

    private static IRiakObject mapToRiakObject(Map data) {
        RiakObjectBuilder b = RiakObjectBuilder.newBuilder((String)data.get("bucket"), (String)data.get("key"));
        String vclock = (String)data.get("vclock");
        b.withVClock(CharsetUtils.utf8StringToBytes(vclock));
        List values = (List)data.get("values");
        if (values.size() != 0) {
            List links;
            Map value = (Map)values.get(0);
            Map meta = (Map)value.get("metadata");
            String contentType = (String)meta.get("content-type");
            b.withValue(CharsetUtils.asBytes((String)value.get("data"), CharsetUtils.getCharset(contentType)));
            b.withContentType(contentType);
            b.withVtag((String)meta.get("X-Riak-VTag"));
            Date lastModDate = ClientUtils.parseDate((String)meta.get("X-Riak-Last-Modified"));
            if (lastModDate != null) {
                b.withLastModified(lastModDate.getTime());
            }
            if ((links = (List)meta.get("Links")) != null) {
                for (List link : links) {
                    b.addLink((String)link.get(0), (String)link.get(1), (String)link.get(2));
                }
            }
            Map userMetaData = (Map)meta.get("X-Riak-Meta");
            b.withUsermeta(userMetaData);
        }
        return b.build();
    }

    static com.basho.riak.pbc.FetchMeta convert(FetchMeta fm) {
        if (fm != null) {
            return new com.basho.riak.pbc.FetchMeta(fm.hasR() ? Integer.valueOf(fm.getR().getIntValue()) : null, fm.hasPr() ? Integer.valueOf(fm.getPr().getIntValue()) : null, fm.getNotFoundOK(), fm.getBasicQuorum(), fm.getHeadOnly(), fm.getReturnDeletedVClock(), fm.getIfModifiedVClock(), fm.getTimeout());
        }
        return com.basho.riak.pbc.FetchMeta.empty();
    }

    static com.basho.riak.pbc.DeleteMeta convert(DeleteMeta dm) {
        if (dm != null) {
            return new com.basho.riak.pbc.DeleteMeta(dm.hasR() ? Integer.valueOf(dm.getR().getIntValue()) : null, dm.hasPr() ? Integer.valueOf(dm.getPr().getIntValue()) : null, dm.hasW() ? Integer.valueOf(dm.getW().getIntValue()) : null, dm.hasDw() ? Integer.valueOf(dm.getDw().getIntValue()) : null, dm.hasPw() ? Integer.valueOf(dm.getPw().getIntValue()) : null, dm.hasRw() ? Integer.valueOf(dm.getRw().getIntValue()) : null, ConversionUtil.nullSafeToBytes(dm.getVclock()), dm.getTimeout());
        }
        return com.basho.riak.pbc.DeleteMeta.empty();
    }

    static IndexRequest convert(IndexSpec indexSpec) {
        IndexRequest.Builder builder = new IndexRequest.Builder(indexSpec.getBucketName(), indexSpec.getIndexName()).withIndexKey(indexSpec.getIndexKey()).withRangeStart(indexSpec.getRangeStart()).withRangeEnd(indexSpec.getRangeEnd()).withReturnKeyAndIndex(indexSpec.isReturnTerms()).withMaxResults(indexSpec.getMaxResults());
        if (indexSpec.getContinuation() != null) {
            builder.withContinuation(ByteString.copyFromUtf8(indexSpec.getContinuation()));
        }
        return builder.build();
    }
}

