/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import shaded.com.bash.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;

public class IndexRequest {
    private final String bucketName;
    private final String indexName;
    private final String indexKey;
    private final String rangeStart;
    private final String rangeEnd;
    private final boolean returnTerms;
    private final Integer maxResults;
    private ByteString continuation;

    private IndexRequest(Builder builder) {
        this.bucketName = builder.bucketName;
        this.indexName = builder.indexName;
        this.indexKey = builder.indexKey;
        this.rangeStart = builder.rangeStart;
        this.rangeEnd = builder.rangeEnd;
        this.returnTerms = builder.returnTerms;
        this.maxResults = builder.maxResults;
        this.continuation = builder.continuation;
    }

    public void setContinuation(ByteString continuation) {
        this.continuation = continuation;
    }

    public RiakKvPB.RpbIndexReq buildProtocolBufferReq() {
        RiakKvPB.RpbIndexReq.Builder builder = RiakKvPB.RpbIndexReq.newBuilder();
        builder.setBucket(ByteString.copyFromUtf8(this.bucketName)).setIndex(ByteString.copyFromUtf8(this.indexName)).setStream(true);
        if (this.indexKey != null) {
            builder.setKey(ByteString.copyFromUtf8(this.indexKey));
            builder.setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.eq);
        } else {
            builder.setRangeMin(ByteString.copyFromUtf8(this.rangeStart));
            builder.setRangeMax(ByteString.copyFromUtf8(this.rangeEnd));
            builder.setQtype(RiakKvPB.RpbIndexReq.IndexQueryType.range);
        }
        builder.setReturnTerms(this.returnTerms);
        if (this.maxResults != null) {
            builder.setMaxResults(this.maxResults);
        }
        if (this.continuation != null) {
            builder.setContinuation(this.continuation);
        }
        return builder.build();
    }

    public boolean returnTerms() {
        return this.returnTerms;
    }

    public boolean isRangeQuery() {
        return this.indexKey == null;
    }

    public String getIndexKey() {
        return this.indexKey;
    }

    public static class Builder {
        private final String bucketName;
        private final String indexName;
        private String indexKey;
        private String rangeStart;
        private String rangeEnd;
        private boolean returnTerms;
        private Integer maxResults;
        private ByteString continuation;

        public Builder(String bucketName, String indexName) {
            if (bucketName == null || bucketName.equalsIgnoreCase("") || indexName == null || indexName.equalsIgnoreCase("")) {
                throw new IllegalArgumentException("Bucket or Index can not be null or empty");
            }
            this.bucketName = bucketName;
            this.indexName = indexName;
        }

        public Builder withIndexKey(String key) {
            this.indexKey = key;
            return this;
        }

        public Builder withIndexKey(long key) {
            this.indexKey = String.valueOf(key);
            return this;
        }

        public Builder withRangeStart(String startingIndex) {
            this.rangeStart = startingIndex;
            return this;
        }

        public Builder withRangeStart(long startIndex) {
            this.rangeStart = String.valueOf(startIndex);
            return this;
        }

        public Builder withRangeEnd(String endIndex) {
            this.rangeEnd = endIndex;
            return this;
        }

        public Builder withRangeEnd(long endIndex) {
            this.rangeEnd = String.valueOf(endIndex);
            return this;
        }

        public Builder withReturnKeyAndIndex(boolean returnBoth) {
            this.returnTerms = returnBoth;
            return this;
        }

        public Builder withMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder withContinuation(ByteString continuation) {
            this.continuation = continuation;
            return this;
        }

        public IndexRequest build() {
            if (this.rangeStart == null && this.rangeEnd == null && this.indexKey == null) {
                throw new IllegalArgumentException("An index key or range must be supplied");
            }
            if (this.rangeStart != null && this.rangeEnd == null || this.rangeEnd != null && this.rangeStart == null) {
                throw new IllegalArgumentException("When specifying ranges both start and end must be set");
            }
            return new IndexRequest(this);
        }
    }
}

