/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.RiakConnectionPool;
import com.basho.riak.pbc.RiakError;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import shaded.com.bash.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.MessageLite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RiakConnection
implements Comparable<RiakConnection> {
    static final int DEFAULT_RIAK_PB_PORT = 8087;
    private Socket sock;
    private DataOutputStream dout;
    private DataInputStream din;
    private final RiakConnectionPool pool;
    private byte[] clientId;
    private volatile long idleStart;

    public RiakConnection(InetAddress addr, int port, int bufferSizeKb, RiakConnectionPool pool, long connectTimeoutMillis, int requestTimeoutMillis) throws IOException {
        this(new InetSocketAddress(addr, port), bufferSizeKb, pool, connectTimeoutMillis, requestTimeoutMillis);
    }

    public RiakConnection(SocketAddress addr, int bufferSizeKb, RiakConnectionPool pool, long connectTimeoutMillis, int requestTimeoutMillis) throws IOException {
        if (connectTimeoutMillis > Integer.MAX_VALUE || connectTimeoutMillis < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Cannot cast timeout to int without changing value");
        }
        this.pool = pool;
        this.sock = new Socket();
        if (requestTimeoutMillis > 0) {
            this.sock.setSoTimeout(requestTimeoutMillis);
        }
        this.sock.connect(addr, (int)connectTimeoutMillis);
        this.sock.setSendBufferSize(1024 * bufferSizeKb);
        this.dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), 1024 * bufferSizeKb));
        this.din = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 1024 * bufferSizeKb));
    }

    void send(int code, MessageLite req) throws IOException {
        try {
            int len = req.getSerializedSize();
            this.dout.writeInt(len + 1);
            this.dout.write(code);
            req.writeTo(this.dout);
            this.dout.flush();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    void send(int code) throws IOException {
        try {
            this.dout.writeInt(1);
            this.dout.write(code);
            this.dout.flush();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    byte[] receive(int code) throws IOException {
        int get_code;
        byte[] data = null;
        try {
            int len = this.din.readInt();
            get_code = this.din.read();
            if (len > 1) {
                data = new byte[len - 1];
                this.din.readFully(data);
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        if (get_code == 0) {
            RiakPB.RpbErrorResp err = RiakPB.RpbErrorResp.parseFrom(data);
            throw new RiakError(err);
        }
        if (code != get_code) {
            throw new IOException("bad message code. Expected: " + code + " actual: " + get_code);
        }
        return data;
    }

    void receive_code(int code) throws IOException, RiakError {
        int get_code;
        int len;
        try {
            len = this.din.readInt();
            get_code = this.din.read();
            if (get_code == 0) {
                RiakPB.RpbErrorResp err = RiakPB.RpbErrorResp.parseFrom(this.din);
                throw new RiakError(err);
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        if (len != 1 || code != get_code) {
            throw new IOException("bad message code. Expected: " + code + " actual: " + get_code);
        }
    }

    void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.sock.close();
            this.din = null;
            this.dout = null;
            this.sock = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    boolean checkValid() {
        return this.isClosed();
    }

    public DataOutputStream getOutputStream() {
        return this.dout;
    }

    public boolean isClosed() {
        return this.sock == null || this.sock.isClosed();
    }

    public synchronized void beginIdle() {
        this.idleStart = System.nanoTime();
    }

    public long getIdleStartTimeNanos() {
        return this.idleStart;
    }

    public void release() {
        this.pool.releaseConnection(this);
    }

    public synchronized byte[] getClientId() {
        return this.clientId == null ? null : (byte[])this.clientId.clone();
    }

    public synchronized void setClientId(byte[] clientId) {
        this.clientId = clientId == null ? null : (byte[])clientId.clone();
    }

    public synchronized boolean hasClientId() {
        return this.clientId != null && this.clientId.length > 0;
    }

    @Override
    public int compareTo(RiakConnection c) {
        if (c.getIdleStartTimeNanos() < this.getIdleStartTimeNanos()) {
            return -1;
        }
        if (c.getIdleStartTimeNanos() > this.getIdleStartTimeNanos()) {
            return 1;
        }
        return 0;
    }
}

