/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.AcquireConnectionTimeoutException;
import com.basho.riak.pbc.LimitlessSemaphore;
import com.basho.riak.pbc.RiakConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import shaded.com.bash.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;

public class RiakConnectionPool {
    public static final int LIMITLESS = 0;
    private final InetAddress host;
    private final int port;
    private final Semaphore permits;
    private final LinkedBlockingDeque<RiakConnection> available;
    private final ConcurrentLinkedQueue<RiakConnection> inUse;
    private final long connectionWaitTimeoutNanos;
    private final int bufferSizeKb;
    private final int initialSize;
    private final long idleConnectionTTLNanos;
    private final int requestTimeoutMillis;
    private final ScheduledExecutorService idleReaper;
    private final ScheduledExecutorService shutdownExecutor;
    private volatile State state;

    public RiakConnectionPool(int initialSize, int maxSize, InetAddress host, int port, long connectionWaitTimeoutMillis, int bufferSizeKb, long idleConnectionTTLMillis, int requestTimeoutMillis) throws IOException {
        this(initialSize, RiakConnectionPool.getSemaphore(maxSize), host, port, connectionWaitTimeoutMillis, bufferSizeKb, idleConnectionTTLMillis, requestTimeoutMillis);
        if (initialSize > maxSize && maxSize > 0) {
            this.state = State.SHUTTING_DOWN;
            throw new IllegalArgumentException("Initial pool size is greater than maximum pools size");
        }
    }

    public RiakConnectionPool(int initialSize, Semaphore poolSemaphore, InetAddress host, int port, long connectionWaitTimeoutMillis, int bufferSizeKb, long idleConnectionTTLMillis, int requestTimeoutMillis) throws IOException {
        this.permits = poolSemaphore;
        this.available = new LinkedBlockingDeque();
        this.inUse = new ConcurrentLinkedQueue();
        this.bufferSizeKb = bufferSizeKb;
        this.host = host;
        this.port = port;
        this.connectionWaitTimeoutNanos = TimeUnit.NANOSECONDS.convert(connectionWaitTimeoutMillis, TimeUnit.MILLISECONDS);
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.initialSize = initialSize;
        this.idleConnectionTTLNanos = TimeUnit.NANOSECONDS.convert(idleConnectionTTLMillis, TimeUnit.MILLISECONDS);
        this.idleReaper = Executors.newScheduledThreadPool(1);
        this.shutdownExecutor = Executors.newScheduledThreadPool(1);
        this.state = State.CREATED;
    }

    public synchronized void start() {
        this.state.start(this);
    }

    private synchronized void doStart() {
        if (this.idleConnectionTTLNanos > 0L) {
            this.idleReaper.scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    RiakConnection c;
                    long connIdleStartNanos;
                    Iterator i = RiakConnectionPool.this.available.descendingIterator();
                    while (i.hasNext() && (connIdleStartNanos = (c = (RiakConnection)i.next()).getIdleStartTimeNanos()) + RiakConnectionPool.this.idleConnectionTTLNanos < System.nanoTime()) {
                        boolean removed;
                        if (c.getIdleStartTimeNanos() != connIdleStartNanos || !(removed = RiakConnectionPool.this.available.remove(c))) continue;
                        c.close();
                    }
                }
            }, this.idleConnectionTTLNanos, this.idleConnectionTTLNanos, TimeUnit.NANOSECONDS);
        }
        this.warmUp();
        this.state = State.RUNNING;
    }

    public static Semaphore getSemaphore(int maxSize) {
        if (maxSize <= 0) {
            return new LimitlessSemaphore();
        }
        return new Semaphore(maxSize, true);
    }

    private void warmUp() {
        for (int i = 0; i < this.initialSize; ++i) {
            try {
                RiakConnection c = new RiakConnection(this.host, this.port, this.bufferSizeKb, this, TimeUnit.MILLISECONDS.convert(this.connectionWaitTimeoutNanos, TimeUnit.NANOSECONDS), this.requestTimeoutMillis);
                c.beginIdle();
                this.available.add(c);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public RiakConnection getConnection(byte[] clientId) throws IOException {
        return this.state.getConnection(clientId, this);
    }

    private RiakConnection doGetConection(byte[] clientId) throws IOException {
        RiakConnection c = this.getConnection();
        if (clientId != null && !Arrays.equals(clientId, c.getClientId())) {
            this.setClientIdOnConnection(c, clientId);
        }
        return c;
    }

    private void setClientIdOnConnection(RiakConnection c, byte[] clientId) throws IOException {
        RiakKvPB.RpbSetClientIdReq req = RiakKvPB.RpbSetClientIdReq.newBuilder().setClientId(ByteString.copyFrom(clientId)).build();
        try {
            c.send(5, req);
            c.receive_code(6);
            c.setClientId(clientId);
        }
        catch (IOException e) {
            c.close();
            this.releaseConnection(c);
            throw e;
        }
    }

    private RiakConnection getConnection() throws IOException {
        RiakConnection c;
        block10: {
            c = null;
            try {
                if (this.permits.tryAcquire(this.connectionWaitTimeoutNanos, TimeUnit.NANOSECONDS)) {
                    c = this.available.poll();
                    if (c != null) break block10;
                    boolean releasePermit = true;
                    try {
                        c = new RiakConnection(this.host, this.port, this.bufferSizeKb, this, TimeUnit.MILLISECONDS.convert(this.connectionWaitTimeoutNanos, TimeUnit.NANOSECONDS), this.requestTimeoutMillis);
                        releasePermit = false;
                        break block10;
                    }
                    catch (SocketTimeoutException e) {
                        throw new AcquireConnectionTimeoutException("timeout from socket connection " + e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    finally {
                        if (releasePermit) {
                            this.permits.release();
                        }
                    }
                }
                throw new AcquireConnectionTimeoutException("timeout acquiring connection permit from pool");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("interrupted whilst waiting to acquire connection");
            }
        }
        this.inUse.offer(c);
        return c;
    }

    public void releaseConnection(RiakConnection c) {
        this.state.releaseConnection(c, this);
    }

    private void doRelease(RiakConnection c) {
        if (c == null) {
            return;
        }
        if (this.inUse.remove(c)) {
            if (!c.isClosed()) {
                c.beginIdle();
                this.available.offerFirst(c);
            }
        } else {
            throw new IllegalArgumentException("connection not managed by this pool");
        }
        this.permits.release();
    }

    private void closeAndRemove(RiakConnection c) {
        c.close();
        this.inUse.remove(c);
    }

    public synchronized void shutdown() {
        this.state.shutdown(this);
    }

    private void doShutdown() {
        this.state = State.SHUTTING_DOWN;
        RiakConnection c = this.available.poll();
        while (c != null) {
            c.close();
            c = this.available.poll();
        }
        this.shutdownExecutor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                if (RiakConnectionPool.this.inUse.isEmpty() && RiakConnectionPool.this.available.isEmpty()) {
                    RiakConnectionPool.this.state = State.SHUTDOWN;
                    RiakConnectionPool.this.shutdownExecutor.shutdown();
                    RiakConnectionPool.this.idleReaper.shutdown();
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public String getPoolState() {
        return this.state.name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CREATED{

            void releaseConnection(RiakConnection c, RiakConnectionPool pool) {
                throw new IllegalStateException("Pool not yet started");
            }

            RiakConnection getConnection(byte[] clientId, RiakConnectionPool pool) {
                throw new IllegalStateException("Pool not yet started");
            }

            void start(RiakConnectionPool pool) {
                pool.doStart();
            }

            void shutdown(RiakConnectionPool pool) {
                pool.doShutdown();
            }
        }
        ,
        RUNNING{

            void releaseConnection(RiakConnection c, RiakConnectionPool pool) {
                pool.doRelease(c);
            }

            RiakConnection getConnection(byte[] clientId, RiakConnectionPool pool) throws IOException {
                return pool.doGetConection(clientId);
            }

            void start(RiakConnectionPool pool) {
                throw new IllegalStateException("pool already started");
            }

            void shutdown(RiakConnectionPool pool) {
                pool.doShutdown();
            }
        }
        ,
        SHUTTING_DOWN{

            void releaseConnection(RiakConnection c, RiakConnectionPool pool) {
                pool.closeAndRemove(c);
            }

            RiakConnection getConnection(byte[] clientId, RiakConnectionPool pool) {
                throw new IllegalStateException("pool shutting down");
            }

            void start(RiakConnectionPool pool) {
                throw new IllegalStateException("pool shutting down");
            }

            void shutdown(RiakConnectionPool pool) {
                throw new IllegalStateException("pool shutting down");
            }
        }
        ,
        SHUTDOWN{

            void releaseConnection(RiakConnection c, RiakConnectionPool pool) {
                throw new IllegalStateException("pool shut down");
            }

            RiakConnection getConnection(byte[] clientId, RiakConnectionPool pool) {
                throw new IllegalStateException("pool shut down");
            }

            void start(RiakConnectionPool pool) {
                throw new IllegalStateException("pool shut down");
            }

            void shutdown(RiakConnectionPool pool) {
                throw new IllegalStateException("pool shut down");
            }
        };


        abstract void releaseConnection(RiakConnection var1, RiakConnectionPool var2);

        abstract RiakConnection getConnection(byte[] var1, RiakConnectionPool var2) throws IOException;

        abstract void start(RiakConnectionPool var1);

        abstract void shutdown(RiakConnectionPool var1);
    }
}

