/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.mext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="com.basistech.version")
public class VersionGeneratorLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Logger LOG = LoggerFactory.getLogger(VersionGeneratorLifecycleParticipant.class);

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        File projectBase = new File(session.getRequest().getBaseDirectory());
        File policyFile = new File(projectBase, "version-policy.txt");
        if (policyFile.exists()) {
            String template;
            try {
                template = this.fileContents(policyFile);
            }
            catch (IOException e) {
                throw new MavenExecutionException("Failed to read " + policyFile.getAbsolutePath(), (Throwable)e);
            }
            String[] bits = template.split("=");
            String prop = bits[0];
            String valueTemplate = bits[1];
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            String timestamp = format.format(new Date());
            String rev = valueTemplate.replace("${timestamp}", timestamp);
            LOG.info("Setting {} to {}", (Object)prop, (Object)rev);
            session.getUserProperties().put(prop, rev);
        }
    }

    private String fileContents(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("utf-8")));){
            String string = reader.readLine();
            return string;
        }
    }
}

