/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.metrics.reporting;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statsd
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Statsd.class);
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final String host;
    private final int port;
    private boolean prependNewline = false;
    private ByteArrayOutputStream outputData;
    private DatagramSocket datagramSocket;
    private Writer writer;

    public Statsd(String host, int port) {
        this.host = host;
        this.port = port;
        this.outputData = new ByteArrayOutputStream();
    }

    public void connect() throws IllegalStateException, SocketException {
        if (this.datagramSocket != null) {
            throw new IllegalStateException("Already connected");
        }
        this.prependNewline = false;
        this.datagramSocket = new DatagramSocket();
        this.outputData.reset();
        this.writer = new BufferedWriter(new OutputStreamWriter(this.outputData));
    }

    public void send(String name, String value, StatType statType) throws IOException {
        String statTypeStr = "";
        switch (statType) {
            case COUNTER: {
                statTypeStr = "c";
                break;
            }
            case GAUGE: {
                statTypeStr = "g";
                break;
            }
            case TIMER: {
                statTypeStr = "ms";
            }
        }
        try {
            if (this.prependNewline) {
                this.writer.write("\n");
            }
            this.writer.write(this.sanitizeString(name));
            this.writer.write(":");
            this.writer.write(value);
            this.writer.write("|");
            this.writer.write(statTypeStr);
            this.prependNewline = true;
            this.writer.flush();
        }
        catch (IOException e) {
            logger.error("Error sending to Statsd:", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        DatagramPacket packet = this.newPacket(this.outputData);
        packet.setData(this.outputData.toByteArray());
        this.datagramSocket.send(packet);
        if (this.datagramSocket != null) {
            this.datagramSocket.close();
        }
        this.datagramSocket = null;
        this.writer = null;
    }

    private String sanitizeString(String s) {
        return WHITESPACE.matcher(s).replaceAll("-");
    }

    private DatagramPacket newPacket(ByteArrayOutputStream out) {
        byte[] dataBuffer = out != null ? out.toByteArray() : new byte[8192];
        try {
            return new DatagramPacket(dataBuffer, dataBuffer.length, InetAddress.getByName(this.host), this.port);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum StatType {
        COUNTER,
        TIMER,
        GAUGE;

    }
}

