/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.metrics.reporting;

import com.basistech.metrics.reporting.Statsd;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsdReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsdReporter.class);
    private final Statsd statsd;
    private final String prefix;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public StatsdReporter(MetricRegistry registry, Statsd statsd, String prefix, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, "statsd-reporter", filter, rateUnit, durationUnit);
        this.statsd = statsd;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            this.statsd.connect();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue());
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to report to StatsD", (Object)this.statsd, (Object)e);
        }
        finally {
            try {
                this.statsd.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error disconnecting from StatsD server", (Object)this.statsd, (Object)e);
            }
        }
    }

    private void reportTimer(String name, Timer timer) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        this.statsd.send(this.prefix(name, "max"), this.format(this.convertDuration(snapshot.getMax())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "mean"), this.format(this.convertDuration(snapshot.getMean())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "min"), this.format(this.convertDuration(snapshot.getMin())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "stddev"), this.format(this.convertDuration(snapshot.getStdDev())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p50"), this.format(this.convertDuration(snapshot.getMedian())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p75"), this.format(this.convertDuration(snapshot.get75thPercentile())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p95"), this.format(this.convertDuration(snapshot.get95thPercentile())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p98"), this.format(this.convertDuration(snapshot.get98thPercentile())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p99"), this.format(this.convertDuration(snapshot.get99thPercentile())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p999"), this.format(this.convertDuration(snapshot.get999thPercentile())), Statsd.StatType.TIMER);
        this.reportMetered(name, (Metered)timer);
    }

    private void reportMetered(String name, Metered meter) throws IOException {
        this.statsd.send(this.prefix(name, "count"), this.format(meter.getCount()), Statsd.StatType.GAUGE);
        this.statsd.send(this.prefix(name, "m1_rate"), this.format(this.convertRate(meter.getOneMinuteRate())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "m5_rate"), this.format(this.convertRate(meter.getFiveMinuteRate())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "m15_rate"), this.format(this.convertRate(meter.getFifteenMinuteRate())), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "mean_rate"), this.format(this.convertRate(meter.getMeanRate())), Statsd.StatType.TIMER);
    }

    private void reportHistogram(String name, Histogram histogram) throws IOException {
        Snapshot snapshot = histogram.getSnapshot();
        this.statsd.send(this.prefix(name, "count"), this.format(histogram.getCount()), Statsd.StatType.GAUGE);
        this.statsd.send(this.prefix(name, "max"), this.format(snapshot.getMax()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "mean"), this.format(snapshot.getMean()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "min"), this.format(snapshot.getMin()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "stddev"), this.format(snapshot.getStdDev()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p50"), this.format(snapshot.getMedian()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p75"), this.format(snapshot.get75thPercentile()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p95"), this.format(snapshot.get95thPercentile()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p98"), this.format(snapshot.get98thPercentile()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p99"), this.format(snapshot.get99thPercentile()), Statsd.StatType.TIMER);
        this.statsd.send(this.prefix(name, "p999"), this.format(snapshot.get999thPercentile()), Statsd.StatType.TIMER);
    }

    private void reportCounter(String name, Counter counter) throws IOException {
        this.statsd.send(this.prefix(name, "count"), this.format(counter.getCount()), Statsd.StatType.COUNTER);
    }

    private void reportGauge(String name, Gauge gauge) throws IOException {
        String value = this.format(gauge.getValue());
        if (value != null) {
            this.statsd.send(this.prefix(name), value, Statsd.StatType.GAUGE);
        }
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        return null;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name((String)this.prefix, (String[])components);
    }

    private String format(long n) {
        return Long.toString(n);
    }

    private String format(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public StatsdReporter build(Statsd statsd) {
            return new StatsdReporter(this.registry, statsd, this.prefix, this.filter, this.rateUnit, this.durationUnit);
        }
    }
}

