/*
 * Decompiled with CFR 0.152.
 */
package com.battcn.boot.elasticsearch.autoconfigure;

import com.battcn.boot.elasticsearch.properties.ElasticsearchHttpClientProperties;
import com.battcn.boot.elasticsearch.properties.ElasticsearchRestClientProperties;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.rest.RestClientBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ElasticsearchRestClientProperties.class, ElasticsearchHttpClientProperties.class})
public class ElasticsearchRestAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchRestAutoConfiguration.class);
    private ObjectProvider<RestClientBuilderCustomizer> builderCustomizers;

    public ElasticsearchRestAutoConfiguration(ObjectProvider<RestClientBuilderCustomizer> builderCustomizers) {
        this.builderCustomizers = builderCustomizers;
    }

    @Bean
    @ConditionalOnMissingBean
    public RestClient restClient(RestClientBuilder builder) {
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public RestClientBuilder restClientBuilder(ElasticsearchRestClientProperties restClientProperties, ElasticsearchHttpClientProperties httpClientProperties) {
        HttpHost[] hosts = (HttpHost[])restClientProperties.getUris().stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        PropertyMapper map = PropertyMapper.get();
        map.from(restClientProperties::getUsername).whenHasText().to(username -> {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(restClientProperties.getUsername(), restClientProperties.getPassword());
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback = arg_0 -> ElasticsearchRestAutoConfiguration.lambda$null$1(httpClientProperties, (CredentialsProvider)credentialsProvider, arg_0);
            builder.setHttpClientConfigCallback(httpClientConfigCallback);
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectionRequestTimeout(httpClientProperties.getConnectionRequestTimeout().intValue()).setConnectTimeout(httpClientProperties.getConnectTimeout().intValue()).setSocketTimeout(httpClientProperties.getReadTimeout().intValue())).setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
                log.error("elasticsearch server occur error.");
                super.onFailure(node);
            }
        });
        this.builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$null$1(ElasticsearchHttpClientProperties httpClientProperties, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors() * 5).build()).setMaxConnTotal(httpClientProperties.getMaxTotal().intValue()).setMaxConnPerRoute(httpClientProperties.getDefaultMaxPerRoute().intValue()).setDefaultCredentialsProvider(credentialsProvider);
    }

    @Configuration
    @ConditionalOnClass(value={RestHighLevelClient.class})
    public static class RestHighLevelClientConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public RestHighLevelClient restHighLevelClient(RestClientBuilder restClientBuilder) throws IOException {
            RestHighLevelClient client = new RestHighLevelClient(restClientBuilder);
            boolean ping = client.ping(RequestOptions.DEFAULT);
            if (ping) {
                log.info("elasticsearch server connected");
            }
            return client;
        }
    }
}

