/*
 * Decompiled with CFR 0.152.
 */
package com.battcn.boot.swagger.security;

import com.battcn.boot.swagger.properties.SwaggerProperties;
import com.google.common.collect.Lists;
import java.util.List;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.service.contexts.SecurityContext;

public class GlobalAccess {
    private final SwaggerProperties swaggerProperties;

    public GlobalAccess(SwaggerProperties swaggerProperties) {
        this.swaggerProperties = swaggerProperties;
    }

    public ApiKey apiKey() {
        SwaggerProperties.ApiKey apiKey = this.swaggerProperties.getApiKey();
        return new ApiKey(apiKey.getName(), apiKey.getKeyName(), apiKey.getParamType());
    }

    public SecurityContext securityContext() {
        SwaggerProperties.ApiKey apiKey = this.swaggerProperties.getApiKey();
        return SecurityContext.builder().securityReferences(this.defaultAuth(apiKey)).forPaths(PathSelectors.regex((String)apiKey.getAuthRegex())).build();
    }

    private List<SecurityReference> defaultAuth(SwaggerProperties.ApiKey apiKey) {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        return Lists.newArrayList((Object[])new SecurityReference[]{new SecurityReference(apiKey.getName(), new AuthorizationScope[]{authorizationScope})});
    }
}

