/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER;

    public static Object cloneJson(Object json) {
        if (json instanceof Map) {
            Map jsonMap = (Map)json;
            HashMap<String, Object> retvalue = new HashMap<String, Object>();
            for (String key : jsonMap.keySet()) {
                retvalue.put(key, JsonUtils.cloneJson(jsonMap.get(key)));
            }
            return retvalue;
        }
        if (json instanceof List) {
            List jsonList = (List)json;
            ArrayList<Object> retvalue = new ArrayList<Object>(jsonList.size());
            for (Object sub : jsonList) {
                retvalue.add(JsonUtils.cloneJson(sub));
            }
            return retvalue;
        }
        return json;
    }

    public static void removeRecursive(Object json, String keyToRemove) {
        if (json == null || keyToRemove == null) {
            return;
        }
        if (json instanceof Map) {
            Map jsonMap = (Map)json;
            if (jsonMap.containsKey(keyToRemove)) {
                jsonMap.remove(keyToRemove);
            }
            for (String subkey : jsonMap.keySet()) {
                Object value = jsonMap.get(subkey);
                JsonUtils.removeRecursive(value, keyToRemove);
            }
        }
        if (json instanceof List) {
            for (Object value : (List)json) {
                JsonUtils.removeRecursive(value, keyToRemove);
            }
        }
    }

    public static Map<String, Object> javason(String javason) throws IOException {
        String json = javason.replace('\'', '\"');
        return JsonUtils.jsonToMap(new ByteArrayInputStream(json.getBytes()));
    }

    public static Map<String, Object> jsonToMap(String json) throws IOException {
        return JsonUtils.jsonToMap(new ByteArrayInputStream(json.getBytes()));
    }

    public static Object jsonToObject(String json) throws IOException {
        return JsonUtils.jsonToObject(new ByteArrayInputStream(json.getBytes()));
    }

    public static Object jsonToObject(InputStream in) throws IOException {
        return OBJECT_MAPPER.readValue(in, Object.class);
    }

    public static Map<String, Object> jsonToMap(InputStream in) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap o = (HashMap)OBJECT_MAPPER.readValue(in, (TypeReference)typeRef);
        return o;
    }

    public static <T> T jsonTo(InputStream in, TypeReference<T> typeRef) throws IOException {
        return (T)OBJECT_MAPPER.readValue(in, typeRef);
    }

    public static String toJsonString(Object map) throws IOException {
        return OBJECT_MAPPER.writeValueAsString(map);
    }

    static {
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        OBJECT_MAPPER = new ObjectMapper(factory);
    }
}

