/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.JsonUtils;
import java.util.List;
import java.util.Map;

public class Diffy {
    public Result diff(Object expected, Object actual) {
        Object expectedCopy = JsonUtils.cloneJson(expected);
        Object actualCopy = JsonUtils.cloneJson(actual);
        return this.diffHelper(expectedCopy, actualCopy);
    }

    protected Result diffHelper(Object expected, Object actual) {
        if (expected instanceof Map) {
            if (!(actual instanceof Map)) {
                return new Result(expected, actual);
            }
            return this.diffMap((Map)expected, (Map)actual);
        }
        if (expected instanceof List) {
            if (!(actual instanceof List)) {
                return new Result(expected, actual);
            }
            return this.diffList((List)expected, (List)actual);
        }
        return this.diffScalar(expected, actual);
    }

    protected Result diffMap(Map<String, Object> expected, Map<String, Object> actual) {
        for (Object key : expected.keySet().toArray()) {
            Result subResult = this.diffHelper(expected.get(key), actual.get(key));
            if (!subResult.isEmpty()) continue;
            expected.remove(key);
            actual.remove(key);
        }
        if (expected.isEmpty() && actual.isEmpty()) {
            return new Result();
        }
        return new Result(expected, actual);
    }

    protected Result diffList(List expected, List actual) {
        int shortlen = Math.min(expected.size(), actual.size());
        boolean emptyDiff = true;
        for (int i = 0; i < shortlen; ++i) {
            Result subresult = this.diffHelper(expected.get(i), actual.get(i));
            expected.set(i, subresult.expected);
            actual.set(i, subresult.actual);
            emptyDiff = emptyDiff && subresult.isEmpty();
        }
        if (emptyDiff && expected.size() == actual.size()) {
            return new Result();
        }
        return new Result(expected, actual);
    }

    protected Result diffScalar(Object expected, Object actual) {
        if (expected == null) {
            if (actual == null) {
                return new Result();
            }
            return new Result(expected, actual);
        }
        if (actual == null) {
            return new Result(expected, actual);
        }
        if (this.scalarEquals(expected, actual)) {
            return new Result();
        }
        return new Result(expected, actual);
    }

    protected boolean scalarEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public static class Result {
        public Object expected;
        public Object actual;

        public Result() {
        }

        public Result(Object expected, Object actual) {
            this.expected = expected;
            this.actual = actual;
        }

        public boolean isEmpty() {
            return this.expected == null && this.actual == null;
        }
    }
}

