/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.maven.plugin.process;

import com.bazaarvoice.maven.plugin.process.AbstractProcessMojo;
import com.bazaarvoice.maven.plugin.process.CrossMojoState;
import com.bazaarvoice.maven.plugin.process.ExecProcess;
import com.bazaarvoice.maven.plugin.process.ProcessHealthCondition;
import com.google.common.base.Joiner;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class ProcessStartMojo
extends AbstractProcessMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)("Skipping " + this.name + " due to configuration skip=true"));
            return;
        }
        for (String arg : this.arguments) {
            this.getLog().info((CharSequence)("arg: " + arg));
        }
        this.getLog().info((CharSequence)("Full command line: " + Joiner.on((String)" ").join((Object[])this.arguments)));
        try {
            this.startProcess();
            if (this.waitForInterrupt) {
                this.sleepUntilInterrupted();
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void startProcess() {
        ExecProcess exec = new ExecProcess(this.name);
        if (null != this.processLogFile) {
            exec.setProcessLogFile(new File(this.processLogFile));
        }
        this.getLog().info((CharSequence)("Starting process: " + exec.getName()));
        exec.execute(this.processWorkingDirectory(), this.getLog(), this.arguments);
        CrossMojoState.addProcess(exec, this.getPluginContext());
        ProcessHealthCondition.waitSecondsUntilHealthy(this.healthcheckUrl, this.waitAfterLaunch);
        this.getLog().info((CharSequence)("Started process: " + exec.getName()));
    }

    private File processWorkingDirectory() {
        if (this.workingDir == null) {
            return ProcessStartMojo.ensureDirectory(new File(this.project.getBuild().getDirectory()));
        }
        File potentialWorkingDir = new File(this.workingDir);
        if (potentialWorkingDir.isAbsolute() && potentialWorkingDir.exists() && potentialWorkingDir.isDirectory()) {
            return potentialWorkingDir;
        }
        return ProcessStartMojo.ensureDirectory(new File(this.project.getBuild().getDirectory(), this.workingDir));
    }
}

