/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.maven.plugin.process;

import com.bazaarvoice.maven.plugin.process.MavenLogOutputStream;
import com.bazaarvoice.maven.plugin.process.StdoutRedirector;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class ExecProcess {
    private Process process = null;
    private final List<StdoutRedirector> redirectors = Lists.newArrayList();
    private File processLogFile = null;
    private boolean redirectErrorStream;
    private final String name;
    final ProcessBuilder pb = new ProcessBuilder(new String[0]);

    public ExecProcess(String name) {
        this.name = name;
    }

    public void setProcessLogFile(File emoLogFile) {
        this.processLogFile = emoLogFile;
    }

    public void setRedirectErrorStream(boolean isRedirect) {
        this.redirectErrorStream = isRedirect;
    }

    public String getName() {
        return this.name;
    }

    public void execute(File workingDirectory, Log log, String ... args) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (this.redirectErrorStream) {
            pb.redirectErrorStream(true);
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        log.info((CharSequence)("Using working directory for this process: " + workingDirectory));
        pb.directory(workingDirectory);
        pb.command(args);
        try {
            this.process = pb.start();
            this.pumpOutputToLog(this.process, log);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void pumpOutputToLog(Process process, Log mavenLog) {
        if (this.processLogFile == null) {
            this.redirectors.add(new StdoutRedirector(new InputStreamReader(process.getInputStream()), (OutputStream)((Object)new MavenLogOutputStream(mavenLog, 1))));
            this.redirectors.add(new StdoutRedirector(new InputStreamReader(process.getErrorStream()), (OutputStream)((Object)new MavenLogOutputStream(mavenLog, 0))));
        } else {
            if (!this.processLogFile.getParentFile().isDirectory() && !this.processLogFile.getParentFile().mkdir()) {
                throw new IllegalStateException("Could not find or create directory containing " + this.processLogFile.getPath());
            }
            FileOutputStream out = ExecProcess.openFileOutputStream(this.processLogFile);
            this.redirectors.add(new StdoutRedirector(new InputStreamReader(process.getInputStream()), out));
            this.redirectors.add(new StdoutRedirector(new InputStreamReader(process.getErrorStream()), out));
        }
        for (StdoutRedirector redirector : this.redirectors) {
            redirector.start();
        }
    }

    private static FileOutputStream openFileOutputStream(File file) {
        FileOutputStream out;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("couldn't create or open file '" + file + "'", e);
        }
        return out;
    }

    public void destroy() {
        for (StdoutRedirector redirector : this.redirectors) {
            redirector.stopIt();
        }
        this.process.destroy();
    }

    public void waitFor() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

