/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.spi.assemble.BeanInstanceException;
import com.frameworkset.spi.assemble.CurrentlyInCreationException;
import com.frameworkset.util.Base64;
import com.frameworkset.util.BaseSimpleStringUtil;
import com.frameworkset.util.EditorInf;
import com.frameworkset.util.ListInfo;
import com.frameworkset.util.NoSupportTypeCastException;
import com.frameworkset.util.WrapperEditorInf;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.frameworkset.util.BigFile;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.DataFormatUtil;
import org.frameworkset.util.MethodParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueObjectUtil {
    public static final Class[] baseTypes = new Class[]{String.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Timestamp.class, Date.class, java.util.Date.class, Boolean.TYPE, Boolean.class, BigFile.class, Float.TYPE, Float.class, Short.TYPE, Short.class, Double.TYPE, Double.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, BigDecimal.class, BigInteger.class};
    public static final Class[] basePrimaryTypes = new Class[]{String.class, Integer.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Short.TYPE, Double.TYPE, Character.TYPE, Byte.TYPE, Class.class, BigInteger.class, BigDecimal.class, Timestamp.class, Date.class, java.util.Date.class};
    public static final Class[] simplePrimaryTypes = new Class[]{String.class, Integer.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Short.TYPE, Double.TYPE, Character.TYPE, Byte.TYPE, Class.class, Timestamp.class, Date.class, java.util.Date.class, Locale.class};
    private static final Logger log = LoggerFactory.getLogger(ValueObjectUtil.class);

    public static Object getValue(Object obj, String property) {
        block5: {
            if (obj == null || property == null || property.trim().length() == 0) {
                return null;
            }
            Class<?> clazz = obj.getClass();
            try {
                ClassUtil.PropertieDescription pd = ClassUtil.getPropertyDescriptor(clazz, property);
                if (pd != null) {
                    return pd.getValue(obj);
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u7c7b" + clazz.getCanonicalName() + "\u6ca1\u6709\u5b9a\u4e49\u5c5e\u6027" + property);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("\u83b7\u53d6\u7c7b" + clazz.getCanonicalName() + "\u5c5e\u6027[" + property + "]\u503c\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return null;
    }

    public static Object getValueOrSize(Object obj, String property) {
        boolean issize = false;
        if (property.startsWith("size:")) {
            issize = true;
            property = property.substring(5);
        }
        Object value = ValueObjectUtil.getValue(obj, property);
        if (issize) {
            return ValueObjectUtil.length(value);
        }
        return value;
    }

    public static int length(Object _actualValue) {
        if (_actualValue == null) {
            return 0;
        }
        if (_actualValue instanceof Collection) {
            return ((Collection)_actualValue).size();
        }
        if (_actualValue instanceof Map) {
            return ((Map)_actualValue).size();
        }
        if (_actualValue.getClass().isArray()) {
            return Array.getLength(_actualValue);
        }
        if (_actualValue instanceof String) {
            return ((String)_actualValue).length();
        }
        if (_actualValue instanceof ListInfo) {
            return ((ListInfo)_actualValue).getSize();
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u8ba1\u7b97\u7c7b\u578b\u4e3a" + _actualValue.getClass().getName() + "\u7684\u5bf9\u8c61\u957f\u5ea6length\u3002");
    }

    public static Object getValue(Object obj, String property, Object[] params) {
        block6: {
            if (obj == null || property == null || property.trim().length() == 0) {
                return null;
            }
            Class<?> clazz = obj.getClass();
            try {
                if (params == null || params.length == 0) {
                    ClassUtil.PropertieDescription pd = ClassUtil.getPropertyDescriptor(clazz, property);
                    if (pd != null) {
                        return pd.getValue(obj);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("\u7c7b" + clazz.getCanonicalName() + "\u6ca1\u6709\u5b9a\u4e49\u5c5e\u6027" + property);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("\u83b7\u53d6\u7c7b" + clazz.getCanonicalName() + "\u5c5e\u6027[" + property + "]\u503c\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return null;
    }

    public static Object getValueByMethodName(Object obj, String methodName, Object[] params) {
        if (obj == null || methodName == null || methodName.trim().length() == 0) {
            return null;
        }
        return ValueObjectUtil.getValueByMethodName(obj, methodName, params, null);
    }

    public static Method getMethodByPropertyName(Object obj, String propertyName) throws Exception {
        Method method = null;
        try {
            ClassUtil.PropertieDescription pd = ClassUtil.getPropertyDescriptor(obj.getClass(), propertyName);
            if (pd != null) {
                method = pd.getReadMethod();
            }
        }
        catch (SecurityException pd) {
        }
        catch (Exception pd) {
            // empty catch block
        }
        if (method == null) {
            String name = ValueObjectUtil.getBooleanMethodName(propertyName);
            method = ClassUtil.getDeclaredMethod(obj.getClass(), name);
            if (method == null) {
                throw new NoSuchMethodException(obj.getClass().getName() + "." + name);
            }
        }
        return method;
    }

    public static Object getValueByMethodName(Object obj, String methodName, Object[] params, Class[] paramsTtype) {
        if (obj == null || methodName == null || methodName.trim().length() == 0) {
            return null;
        }
        try {
            if (paramsTtype == null || paramsTtype.length == 0) {
                Method method = ClassUtil.getDeclaredMethod(obj.getClass(), methodName);
                if (method != null) {
                    return method.invoke(obj, params);
                }
            } else {
                Method method = obj.getClass().getMethod(methodName, paramsTtype);
                if (method != null) {
                    return method.invoke(obj, params);
                }
            }
        }
        catch (Exception e) {
            log.info("NoSuchMethodException:" + e.getMessage());
        }
        return null;
    }

    public static Object getValueByMethod(Object obj, Method method, Object[] params) {
        if (obj == null || method == null) {
            return null;
        }
        try {
            return method.invoke(obj, params);
        }
        catch (Exception e) {
            log.info("Invoker method[" + method.getName() + "] on " + obj.getClass().getCanonicalName() + " failed:" + e.getMessage());
            return null;
        }
    }

    public static Object invoke(Object obj, Method method, Object[] params) throws Exception {
        return method.invoke(obj, params);
    }

    public static Object invoke(Object obj, String method, Object[] params) throws Exception {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        Method _m = ClassUtil.getDeclaredMethod(clazz, method);
        return _m.invoke(obj, params);
    }

    public static String getMethodName(String fieldName) {
        String ret = null;
        if (fieldName == null) {
            return null;
        }
        String letter = String.valueOf(fieldName.charAt(0));
        letter = letter.toUpperCase();
        ret = "get" + letter + fieldName.substring(1);
        return ret;
    }

    public static String getBooleanMethodName(String fieldName) {
        String ret = null;
        if (fieldName == null) {
            return null;
        }
        String letter = String.valueOf(fieldName.charAt(0));
        letter = letter.toUpperCase();
        ret = "is" + letter + fieldName.substring(1);
        return ret;
    }

    public static String getSetterMethodName(String fieldName) {
        String ret = null;
        if (fieldName == null) {
            return null;
        }
        String letter = String.valueOf(fieldName.charAt(0));
        letter = letter.toUpperCase();
        ret = "set" + letter + fieldName.substring(1);
        return ret;
    }

    public static boolean isSameTypes(Class[] types, Class[] params, Object[] paramArgs) {
        if (types.length != params.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (ValueObjectUtil.isSameType(params[i], types[i], paramArgs[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSameType(Class type, Class toType, Object value) {
        if (toType == Object.class) {
            return true;
        }
        if (type == toType) {
            return true;
        }
        if (toType.isAssignableFrom(type)) {
            return true;
        }
        if (type.isAssignableFrom(toType)) {
            try {
                toType.cast(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (type == Boolean.TYPE && toType == Boolean.class || type == Boolean.class && toType == Boolean.TYPE) {
            return true;
        }
        if (type == Integer.TYPE && toType == Integer.class || type == Integer.class && toType == Integer.TYPE) {
            return true;
        }
        if (type == Short.TYPE && toType == Short.class || type == Short.class && toType == Short.TYPE) {
            return true;
        }
        if (type == Long.TYPE && toType == Long.class || type == Long.class && toType == Long.TYPE) {
            return true;
        }
        if (type == Double.TYPE && toType == Double.class || type == Double.class && toType == Double.TYPE) {
            return true;
        }
        if (type == Float.TYPE && toType == Float.class || type == Float.class && toType == Float.TYPE) {
            return true;
        }
        return type == Character.TYPE && toType == Character.class || type == Character.class && toType == Character.TYPE;
    }

    public static final Object typeCast(Object obj, EditorInf editor) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        return editor.getValueFromObject(obj);
    }

    public static final Object typeCast(Object obj, Class toType, String dateformat) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        return ValueObjectUtil.typeCast(obj, toType, dateformat, (Locale)null);
    }

    public static final Object typeCast(Object obj, Class toType, String dateformat, Locale locale) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        if (toType == null) {
            return obj;
        }
        if (obj == null) {
            return null;
        }
        return ValueObjectUtil.typeCast(obj, obj.getClass(), toType, dateformat, locale);
    }

    public static final Object typeCastWithDateformat(Object obj, Class toType, DateFormat dateformat) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        if (obj == null) {
            return null;
        }
        return ValueObjectUtil.typeCastWithDateformat(obj, obj.getClass(), toType, dateformat);
    }

    public static final Object typeCast(Object obj, Class toType) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        return ValueObjectUtil.typeCast(obj, toType, (String)null, (Locale)null);
    }

    public static final Object typeCast(Object obj, Class type, Class toType) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        return ValueObjectUtil.typeCast(obj, type, toType, null, (Locale)null);
    }

    public static byte[] getByteArrayFromBlob(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        InputStream in = null;
        try {
            out = new ByteArrayOutputStream();
            in = blob.getBinaryStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) > 0) {
                out.write(buf, 0, i);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getStringFromBlob(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        InputStream in = null;
        try {
            out = new ByteArrayOutputStream();
            in = blob.getBinaryStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, i);
            }
            String string = ((Object)out).toString();
            return string;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                    out = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] getByteArrayFromClob(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        StringWriter w = null;
        Reader out = null;
        try {
            w = new StringWriter();
            out = clob.getCharacterStream();
            char[] buf = new char[1024];
            int i = 0;
            while ((i = out.read(buf)) > 0) {
                w.write(buf, 0, i);
            }
            String temp = w.toString();
            byte[] byArray = temp.getBytes();
            return byArray;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (w != null) {
                    w.close();
                    w = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getStringFromClob(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        StringWriter w = null;
        Reader out = null;
        try {
            w = new StringWriter();
            out = clob.getCharacterStream();
            char[] buf = new char[1024];
            int i = 0;
            while ((i = out.read(buf)) > 0) {
                w.write(buf, 0, i);
            }
            String string = w.toString();
            return string;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (w != null) {
                    w.close();
                    w = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getByteStringFromBlob(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        InputStream in = null;
        try {
            out = new ByteArrayOutputStream();
            in = blob.getBinaryStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) > 0) {
                out.write(buf, 0, i);
            }
            Base64 en = new Base64();
            String string = Base64.encode(out.toByteArray());
            return string;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Object cast(Object obj, Class toType) {
        if (!toType.isArray()) {
            return toType.cast(obj);
        }
        int size = Array.getLength(obj);
        Class<?> ctype = toType.getComponentType();
        Object ret = Array.newInstance(ctype, size);
        for (int i = 0; i < size; ++i) {
            Array.set(ret, i, ctype.cast(Array.get(obj, i)));
        }
        return ret;
    }

    public static final Object typeCast(Object obj, Class type, Class toType, String dateformat) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        return ValueObjectUtil.typeCast(obj, type, toType, dateformat, (Locale)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object typeCast(Object obj, Class type, Class toType, String dateformat, Locale locale) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        if (obj == null) {
            return null;
        }
        if (ValueObjectUtil.isSameType(type, toType, obj)) {
            return obj;
        }
        if (type.isAssignableFrom(toType) && !java.util.Date.class.isAssignableFrom(type)) {
            return ValueObjectUtil.cast(obj, toType);
        }
        if (type == byte[].class && toType == String.class) {
            return new String((byte[])obj);
        }
        if (type == String.class && toType == byte[].class) {
            return ((String)obj).getBytes();
        }
        if (Blob.class.isAssignableFrom(type)) {
            try {
                if (File.class.isAssignableFrom(toType)) {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), ".tmp");
                    ValueObjectUtil.getFileFromBlob((Blob)obj, tmp);
                    return tmp;
                }
                if (byte[].class.isAssignableFrom(toType)) {
                    return ValueObjectUtil.getByteArrayFromBlob((Blob)obj);
                }
                return ValueObjectUtil.getStringFromBlob((Blob)obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362" + ",value is  " + obj);
            }
        }
        if (Clob.class.isAssignableFrom(type)) {
            try {
                if (File.class.isAssignableFrom(toType)) {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), ".tmp");
                    ValueObjectUtil.getFileFromClob((Clob)obj, tmp);
                    return tmp;
                }
                if (byte[].class.isAssignableFrom(toType)) {
                    return ValueObjectUtil.getByteArrayFromClob((Clob)obj);
                }
                return ValueObjectUtil.getStringFromClob((Clob)obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362" + ",value is " + obj);
            }
        }
        if (type == byte[].class && File.class.isAssignableFrom(toType)) {
            ByteArrayInputStream byteIn = null;
            FileOutputStream fileOut = null;
            if (!(obj instanceof byte[])) {
                Object[] object = (Object[])obj;
                try {
                    byteIn = new ByteArrayInputStream((byte[])object[0]);
                    fileOut = new FileOutputStream((File)object[1]);
                    byte[] v = new byte[1024];
                    int i = 0;
                    while ((i = byteIn.read(v)) > 0) {
                        fileOut.write(v, 0, i);
                    }
                    fileOut.flush();
                    Object object2 = object[1];
                    return object2;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (byteIn != null) {
                            byteIn.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (fileOut != null) {
                            fileOut.close();
                        }
                    }
                    catch (Exception e) {}
                }
            } else {
                try {
                    byteIn = new ByteArrayInputStream((byte[])obj);
                    File f = File.createTempFile(UUID.randomUUID().toString(), ".soa");
                    fileOut = new FileOutputStream(f);
                    byte[] v = new byte[1024];
                    int i = 0;
                    while ((i = byteIn.read(v)) > 0) {
                        fileOut.write(v, 0, i);
                    }
                    fileOut.flush();
                    File file = f;
                    return file;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (byteIn != null) {
                            byteIn.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (fileOut != null) {
                            fileOut.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        } else if (List.class.isAssignableFrom(toType)) {
            if (!type.isArray()) {
                ArrayList<Object> valueto = new ArrayList<Object>();
                valueto.add(obj);
                return valueto;
            }
            if (type == String[].class) {
                ArrayList<String> valueto = new ArrayList<String>();
                for (String data : (String[])obj) {
                    valueto.add(data);
                }
                return valueto;
            }
        } else if (Set.class.isAssignableFrom(toType)) {
            if (!type.isArray()) {
                TreeSet<Object> valueto = new TreeSet<Object>();
                valueto.add(obj);
                return valueto;
            }
            if (type == String[].class) {
                TreeSet<String> valueto = new TreeSet<String>();
                for (String data : (String[])obj) {
                    valueto.add(data);
                }
                return valueto;
            }
        } else {
            if (File.class.isAssignableFrom(toType) && toType == byte[].class) {
                FileInputStream in = null;
                ByteArrayOutputStream out = null;
                try {
                    int i = 0;
                    in = new FileInputStream((File)obj);
                    out = new ByteArrayOutputStream();
                    byte[] v = new byte[1024];
                    while ((i = in.read(v)) > 0) {
                        out.write(v, 0, i);
                    }
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (type.isArray() && !toType.isArray()) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362" + ",value is " + obj);
            }
            if (type == String.class && toType == Class.class) {
                try {
                    return ValueObjectUtil.getClass((String)obj);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362", e);
                }
            }
        }
        Object arrayObj = !type.isArray() && !toType.isArray() ? ValueObjectUtil.basicTypeCast(obj, type, toType, dateformat, locale) : ValueObjectUtil.arrayTypeCast(obj, type, toType, dateformat);
        return arrayObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object typeCastWithDateformat(Object obj, Class type, Class toType, DateFormat dateformat) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        if (obj == null) {
            return null;
        }
        if (ValueObjectUtil.isSameType(type, toType, obj)) {
            return obj;
        }
        if (type.isAssignableFrom(toType) && !java.util.Date.class.isAssignableFrom(type)) {
            return ValueObjectUtil.cast(obj, toType);
        }
        if (type == byte[].class && toType == String.class) {
            return new String((byte[])obj);
        }
        if (type == String.class && toType == byte[].class) {
            return ((String)obj).getBytes();
        }
        if (Blob.class.isAssignableFrom(type)) {
            try {
                if (File.class.isAssignableFrom(toType)) {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), ".tmp");
                    ValueObjectUtil.getFileFromBlob((Blob)obj, tmp);
                    return tmp;
                }
                if (byte[].class.isAssignableFrom(toType)) {
                    return ValueObjectUtil.getByteArrayFromBlob((Blob)obj);
                }
                return ValueObjectUtil.getStringFromBlob((Blob)obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362" + ",value is " + obj);
            }
        }
        if (Clob.class.isAssignableFrom(type)) {
            try {
                if (File.class.isAssignableFrom(toType)) {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), ".tmp");
                    ValueObjectUtil.getFileFromClob((Clob)obj, tmp);
                    return tmp;
                }
                if (byte[].class.isAssignableFrom(toType)) {
                    return ValueObjectUtil.getByteArrayFromClob((Clob)obj);
                }
                return ValueObjectUtil.getStringFromClob((Clob)obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362" + ",value is " + obj);
            }
        }
        if (type == byte[].class && File.class.isAssignableFrom(toType)) {
            ByteArrayInputStream byteIn = null;
            FileOutputStream fileOut = null;
            if (!(obj instanceof byte[])) {
                Object[] object = (Object[])obj;
                try {
                    byteIn = new ByteArrayInputStream((byte[])object[0]);
                    fileOut = new FileOutputStream((File)object[1]);
                    byte[] v = new byte[1024];
                    int i = 0;
                    while ((i = byteIn.read(v)) > 0) {
                        fileOut.write(v, 0, i);
                    }
                    fileOut.flush();
                    Object object2 = object[1];
                    return object2;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (byteIn != null) {
                            byteIn.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (fileOut != null) {
                            fileOut.close();
                        }
                    }
                    catch (Exception e) {}
                }
            } else {
                try {
                    byteIn = new ByteArrayInputStream((byte[])obj);
                    File f = File.createTempFile(UUID.randomUUID().toString(), ".soa");
                    fileOut = new FileOutputStream(f);
                    byte[] v = new byte[1024];
                    int i = 0;
                    while ((i = byteIn.read(v)) > 0) {
                        fileOut.write(v, 0, i);
                    }
                    fileOut.flush();
                    File file = f;
                    return file;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (byteIn != null) {
                            byteIn.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (fileOut != null) {
                            fileOut.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        } else if (List.class.isAssignableFrom(toType)) {
            if (!type.isArray()) {
                ArrayList<Object> valueto = new ArrayList<Object>();
                valueto.add(obj);
                return valueto;
            }
            if (type == String[].class) {
                ArrayList<String> valueto = new ArrayList<String>();
                for (String data : (String[])obj) {
                    valueto.add(data);
                }
                return valueto;
            }
        } else if (Set.class.isAssignableFrom(toType)) {
            if (!type.isArray()) {
                TreeSet<Object> valueto = new TreeSet<Object>();
                valueto.add(obj);
                return valueto;
            }
            if (type == String[].class) {
                TreeSet<String> valueto = new TreeSet<String>();
                for (String data : (String[])obj) {
                    valueto.add(data);
                }
                return valueto;
            }
        } else {
            if (File.class.isAssignableFrom(toType) && toType == byte[].class) {
                FileInputStream in = null;
                ByteArrayOutputStream out = null;
                try {
                    int i = 0;
                    in = new FileInputStream((File)obj);
                    out = new ByteArrayOutputStream();
                    byte[] v = new byte[1024];
                    while ((i = in.read(v)) > 0) {
                        out.write(v, 0, i);
                    }
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (type.isArray() && !toType.isArray()) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362" + ",value is " + obj);
            }
            if (type == String.class && toType == Class.class) {
                try {
                    return ValueObjectUtil.getClass((String)obj);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362", e);
                }
            }
        }
        Object arrayObj = !type.isArray() && !toType.isArray() ? ValueObjectUtil.basicTypeCastWithDateformat(obj, type, toType, dateformat) : ValueObjectUtil.arrayTypeCastWithDateformat(obj, type, toType, dateformat);
        return arrayObj;
    }

    public static Object shell(Class toType, Object obj) {
        return toType.cast(obj);
    }

    public static final Object basicTypeCast(Object obj, Class type, Class toType) throws NoSupportTypeCastException, NumberFormatException {
        return ValueObjectUtil.basicTypeCast(obj, type, toType, null, null);
    }

    public static SimpleDateFormat getDefaultDateFormat() {
        return DataFormatUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static SimpleDateFormat getDateFormat(String dateformat, Locale locale) {
        if (dateformat == null || dateformat.equals("")) {
            return ValueObjectUtil.getDefaultDateFormat();
        }
        SimpleDateFormat f = DataFormatUtil.getSimpleDateFormat(dateformat, locale);
        return f;
    }

    public static Boolean toBoolean(Object obj) {
        if (obj == null) {
            return new Boolean(false);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            String ret = obj.toString();
            if (ret.equals("1") || ret.equals("true")) {
                return new Boolean(true);
            }
            if (ret.equals("0") || ret.equals("false")) {
                return new Boolean(false);
            }
            return false;
        }
        if (obj instanceof Integer) {
            return (Integer)obj > 0;
        }
        if (obj instanceof Long) {
            return (Long)obj > 0L;
        }
        if (obj instanceof Double) {
            return (Double)obj > 0.0;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue() > 0.0f;
        }
        if (obj instanceof Short) {
            return (Short)obj > 0;
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).intValue() > 0;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).floatValue() > 0.0f;
        }
        return false;
    }

    public static final Object basicTypeCast(Object obj, Class type, Class toType, String dateformat) throws NoSupportTypeCastException, NumberFormatException {
        return ValueObjectUtil.basicTypeCast(obj, type, toType, dateformat, null);
    }

    public static final Object basicTypeCast(Object obj, Class type, Class toType, String dateformat, Locale locale) throws NoSupportTypeCastException, NumberFormatException {
        if (obj == null) {
            return null;
        }
        if (ValueObjectUtil.isSameType(type, toType, obj)) {
            return obj;
        }
        if (type.isAssignableFrom(toType) && !java.util.Date.class.isAssignableFrom(type)) {
            return ValueObjectUtil.shell(toType, obj);
        }
        if (toType == Long.TYPE || toType == Long.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return ((Number)obj).longValue();
            }
            if (java.util.Date.class.isAssignableFrom(type)) {
                return ((java.util.Date)obj).getTime();
            }
            return Long.parseLong(obj.toString());
        }
        if (toType == Integer.TYPE || toType == Integer.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return ((Number)obj).intValue();
            }
            return Integer.parseInt(obj.toString());
        }
        if (toType == Float.TYPE || toType == Float.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return Float.valueOf(((Number)obj).floatValue());
            }
            return Float.valueOf(Float.parseFloat(obj.toString()));
        }
        if (toType == Short.TYPE || toType == Short.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return ((Number)obj).shortValue();
            }
            return Short.parseShort(obj.toString());
        }
        if (toType == Double.TYPE || toType == Double.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return ((Number)obj).doubleValue();
            }
            return Double.parseDouble(obj.toString());
        }
        if (toType == Character.TYPE || toType == Character.class) {
            return new Character(obj.toString().charAt(0));
        }
        if (toType == Boolean.TYPE || toType == Boolean.class) {
            return ValueObjectUtil.toBoolean(obj);
        }
        if (toType == Byte.TYPE || toType == Byte.class) {
            return new Byte(obj.toString());
        }
        if (toType == BigDecimal.class) {
            return ValueObjectUtil.converObjToBigDecimal(obj);
        }
        if (toType == BigInteger.class) {
            return ValueObjectUtil.converObjToBigInteger(obj);
        }
        if (toType == String.class) {
            if (obj instanceof java.util.Date) {
                if (!"".equals(obj)) {
                    return ValueObjectUtil.getDateFormat(dateformat, locale).format(obj);
                }
                return null;
            }
            return obj.toString();
        }
        Object date = ValueObjectUtil.convertObjToDate(obj, toType, dateformat, locale);
        if (date != null) {
            return date;
        }
        if (type == String.class && toType == Class.class) {
            try {
                return ValueObjectUtil.getClass((String)obj);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362", e);
            }
        }
        if (type == String.class && toType.isEnum()) {
            try {
                return ValueObjectUtil.convertStringToEnum((String)obj, toType);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
        }
        throw new NoSupportTypeCastException("\u4e0d\u652f\u6301[" + type + "]\u5411[" + toType + "]\u7684\u8f6c\u6362" + ",value is " + obj);
    }

    public static final Object basicTypeCastWithDateformat(Object obj, Class type, Class toType, DateFormat dateformat) throws NoSupportTypeCastException, NumberFormatException {
        if (obj == null) {
            return null;
        }
        if (ValueObjectUtil.isSameType(type, toType, obj)) {
            return obj;
        }
        if (type.isAssignableFrom(toType) && !java.util.Date.class.isAssignableFrom(type)) {
            return ValueObjectUtil.shell(toType, obj);
        }
        if (toType == Long.TYPE || toType == Long.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return ((Number)obj).longValue();
            }
            if (java.util.Date.class.isAssignableFrom(type)) {
                return ((java.util.Date)obj).getTime();
            }
            return Long.parseLong(obj.toString());
        }
        if (toType == Integer.TYPE || toType == Integer.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return ((Number)obj).intValue();
            }
            return Integer.parseInt(obj.toString());
        }
        if (toType == Float.TYPE || toType == Float.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return Float.valueOf(((Number)obj).floatValue());
            }
            return Float.valueOf(Float.parseFloat(obj.toString()));
        }
        if (toType == Short.TYPE || toType == Short.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return ((Number)obj).shortValue();
            }
            return Short.parseShort(obj.toString());
        }
        if (toType == Double.TYPE || toType == Double.class) {
            if (ValueObjectUtil.isNumber(obj)) {
                return ((Number)obj).doubleValue();
            }
            return Double.parseDouble(obj.toString());
        }
        if (toType == Character.TYPE || toType == Character.class) {
            return new Character(obj.toString().charAt(0));
        }
        if (toType == Boolean.TYPE || toType == Boolean.class) {
            return ValueObjectUtil.toBoolean(obj);
        }
        if (toType == Byte.TYPE || toType == Byte.class) {
            return new Byte(obj.toString());
        }
        if (toType == BigDecimal.class) {
            return ValueObjectUtil.converObjToBigDecimal(obj);
        }
        if (toType == String.class) {
            if (obj instanceof java.util.Date) {
                if (!"".equals(obj)) {
                    if (dateformat == null) {
                        dateformat = ValueObjectUtil.getDefaultDateFormat();
                    }
                    return dateformat.format(obj);
                }
                return null;
            }
            return obj.toString();
        }
        Object date = ValueObjectUtil.convertObjToDateWithDateformat(obj, toType, dateformat);
        if (date != null) {
            return date;
        }
        if (type == String.class && toType == Class.class) {
            try {
                return ValueObjectUtil.getClass((String)obj);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411[" + toType.getName() + "]\u8f6c\u6362", e);
            }
        }
        if (type == String.class && toType.isEnum()) {
            try {
                return ValueObjectUtil.convertStringToEnum((String)obj, toType);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
            }
        }
        throw new NoSupportTypeCastException("\u4e0d\u652f\u6301[" + type + "]\u5411[" + toType + "]\u7684\u8f6c\u6362" + ",value is " + obj);
    }

    public static BigDecimal converObjToBigDecimal(Object obj) {
        if (obj.getClass() == Long.TYPE || obj.getClass() == Long.class) {
            return BigDecimal.valueOf((Long)obj);
        }
        if (obj.getClass() == Short.TYPE || obj.getClass() == Short.class) {
            return BigDecimal.valueOf(((Short)obj).shortValue());
        }
        if (obj.getClass() == Integer.TYPE || obj.getClass() == Integer.class) {
            return BigDecimal.valueOf(((Integer)obj).intValue());
        }
        if (obj.getClass() == Double.TYPE || obj.getClass() == Double.class) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj.getClass() == Float.TYPE || obj.getClass() == Float.class) {
            return BigDecimal.valueOf(((Float)obj).floatValue());
        }
        return new BigDecimal(obj.toString());
    }

    public static BigInteger converObjToBigInteger(Object obj) {
        if (obj.getClass() == Long.TYPE || obj.getClass() == Long.class) {
            return BigInteger.valueOf((Long)obj);
        }
        if (obj.getClass() == Short.TYPE || obj.getClass() == Short.class) {
            return BigInteger.valueOf(((Short)obj).shortValue());
        }
        if (obj.getClass() == Integer.TYPE || obj.getClass() == Integer.class) {
            return BigInteger.valueOf(((Integer)obj).intValue());
        }
        if (obj.getClass() == Double.TYPE || obj.getClass() == Double.class) {
            return BigInteger.valueOf(((Double)obj).longValue());
        }
        if (obj.getClass() == Float.TYPE || obj.getClass() == Float.class) {
            return BigInteger.valueOf(((Float)obj).longValue());
        }
        return new BigInteger(obj.toString());
    }

    public static Object convertObjToDate(Object obj, Class toType, String dateformat) {
        return ValueObjectUtil.convertObjToDate(obj, toType, dateformat, null);
    }

    public static Object convertObjToDate(Object obj, Class toType, String dateformat, Locale locale) {
        if (dateformat == null) {
            return ValueObjectUtil.convertObjToDateWithDateformat(obj, toType, null);
        }
        return ValueObjectUtil.convertObjToDateWithDateformat(obj, toType, ValueObjectUtil.getDateFormat(dateformat, locale));
    }

    public static Object convertObjToDateWithDateformat(Object obj, Class toType, DateFormat dateformat) {
        if (toType == java.util.Date.class) {
            if (java.util.Date.class.isAssignableFrom(obj.getClass())) {
                return obj;
            }
            if (obj.getClass() == Long.TYPE || obj.getClass() == Long.class) {
                return new java.util.Date((Long)obj);
            }
            String data_str = obj.toString();
            if (!"".equals(data_str)) {
                if (dateformat == null) {
                    try {
                        long dl = Long.parseLong(data_str);
                        return new java.util.Date(dl);
                    }
                    catch (Exception e1) {
                        try {
                            dateformat = ValueObjectUtil.getDefaultDateFormat();
                            return new java.util.Date(dateformat.parse(data_str).getTime());
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException("Date format [" + ((SimpleDateFormat)dateformat).toPattern() + "] can not format date : " + data_str, e);
                        }
                    }
                }
                try {
                    return new java.util.Date(dateformat.parse(data_str).getTime());
                }
                catch (ParseException e) {
                    try {
                        long dl = Long.parseLong(data_str);
                        return new java.util.Date(dl);
                    }
                    catch (Exception e1) {
                        throw new IllegalArgumentException("Date format [" + ((SimpleDateFormat)dateformat).toPattern() + "] can not format date : " + data_str, e);
                    }
                }
            }
            return null;
        }
        if (toType == Date.class) {
            if (java.util.Date.class.isAssignableFrom(obj.getClass())) {
                return new Date(((java.util.Date)obj).getTime());
            }
            if (obj.getClass() == Long.TYPE || obj.getClass() == Long.class) {
                return new Date((Long)obj);
            }
            if (obj.getClass() == Integer.TYPE || obj.getClass() == Integer.class) {
                return new Date(((Integer)obj).longValue());
            }
            String data_str = obj.toString();
            if (!"".equals(data_str)) {
                if (dateformat == null) {
                    try {
                        long dl = Long.parseLong(data_str);
                        return new Date(dl);
                    }
                    catch (Exception e1) {
                        try {
                            dateformat = ValueObjectUtil.getDefaultDateFormat();
                            return new Date(dateformat.parse(data_str).getTime());
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException("Date format [" + ((SimpleDateFormat)dateformat).toPattern() + "] can not format date : " + data_str, e);
                        }
                    }
                }
                try {
                    return new Date(dateformat.parse(data_str).getTime());
                }
                catch (ParseException e) {
                    try {
                        long dl = Long.parseLong(data_str);
                        return new Date(dl);
                    }
                    catch (Exception e1) {
                        throw new IllegalArgumentException("Date format [" + ((SimpleDateFormat)dateformat).toPattern() + "] can not format date : " + data_str, e);
                    }
                }
            }
            return null;
        }
        if (toType == Timestamp.class) {
            if (java.util.Date.class.isAssignableFrom(obj.getClass())) {
                return new Timestamp(((java.util.Date)obj).getTime());
            }
            if (obj.getClass() == Long.TYPE || obj.getClass() == Long.class) {
                return new Timestamp((Long)obj);
            }
            String data_str = obj.toString();
            if (!"".equals(data_str)) {
                if (dateformat == null) {
                    try {
                        long dl = Long.parseLong(data_str);
                        return new Timestamp(dl);
                    }
                    catch (Exception e1) {
                        try {
                            dateformat = ValueObjectUtil.getDefaultDateFormat();
                            return new Timestamp(dateformat.parse(data_str).getTime());
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException("Date format [" + ((SimpleDateFormat)dateformat).toPattern() + "] can not format date : " + data_str, e);
                        }
                    }
                }
                try {
                    return new Timestamp(dateformat.parse(data_str).getTime());
                }
                catch (ParseException e) {
                    try {
                        long dl = Long.parseLong(data_str);
                        return new Timestamp(dl);
                    }
                    catch (Exception e1) {
                        throw new IllegalArgumentException("Date format [" + ((SimpleDateFormat)dateformat).toPattern() + "] can not format date : " + data_str, e);
                    }
                }
            }
            return null;
        }
        return null;
    }

    public static <T> T convertStringToEnum(String value, Class<T> enumType) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method valueof = enumType.getMethod("valueOf", String.class);
        return (T)valueof.invoke(null, value);
    }

    public static <T> T[] convertStringToEnumArray(String value, Class<T> enumType, T[] arrays) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method valueof = enumType.getMethod("valueOf", String.class);
        Array.set(arrays, 0, valueof.invoke(null, value));
        return arrays;
    }

    public static <T> T[] convertStringsToEnumArray(String[] value, Class<T> enumType, T[] arrays) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (value == null) {
            return null;
        }
        int i = 0;
        Method valueof = enumType.getMethod("valueOf", String.class);
        for (String v : value) {
            Array.set(arrays, i, valueof.invoke(null, value[i]));
            ++i;
        }
        return arrays;
    }

    public static <T> T[] convertStringToEnumArray(String value, Class<T> enumType) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method valueof = enumType.getMethod("valueOf", String.class);
        Object retvalue = Array.newInstance(enumType, 1);
        Array.set(retvalue, 0, valueof.invoke(null, value));
        return (Object[])retvalue;
    }

    public static <T> T[] convertStringsToEnumArray(String[] value, Class<T> enumType) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (value == null) {
            return null;
        }
        Object retvalue = Array.newInstance(enumType, value.length);
        int i = 0;
        Method valueof = enumType.getMethod("valueOf", String.class);
        for (String v : value) {
            Array.set(retvalue, i, valueof.invoke(null, value[i]));
            ++i;
        }
        return (Object[])retvalue;
    }

    public static final Object arrayTypeCast(Object obj, Class type, Class toType) throws NoSupportTypeCastException, NumberFormatException {
        return ValueObjectUtil.arrayTypeCast(obj, type, toType, null);
    }

    public static final Object arrayTypeCast(Object obj, Class type, Class toType, String dateformat) throws NoSupportTypeCastException, NumberFormatException {
        SimpleDateFormat dateformat_ = null;
        if (dateformat != null) {
            dateformat_ = DataFormatUtil.getSimpleDateFormat(dateformat);
        }
        return ValueObjectUtil.arrayTypeCastWithDateformat(obj, type, toType, dateformat_);
    }

    public static final Object arrayTypeCastWithDateformat(Object obj, Class type, Class toType, DateFormat dateformat) throws NoSupportTypeCastException, NumberFormatException {
        if (ValueObjectUtil.isSameType(type, toType, obj)) {
            return obj;
        }
        if (dateformat == null) {
            dateformat = ValueObjectUtil.getDefaultDateFormat();
        }
        if (toType == long[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                if (java.util.Date.class.isAssignableFrom(type)) {
                    java.util.Date date = (java.util.Date)obj;
                    return new long[]{date.getTime()};
                }
                if (!ValueObjectUtil.isDateArray(obj)) {
                    String[] values = (String[])obj;
                    long[] ret = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        ret[i] = Long.parseLong(values[i]);
                    }
                    return ret;
                }
                int len = Array.getLength(obj);
                long[] ret = new long[len];
                for (int i = 0; i < len; ++i) {
                    java.util.Date date = (java.util.Date)Array.get(obj, i);
                    ret[i] = date.getTime();
                }
                return ret;
            }
            return ValueObjectUtil.tolongArray(obj, componentType);
        }
        if (toType == Long[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                if (!ValueObjectUtil.isDateArray(obj)) {
                    String[] values = (String[])obj;
                    Long[] ret = new Long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        ret[i] = new Long(values[i]);
                    }
                    return ret;
                }
                int len = Array.getLength(obj);
                Long[] ret = new Long[len];
                for (int i = 0; i < len; ++i) {
                    java.util.Date date = (java.util.Date)Array.get(obj, i);
                    ret[i] = date.getTime();
                }
                return ret;
            }
            return ValueObjectUtil.toLongArray(obj, componentType);
        }
        if (toType == int[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                String[] values = (String[])obj;
                int[] ret = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = Integer.parseInt(values[i]);
                }
                return ret;
            }
            return ValueObjectUtil.toIntArray(obj, componentType);
        }
        if (toType == Integer[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                String[] values = (String[])obj;
                Integer[] ret = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = new Integer(values[i]);
                }
                return ret;
            }
            return ValueObjectUtil.toIntegerArray(obj, componentType);
        }
        if (toType == float[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                String[] values = (String[])obj;
                float[] ret = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = Float.parseFloat(values[i]);
                }
                return ret;
            }
            return ValueObjectUtil.tofloatArray(obj, componentType);
        }
        if (toType == Float[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                String[] values = (String[])obj;
                Float[] ret = new Float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = new Float(values[i]);
                }
                return ret;
            }
            return ValueObjectUtil.toFloatArray(obj, componentType);
        }
        if (toType == short[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                String[] values = (String[])obj;
                short[] ret = new short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = Short.parseShort(values[i]);
                }
                return ret;
            }
            return ValueObjectUtil.toshortArray(obj, componentType);
        }
        if (toType == Short[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                String[] values = (String[])obj;
                Short[] ret = new Short[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = new Short(values[i]);
                }
                return ret;
            }
            return ValueObjectUtil.toShortArray(obj, componentType);
        }
        if (toType == double[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                String[] values = (String[])obj;
                double[] ret = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = Double.parseDouble(values[i]);
                }
                return ret;
            }
            return ValueObjectUtil.todoubleArray(obj, componentType);
        }
        if (toType == Double[].class) {
            Class componentType = ValueObjectUtil.isNumberArray(obj);
            if (componentType == null) {
                String[] values = (String[])obj;
                Double[] ret = new Double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    ret[i] = new Double(values[i]);
                }
                return ret;
            }
            return ValueObjectUtil.toDoubleArray(obj, componentType);
        }
        if (toType == BigDecimal[].class) {
            return ValueObjectUtil.toBigDecimalArray(obj, null);
        }
        if (toType == BigInteger[].class) {
            return ValueObjectUtil.toBigIntegerArray(obj, null);
        }
        if (toType == char[].class) {
            String[] values = (String[])obj;
            char[] ret = new char[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].charAt(0);
            }
            return ret;
        }
        if (toType == Character[].class) {
            String[] values = (String[])obj;
            Character[] ret = new Character[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Character(values[i].charAt(0));
            }
            return ret;
        }
        if (toType == boolean[].class) {
            String[] values = (String[])obj;
            boolean[] ret = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = ValueObjectUtil.toBoolean(values[i]);
            }
            return ret;
        }
        if (toType == Boolean[].class) {
            String[] values = (String[])obj;
            Boolean[] ret = new Boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = ValueObjectUtil.toBoolean(values[i]);
            }
            return ret;
        }
        if (toType == byte[].class) {
            String[] values = (String[])obj;
            byte[] ret = new byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Byte(values[i]);
            }
            return ret;
        }
        if (toType == Byte[].class) {
            String[] values = (String[])obj;
            Byte[] ret = new Byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Byte(values[i]);
            }
            return ret;
        }
        if (toType == String[].class) {
            if (obj.getClass() == java.util.Date[].class) {
                return BaseSimpleStringUtil.dateArrayTOStringArray((Date[])obj);
            }
            String[] values = (String[])obj;
            return values;
        }
        Object dates = ValueObjectUtil.convertObjectToDateArrayWithDateFormat(obj, type, toType, dateformat);
        if (dates != null) {
            return dates;
        }
        if (toType.isArray() && toType.getComponentType().isEnum()) {
            if (type == String.class) {
                try {
                    ?[] value = ValueObjectUtil.convertStringToEnumArray((String)obj, toType.getComponentType());
                    return value;
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
            }
            if (type == String[].class) {
                try {
                    ?[] value = ValueObjectUtil.convertStringsToEnumArray((String[])obj, toType.getComponentType());
                    return value;
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[" + type.getName() + "]\u5411\u679a\u4e3e\u7c7b\u578b[" + toType.getName() + "]\u8f6c\u6362\uff0c\u8d85\u51fa\u679a\u4e3e\u503c\u8303\u56f4" + ",value is " + obj);
                }
            }
        }
        throw new NoSupportTypeCastException("\u4e0d\u652f\u6301[" + type + "]\u5411[" + toType + "]\u7684\u8f6c\u6362" + ",value is " + obj);
    }

    public static Object convertObjectToDateArray(Object obj, Class type, Class toType, String dateformat) {
        return ValueObjectUtil.convertObjectToDateArray(obj, type, toType, dateformat, null);
    }

    public static Object convertObjectToDateArray(Object obj, Class type, Class toType, String dateformat, Locale locale) {
        if (dateformat == null) {
            return ValueObjectUtil.convertObjectToDateArrayWithDateFormat(obj, type, toType, ValueObjectUtil.getDefaultDateFormat());
        }
        return ValueObjectUtil.convertObjectToDateArrayWithDateFormat(obj, type, toType, ValueObjectUtil.getDateFormat(dateformat, locale));
    }

    public static Object convertObjectToDateArrayWithDateFormat(Object obj, Class type, Class toType, DateFormat dateformat) {
        if (dateformat == null) {
            dateformat = ValueObjectUtil.getDefaultDateFormat();
        }
        if (toType == java.util.Date[].class) {
            if (type.isArray()) {
                if (type == String[].class) {
                    String[] values = (String[])obj;
                    return BaseSimpleStringUtil.stringArrayTODateArray(values, dateformat);
                }
                long[] values = (long[])obj;
                return BaseSimpleStringUtil.longArrayTODateArray(values, dateformat);
            }
            if (type == String.class) {
                String[] values = new String[]{(String)obj};
                return BaseSimpleStringUtil.stringArrayTODateArray(values, dateformat);
            }
            long[] values = new long[]{(Long)obj};
            return BaseSimpleStringUtil.longArrayTODateArray(values, dateformat);
        }
        if (toType == Date[].class) {
            if (type.isArray()) {
                if (type == String[].class) {
                    String[] values = (String[])obj;
                    return BaseSimpleStringUtil.stringArrayTOSQLDateArray(values, dateformat);
                }
                long[] values = (long[])obj;
                return BaseSimpleStringUtil.longArrayTOSQLDateArray(values, dateformat);
            }
            if (type == String.class) {
                String[] values = new String[]{(String)obj};
                return BaseSimpleStringUtil.stringArrayTOSQLDateArray(values, dateformat);
            }
            long[] values = new long[]{(Long)obj};
            return BaseSimpleStringUtil.longArrayTOSQLDateArray(values, dateformat);
        }
        if (toType == Timestamp[].class) {
            if (type.isArray()) {
                if (type == String[].class) {
                    String[] values = (String[])obj;
                    return BaseSimpleStringUtil.stringArrayTOTimestampArray(values, dateformat);
                }
                long[] values = (long[])obj;
                return BaseSimpleStringUtil.longArrayTOTimestampArray(values, dateformat);
            }
            if (type == String.class) {
                String[] values = new String[]{(String)obj};
                return BaseSimpleStringUtil.stringArrayTOTimestampArray(values, dateformat);
            }
            long[] values = new long[]{(Long)obj};
            return BaseSimpleStringUtil.longArrayTOTimestampArray(values, dateformat);
        }
        return null;
    }

    public static void getFileFromString(String value, File outfile) throws SQLException {
        if (value == null) {
            return;
        }
        byte[] bytes = value.getBytes();
        ValueObjectUtil.getFileFromBytes(bytes, outfile);
    }

    public static void getFileFromBytes(byte[] bytes, File outfile) throws SQLException {
        if (bytes == null) {
            return;
        }
        FileOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            out = new FileOutputStream(outfile);
            byte[] v = bytes;
            in = new ByteArrayInputStream(v);
            byte[] b = new byte[1024];
            int i = 0;
            while ((i = in.read(b)) > 0) {
                out.write(b, 0, i);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void getFileFromClob(Clob value, File outfile) throws SQLException {
        if (value == null) {
            return;
        }
        FileWriter out = null;
        Reader stream = null;
        try {
            out = new FileWriter(outfile);
            Clob clob = value;
            stream = clob.getCharacterStream();
            char[] buf = new char[1024];
            int i = 0;
            while ((i = stream.read(buf)) > 0) {
                ((Writer)out).write(buf, 0, i);
            }
            ((Writer)out).flush();
        }
        catch (IOException e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((Writer)out).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void getFileFromBlob(Blob value, File outfile) throws SQLException {
        if (value == null) {
            return;
        }
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(outfile);
            Blob blob = value;
            byte[] v = new byte[1024];
            in = blob.getBinaryStream();
            int i = 0;
            while ((i = in.read(v)) > 0) {
                out.write(v, 0, i);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new NestedSQLException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                in = null;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                out = null;
            }
        }
    }

    public static Class[] synParamTypes(Class[] params, Object[] paramArgs) {
        Class[] news = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            news[i] = paramArgs[i] != null ? paramArgs[i].getClass() : params[i];
        }
        return news;
    }

    public static Constructor getConstructor(Class clazz, Class[] params_, Object[] paramArgs) {
        return ValueObjectUtil.getConstructor(clazz, params_, paramArgs, false);
    }

    public static Constructor getConstructor(Class clazz, Class[] params_, Object[] paramArgs, boolean synTypes) {
        if (params_ == null || params_.length == 0) {
            return null;
        }
        Class[] params = null;
        params = synTypes ? ValueObjectUtil.synParamTypes(params_, paramArgs) : params_;
        try {
            Constructor constructor = null;
            constructor = clazz.getConstructor(params);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors == null || constructors.length == 0) {
                throw new CurrentlyInCreationException("Inject constructor error: no construction define in the " + clazz + ",\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u914d\u7f6e\u6b63\u786e,\u53c2\u6570\u4e2a\u6570\u662f\u5426\u6b63\u786e.");
            }
            int l = constructors.length;
            int size = params.length;
            Class[] types = null;
            Constructor<?> fault_ = null;
            for (int i = 0; i < l; ++i) {
                Constructor<?> temp = constructors[i];
                types = temp.getParameterTypes();
                if (types == null || types.length != size) continue;
                if (fault_ == null) {
                    fault_ = temp;
                }
                if (!ValueObjectUtil.isSameTypes(types, params, paramArgs)) continue;
                return temp;
            }
            if (fault_ != null) {
                return fault_;
            }
            throw new CurrentlyInCreationException("Inject constructor error: Parameters with construction defined in the " + clazz + " is not matched with the config paramenters .\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u914d\u7f6e\u6b63\u786e,\u53c2\u6570\u4e2a\u6570\u662f\u5426\u6b63\u786e.");
        }
        catch (Exception e) {
            throw new BeanInstanceException("Inject constructor error:" + clazz.getName(), e);
        }
    }

    public static Object typeCast(Object value, Class requiredType, MethodParameter methodParam) throws NumberFormatException, IllegalArgumentException, NoSupportTypeCastException {
        return ValueObjectUtil.typeCast(value, requiredType);
    }

    public static Object typeCast(Object oldValue, Object newValue, Class oldtype, Class toType, WrapperEditorInf editorInf) {
        if (editorInf != null) {
            return editorInf.getValueFromObject(newValue, oldValue);
        }
        return ValueObjectUtil.typeCast(newValue, oldtype, toType);
    }

    public static Object getDefaultValue(Class toType) {
        if (toType == String.class) {
            return null;
        }
        if (toType == Long.TYPE) {
            return 0L;
        }
        if (toType == Integer.TYPE) {
            return 0;
        }
        if (toType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (toType == Double.TYPE) {
            return 0.0;
        }
        if (toType == Boolean.TYPE) {
            return false;
        }
        if (toType == Short.TYPE) {
            return (short)0;
        }
        if (toType == Character.TYPE) {
            return Character.valueOf('0');
        }
        if (toType == Long.class) {
            return null;
        }
        if (toType == Integer.class) {
            return null;
        }
        if (toType == Float.class) {
            return null;
        }
        if (toType == Short.class) {
            return null;
        }
        if (toType == Double.class) {
            return null;
        }
        if (toType == Character.class) {
            return null;
        }
        if (toType == Boolean.class) {
            return null;
        }
        if (toType == Byte.TYPE) {
            return (byte)0;
        }
        if (toType == Byte.class) {
            return new Byte(0);
        }
        return null;
    }

    public static int typecompare(Object value1, Object value2) {
        if (value1 == null && value2 != null) {
            return -1;
        }
        if (value1 != null && value2 == null) {
            return 1;
        }
        if (value1 == null && value2 == null) {
            return 0;
        }
        Class<?> vc1 = value1.getClass();
        try {
            if (value1 instanceof String && value2 instanceof String) {
                return ((String)value1).compareTo((String)value2);
            }
            if (value1 instanceof String) {
                return ((String)value1).compareTo(String.valueOf(value2));
            }
            if (vc1 == Integer.TYPE || Integer.class.isAssignableFrom(vc1)) {
                return ValueObjectUtil.intcompare((Integer)value1, value2);
            }
            if (value2 instanceof String && ((String)value2).equals("")) {
                return -100;
            }
            if (vc1 == Long.TYPE || Long.class.isAssignableFrom(vc1)) {
                return ValueObjectUtil.longCompare((Long)value1, value2);
            }
            if (vc1 == Double.TYPE || Double.class.isAssignableFrom(vc1)) {
                return ValueObjectUtil.doubleCompare((Double)value1, value2);
            }
            if (vc1 == Float.TYPE || Float.class.isAssignableFrom(vc1)) {
                return ValueObjectUtil.floatCompare(((Float)value1).floatValue(), value2);
            }
            if (java.util.Date.class.isAssignableFrom(vc1)) {
                return ValueObjectUtil.dateCompare((java.util.Date)value1, value2);
            }
            if (value1 instanceof java.util.Date && value2 instanceof java.util.Date) {
                return ValueObjectUtil.dateCompare((java.util.Date)value1, (java.util.Date)value2);
            }
            if (vc1 == Short.TYPE || Short.class.isAssignableFrom(vc1)) {
                return ValueObjectUtil.shortCompare((Short)value1, value2);
            }
        }
        catch (Throwable e) {
            log.error("compare value1=" + value1 + ",value2=" + value2 + " failed,use default String compare rules instead.", e);
            return String.valueOf(value1).compareTo(String.valueOf(value2));
        }
        return String.valueOf(value1).compareTo(String.valueOf(value2));
    }

    public static int intcompare(int value1, Object value2) {
        Class<?> vc2 = value2.getClass();
        if (String.class.isAssignableFrom(vc2)) {
            int v2 = Integer.parseInt((String)value2);
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Integer.class.isAssignableFrom(vc2)) {
            int v2 = (Integer)value2;
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Long.class.isAssignableFrom(vc2)) {
            long v2 = (Long)value2;
            if ((long)value1 == v2) {
                return 0;
            }
            if ((long)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Double.class.isAssignableFrom(vc2)) {
            double v2 = (Double)value2;
            if ((double)value1 == v2) {
                return 0;
            }
            if ((double)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Float.class.isAssignableFrom(vc2)) {
            float v2 = ((Float)value2).floatValue();
            if ((float)value1 == v2) {
                return 0;
            }
            if ((float)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Short.class.isAssignableFrom(vc2)) {
            short v2 = (Short)value2;
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (java.util.Date.class.isAssignableFrom(vc2)) {
            long v2 = ((java.util.Date)value2).getTime();
            if ((long)value1 == v2) {
                return 0;
            }
            if ((long)value1 > v2) {
                return 1;
            }
            return -1;
        }
        int v2 = Integer.parseInt((String)value2);
        if (value1 == v2) {
            return 0;
        }
        if (value1 > v2) {
            return 1;
        }
        return -1;
    }

    public static int IntegerCompare(Integer value1, Object value2) {
        return ValueObjectUtil.intcompare(value1, value2);
    }

    public static int longCompare(long value1, Object value2) {
        Class<?> vc2 = value2.getClass();
        if (String.class.isAssignableFrom(vc2)) {
            long v2 = Long.parseLong((String)value2);
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Integer.class.isAssignableFrom(vc2)) {
            int v2 = (Integer)value2;
            if (value1 == (long)v2) {
                return 0;
            }
            if (value1 > (long)v2) {
                return 1;
            }
            return -1;
        }
        if (Long.class.isAssignableFrom(vc2)) {
            long v2 = (Long)value2;
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Double.class.isAssignableFrom(vc2)) {
            double v2 = (Double)value2;
            if ((double)value1 == v2) {
                return 0;
            }
            if ((double)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Float.class.isAssignableFrom(vc2)) {
            float v2 = ((Float)value2).floatValue();
            if ((float)value1 == v2) {
                return 0;
            }
            if ((float)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Short.class.isAssignableFrom(vc2)) {
            short v2 = (Short)value2;
            if (value1 == (long)v2) {
                return 0;
            }
            if (value1 > (long)v2) {
                return 1;
            }
            return -1;
        }
        if (java.util.Date.class.isAssignableFrom(vc2)) {
            long v2 = ((java.util.Date)value2).getTime();
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        long v2 = Long.parseLong((String)value2);
        if (value1 == v2) {
            return 0;
        }
        if (value1 > v2) {
            return 1;
        }
        return -1;
    }

    public static int LongCompare(Long value1, Object value2) {
        return ValueObjectUtil.longCompare(value1, value2);
    }

    public static int doubleCompare(double value1, Object value2) {
        Class<?> vc2 = value2.getClass();
        if (String.class.isAssignableFrom(vc2)) {
            double v2 = Double.parseDouble((String)value2);
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Integer.class.isAssignableFrom(vc2)) {
            int v2 = (Integer)value2;
            if (value1 == (double)v2) {
                return 0;
            }
            if (value1 > (double)v2) {
                return 1;
            }
            return -1;
        }
        if (Long.class.isAssignableFrom(vc2)) {
            long v2 = (Long)value2;
            if (value1 == (double)v2) {
                return 0;
            }
            if (value1 > (double)v2) {
                return 1;
            }
            return -1;
        }
        if (Double.class.isAssignableFrom(vc2)) {
            double v2 = (Double)value2;
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Float.class.isAssignableFrom(vc2)) {
            float v2 = ((Float)value2).floatValue();
            if (value1 == (double)v2) {
                return 0;
            }
            if (value1 > (double)v2) {
                return 1;
            }
            return -1;
        }
        if (Short.class.isAssignableFrom(vc2)) {
            short v2 = (Short)value2;
            if (value1 == (double)v2) {
                return 0;
            }
            if (value1 > (double)v2) {
                return 1;
            }
            return -1;
        }
        if (java.util.Date.class.isAssignableFrom(vc2)) {
            long v2 = ((java.util.Date)value2).getTime();
            if (value1 == (double)v2) {
                return 0;
            }
            if (value1 > (double)v2) {
                return 1;
            }
            return -1;
        }
        double v2 = Double.parseDouble((String)value2);
        if (value1 == v2) {
            return 0;
        }
        if (value1 > v2) {
            return 1;
        }
        return -1;
    }

    public static int DoubleCompare(Double value1, Object value2) {
        return ValueObjectUtil.doubleCompare(value1, value2);
    }

    public static int floatCompare(float value1, Object value2) {
        Class<?> vc2 = value2.getClass();
        if (String.class.isAssignableFrom(vc2)) {
            float v2 = Float.parseFloat(String.valueOf(value2));
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Integer.class.isAssignableFrom(vc2)) {
            int v2 = (Integer)value2;
            if (value1 == (float)v2) {
                return 0;
            }
            if (value1 > (float)v2) {
                return 1;
            }
            return -1;
        }
        if (Long.class.isAssignableFrom(vc2)) {
            long v2 = (Long)value2;
            if (value1 == (float)v2) {
                return 0;
            }
            if (value1 > (float)v2) {
                return 1;
            }
            return -1;
        }
        if (Double.class.isAssignableFrom(vc2)) {
            double v2 = (Double)value2;
            if ((double)value1 == v2) {
                return 0;
            }
            if ((double)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Float.class.isAssignableFrom(vc2)) {
            float v2 = ((Float)value2).floatValue();
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Short.class.isAssignableFrom(vc2)) {
            short v2 = (Short)value2;
            if (value1 == (float)v2) {
                return 0;
            }
            if (value1 > (float)v2) {
                return 1;
            }
            return -1;
        }
        if (java.util.Date.class.isAssignableFrom(vc2)) {
            long v2 = ((java.util.Date)value2).getTime();
            if (value1 == (float)v2) {
                return 0;
            }
            if (value1 > (float)v2) {
                return 1;
            }
            return -1;
        }
        float v2 = Float.parseFloat(String.valueOf(value2));
        if (value1 == v2) {
            return 0;
        }
        if (value1 > v2) {
            return 1;
        }
        return -1;
    }

    public static int FloatCompare(Float value1, Object value2) {
        return ValueObjectUtil.floatCompare(value1.floatValue(), value2);
    }

    public static int shortCompare(short value1, Object value2) {
        Class<?> vc2 = value2.getClass();
        if (String.class.isAssignableFrom(vc2)) {
            short v2 = Short.parseShort(String.valueOf(value2));
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Integer.class.isAssignableFrom(vc2)) {
            int v2 = (Integer)value2;
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Long.class.isAssignableFrom(vc2)) {
            long v2 = (Long)value2;
            if ((long)value1 == v2) {
                return 0;
            }
            if ((long)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Double.class.isAssignableFrom(vc2)) {
            double v2 = (Double)value2;
            if ((double)value1 == v2) {
                return 0;
            }
            if ((double)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Float.class.isAssignableFrom(vc2)) {
            float v2 = ((Float)value2).floatValue();
            if ((float)value1 == v2) {
                return 0;
            }
            if ((float)value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (Short.class.isAssignableFrom(vc2)) {
            short v2 = (Short)value2;
            if (value1 == v2) {
                return 0;
            }
            if (value1 > v2) {
                return 1;
            }
            return -1;
        }
        if (java.util.Date.class.isAssignableFrom(vc2)) {
            long v2 = ((java.util.Date)value2).getTime();
            if ((long)value1 == v2) {
                return 0;
            }
            if ((long)value1 > v2) {
                return 1;
            }
            return -1;
        }
        short v2 = Short.parseShort(String.valueOf(value2));
        if (value1 == v2) {
            return 0;
        }
        if (value1 > v2) {
            return 1;
        }
        return -1;
    }

    public static int ShortCompare(Short value1, Object value2) {
        return ValueObjectUtil.shortCompare(value1, value2);
    }

    public static int dateCompare(java.util.Date value1, Object value2) {
        try {
            Class<?> vc2 = value2.getClass();
            if (java.util.Date.class.isAssignableFrom(vc2)) {
                java.util.Date v2 = (java.util.Date)value2;
                return ValueObjectUtil.dateCompare(value1, v2);
            }
            if (String.class.isAssignableFrom(vc2)) {
                SimpleDateFormat format = DataFormatUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                java.util.Date v2 = format.parse((String)value2);
                return ValueObjectUtil.dateCompare(value1, v2);
            }
            if (Long.class.isAssignableFrom(vc2)) {
                java.util.Date v2 = new java.util.Date((Long)value2);
                return ValueObjectUtil.dateCompare(value1, v2);
            }
            if (Integer.class.isAssignableFrom(vc2)) {
                java.util.Date v2 = new java.util.Date(((Integer)value2).intValue());
                return ValueObjectUtil.dateCompare(value1, v2);
            }
            if (Double.class.isAssignableFrom(vc2)) {
                java.util.Date v2 = new java.util.Date(((Double)value2).longValue());
                return ValueObjectUtil.dateCompare(value1, v2);
            }
            if (Float.class.isAssignableFrom(vc2)) {
                java.util.Date v2 = new java.util.Date(((Float)value2).longValue());
                return ValueObjectUtil.dateCompare(value1, v2);
            }
            if (Short.class.isAssignableFrom(vc2)) {
                java.util.Date v2 = new java.util.Date(((Short)value2).longValue());
                return ValueObjectUtil.dateCompare(value1, v2);
            }
            SimpleDateFormat format = DataFormatUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            java.util.Date v2 = format.parse(String.valueOf(value2));
            return ValueObjectUtil.dateCompare(value1, v2);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int dateCompare(java.util.Date value1, java.util.Date value2) {
        long anotherTime;
        long thisTime = value1.getTime();
        return thisTime < (anotherTime = value2.getTime()) ? -1 : (thisTime == anotherTime ? 0 : 1);
    }

    public static boolean isNumber(Object value) {
        boolean isnumber = value instanceof Number;
        return isnumber;
    }

    public static Class isNumberArray(Object value) {
        if (!value.getClass().isArray()) {
            return null;
        }
        Class<?> componentType = value.getClass().getComponentType();
        if (String.class.isAssignableFrom(componentType)) {
            return null;
        }
        if (componentType == Integer.TYPE || Integer.class.isAssignableFrom(componentType) || componentType == Long.TYPE || Long.class.isAssignableFrom(componentType) || componentType == Double.TYPE || Double.class.isAssignableFrom(componentType) || componentType == Float.TYPE || Float.class.isAssignableFrom(componentType) || componentType == Short.TYPE || Short.class.isAssignableFrom(componentType)) {
            return componentType;
        }
        return null;
    }

    public static boolean isDateArray(Object value) {
        if (!value.getClass().isArray()) {
            return false;
        }
        Class<?> componentType = value.getClass().getComponentType();
        return java.util.Date.class.isAssignableFrom(componentType);
    }

    public static short[] toshortArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new short[]{((Number)value).shortValue()};
            }
            return new short[]{Short.parseShort(value.toString())};
        }
        short[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (short)values[i];
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].shortValue();
            }
            return ret;
        }
        if (componentType == Long.TYPE) {
            long[] values = (long[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (short)values[i];
            }
            return ret;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].shortValue();
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (short)values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].shortValue();
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (short)values[i];
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].shortValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            return (short[])value;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        return null;
    }

    public static Short[] toShortArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new Short[]{((Number)value).shortValue()};
            }
            return new Short[]{Short.parseShort(value.toString())};
        }
        Short[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (short)values[i];
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].shortValue();
            }
            return ret;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].shortValue();
            }
            return ret;
        }
        if (Long.TYPE == componentType) {
            long[] values = (long[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (short)values[i];
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (short)values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].shortValue();
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (short)values[i];
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].shortValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            return (Short[])value;
        }
        return null;
    }

    public static int[] toIntArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new int[]{((Number)value).intValue()};
            }
            return new int[]{Integer.parseInt(value.toString())};
        }
        int[] ret = null;
        if (componentType == Integer.TYPE) {
            return (int[])value;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (componentType == Long.TYPE) {
            long[] values = (long[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (int)values[i];
            }
            return ret;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (int)values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (int)values[i];
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        return null;
    }

    public static Integer[] toIntegerArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new Integer[]{((Number)value).intValue()};
            }
            return new Integer[]{Integer.parseInt(value.toString())};
        }
        Integer[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Integer(values[i]);
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            return (Integer[])value;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        if (Long.TYPE == componentType) {
            long[] values = (long[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (int)values[i];
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (int)values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (int)values[i];
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        return null;
    }

    public static long[] tolongArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new long[]{((Number)value).longValue()};
            }
            return new long[]{Long.parseLong(value.toString())};
        }
        long[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        if (componentType == Long.TYPE) {
            return (long[])value;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (long)values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].longValue();
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (long)values[i];
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].longValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].longValue();
            }
            return ret;
        }
        return null;
    }

    public static Long[] toLongArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new Long[]{((Number)value).longValue()};
            }
            return new Long[]{Long.parseLong(value.toString())};
        }
        Long[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Long(values[i]);
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].longValue();
            }
            return ret;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            return (Long[])value;
        }
        if (Long.TYPE == componentType) {
            long[] values = (long[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (long)values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].longValue();
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (long)values[i];
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].longValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].longValue();
            }
            return ret;
        }
        return null;
    }

    public static float[] tofloatArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new float[]{((Number)value).floatValue()};
            }
            return new float[]{Float.parseFloat(value.toString())};
        }
        float[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].intValue();
            }
            return ret;
        }
        if (componentType == Long.TYPE) {
            long[] values = (long[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].longValue();
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = (float)values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].floatValue();
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            return (float[])value;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].floatValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].floatValue();
            }
            return ret;
        }
        return null;
    }

    public static Float[] toFloatArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new Float[]{Float.valueOf(((Number)value).floatValue())};
            }
            return new Float[]{Float.valueOf(Float.parseFloat(value.toString()))};
        }
        Float[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Float(values[i]);
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.valueOf(values[i].floatValue());
            }
            return ret;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.valueOf(values[i].floatValue());
            }
            return ret;
        }
        if (Long.TYPE == componentType) {
            long[] values = (long[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.valueOf(values[i]);
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.valueOf((float)values[i]);
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.valueOf(values[i].floatValue());
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.valueOf(values[i]);
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            return (Float[])value;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.valueOf(values[i]);
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.valueOf(values[i].floatValue());
            }
            return ret;
        }
        return null;
    }

    public static double[] todoubleArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new double[]{((Number)value).doubleValue()};
            }
            return new double[]{Double.parseDouble(value.toString())};
        }
        double[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].doubleValue();
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            return (double[])value;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].doubleValue();
            }
            return ret;
        }
        if (componentType == Long.TYPE) {
            long[] values = (long[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            Double[] values = (Double[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].doubleValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].doubleValue();
            }
            return ret;
        }
        return null;
    }

    public static BigDecimal[] toBigDecimalArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            return new BigDecimal[]{ValueObjectUtil.converObjToBigDecimal(value)};
        }
        BigDecimal[] ret = null;
        int length = Array.getLength(value);
        ret = new BigDecimal[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = ValueObjectUtil.converObjToBigDecimal(Array.get(value, i));
        }
        return ret;
    }

    public static BigInteger[] toBigIntegerArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            return new BigInteger[]{ValueObjectUtil.converObjToBigInteger(value)};
        }
        BigInteger[] ret = null;
        int length = Array.getLength(value);
        ret = new BigInteger[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = ValueObjectUtil.converObjToBigInteger(Array.get(value, i));
        }
        return ret;
    }

    public static Double[] toDoubleArray(Object value, Class componentType) {
        if (!value.getClass().isArray()) {
            if (ValueObjectUtil.isNumber(value)) {
                return new Double[]{((Number)value).doubleValue()};
            }
            return new Double[]{Double.parseDouble(value.toString())};
        }
        Double[] ret = null;
        if (componentType == Integer.TYPE) {
            int[] values = (int[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Double(values[i]);
            }
            return ret;
        }
        if (Integer.class.isAssignableFrom(componentType)) {
            Integer[] values = (Integer[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].doubleValue();
            }
            return ret;
        }
        if (Long.class.isAssignableFrom(componentType)) {
            Long[] values = (Long[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].doubleValue();
            }
            return ret;
        }
        if (Long.TYPE == componentType) {
            long[] values = (long[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Double(values[i]);
            }
            return ret;
        }
        if (componentType == Double.TYPE) {
            double[] values = (double[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Double.class.isAssignableFrom(componentType)) {
            return (Double[])value;
        }
        if (componentType == Float.TYPE) {
            float[] values = (float[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Float.class.isAssignableFrom(componentType)) {
            Float[] values = (Float[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].doubleValue();
            }
            return ret;
        }
        if (componentType == Short.TYPE) {
            short[] values = (short[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i];
            }
            return ret;
        }
        if (Short.class.isAssignableFrom(componentType)) {
            Short[] values = (Short[])value;
            ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].doubleValue();
            }
            return ret;
        }
        return null;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        System.out.println(ValueObjectUtil.typecompare(0, "0"));
        System.out.println(ValueObjectUtil.typecompare(0, 0));
        Class<List> clazz = List.class;
    }

    public static String getTypeName(Class array) {
        if (array == null) {
            return null;
        }
        if (array.isArray()) {
            String ret = array.getComponentType().getName();
            if (ret.equals("java.lang.String")) {
                return "String[]";
            }
            if (ret.equals("java.lang.Object")) {
                return "Object[]";
            }
            if (ret.equals("java.lang.Class")) {
                return "Class[]";
            }
            if (ret.equals("byte")) {
                return "byte[]";
            }
            ret = array.getName();
            return ret;
        }
        String ret = array.getName();
        if (ret.equals("java.lang.String")) {
            return "String";
        }
        if (ret.equals("java.lang.Object")) {
            return "Object";
        }
        if (ret.equals("java.lang.Class")) {
            return "Class";
        }
        return ret;
    }

    public static String getSimpleTypeName(Class array) {
        if (array == null) {
            return null;
        }
        if (array.isArray()) {
            String ret = array.getComponentType().getName();
            if (ret.equals("java.lang.String")) {
                return "String[]";
            }
            if (ret.equals("java.lang.Object")) {
                return "Object[]";
            }
            if (ret.equals("java.lang.Class")) {
                return "Class[]";
            }
            if (ret.equals("byte")) {
                return "byte[]";
            }
            return array.getName();
        }
        String ret = array.getName();
        if (ret.equals("java.lang.String")) {
            return "String";
        }
        if (ret.equals("java.util.ArrayList")) {
            return "ArrayList";
        }
        if (ret.equals("java.util.HashMap")) {
            return "HashMap";
        }
        if (ret.equals("java.lang.Class")) {
            return "Class";
        }
        if (ret.equals("java.util.TreeSet")) {
            return "TreeSet";
        }
        if (ret.equals("java.lang.Object")) {
            return "Object";
        }
        return ret;
    }

    public static String getComponentTypeName(Class array) {
        if (array == null) {
            return null;
        }
        if (array.isArray()) {
            String ret = array.getComponentType().getName();
            if (ret.equals("java.lang.String")) {
                return "String";
            }
            if (ret.equals("java.lang.Object")) {
                return "Object";
            }
            if (ret.equals("java.lang.Class")) {
                return "Class";
            }
            if (ret.equals("byte")) {
                return "byte";
            }
            return ret;
        }
        String ret = array.getName();
        if (ret.equals("java.lang.String")) {
            return "String";
        }
        if (ret.equals("java.lang.Object")) {
            return "Object";
        }
        if (ret.equals("java.lang.Class")) {
            return "Class";
        }
        return ret;
    }

    public static Class<?> getClass(String type) throws ClassNotFoundException {
        if (type == null) {
            return null;
        }
        if (type.equals("String")) {
            return String.class;
        }
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("Integer")) {
            return Integer.class;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("Long")) {
            return Long.class;
        }
        if (type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("double")) {
            return Double.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("ArrayList")) {
            return ArrayList.class;
        }
        if (type.equals("HashMap")) {
            return HashMap.class;
        }
        if (type.equals("string") || type.equals("java.lang.String") || type.equals("java.lang.string")) {
            return String.class;
        }
        if (type.equals("short")) {
            return Short.TYPE;
        }
        if (type.equals("char")) {
            return Character.TYPE;
        }
        if (type.equals("Boolean")) {
            return Boolean.class;
        }
        if (type.equals("Double")) {
            return Double.class;
        }
        if (type.equals("Float")) {
            return Float.class;
        }
        if (type.equals("Short")) {
            return Short.class;
        }
        if (type.equals("Char") || type.equals("Character") || type.equals("character")) {
            return Character.class;
        }
        if (type.equals("bigint")) {
            return BigInteger.class;
        }
        if (type.equals("bigdecimal")) {
            return BigDecimal.class;
        }
        if (type.equals("String[]")) {
            return String[].class;
        }
        if (type.equals("int[]")) {
            return int[].class;
        }
        if (type.equals("Integer[]")) {
            return Integer[].class;
        }
        if (type.equals("byte[]")) {
            return byte[].class;
        }
        if (type.equals("string[]") || type.equals("java.lang.String[]")) {
            return String[].class;
        }
        if (type.equals("boolean[]")) {
            return boolean[].class;
        }
        if (type.equals("double[]")) {
            return double[].class;
        }
        if (type.equals("float[]")) {
            return float[].class;
        }
        if (type.equals("short[]")) {
            return short[].class;
        }
        if (type.equals("char[]")) {
            return char[].class;
        }
        if (type.equals("long[]")) {
            return long[].class;
        }
        if (type.equals("Long[]")) {
            return Long[].class;
        }
        if (type.equals("Boolean[]")) {
            return Boolean[].class;
        }
        if (type.equals("Double[]")) {
            return Double[].class;
        }
        if (type.equals("Float[]")) {
            return Float[].class;
        }
        if (type.equals("Short[]")) {
            return Short[].class;
        }
        if (type.equals("bigint[]")) {
            return BigInteger[].class;
        }
        if (type.equals("bigdecimal[]")) {
            return BigDecimal[].class;
        }
        if (type.equals("Char[]") || type.equals("Character[]") || type.equals("character[]")) {
            return Character[].class;
        }
        if (type.equals("Class") || type.equals("class")) {
            return Class.class;
        }
        if (type.equals("Class[]") || type.equals("class[]")) {
            return Class[].class;
        }
        if (type.equals("byte")) {
            return Byte.TYPE;
        }
        if (type.equals("TreeSet")) {
            return TreeSet.class;
        }
        if (type.endsWith("[]")) {
            int len = type.length() - 2;
            int idx = type.indexOf("[");
            String subClass = type.substring(0, idx);
            String array = type.substring(idx);
            boolean count = false;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < array.length(); ++i) {
                char c = array.charAt(i);
                if (c != '[') continue;
                builder.append("[");
            }
            builder.append("L").append(subClass).append(";");
            return Class.forName(builder.toString());
        }
        Class<?> Type2 = Class.forName(type);
        return Type2;
    }

    public static String byteArrayEncoder(byte[] contents) {
        Base64 en = new Base64();
        return Base64.encode(contents);
    }

    public static byte[] byteArrayDecoder(String contents) throws Exception {
        if (contents == null) {
            return null;
        }
        Base64 en = new Base64();
        return Base64.decode(contents);
    }

    public static String getFileContent(String configFile) {
        try {
            return ValueObjectUtil.getFileContent(configFile, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
    }

    public static String getFileContent(File file, String charSet) throws IOException {
        ByteArrayOutputStream swriter = null;
        OutputStream temp = null;
        FileInputStream reader = null;
        try {
            reader = new FileInputStream(file);
            swriter = new ByteArrayOutputStream();
            temp = new BufferedOutputStream(swriter);
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)reader).read(buffer)) > 0) {
                temp.write(buffer, 0, len);
            }
            temp.flush();
            String string = swriter.toString(charSet);
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    ((InputStream)reader).close();
                }
                catch (IOException iOException) {}
            }
            if (swriter != null) {
                try {
                    swriter.close();
                }
                catch (IOException iOException) {}
            }
            if (temp != null) {
                try {
                    temp.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getFileContent(String file, String charSet) {
        ByteArrayOutputStream swriter = null;
        OutputStream temp = null;
        InputStream reader = null;
        try {
            reader = ValueObjectUtil.getInputStreamFromFile(file);
            swriter = new ByteArrayOutputStream();
            temp = new BufferedOutputStream(swriter);
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = reader.read(buffer)) > 0) {
                temp.write(buffer, 0, len);
            }
            temp.flush();
            String string = swriter.toString(charSet);
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        catch (Exception e2) {
            String string = "";
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (swriter != null) {
                try {
                    swriter.close();
                }
                catch (IOException iOException) {}
            }
            if (temp != null) {
                try {
                    temp.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] getBytesFileContent(String file) {
        ByteArrayOutputStream swriter = null;
        OutputStream temp = null;
        InputStream reader = null;
        try {
            reader = ValueObjectUtil.getInputStreamFromFile(file);
            swriter = new ByteArrayOutputStream();
            temp = new BufferedOutputStream(swriter);
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = reader.read(buffer)) > 0) {
                temp.write(buffer, 0, len);
            }
            temp.flush();
            byte[] byArray = swriter.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e2) {
            byte[] byArray = null;
            return byArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (swriter != null) {
                try {
                    swriter.close();
                }
                catch (IOException iOException) {}
            }
            if (temp != null) {
                try {
                    temp.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File getClassPathFile(String configFile) throws Exception {
        String url = configFile;
        URL confURL = ValueObjectUtil.class.getClassLoader().getResource(configFile);
        if (confURL == null) {
            confURL = ValueObjectUtil.class.getClassLoader().getResource("/" + configFile);
        }
        if (confURL == null) {
            confURL = ValueObjectUtil.getTCL().getResource(configFile);
        }
        if (confURL == null) {
            confURL = ValueObjectUtil.getTCL().getResource("/" + configFile);
        }
        if (confURL == null) {
            confURL = ClassLoader.getSystemResource(configFile);
        }
        if (confURL == null) {
            confURL = ClassLoader.getSystemResource("/" + configFile);
        }
        if (confURL == null) {
            url = System.getProperty("user.dir");
            File f = new File(url = url + "/" + configFile);
            if (f.exists()) {
                return f;
            }
            return null;
        }
        url = confURL.getFile();
        File f = new File(url);
        if (f.exists()) {
            return f;
        }
        f = new File(confURL.toString());
        return f;
    }

    public static InputStream getInputStreamFromFile(String configFile) throws Exception {
        String url = configFile;
        try {
            URL confURL = ValueObjectUtil.class.getClassLoader().getResource(configFile);
            if (confURL == null) {
                confURL = ValueObjectUtil.class.getClassLoader().getResource("/" + configFile);
            }
            if (confURL == null) {
                confURL = ValueObjectUtil.getTCL().getResource(configFile);
            }
            if (confURL == null) {
                confURL = ValueObjectUtil.getTCL().getResource("/" + configFile);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource(configFile);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource("/" + configFile);
            }
            if (confURL == null) {
                url = System.getProperty("user.dir");
                url = url + "/" + configFile;
                return new FileInputStream(new File(url));
            }
            return confURL.openStream();
        }
        catch (Exception e) {
            return new FileInputStream(configFile);
        }
    }

    public static boolean isSamplePrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : baseTypes) {
                if (primaryType != type) continue;
                return true;
            }
            return false;
        }
        return ValueObjectUtil.isPrimaryType(type.getComponentType());
    }

    public static boolean isPrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : baseTypes) {
                if (!primaryType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
        return ValueObjectUtil.isPrimaryType(type.getComponentType());
    }

    public static boolean isArrayType(Class type) {
        return type.isArray();
    }

    public static boolean isNumeric(Class type) {
        if (!type.isArray()) {
            return Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type);
        }
        return ValueObjectUtil.isNumeric(type.getComponentType());
    }

    public static Class getComponentType(Class type) {
        if (!type.isArray()) {
            return type;
        }
        return ValueObjectUtil.getComponentType(type.getComponentType());
    }

    public static boolean isListType(Class type) {
        return List.class.isAssignableFrom(type);
    }

    public static boolean isMapType(Class type) {
        return Map.class.isAssignableFrom(type);
    }

    public static boolean isEnumType(Class type) {
        return type.isEnum();
    }

    public static boolean isBasePrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : basePrimaryTypes) {
                if (!primaryType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isSimplePrimaryType(Class type) {
        if (!type.isArray()) {
            for (Class primaryType : simplePrimaryTypes) {
                if (primaryType != type) continue;
                return true;
            }
            return type.isEnum();
        }
        return false;
    }

    public static boolean isCollectionType(Class type) {
        return Collection.class.isAssignableFrom(type);
    }

    public static void typeCastCollection(String[] values, Collection targetContainer, Class elementType) {
        for (int i = 0; values != null && i < values.length; ++i) {
            String v = values[i];
            targetContainer.add(ValueObjectUtil.typeCast((Object)v, elementType));
        }
    }

    public static void typeCastCollection(Object values, Collection targetContainer, Class elementType, String dateformat) {
        ValueObjectUtil.typeCastCollection(values, targetContainer, elementType, dateformat, null);
    }

    public static void typeCastCollection(Object values, Collection targetContainer, Class elementType, String dateformat, Locale locale) {
        if (values == null) {
            return;
        }
        if (values.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(values); ++i) {
                Object v = Array.get(values, i);
                targetContainer.add(ValueObjectUtil.typeCast(v, elementType, dateformat, locale));
            }
        } else {
            targetContainer.add(ValueObjectUtil.typeCast(values, elementType));
        }
    }

    public static Collection createCollection(Class targetContainerType) {
        if (List.class.isAssignableFrom(targetContainerType)) {
            ArrayList valueto = new ArrayList();
            return valueto;
        }
        TreeSet valueto = new TreeSet();
        return valueto;
    }

    public static Object typeCastCollection(Object values, Class targetContainerType, Class elementType, String dateformat) {
        return ValueObjectUtil.typeCastCollection(values, targetContainerType, elementType, dateformat, null);
    }

    public static Object typeCastCollection(Object values, Class targetContainerType, Class elementType, String dateformat, Locale locale) {
        if (values == null) {
            return null;
        }
        Collection targetContainer = ValueObjectUtil.createCollection(targetContainerType);
        if (values.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(values); ++i) {
                Object v = Array.get(values, i);
                targetContainer.add(ValueObjectUtil.typeCast(v, elementType, dateformat, locale));
            }
        } else {
            targetContainer.add(ValueObjectUtil.typeCast(values, elementType, dateformat, locale));
        }
        return targetContainer;
    }

    static class Calle {
        Calle() {
        }

        public static void testEnum(Test ... tests) {
            System.out.println(tests);
        }
    }

    static enum Test {
        A,
        B,
        C;

    }
}

