/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.bulk;

import org.frameworkset.bulk.BulkAction;
import org.frameworkset.bulk.CommonBulkConfig;
import org.frameworkset.bulk.CommonBulkInterceptor;
import org.frameworkset.bulk.CommonBulkProcessor;
import org.frameworkset.bulk.CommonBulkProcessorException;
import org.frameworkset.bulk.CommonBulkRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonBulkProcessorBuilder {
    private static Logger logger = LoggerFactory.getLogger(CommonBulkProcessor.class);
    private CommonBulkConfig bulkConfig = new CommonBulkConfig();

    public CommonBulkProcessorBuilder setBulkRetryHandler(CommonBulkRetryHandler bulkRetryHandler) {
        this.bulkConfig.setBulkRetryHandler(bulkRetryHandler);
        return this;
    }

    public CommonBulkProcessorBuilder setRetryTimes(int retryTimes) {
        this.bulkConfig.setRetryTimes(retryTimes);
        return this;
    }

    public CommonBulkProcessorBuilder setBulkAction(BulkAction bulkAction) {
        this.bulkConfig.setBulkAction(bulkAction);
        return this;
    }

    public CommonBulkProcessorBuilder setRetryInterval(long retryInterval) {
        this.bulkConfig.setRetryInterval(retryInterval);
        return this;
    }

    public CommonBulkProcessorBuilder setBulkSizes(int bulkSizes) {
        this.bulkConfig.setBulkSizes(bulkSizes);
        return this;
    }

    public CommonBulkProcessorBuilder setBulkFailRetry(int bulkFailRetry) {
        this.bulkConfig.setBulkFailRetry(bulkFailRetry);
        return this;
    }

    public CommonBulkProcessorBuilder setFlushInterval(long flushInterval) {
        this.bulkConfig.setFlushInterval(flushInterval);
        return this;
    }

    public CommonBulkProcessorBuilder setWorkThreadQueue(int workThreadQueue) {
        this.bulkConfig.setWorkThreadQueue(workThreadQueue);
        return this;
    }

    public CommonBulkProcessorBuilder setWorkThreads(int workThreads) {
        this.bulkConfig.setWorkThreads(workThreads);
        return this;
    }

    public CommonBulkProcessorBuilder addBulkInterceptor(CommonBulkInterceptor bulkInterceptor) {
        this.bulkConfig.addBulkInterceptor(bulkInterceptor);
        return this;
    }

    public CommonBulkProcessorBuilder setBlockedWaitTimeout(long blockedWaitTimeout) {
        this.bulkConfig.setBlockedWaitTimeout(blockedWaitTimeout);
        return this;
    }

    public CommonBulkProcessorBuilder setWarnMultsRejects(int warnMultsRejects) {
        this.bulkConfig.setWarnMultsRejects(warnMultsRejects);
        return this;
    }

    public CommonBulkProcessor build() {
        if (this.bulkConfig == null) {
            throw new CommonBulkProcessorException("Build BulkProcessor failed:bulkConfig is null.");
        }
        if (this.bulkConfig.getBulkAction() == null) {
            throw new CommonBulkProcessorException("Build BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] failed: BulkAction is not setted.");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Build BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] start.....");
        }
        CommonBulkProcessor bulkProcessor = new CommonBulkProcessor(this.bulkConfig);
        bulkProcessor.init();
        if (logger.isInfoEnabled()) {
            logger.info("Build BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] completed.");
        }
        return bulkProcessor;
    }

    public CommonBulkProcessorBuilder setBulkRejectMessage(String bulkRejectMessage) {
        if (bulkRejectMessage == null) {
            bulkRejectMessage = "Reject bulk processor";
        }
        this.bulkConfig.setBulkRejectMessage(bulkRejectMessage);
        return this;
    }

    public CommonBulkProcessorBuilder setBulkProcessorName(String bulkProcessorName) {
        if (bulkProcessorName == null) {
            bulkProcessorName = "BulkProcessor";
        }
        this.bulkConfig.setBulkProcessorName(bulkProcessorName);
        return this;
    }
}

