/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

public class OSInfo {
    private static String OS;
    private static OSInfo _instance;
    private EPlatform platform;
    private static boolean isLinux;
    private static boolean isMacOS;
    private static boolean isMacOSX;
    private static boolean isWindows;
    private static boolean isOS2;
    private static boolean isSolaris;
    private static boolean isSunOS;
    private static boolean isMPEiX;
    private static boolean isHPUX;
    private static boolean isAix;
    private static boolean isOS390;
    private static boolean isFreeBSD;
    private static boolean isIrix;
    private static boolean isDigitalUnix;
    private static boolean isNetWare;
    private static boolean isOSF1;
    private static boolean isOpenVMS;

    private OSInfo() {
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static String getOS() {
        return OS;
    }

    public static boolean isMacOS() {
        return isMacOS;
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isOS2() {
        return isOS2;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isSunOS() {
        return isSunOS;
    }

    public static boolean isMPEiX() {
        return isMPEiX;
    }

    public static boolean isHPUX() {
        return isHPUX;
    }

    public static boolean isAix() {
        return isAix;
    }

    public static boolean isOS390() {
        return isOS390;
    }

    public static boolean isFreeBSD() {
        return isFreeBSD;
    }

    public static boolean isIrix() {
        return isIrix;
    }

    public static boolean isDigitalUnix() {
        return isDigitalUnix;
    }

    public static boolean isNetWare() {
        return isNetWare;
    }

    public static boolean isOSF1() {
        return isOSF1;
    }

    public static boolean isOpenVMS() {
        return isOpenVMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EPlatform getOSname() {
        if (OSInfo._instance.platform != null) {
            return OSInfo._instance.platform;
        }
        Class<EPlatform> clazz = EPlatform.class;
        synchronized (EPlatform.class) {
            if (OSInfo._instance.platform != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return OSInfo._instance.platform;
            }
            OSInfo._instance.platform = OSInfo.isAix() ? EPlatform.AIX : (OSInfo.isDigitalUnix() ? EPlatform.Digital_Unix : (OSInfo.isFreeBSD() ? EPlatform.FreeBSD : (OSInfo.isHPUX() ? EPlatform.HP_UX : (OSInfo.isIrix() ? EPlatform.Irix : (OSInfo.isLinux() ? EPlatform.Linux : (OSInfo.isMacOS() ? EPlatform.Mac_OS : (OSInfo.isMacOSX() ? EPlatform.Mac_OS_X : (OSInfo.isMPEiX() ? EPlatform.MPEiX : (OSInfo.isNetWare() ? EPlatform.NetWare_411 : (OSInfo.isOpenVMS() ? EPlatform.OpenVMS : (OSInfo.isOS2() ? EPlatform.OS2 : (OSInfo.isOS390() ? EPlatform.OS390 : (OSInfo.isOSF1() ? EPlatform.OSF1 : (OSInfo.isSolaris() ? EPlatform.Solaris : (OSInfo.isSunOS() ? EPlatform.SunOS : (OSInfo.isWindows() ? EPlatform.Windows : EPlatform.Others))))))))))))))));
            // ** MonitorExit[var0] (shouldn't be in output)
            return OSInfo._instance.platform;
        }
    }

    public static void main(String[] args) {
        System.out.println((Object)OSInfo.getOSname());
    }

    static {
        _instance = new OSInfo();
        OS = System.getProperty("os.name").toLowerCase();
        isLinux = OS.indexOf("linux") >= 0;
        isMacOS = OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") < 0;
        isMacOSX = OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") > 0;
        isWindows = OS.indexOf("windows") >= 0;
        isOS2 = OS.indexOf("os/2") >= 0;
        isSolaris = OS.indexOf("solaris") >= 0;
        isSunOS = OS.indexOf("sunos") >= 0;
        isMPEiX = OS.indexOf("mpe/ix") >= 0;
        isHPUX = OS.indexOf("hp-ux") >= 0;
        isAix = OS.indexOf("aix") >= 0;
        isOS390 = OS.indexOf("os/390") >= 0;
        isFreeBSD = OS.indexOf("freebsd") >= 0;
        isIrix = OS.indexOf("irix") >= 0;
        isDigitalUnix = OS.indexOf("digital") >= 0 && OS.indexOf("unix") > 0;
        isNetWare = OS.indexOf("netware") >= 0;
        isOSF1 = OS.indexOf("osf1") >= 0;
        isOpenVMS = OS.indexOf("openvms") >= 0;
    }

    public static enum EPlatform {
        Any("any"),
        Linux("Linux"),
        Mac_OS("Mac OS"),
        Mac_OS_X("Mac OS X"),
        Windows("Windows"),
        OS2("OS/2"),
        Solaris("Solaris"),
        SunOS("SunOS"),
        MPEiX("MPE/iX"),
        HP_UX("HP-UX"),
        AIX("AIX"),
        OS390("OS/390"),
        FreeBSD("FreeBSD"),
        Irix("Irix"),
        Digital_Unix("Digital Unix"),
        NetWare_411("NetWare"),
        OSF1("OSF1"),
        OpenVMS("OpenVMS"),
        Others("Others");

        private String description;

        private EPlatform(String desc) {
            this.description = desc;
        }

        public String toString() {
            return this.description;
        }
    }
}

