/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.shutdown;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownUtil {
    private static final Logger log = LoggerFactory.getLogger(ShutdownUtil.class);
    private static List<WrapperRunnable> shutdownHooks = new ArrayList<WrapperRunnable>();
    static PriorComparator priorComparator = new PriorComparator();
    private static Thread shutdownHook;

    public static List<WrapperRunnable> getShutdownHooks() {
        return shutdownHooks;
    }

    private static synchronized void addShutdownHook_(WrapperRunnable destroyVMHook) {
        shutdownHooks.add(destroyVMHook);
        Collections.sort(shutdownHooks, priorComparator);
    }

    public static void addShutdownHook(Runnable destroyVMHook, int proir) {
        try {
            destroyVMHook = new WrapperRunnable(destroyVMHook, proir);
            ShutdownUtil.addShutdownHook_((WrapperRunnable)destroyVMHook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addShutdownHook(Runnable destroyVMHook) {
        ShutdownUtil.addShutdownHook(destroyVMHook, -1);
    }

    public static void shutdown() {
        try {
            if (shutdownHooks != null) {
                for (int i = shutdownHooks.size() - 1; i >= 0; --i) {
                    try {
                        WrapperRunnable destroyVMHook = shutdownHooks.get(i);
                        destroyVMHook.run();
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException destroyVMHook) {
                        continue;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn("", (Throwable)e);
                    }
                }
                shutdownHooks.clear();
                shutdownHooks = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class<?> r = Runtime.getRuntime().getClass();
            Method m = r.getDeclaredMethod("addShutdownHook", Thread.class);
            shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    ShutdownUtil.shutdown();
                }
            });
            m.invoke((Object)Runtime.getRuntime(), shutdownHook);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static class WrapperRunnable
    implements Runnable {
        private final Runnable executor;
        private int proir;
        private boolean executed = false;

        WrapperRunnable(Runnable executor, int proir) {
            this.executor = executor;
            this.proir = proir;
        }

        @Override
        public void run() {
            if (this.executed) {
                return;
            }
            this.executor.run();
            this.executed = true;
        }

        public int getProir() {
            return this.proir;
        }

        public void setProir(int proir) {
            this.proir = proir;
        }
    }

    static class PriorComparator
    implements Comparator<WrapperRunnable> {
        PriorComparator() {
        }

        @Override
        public int compare(WrapperRunnable o1, WrapperRunnable o2) {
            if (o1.getProir() > o2.getProir()) {
                return 1;
            }
            if (o1.getProir() == o2.getProir()) {
                return 0;
            }
            return -1;
        }
    }
}

