/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.ListInfo;
import java.io.Serializable;
import java.util.List;
import org.frameworkset.util.MoreListInfo;

public class RListInfo<T>
implements Serializable {
    private long offset;
    public static final int DEFAULT_MAX_ITEMS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_PAGE_ITEMS = 10;
    public static final int DEFAULT_MAX_INDEX_PAGES = 10;
    private int maxPageItems = 10;
    private long totalSize;
    private int resultSize;
    private List<T> datas;
    private boolean more = false;

    public RListInfo() {
    }

    public RListInfo(long totalSize, long offset, int resultSize, List<T> datas) {
        this.totalSize = totalSize;
        this.resultSize = resultSize;
        this.datas = datas;
        this.offset = offset;
    }

    public RListInfo(ListInfo listInfo) {
        if (listInfo != null) {
            this.totalSize = listInfo.getTotalSize();
            this.more = listInfo.isMore();
            this.maxPageItems = listInfo.getMaxPageItems();
            this.resultSize = this.more ? listInfo.getResultSize() : listInfo.getSize();
            this.datas = listInfo.getDatas();
        }
    }

    public RListInfo(ListInfo listInfo, long offset) {
        this(listInfo);
        this.offset = offset;
    }

    public boolean isMore() {
        return this.more;
    }

    public void setMore(boolean more) {
        this.more = more;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> aDatas) {
        this.datas = aDatas;
    }

    public String toString() {
        return "ListInfo:" + this.getClass() + "\r\ndatas:" + this.datas + "\r\ntotalSize:" + this.totalSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int size() {
        return this.datas != null ? this.datas.size() : 0;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public int getMaxPageItems() {
        return this.maxPageItems;
    }

    public void setMaxPageItems(int maxPageItems) {
        this.maxPageItems = maxPageItems;
    }

    public int getResultSize() {
        return this.resultSize;
    }

    public void setResultSize(int resultSize) {
        this.resultSize = resultSize;
    }

    public static MoreListInfo buildMoreListInfo(RListInfo listInfo) {
        MoreListInfo moreList = new MoreListInfo(listInfo.getResultSize() == listInfo.getMaxPageItems(), listInfo.getResultSize(), listInfo.getDatas());
        return moreList;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

