/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.bulk;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.frameworkset.bulk.BulkAction;
import org.frameworkset.bulk.BulkResult;
import org.frameworkset.bulk.CommonBulkConfig;
import org.frameworkset.bulk.CommonBulkData;
import org.frameworkset.bulk.CommonBulkInterceptor;
import org.frameworkset.bulk.CommonBulkProcessor;
import org.frameworkset.bulk.CommonBulkRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonBulkCommand
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(CommonBulkCommand.class);
    private List<CommonBulkData> batchBulkDatas;
    private CommonBulkProcessor bulkProcessor;
    private Date bulkCommandStartTime;
    private Date bulkCommandCompleteTime;
    private BulkAction bulkAction;

    public Date getBulkCommandStartTime() {
        return this.bulkCommandStartTime;
    }

    public void setBulkCommandStartTime(Date bulkCommandStartTime) {
        this.bulkCommandStartTime = bulkCommandStartTime;
    }

    public Date getBulkCommandCompleteTime() {
        return this.bulkCommandCompleteTime;
    }

    public long getElapsed() {
        if (this.bulkCommandCompleteTime != null && this.bulkCommandStartTime != null) {
            return this.bulkCommandCompleteTime.getTime() - this.bulkCommandStartTime.getTime();
        }
        return 0L;
    }

    public void setBulkCommandCompleteTime(Date bulkCommandCompleteTime) {
        this.bulkCommandCompleteTime = bulkCommandCompleteTime;
    }

    public CommonBulkCommand(CommonBulkProcessor bulkProcessor) {
        this.batchBulkDatas = new ArrayList<CommonBulkData>(bulkProcessor.getBulkSizes());
        this.bulkProcessor = bulkProcessor;
        this.bulkAction = bulkProcessor.getBulkAction();
    }

    private void directRun(List<CommonBulkInterceptor> bulkInterceptors) {
        BulkResult result = this.bulkAction.execute(this);
        this.bulkProcessor.increamentTotalsize(this.getBulkDataSize());
        boolean hasError = result.isError();
        if (!hasError) {
            for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                CommonBulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                try {
                    bulkInterceptor.afterBulk(this, result);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("bulkInterceptor.afterBulk", (Throwable)e);
                }
            }
        } else {
            for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                CommonBulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                try {
                    bulkInterceptor.errorBulk(this, result);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                }
            }
        }
        result = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommonBulkConfig bulkConfig = this.bulkProcessor.getBulkConfig();
        List<CommonBulkInterceptor> bulkInterceptors = bulkConfig.getBulkInterceptors();
        for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
            CommonBulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
            try {
                bulkInterceptor.beforeBulk(this);
                continue;
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("bulkInterceptor.beforeBulk", (Throwable)e);
            }
        }
        CommonBulkRetryHandler bulkRetryHandler = bulkConfig.getBulkRetryHandler();
        int retryTimes = bulkConfig.getRetryTimes();
        if (bulkRetryHandler == null || retryTimes <= 0) {
            try {
                this.setBulkCommandStartTime(new Date());
                this.directRun(bulkInterceptors);
                this.setBulkCommandCompleteTime(new Date());
            }
            catch (Throwable throwable) {
                this.setBulkCommandCompleteTime(new Date());
                this.bulkProcessor.increamentFailedSize(this.getBulkDataSize());
                for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                    CommonBulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                    try {
                        bulkInterceptor.exceptionBulk(this, throwable);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                    }
                }
            }
            finally {
                if (this.batchBulkDatas != null) {
                    this.batchBulkDatas.clear();
                    this.batchBulkDatas = null;
                }
            }
        } else {
            try {
                this.setBulkCommandStartTime(new Date());
                Exception exception = null;
                int count = 0;
                long retryInterval = bulkConfig.getRetryInterval();
                while (true) {
                    if (count > 0 && logger.isInfoEnabled()) {
                        logger.info("Retry bulkprocess {} times.", (Object)count);
                    }
                    try {
                        this.directRun(bulkInterceptors);
                        exception = null;
                    }
                    catch (Exception e) {
                        exception = e;
                        if (!bulkRetryHandler.neadRetry(e, this) || count == retryTimes) break;
                        if (logger.isErrorEnabled()) {
                            logger.error("Exception occur and  Retry process will be take.", (Throwable)e);
                        }
                        ++count;
                        if (retryInterval <= 0L) continue;
                        try {
                            Thread.sleep(retryInterval);
                        }
                        catch (Exception interupt) {
                            break;
                        }
                    }
                }
                this.setBulkCommandCompleteTime(new Date());
                if (exception != null) {
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                this.setBulkCommandCompleteTime(new Date());
                this.bulkProcessor.increamentFailedSize(this.getBulkDataSize());
                for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                    CommonBulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                    try {
                        bulkInterceptor.exceptionBulk(this, throwable);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                    }
                }
            }
            finally {
                if (this.batchBulkDatas != null) {
                    this.batchBulkDatas.clear();
                    this.batchBulkDatas = null;
                }
            }
        }
    }

    public long getTotalSize() {
        return this.bulkProcessor.getTotalSize();
    }

    public long getTotalFailedSize() {
        return this.bulkProcessor.getFailedSize();
    }

    public long getAppendRecords() {
        return this.bulkProcessor.getAppendRecords();
    }

    public CommonBulkProcessor getBulkProcessor() {
        return this.bulkProcessor;
    }

    public List<CommonBulkData> getBatchBulkDatas() {
        return this.batchBulkDatas;
    }

    public void addBulkData(CommonBulkData bulkData) {
        this.batchBulkDatas.add(bulkData);
    }

    public int getBulkDataSize() {
        if (this.batchBulkDatas != null) {
            return this.batchBulkDatas.size();
        }
        return 0;
    }
}

