/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.bulk;

import java.util.ArrayList;
import java.util.List;
import org.frameworkset.bulk.BulkAction;
import org.frameworkset.bulk.CommonBulkInterceptor;
import org.frameworkset.bulk.CommonBulkRetryHandler;

public class CommonBulkConfig {
    private List<CommonBulkInterceptor> bulkInterceptors;
    private long blockedWaitTimeout;
    private int warnMultsRejects;
    private String bulkProcessorName = "BulkProcessor";
    private String bulkRejectMessage = "Reject bulk processor";
    private CommonBulkRetryHandler bulkRetryHandler;
    private int retryTimes = 3;
    private long retryInterval = 0L;
    private int bulkSizes;
    private long flushInterval;
    private int workThreads = 20;
    private int workThreadQueue = 100;
    private BulkAction bulkAction;

    public int getBulkSizes() {
        return this.bulkSizes;
    }

    public CommonBulkConfig setBulkSizes(int bulkSizes) {
        this.bulkSizes = bulkSizes;
        return this;
    }

    public List<CommonBulkInterceptor> getBulkInterceptors() {
        return this.bulkInterceptors;
    }

    public long getFlushInterval() {
        return this.flushInterval;
    }

    public CommonBulkConfig setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public int getWorkThreads() {
        return this.workThreads;
    }

    public CommonBulkConfig setWorkThreads(int workThreads) {
        this.workThreads = workThreads;
        return this;
    }

    public CommonBulkConfig addBulkInterceptor(CommonBulkInterceptor bulkInterceptor) {
        if (this.bulkInterceptors == null) {
            this.bulkInterceptors = new ArrayList<CommonBulkInterceptor>();
        }
        this.bulkInterceptors.add(bulkInterceptor);
        return this;
    }

    public int getWorkThreadQueue() {
        return this.workThreadQueue;
    }

    public CommonBulkConfig setWorkThreadQueue(int workThreadQueue) {
        this.workThreadQueue = workThreadQueue;
        return this;
    }

    public long getBlockedWaitTimeout() {
        return this.blockedWaitTimeout;
    }

    public CommonBulkConfig setBlockedWaitTimeout(long blockedWaitTimeout) {
        this.blockedWaitTimeout = blockedWaitTimeout;
        return this;
    }

    public int getWarnMultsRejects() {
        return this.warnMultsRejects;
    }

    public CommonBulkConfig setWarnMultsRejects(int warnMultsRejects) {
        this.warnMultsRejects = warnMultsRejects;
        return this;
    }

    public String getBulkProcessorName() {
        return this.bulkProcessorName;
    }

    public CommonBulkConfig setBulkProcessorName(String bulkProcessorName) {
        this.bulkProcessorName = bulkProcessorName;
        return this;
    }

    public String getBulkRejectMessage() {
        return this.bulkRejectMessage;
    }

    public CommonBulkConfig setBulkRejectMessage(String bulkRejectMessage) {
        this.bulkRejectMessage = bulkRejectMessage;
        return this;
    }

    public CommonBulkRetryHandler getBulkRetryHandler() {
        return this.bulkRetryHandler;
    }

    public void setBulkRetryHandler(CommonBulkRetryHandler bulkRetryHandler) {
        this.bulkRetryHandler = bulkRetryHandler;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public BulkAction getBulkAction() {
        return this.bulkAction;
    }

    public void setBulkAction(BulkAction bulkAction) {
        this.bulkAction = bulkAction;
    }
}

