/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.bulk;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.bulk.BulkAction;
import org.frameworkset.bulk.CommonBulkCommand;
import org.frameworkset.bulk.CommonBulkConfig;
import org.frameworkset.bulk.CommonBulkData;
import org.frameworkset.bulk.CommonBulkProcessorException;
import org.frameworkset.util.concurrent.ThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonBulkProcessor {
    private Logger logger = LoggerFactory.getLogger(CommonBulkProcessor.class);
    private CommonBulkCommand bulkCommand;
    private long appendRecords;
    private long lastAppendDataTime = -1L;
    private Lock r = new ReentrantLock();
    private Lock w = new ReentrantLock();
    private CommonBulkConfig bulkConfig;
    private Flush flush;
    private ExecutorService executor;
    private BulkAction bulkAction;
    private boolean inited;
    private volatile int status;
    private long totalSize = 0L;
    private long failedSize = 0L;
    private boolean shutdown;

    public CommonBulkConfig getBulkConfig() {
        return this.bulkConfig;
    }

    private CommonBulkCommand buildBulkCommand() {
        return new CommonBulkCommand(this);
    }

    public BulkAction getBulkAction() {
        return this.bulkAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        if (this.status == 1) {
            return;
        }
        this.w.lock();
        try {
            if (this.status == 1) {
                return;
            }
            this.status = 1;
        }
        finally {
            this.w.unlock();
        }
        Flush flush = this.flush;
        synchronized (flush) {
            this.flush.interrupt();
        }
        try {
            this.flush.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public CommonBulkProcessor(CommonBulkConfig bulkConfig) {
        this.bulkConfig = bulkConfig;
    }

    public synchronized void increamentTotalsize(int totalSize) {
        this.r.lock();
        try {
            this.totalSize += (long)totalSize;
        }
        finally {
            this.r.unlock();
        }
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.bulkAction = this.bulkConfig.getBulkAction();
        this.executor = ThreadPoolFactory.buildThreadPool(this.bulkConfig.getBulkProcessorName(), this.bulkConfig.getBulkRejectMessage(), this.bulkConfig.getWorkThreads(), this.bulkConfig.getWorkThreadQueue(), this.bulkConfig.getBlockedWaitTimeout(), this.bulkConfig.getWarnMultsRejects());
        this.bulkCommand = this.buildBulkCommand();
        if (this.bulkConfig.getFlushInterval() > 0L) {
            this.flush = new Flush(this.bulkConfig.getBulkProcessorName() + "-flush-thread");
            this.flush.start();
        }
    }

    private boolean touchBatchSize() {
        return this.bulkCommand != null && this.bulkCommand.getBulkDataSize() >= this.bulkConfig.getBulkSizes();
    }

    public long getLastAppendDataTime() {
        return this.lastAppendDataTime;
    }

    private void appendBulkData(CommonBulkData bulkData) {
        this.w.lock();
        try {
            if (this.bulkCommand == null) {
                return;
            }
            this.assertShutdown();
            this._appendBulkData(bulkData);
        }
        finally {
            this.w.unlock();
        }
    }

    private void _appendBulkData(CommonBulkData bulkData) {
        ++this.appendRecords;
        this.lastAppendDataTime = System.currentTimeMillis();
        this.bulkCommand.addBulkData(bulkData);
        if (this.touchBatchSize()) {
            this.execute(true);
        }
    }

    public long getAppendRecords() {
        return this.appendRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceFlush(long flushInterval) {
        this.w.lock();
        try {
            if (this.bulkCommand == null) {
                return;
            }
            long interval = System.currentTimeMillis() - this.lastAppendDataTime;
            if (interval > flushInterval && this.bulkCommand.getBulkDataSize() > 0) {
                this.execute(true);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private void forceExecute() {
        this.w.lock();
        try {
            if (this.bulkCommand != null && this.bulkCommand.getBulkDataSize() > 0) {
                this.execute(false);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void insertData(Object data) {
        this.assertShutdown();
        CommonBulkData bulkData = new CommonBulkData();
        bulkData.setData(data);
        bulkData.setType(0);
        this.appendBulkData(bulkData);
    }

    public void appendData(Object data, int type) {
        this.assertShutdown();
        CommonBulkData bulkData = new CommonBulkData();
        bulkData.setData(data);
        bulkData.setType(type);
        this.appendBulkData(bulkData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendDatas(List<?> datas, int type) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        this.w.lock();
        try {
            if (this.bulkCommand == null) {
                return;
            }
            this.assertShutdown();
            for (Object data : datas) {
                CommonBulkData bulkData = new CommonBulkData();
                bulkData.setData(data);
                bulkData.setType(type);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void updateData(Object data) {
        this.assertShutdown();
        CommonBulkData bulkData = new CommonBulkData();
        bulkData.setData(data);
        bulkData.setType(1);
        this.appendBulkData(bulkData);
    }

    public void deleteData(Object data) {
        this.assertShutdown();
        CommonBulkData bulkData = new CommonBulkData();
        bulkData.setData(data);
        bulkData.setType(2);
        this.appendBulkData(bulkData);
    }

    private void execute(boolean initBuilCommand) {
        this.executor.submit(this.bulkCommand);
        this.bulkCommand = initBuilCommand ? this.buildBulkCommand() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDatas(List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        this.w.lock();
        try {
            if (this.bulkCommand == null) {
                return;
            }
            this.assertShutdown();
            for (Object data : datas) {
                CommonBulkData bulkData = new CommonBulkData();
                bulkData.setData(data);
                bulkData.setType(0);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatas(List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        this.w.lock();
        try {
            if (this.bulkCommand == null) {
                return;
            }
            this.assertShutdown();
            for (Object data : datas) {
                CommonBulkData bulkData = new CommonBulkData();
                bulkData.setData(data);
                bulkData.setType(1);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean isShutdown() {
        return this.status == 1;
    }

    public void assertShutdown() {
        if (this.isShutdown()) {
            throw new CommonBulkProcessorException("Bulk processor is Shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatas(List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        this.w.lock();
        try {
            if (this.bulkCommand == null) {
                return;
            }
            this.assertShutdown();
            for (Object data : datas) {
                CommonBulkData bulkData = new CommonBulkData();
                bulkData.setData(data);
                bulkData.setType(2);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public long getFailedSize() {
        return this.failedSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void increamentFailedSize(int failedSize) {
        this.r.lock();
        try {
            this.failedSize += (long)failedSize;
        }
        finally {
            this.r.unlock();
        }
    }

    public int getBulkSizes() {
        return this.bulkConfig.getBulkSizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        block15: {
            if (this.shutdown) {
                return;
            }
            CommonBulkProcessor commonBulkProcessor = this;
            synchronized (commonBulkProcessor) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                if (!this.inited) {
                    return;
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ShutDown BulkProcessor[{}] begin.....", (Object)this.bulkConfig.getBulkProcessorName());
            }
            this.stop();
            try {
                this.forceExecute();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.executor != null) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool  begin......");
                    }
                    ThreadPoolFactory.shutdownExecutor(this.executor);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool complete.");
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block15;
                    this.logger.error("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool failed:", (Throwable)e);
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ShutDown BulkProcessor[{}] complete.", (Object)this.bulkConfig.getBulkProcessorName());
        }
    }

    class Flush
    extends Thread {
        public Flush(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long flushInterval = CommonBulkProcessor.this.bulkConfig.getFlushInterval();
            try {
                while (true) {
                    Flush flush = this;
                    synchronized (flush) {
                        this.wait(flushInterval);
                    }
                    CommonBulkProcessor.this.forceFlush(flushInterval);
                    if (!CommonBulkProcessor.this.isShutdown()) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
            }
        }
    }
}

