/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import org.frameworkset.util.io.Resource;

public class FileBlob {
    private int rendtype = DOWNLOAD;
    public static int BROWSER = 0;
    public static int DOWNLOAD = 1;
    private int dataType = 0;
    private String fileName;
    private Object data;

    public int getRendtype() {
        return this.rendtype;
    }

    public void setRendtype(int rendtype) {
        this.rendtype = rendtype;
    }

    public boolean isBlob() {
        return this.dataType == 1;
    }

    public FileBlob(String fileName, Blob data) {
        this.fileName = fileName;
        this.data = data;
        this.dataType = 1;
    }

    public FileBlob(String fileName, Resource data) {
        this.fileName = fileName;
        try {
            this.data = data.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("FileBlob fileName[" + fileName + "] build failed:", e);
        }
        this.dataType = 1;
    }

    public FileBlob(String fileName, InputStream data) {
        this.fileName = fileName;
        this.data = data;
        this.dataType = 2;
    }

    public FileBlob(String fileName, URL data) {
        this.fileName = fileName;
        this.data = data;
        this.dataType = 2;
    }

    public FileBlob(String fileName, String url) {
        this.fileName = fileName;
        try {
            this.data = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.dataType = 2;
    }

    public FileBlob(File data, int rendtype) {
        this.fileName = data.getName();
        this.data = data;
        this.rendtype = rendtype;
        this.dataType = 0;
    }

    public FileBlob(String file) {
        this(file, DOWNLOAD);
    }

    public FileBlob(File data) {
        this(data, DOWNLOAD);
    }

    public FileBlob(String file, int rendtype) {
        File data = new File(file);
        this.fileName = data.getName();
        this.data = data;
        this.rendtype = rendtype;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isdownload() {
        return this.rendtype == DOWNLOAD;
    }

    public boolean isFile() {
        return this.dataType == 0;
    }

    public boolean isStream() {
        return this.dataType == 2;
    }

    public Blob getData() {
        return (Blob)this.data;
    }

    public File getFileData() {
        return (File)this.data;
    }

    public InputStream getInputStream() {
        if (this.data instanceof InputStream) {
            return (InputStream)this.data;
        }
        URL url = (URL)this.data;
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

