/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.annotations;

import com.frameworkset.util.BeanUtils;
import com.frameworkset.util.EditorInf;
import com.frameworkset.util.ValueObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.http.MediaType;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.MethodParameter;
import org.frameworkset.util.ParameterNameDiscoverer;
import org.frameworkset.util.ParameterUtil;
import org.frameworkset.util.annotations.AssertDToken;
import org.frameworkset.util.annotations.AssertTicket;
import org.frameworkset.util.annotations.Attribute;
import org.frameworkset.util.annotations.AttributeScope;
import org.frameworkset.util.annotations.CookieValue;
import org.frameworkset.util.annotations.DataBind;
import org.frameworkset.util.annotations.HandlerMapping;
import org.frameworkset.util.annotations.HttpMethod;
import org.frameworkset.util.annotations.MapKey;
import org.frameworkset.util.annotations.PagerParam;
import org.frameworkset.util.annotations.PathVariable;
import org.frameworkset.util.annotations.PathVariableInfo;
import org.frameworkset.util.annotations.PermissionToken;
import org.frameworkset.util.annotations.RequestBody;
import org.frameworkset.util.annotations.RequestHeader;
import org.frameworkset.util.annotations.RequestParam;
import org.frameworkset.util.annotations.ResponseBody;
import org.frameworkset.util.annotations.Scope;
import org.frameworkset.util.annotations.wraper.AttributeWraper;
import org.frameworkset.util.annotations.wraper.BaseWraper;
import org.frameworkset.util.annotations.wraper.CookieValueWraper;
import org.frameworkset.util.annotations.wraper.PagerParamWraper;
import org.frameworkset.util.annotations.wraper.PathVariableWraper;
import org.frameworkset.util.annotations.wraper.RequestBodyWraper;
import org.frameworkset.util.annotations.wraper.RequestHeaderWraper;
import org.frameworkset.util.annotations.wraper.RequestParamWraper;
import org.frameworkset.util.annotations.wraper.ResponseBodyWraper;
import org.frameworkset.util.beans.BeansException;

public class MethodInfo {
    private Method method;
    private boolean pagerMethod = false;
    private boolean definePageSize = false;
    private int pageSize = 10;
    private MethodParameter[] paramNames;
    private HandlerMapping mapping = null;
    private HandlerMapping typeLevelMapping;
    private AssertDToken assertDToken;
    private AssertTicket assertTicket;
    private PermissionToken permissionToken;
    private boolean requireTicket;
    private boolean responsebody = false;
    private ResponseBodyWraper responsebodyAnno;
    private HttpMethod[] requestMethods;
    private String[] paths;
    private String[] pathPattern;
    private PathVariableInfo[] pathVariables;
    private boolean[] databind;
    private String[] baseurls;
    private boolean requiredDToken = false;
    private Map<Integer, Object> genericParameterTypes = new HashMap<Integer, Object>();

    public MethodInfo(Method method, HandlerMapping typeLevelMapping) {
        this.method = method;
        this.assertDToken = method.getAnnotation(AssertDToken.class);
        this.requiredDToken = this.assertDToken != null;
        this.assertTicket = method.getAnnotation(AssertTicket.class);
        this.requireTicket = this.assertTicket != null;
        this.mapping = method.getAnnotation(HandlerMapping.class);
        this.permissionToken = method.getAnnotation(PermissionToken.class);
        ResponseBody body = method.getAnnotation(ResponseBody.class);
        if (body != null) {
            this.responsebodyAnno = new ResponseBodyWraper(body, method);
            this.responsebody = true;
        }
        if (this.mapping != null) {
            this.requestMethods = this.mapping.method();
        }
        this.typeLevelMapping = typeLevelMapping;
        this.baseurls = typeLevelMapping != null ? typeLevelMapping.value() : null;
        this.paths = this.mapping != null ? this.mapping.value() : null;
        this.pathPattern = this.buildPathPatterns();
        this.parserVariables();
        this.parserInfo();
    }

    public MethodInfo(Method method, String[] baseurls) {
        this.method = method;
        this.mapping = method.getAnnotation(HandlerMapping.class);
        this.assertDToken = method.getAnnotation(AssertDToken.class);
        this.requiredDToken = this.assertDToken != null;
        this.assertTicket = method.getAnnotation(AssertTicket.class);
        this.requireTicket = this.assertTicket != null;
        this.permissionToken = method.getAnnotation(PermissionToken.class);
        ResponseBody body = method.getAnnotation(ResponseBody.class);
        if (body != null) {
            this.responsebodyAnno = new ResponseBodyWraper(body, method);
            this.responsebody = true;
        }
        if (this.mapping != null) {
            this.requestMethods = this.mapping.method();
        }
        this.baseurls = baseurls;
        this.paths = this.mapping != null ? this.mapping.value() : null;
        this.pathPattern = this.buildPathPatterns();
        this.parserVariables();
        this.parserInfo();
    }

    public boolean isResponseBody() {
        return this.responsebody;
    }

    public String toString() {
        if (this.method != null) {
            return this.method.toString();
        }
        return super.toString();
    }

    private MediaType convertMediaType() {
        MediaType temp = null;
        if (this.responsebodyAnno != null) {
            String type = this.responsebodyAnno.datatype();
            String charset = this.responsebodyAnno.charset();
            if (type == null) {
                temp = charset != null ? new MediaType("text", "html", Charset.forName(charset)) : new MediaType("text", "html", Charset.forName("UTF-8"));
            } else if (type.equals("json")) {
                temp = charset != null ? new MediaType("application", "json", Charset.forName(charset)) : new MediaType("application", "json", Charset.forName("UTF-8"));
            } else if (type.equals("jsonp")) {
                temp = charset != null ? new MediaType("application", "jsonp", Charset.forName(charset)) : new MediaType("application", "jsonp", Charset.forName("UTF-8"));
            } else if (type.equals("xml")) {
                temp = charset != null ? new MediaType("application", "xml", Charset.forName(charset)) : new MediaType("application", "xml", Charset.forName("UTF-8"));
            } else if (type.equals("javascript")) {
                temp = charset != null ? new MediaType("application", "javascript", Charset.forName(charset)) : new MediaType("application", "javascript", Charset.forName("UTF-8"));
            }
        }
        return temp;
    }

    public static String getRealPath(String contextPath, String path) {
        if (contextPath == null || contextPath.equals("")) {
            return path == null ? "" : path;
        }
        if (path == null || path.equals("")) {
            return contextPath;
        }
        contextPath = contextPath.replace('\\', '/');
        if ((path = path.replace('\\', '/')).startsWith("/")) {
            if (!contextPath.endsWith("/")) {
                return contextPath + path;
            }
            return contextPath.substring(0, contextPath.length() - 1) + path;
        }
        if (!contextPath.endsWith("/")) {
            return contextPath + "/" + path;
        }
        return contextPath + path;
    }

    private void parserVariables() {
        if (this.paths == null || this.paths.length == 0) {
            return;
        }
        String baseurl = this.baseurls != null && this.baseurls.length > 0 ? this.baseurls[0] : "";
        String path = MethodInfo.getRealPath(baseurl, this.paths[0]);
        this.parserPathdata(path);
    }

    public void parserPathdata(String path) {
        int k;
        ArrayList<String> datas = new ArrayList<String>();
        ArrayList<PathVariableInfo> variables = new ArrayList<PathVariableInfo>();
        int i = 0;
        char c = ' ';
        int end = path.length();
        StringBuilder bu = new StringBuilder();
        do {
            if ((c = (char)path.charAt(i)) == '/') {
                if (bu.length() > 0) {
                    datas.add(bu.toString());
                    bu.setLength(0);
                    continue;
                }
                if (i == end - 1 || i != 0) continue;
                continue;
            }
            bu.append(c);
        } while (++i < end);
        if (bu.length() > 0) {
            datas.add(bu.toString());
            bu = null;
        }
        for (k = 0; k < datas.size(); ++k) {
            int idx;
            String data = (String)datas.get(k);
            if (data.charAt(0) != '{' || (idx = data.lastIndexOf(125)) <= 0) continue;
            String temp = data.substring(1, idx);
            PathVariableInfo v = new PathVariableInfo();
            v.setVariable(temp);
            v.setPostion(k);
            if (idx != data.length() - 1) {
                temp = data.substring(idx + 1);
                v.setConstantstr(temp);
            }
            variables.add(v);
        }
        if (variables.size() > 0) {
            this.pathVariables = new PathVariableInfo[variables.size()];
            for (k = 0; k < variables.size(); ++k) {
                this.pathVariables[k] = (PathVariableInfo)variables.get(k);
            }
        }
    }

    public static String buildPathPattern(String mappedPath) {
        return MethodInfo.buildPathPattern(null, mappedPath);
    }

    public static String buildPathPattern(String baseurl, String mappedPath) {
        StringBuilder pathUrl = new StringBuilder();
        if (baseurl != null) {
            pathUrl.append(baseurl);
        }
        String[] tmp = mappedPath.split("/");
        for (int i = 1; i < tmp.length; ++i) {
            String data = tmp[i];
            if (data.charAt(0) == '{') {
                int idx = data.lastIndexOf(125);
                if (idx > 0) {
                    String temp = data.substring(1, idx);
                    if (idx == data.length() - 1) {
                        pathUrl.append("/*");
                        continue;
                    }
                    temp = data.substring(idx + 1);
                    pathUrl.append("/*").append(temp);
                    continue;
                }
                pathUrl.append("/").append(data);
                continue;
            }
            pathUrl.append("/").append(data);
        }
        return pathUrl.toString();
    }

    private String[] buildPathPatterns() {
        if (this.paths == null || this.paths.length == 0) {
            return null;
        }
        String[] pathPatterns = null;
        if (this.baseurls == null || this.baseurls.length == 0) {
            pathPatterns = new String[this.paths.length];
            int k = 0;
            for (String mappedPath : this.paths) {
                pathPatterns[k] = MethodInfo.buildPathPattern(null, mappedPath);
                ++k;
            }
        } else {
            pathPatterns = new String[this.baseurls.length * this.paths.length];
            int k = 0;
            for (String baseurl : this.baseurls) {
                for (String mappedPath : this.paths) {
                    pathPatterns[k] = MethodInfo.buildPathPattern(baseurl, mappedPath);
                    ++k;
                }
            }
        }
        return pathPatterns;
    }

    public MethodInfo(Method method) {
        this.method = method;
        this.assertDToken = method.getAnnotation(AssertDToken.class);
        this.requiredDToken = this.assertDToken != null;
        this.assertTicket = method.getAnnotation(AssertTicket.class);
        this.requireTicket = this.assertTicket != null;
        this.permissionToken = method.getAnnotation(PermissionToken.class);
        ResponseBody body = method.getAnnotation(ResponseBody.class);
        if (body != null) {
            this.responsebodyAnno = new ResponseBodyWraper(body, method);
            this.responsebody = true;
        }
        this.parserInfo();
    }

    public String[] getPaths() {
        return this.mapping == null ? null : this.mapping.value();
    }

    public PermissionToken getPermissionToken() {
        return this.permissionToken;
    }

    private MethodParameter buildMutilMethodParamAnnotations(Annotation[] annotations, int parampostion, String methodparamname, Class paramType) {
        MethodParameter ret = new MethodParameter(this.method, parampostion);
        ArrayList<MethodParameter> mutilMethodParamAnnotations = new ArrayList<MethodParameter>();
        MethodParameter paramAnno = null;
        Annotation annotation = null;
        boolean ismapkey = false;
        for (int k = 0; k < annotations.length; ++k) {
            Object aa;
            Object param;
            annotation = annotations[k];
            if (annotation instanceof RequestBody) {
                paramAnno = new MethodParameter(this.method, parampostion);
                param = new RequestBodyWraper((RequestBody)annotation, paramType);
                paramAnno.setDataBindScope(Scope.REQUEST_BODY);
                paramAnno.setRequestBody((RequestBodyWraper)param);
                mutilMethodParamAnnotations.add(paramAnno);
                paramAnno.setIsrequestbody(true);
                continue;
            }
            if (annotation instanceof DataBind) {
                paramAnno = new MethodParameter(this.method, parampostion);
                paramAnno.setDataBeanBind(true);
                mutilMethodParamAnnotations.add(paramAnno);
                continue;
            }
            if (annotation instanceof RequestParam) {
                paramAnno = new MethodParameter(this.method, parampostion);
                param = new RequestParamWraper((RequestParam)annotation, paramType);
                paramAnno.setRequestParam((RequestParamWraper)param);
                if (((RequestParamWraper)param).editor() != null && !((RequestParamWraper)param).editor().equals("")) {
                    paramAnno.setEditor((EditorInf)BeanUtils.instantiateClass(((RequestParamWraper)param).editor()));
                }
                if (!((RequestParamWraper)param).name().equals("")) {
                    String paramname = ((RequestParamWraper)param).name();
                    int vstart = paramname.indexOf("${");
                    if (vstart < 0) {
                        paramAnno.setParameterName(paramname);
                    } else {
                        paramAnno.setRequestParamNameToken(ParameterUtil.evalVars(vstart, paramname));
                        paramAnno.setNamevariabled(true);
                    }
                } else {
                    paramAnno.setParameterName(methodparamname);
                }
                paramAnno.setDataBindScope(Scope.REQUEST_PARAM);
                paramAnno.setRequired(((RequestParamWraper)param).required());
                aa = ((BaseWraper)param).defaultvalue();
                if (aa != null) {
                    paramAnno.setDefaultValue(aa);
                }
                mutilMethodParamAnnotations.add(paramAnno);
                continue;
            }
            if (annotation instanceof MapKey) {
                ret = new MethodParameter(this.method, parampostion);
                param = (MapKey)annotation;
                ret.setMapKey((MapKey)param);
                ret.setDataBindScope(Scope.MAP_PARAM);
                ismapkey = true;
                break;
            }
            if (annotation instanceof PagerParam) {
                String id;
                this.setPagerMethod(true);
                paramAnno = new MethodParameter(this.method, parampostion);
                param = new PagerParamWraper((PagerParam)annotation, paramType);
                paramAnno.setPagerParam((PagerParamWraper)param);
                if (((PagerParamWraper)param).editor() != null && !((PagerParamWraper)param).editor().equals("")) {
                    paramAnno.setEditor((EditorInf)BeanUtils.instantiateClass(((PagerParamWraper)param).editor()));
                }
                if (((PagerParamWraper)param).name().equals("PAGE_SIZE")) {
                    this.setDefinePageSize(true);
                    id = ((PagerParamWraper)param).id();
                    paramAnno.setParamNamePrefix(id);
                    paramAnno.setParameterName(((PagerParamWraper)param).name());
                } else {
                    id = ((PagerParamWraper)param).id();
                    if (((PagerParamWraper)param).id() == null) {
                        id = "pager";
                    }
                    if (((PagerParamWraper)param).name().startsWith(id)) {
                        paramAnno.setParameterName(((PagerParamWraper)param).name());
                    } else {
                        paramAnno.setParameterName(id + "." + ((PagerParamWraper)param).name());
                    }
                }
                paramAnno.setDataBindScope(Scope.PAGER_PARAM);
                paramAnno.setRequired(((PagerParamWraper)param).required());
                aa = ((BaseWraper)param).defaultvalue();
                if (aa != null) {
                    paramAnno.setDefaultValue(aa);
                }
                mutilMethodParamAnnotations.add(paramAnno);
                continue;
            }
            if (annotation instanceof PathVariable) {
                paramAnno = new MethodParameter(this.method, parampostion);
                param = new PathVariableWraper((PathVariable)annotation, paramType);
                paramAnno.setPathVariable((PathVariableWraper)param);
                if (((PathVariableWraper)param).editor() != null && !((PathVariableWraper)param).editor().equals("")) {
                    paramAnno.setEditor((EditorInf)BeanUtils.instantiateClass(((PathVariableWraper)param).editor()));
                }
                if (!((PathVariableWraper)param).value().equals("")) {
                    paramAnno.setParameterName(((PathVariableWraper)param).value());
                } else {
                    paramAnno.setParameterName(methodparamname);
                }
                paramAnno.setDataBindScope(Scope.PATHVARIABLE);
                aa = ((BaseWraper)param).defaultvalue();
                if (aa != null) {
                    paramAnno.setDefaultValue(aa);
                }
                mutilMethodParamAnnotations.add(paramAnno);
                continue;
            }
            if (annotation instanceof CookieValue) {
                paramAnno = new MethodParameter(this.method, parampostion);
                param = new CookieValueWraper((CookieValue)annotation, paramType);
                paramAnno.setCookieValue((CookieValueWraper)param);
                if (((CookieValueWraper)param).editor() != null && !((CookieValueWraper)param).editor().equals("")) {
                    paramAnno.setEditor((EditorInf)BeanUtils.instantiateClass(((CookieValueWraper)param).editor()));
                }
                if (!((CookieValueWraper)param).name().equals("")) {
                    paramAnno.setParameterName(((CookieValueWraper)param).name());
                } else {
                    paramAnno.setParameterName(methodparamname);
                }
                paramAnno.setDataBindScope(Scope.COOKIE);
                aa = ((BaseWraper)param).defaultvalue();
                if (aa != null) {
                    paramAnno.setDefaultValue(aa);
                }
                mutilMethodParamAnnotations.add(paramAnno);
                continue;
            }
            if (annotation instanceof RequestHeader) {
                paramAnno = new MethodParameter(this.method, parampostion);
                param = new RequestHeaderWraper((RequestHeader)annotation, paramType);
                paramAnno.setRequestHeader((RequestHeaderWraper)param);
                if (((RequestHeaderWraper)param).editor() != null && !((RequestHeaderWraper)param).editor().equals("")) {
                    paramAnno.setEditor((EditorInf)BeanUtils.instantiateClass(((RequestHeaderWraper)param).editor()));
                }
                if (!((RequestHeaderWraper)param).name().equals("")) {
                    paramAnno.setParameterName(((RequestHeaderWraper)param).name());
                } else {
                    paramAnno.setParameterName(methodparamname);
                }
                paramAnno.setDataBindScope(Scope.REQUEST_HEADER);
                aa = ((BaseWraper)param).defaultvalue();
                if (aa != null) {
                    paramAnno.setDefaultValue(aa);
                }
                mutilMethodParamAnnotations.add(paramAnno);
                continue;
            }
            if (!(annotation instanceof Attribute)) continue;
            paramAnno = new MethodParameter(this.method, parampostion);
            param = new AttributeWraper((Attribute)annotation, paramType);
            paramAnno.setAttribute((AttributeWraper)param);
            paramAnno.setRequired(((AttributeWraper)param).required());
            if (((AttributeWraper)param).editor() != null && !((AttributeWraper)param).editor().equals("")) {
                paramAnno.setEditor((EditorInf)BeanUtils.instantiateClass(((AttributeWraper)param).editor()));
            }
            if (!((AttributeWraper)param).name().equals("")) {
                paramAnno.setParameterName(((AttributeWraper)param).name());
            } else {
                paramAnno.setParameterName(methodparamname);
            }
            if (((AttributeWraper)param).scope() == AttributeScope.PAGECONTEXT_APPLICATION_SCOPE) {
                paramAnno.setDataBindScope(Scope.PAGECONTEXT_APPLICATION_SCOPE);
            } else if (((AttributeWraper)param).scope() == AttributeScope.PAGECONTEXT_PAGE_SCOPE) {
                paramAnno.setDataBindScope(Scope.PAGECONTEXT_PAGE_SCOPE);
            } else if (((AttributeWraper)param).scope() == AttributeScope.PAGECONTEXT_REQUEST_SCOPE) {
                paramAnno.setDataBindScope(Scope.PAGECONTEXT_REQUEST_SCOPE);
            } else if (((AttributeWraper)param).scope() == AttributeScope.PAGECONTEXT_SESSION_SCOPE) {
                paramAnno.setDataBindScope(Scope.PAGECONTEXT_SESSION_SCOPE);
            } else if (((AttributeWraper)param).scope() == AttributeScope.REQUEST_ATTRIBUTE) {
                paramAnno.setDataBindScope(Scope.REQUEST_ATTRIBUTE);
            } else if (((AttributeWraper)param).scope() == AttributeScope.SESSION_ATTRIBUTE) {
                paramAnno.setDataBindScope(Scope.SESSION_ATTRIBUTE);
            } else if (((AttributeWraper)param).scope() == AttributeScope.MODEL_ATTRIBUTE) {
                paramAnno.setDataBindScope(Scope.MODEL_ATTRIBUTE);
            }
            aa = ((BaseWraper)param).defaultvalue();
            if (aa != null) {
                paramAnno.setDefaultValue(aa);
            }
            mutilMethodParamAnnotations.add(paramAnno);
        }
        if (mutilMethodParamAnnotations.size() == 0) {
            if (!ismapkey) {
                MethodParameter temp;
                boolean isprimary = ValueObjectUtil.isPrimaryType(paramType);
                if (isprimary) {
                    temp = new MethodParameter(this.method, parampostion);
                    temp.setParameterName(methodparamname);
                    temp.setPrimaryType(isprimary);
                    return temp;
                }
                temp = new MethodParameter(this.method, parampostion);
                temp.setParameterName(methodparamname);
                temp.setPrimaryType(isprimary);
                return temp;
            }
            return ret;
        }
        ret.setMultiAnnotationParams(mutilMethodParamAnnotations);
        return ret;
    }

    public Class getGenericParameterType(int i) {
        return ClassUtils.genericParameterType(this.method, i);
    }

    public Class[] getGenericParameterTypes(int i) {
        return ClassUtils.genericParameterTypes(this.method, i);
    }

    private void parserInfo() {
        Annotation[][] annotations = this.method.getParameterAnnotations();
        Class<?>[] paramTypes = this.method.getParameterTypes();
        ParameterNameDiscoverer parameterNameDiscoverer = ClassUtil.getParameterNameDiscoverer();
        String[] temp_paramNames = parameterNameDiscoverer.getParameterNames(this.getMethod());
        if (!(temp_paramNames != null && temp_paramNames.length != 0 || annotations != null && annotations.length != 0)) {
            return;
        }
        this.paramNames = new MethodParameter[annotations.length];
        this.databind = new boolean[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            String methodparamName;
            String string = methodparamName = temp_paramNames == null || temp_paramNames.length == 0 ? "" : temp_paramNames[i];
            if (annotations[i].length == 0) {
                MethodParameter temp;
                boolean isprimary = ValueObjectUtil.isPrimaryType(paramTypes[i]);
                if (isprimary && !methodparamName.equals("")) {
                    temp = new MethodParameter(this.method, i);
                    temp.setParameterName(methodparamName);
                    temp.setPrimaryType(isprimary);
                    this.paramNames[i] = temp;
                    continue;
                }
                if (ValueObjectUtil.isCollectionType(paramTypes[i]) && !methodparamName.equals("")) {
                    temp = new MethodParameter(this.method, i);
                    temp.setParameterName(methodparamName);
                    temp.setPrimaryType(false);
                    this.paramNames[i] = temp;
                    continue;
                }
                temp = new MethodParameter(this.method, i);
                temp.setParameterName(methodparamName);
                temp.setPrimaryType(false);
                this.paramNames[i] = temp;
                continue;
            }
            this.paramNames[i] = this.buildMutilMethodParamAnnotations(annotations[i], i, methodparamName, paramTypes[i]);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodParameter[] getParamNames() {
        return this.paramNames;
    }

    public EditorInf getEditor(int index) {
        if (this.paramNames != null) {
            if (this.paramNames.length < index + 1) {
                throw new BeansException("\u975e\u6cd5\u7684param index [" + index + "]\uff1aparamNames length is " + this.paramNames.length);
            }
            return this.paramNames[index].getEditor();
        }
        return null;
    }

    public String getParamName(int index) {
        if (this.paramNames != null) {
            if (this.paramNames.length < index + 1) {
                throw new BeansException("\u975e\u6cd5\u7684paramNames index [" + index + "]\uff1aparamNames length is " + this.paramNames.length);
            }
            return this.paramNames[index].getRequestParameterName();
        }
        return null;
    }

    public MethodParameter getMethodParameter(int index) {
        return this.paramNames[index];
    }

    public boolean isDataBind(int index) {
        if (this.databind != null && this.databind.length < index + 1) {
            throw new BeansException("\u975e\u6cd5\u7684databind index [" + index + "]\uff1adatabind length is " + this.databind.length);
        }
        return this.databind[index];
    }

    public HttpMethod[] getRequestMethods() {
        return this.requestMethods;
    }

    public HandlerMapping getMethodMapping() {
        return this.mapping;
    }

    public HandlerMapping getTypeLevelMapping() {
        return this.typeLevelMapping;
    }

    public String[] getPathPattern() {
        return this.pathPattern;
    }

    public PathVariableInfo[] getPathVariables() {
        return this.pathVariables;
    }

    public boolean isPagerMethod() {
        return this.pagerMethod;
    }

    public void setPagerMethod(boolean pagerMethod) {
        this.pagerMethod = pagerMethod;
    }

    public boolean isDefinePageSize() {
        return this.definePageSize;
    }

    public void setDefinePageSize(boolean definePageSize) {
        this.definePageSize = definePageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public ResponseBodyWraper getResponsebodyAnno() {
        return this.responsebodyAnno;
    }

    public void setResponsebodyAnno(ResponseBodyWraper responsebodyAnno) {
        this.responsebodyAnno = responsebodyAnno;
    }

    public boolean isRequiredDToken() {
        return this.requiredDToken;
    }

    public AssertDToken getAssertDToken() {
        return this.assertDToken;
    }

    public boolean isRequireTicket() {
        return this.requireTicket;
    }

    public AssertTicket getAssertTicket() {
        return this.assertTicket;
    }

    public static void main(String[] args) {
        String path = "/ap/bc/{v1}/{v2}.page";
        String path1 = "/ap/bc/{v1}/{v2}";
        String data = "/ap/bc/ss/dd.page";
    }
}

