/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import com.frameworkset.util.SimpleStringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.frameworkset.spi.assemble.ServiceProviderManager;
import org.frameworkset.util.Assert;
import org.frameworkset.util.io.ClassPathResource;
import org.frameworkset.util.io.ContextResource;
import org.frameworkset.util.io.Resource;
import org.frameworkset.util.io.ResourceLoader;
import org.frameworkset.util.io.UrlResource;

public class HotResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public HotResourceLoader() {
        this.classLoader = HotResourceLoader.class.getClassLoader();
    }

    public HotResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            Object url = null;
            URL confURL = ServiceProviderManager.class.getClassLoader().getResource(location);
            if (confURL == null) {
                confURL = ServiceProviderManager.class.getClassLoader().getResource("/" + location);
            }
            if (confURL == null) {
                confURL = HotResourceLoader.getTCL().getResource(location);
            }
            if (confURL == null) {
                confURL = HotResourceLoader.getTCL().getResource("/" + location);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource(location);
            }
            if (confURL == null) {
                confURL = ClassLoader.getSystemResource("/" + location);
            }
            return new UrlResource(confURL);
        }
        catch (Exception ex) {
            return this.getResourceByPath(location);
        }
    }

    protected Resource getResourceByPath(String path) {
        return new ClassPathContextResource(path, this.getClassLoader());
    }

    private static class ClassPathContextResource
    extends ClassPathResource
    implements ContextResource {
        public ClassPathContextResource(String path, ClassLoader classLoader) {
            super(path, classLoader);
        }

        public String getPathWithinContext() {
            return this.getPath();
        }

        public Resource createRelative(String relativePath) {
            String pathToUse = SimpleStringUtil.applyRelativePath((String)this.getPath(), (String)relativePath);
            return new ClassPathContextResource(pathToUse, this.getClassLoader());
        }
    }
}

