/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi;

import com.frameworkset.proxy.InvocationHandler;
import com.frameworkset.proxy.ProxyFactory;
import com.frameworkset.spi.assemble.BeanInstanceException;
import com.frameworkset.util.ParserError;
import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.frameworkset.spi.CallContext;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.DisposableBean;
import org.frameworkset.spi.Lifecycle;
import org.frameworkset.spi.LocalCallContextImpl;
import org.frameworkset.spi.SPIException;
import org.frameworkset.spi.assemble.BaseTXManager;
import org.frameworkset.spi.assemble.BeanAccembleHelper;
import org.frameworkset.spi.assemble.BeanInf;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.assemble.LinkConfigFile;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProArray;
import org.frameworkset.spi.assemble.ProList;
import org.frameworkset.spi.assemble.ProMap;
import org.frameworkset.spi.assemble.ProProperties;
import org.frameworkset.spi.assemble.ProSet;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.assemble.ProviderManagerInfo;
import org.frameworkset.spi.assemble.RefID;
import org.frameworkset.spi.assemble.ServiceProviderManager;
import org.frameworkset.spi.cglib.CGLibProxy;
import org.frameworkset.spi.cglib.CGLibUtil;
import org.frameworkset.spi.cglib.SimpleCGLibProxy;
import org.frameworkset.spi.cglib.SynCGLibProxy;
import org.frameworkset.spi.cglib.SynTXCGLibProxy;
import org.frameworkset.spi.runtime.Starter;
import org.frameworkset.spi.support.DelegatingMessageSource;
import org.frameworkset.spi.support.HotDeployResourceBundleMessageSource;
import org.frameworkset.spi.support.MessageSource;
import org.frameworkset.spi.support.MessageSourceResolvable;
import org.frameworkset.spi.support.NoSuchMessageException;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.io.DefaultResourceLoader;
import org.frameworkset.util.io.PathMatchingResourcePatternResolver;
import org.frameworkset.util.io.Resource;
import org.frameworkset.util.io.ResourceLoader;
import org.frameworkset.util.io.ResourcePatternResolver;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseApplicationContext
extends DefaultResourceLoader
implements MessageSource,
ResourcePatternResolver,
ResourceLoader,
GetProperties {
    protected ParserError parserError;
    private static final Logger log = LoggerFactory.getLogger(BaseApplicationContext.class);
    private static Long resourcefileRefreshInterval;
    public static int container_type_simple;
    public static int container_type_application;
    public static int container_type_soa;
    public static int container_type_soafile;
    public static int container_type_mvc;
    public static String mvccontainer_identifier;
    protected static Map<String, BaseApplicationContext> applicationContexts;
    protected static List<String> rootFiles;
    protected boolean started = true;
    protected boolean default_singable = true;
    protected boolean needRecordFile = true;
    protected boolean isfile = true;
    protected String baseDir;
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    private static Method getApplicationContextMethod;
    private static final Object lock_getApplicationContextMethod;
    protected String configfile;
    protected URL configFileURL;
    protected String docbaseType;
    protected String docbase;
    protected InputStream instream;
    protected Object initlock = new Object();
    protected boolean applicationContextInited = false;
    protected ServiceProviderManager providerManager;
    protected static Object lock;
    private static String aop_proxy_type;
    private static final String[] aop_webservice_scope_default;
    private static String[] aop_webservice_scope;
    public static final String aop_proxy_type_cglib = "cglib";
    public static final String aop_proxy_type_javaproxy = "javaproxy";
    public static final String aop_proxy_type_default = "cglib";
    protected static final String aop_proxy_type_key = "aop.proxy.type";
    protected static final String aop_webservice_scope_key = "aop.webservice.scope";
    protected static final String AOP_PROPERTIES_PATH = "/aop.properties";
    public static final String DEFAULT_CACHE_KEY = "DEFAULT_CACHE_KEY";
    public static final String SYNCHRO_CACHE_KEY = "SYNCHRO_CACHE_KEY";
    private final Map<String, Object> servicProviders = new HashMap<String, Object>();
    private final List<DestroyMethod> destroyServiceMethods = new ArrayList<DestroyMethod>();
    private final List<DisposableBean> singleDestorys = new ArrayList<DisposableBean>();
    private ResourceLoader resourceLoader;
    private ResourcePatternResolver resourcePatternResolver;
    protected MessageSource messageSource;
    public static final String DEFAULT_MESSAGE_BASENAME = "messages";

    public String getBaseDir() {
        return this.baseDir;
    }

    public static BaseApplicationContext getBaseApplicationContext(String configfile) {
        BaseApplicationContext instance;
        if (configfile == null || configfile.equals("")) {
            log.debug("configfile is null or empty.default Config File[" + ServiceProviderManager.defaultConfigFile + "] will be used. ");
            configfile = ServiceProviderManager.defaultConfigFile;
        }
        if ((instance = applicationContexts.get(configfile)) != null) {
            instance.initApplicationContext();
            return instance;
        }
        return instance;
    }

    @Override
    public String getExternalPropertyWithNS(String namespace, String property) {
        return this.getExternalProperty(property);
    }

    @Override
    public String getExternalPropertyWithNS(String namespace, String property, String defaultValue) {
        return this.getExternalProperty(property, defaultValue);
    }

    @Override
    public Object getExternalObjectPropertyWithNS(String namespace, String property) {
        return this.getExternalObjectProperty(property);
    }

    @Override
    public Object getExternalObjectPropertyWithNS(String namespace, String property, Object defaultValue) {
        return this.getExternalObjectProperty(property, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method initGetApplicationContextMethod() throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        if (getApplicationContextMethod != null) {
            return getApplicationContextMethod;
        }
        Object object = lock_getApplicationContextMethod;
        synchronized (object) {
            Method m;
            if (getApplicationContextMethod != null) {
                return getApplicationContextMethod;
            }
            Class<?> clazz = Class.forName("org.frameworkset.spi.ApplicationContext");
            getApplicationContextMethod = m = clazz.getDeclaredMethod("getApplicationContext", String.class);
        }
        return getApplicationContextMethod;
    }

    public static BaseApplicationContext getBaseApplicationContext(String applicationContextPath, int containerType) {
        if (containerType == container_type_application) {
            try {
                Method m = BaseApplicationContext.initGetApplicationContextMethod();
                return (BaseApplicationContext)m.invoke(null, applicationContextPath);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (containerType == container_type_simple) {
            try {
                return DefaultApplicationContext.getApplicationContext(applicationContextPath);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (containerType == container_type_mvc) {
            try {
                return BaseApplicationContext.getBaseApplicationContext(mvccontainer_identifier);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("\u83b7\u53d6\u5e94\u7528\u4e0a\u4e0b\u6587\u5bb9\u5668\u5931\u8d25,\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1aapplicationContextPath[" + applicationContextPath + "],containerType=" + containerType);
    }

    public boolean defaultsingable() {
        return this.default_singable;
    }

    public void destroy() {
        this.destroy(false);
    }

    public void destroy(boolean clearContext) {
        if (!this.started) {
            return;
        }
        if (this.servicProviders != null) {
            this.servicProviders.clear();
        }
        try {
            this.destroySingleBeans();
        }
        catch (Exception e) {
            log.error("Destroy Single Beans", (Throwable)e);
        }
        if (this.singleDestorys != null) {
            this.singleDestorys.clear();
        }
        if (this.destroyServiceMethods != null) {
            this.destroyServiceMethods.clear();
        }
        if (this.providerManager != null) {
            this.providerManager.destroy();
        }
        if (clearContext && applicationContexts != null) {
            applicationContexts.remove(this.getConfigfile());
        }
        this.applicationContextInited = false;
        this.messageSource = null;
        this.resourcePatternResolver = null;
        this.started = false;
        this.parserError = null;
    }

    public boolean stoped() {
        return !this.started;
    }

    public static List<String> getRootFiles() {
        return rootFiles;
    }

    public URL getConfigFileURL() {
        return this.configFileURL;
    }

    public String getRealConfigPath() {
        if (this.configFileURL != null) {
            return this.configFileURL.toString();
        }
        return this.configfile;
    }

    public void setConfigFileURL(URL configFileURL) {
        this.configFileURL = configFileURL;
    }

    protected BaseApplicationContext(String configfile) {
        this("classpath::", "", configfile);
    }

    protected BaseApplicationContext(String content, boolean isfile, boolean init) {
        this("classpath::", "", content, isfile, init);
    }

    protected BaseApplicationContext(String content, boolean isfile, String charset, boolean init) {
        this("classpath::", "", content, isfile, charset, init);
    }

    protected BaseApplicationContext(String docbaseType, String docbase, String configfile) {
        this(docbaseType, docbase, configfile, true, true);
    }

    protected BaseApplicationContext(String docbaseType, String docbase, String configfile, boolean isfile, boolean init) {
        if (configfile == null || configfile.equals("")) {
            throw new NullPointerException("build ApplicationContext failed:configfile is " + configfile);
        }
        this.isfile = isfile;
        if (isfile) {
            this.configfile = configfile;
            rootFiles.add(configfile);
        } else {
            this.needRecordFile = false;
        }
        if (init) {
            this.providerManager = this._getServiceProviderManager();
            this.providerManager.init(docbaseType, docbase, configfile);
        } else {
            this.docbaseType = docbaseType;
            this.docbase = docbase;
            this.configfile = configfile;
        }
    }

    protected void reinit() {
        if (this.configfile == null || this.configfile.equals("")) {
            throw new NullPointerException("build ApplicationContext failed:configfile is " + this.configfile);
        }
        this.isfile = this.isfile;
        if (this.isfile) {
            this.configfile = this.configfile;
            rootFiles.add(this.configfile);
        } else {
            this.needRecordFile = false;
        }
        this.providerManager = this._getServiceProviderManager();
        this.providerManager.init(this.docbaseType, this.docbase, this.configfile);
    }

    public void init() {
        try {
            this.providerManager = this._getServiceProviderManager();
            if (this.instream == null) {
                this.providerManager.init(this.docbaseType, this.docbase, this.configfile);
            } else {
                this.providerManager.init(this.docbaseType, this.docbase, this.instream);
            }
        }
        finally {
            this.docbaseType = null;
            this.docbase = null;
            this.configfile = null;
            this.instream = null;
        }
    }

    protected BaseApplicationContext(String docbaseType, String docbase, String configfile, boolean isfile, String charset, boolean init) {
        if (configfile == null || configfile.equals("")) {
            throw new NullPointerException("build ApplicationContext failed:configfile is " + configfile);
        }
        this.isfile = isfile;
        if (isfile) {
            this.configfile = configfile;
            rootFiles.add(configfile);
        } else {
            this.needRecordFile = false;
        }
        if (init) {
            this.providerManager = this._getServiceProviderManagerWithCharset(charset);
            this.providerManager.init(docbaseType, docbase, configfile);
        } else {
            this.docbaseType = docbaseType;
            this.docbase = docbase;
            this.configfile = configfile;
        }
    }

    public PropertiesContainer getPropertiesContainer() {
        if (this.providerManager != null) {
            return this.providerManager.getPropertiesContainer();
        }
        return null;
    }

    public BaseApplicationContext(String docbaseType, String docbase, InputStream instream, boolean isfile, boolean init) {
        if (instream == null) {
            throw new NullPointerException("build ApplicationContext failed:instream is null.");
        }
        this.isfile = isfile;
        if (!isfile) {
            this.needRecordFile = false;
        }
        if (init) {
            this.providerManager = this._getServiceProviderManager();
            this.providerManager.init(docbaseType, docbase, instream);
        } else {
            this.docbaseType = docbaseType;
            this.docbase = docbase;
            this.instream = instream;
        }
    }

    public BaseApplicationContext(String docbaseType, String docbase, URL instream, boolean isfile) {
        if (instream == null) {
            throw new NullPointerException("build ApplicationContext failed:instream is null.");
        }
        this.isfile = isfile;
        if (isfile) {
            this.configfile = instream.getFile();
            rootFiles.add(this.configfile);
        } else {
            this.needRecordFile = false;
        }
        this.providerManager = this._getServiceProviderManager();
        this.providerManager.init(docbaseType, "", this.configfile, instream);
    }

    public BaseApplicationContext(String baseDir, URL file, String path) {
        this(baseDir, file, path, true);
    }

    public BaseApplicationContext(String baseDir, URL file, String path, boolean needInit) {
        if (file == null) {
            throw new NullPointerException("build ApplicationContext failed:configfile is " + null);
        }
        this.baseDir = baseDir;
        if (log.isDebugEnabled()) {
            log.debug("ioc config file base dir is {}", (Object)baseDir);
        }
        this.isfile = false;
        this.configfile = path;
        this.configFileURL = file;
        this.needRecordFile = false;
        if (needInit) {
            this.initProviderManager();
        }
    }

    public void initProviderManager() {
        this.providerManager = this._getServiceProviderManager();
        this.providerManager.init("classpath::", "", this.configfile, this.configFileURL);
    }

    public BaseApplicationContext(InputStream instream, boolean isfile, boolean init) {
        this("classpath::", "", instream, isfile, init);
    }

    protected ServiceProviderManager _getServiceProviderManager() {
        return new ServiceProviderManager(this);
    }

    protected ServiceProviderManager _getServiceProviderManagerWithCharset(String charset) {
        return new ServiceProviderManager(this, charset);
    }

    public void destroyBean(Object existingBean) {
        if (existingBean instanceof DisposableBean) {
            try {
                ((DisposableBean)existingBean).destroy();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public boolean isfile() {
        return this.isfile;
    }

    public boolean needRecordFile() {
        return this.needRecordFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initApplicationContext() {
        if (this.applicationContextInited) {
            return;
        }
        Object object = this.initlock;
        synchronized (object) {
            if (this.applicationContextInited) {
                return;
            }
            this.resourcePatternResolver = this.getResourcePatternResolver();
            this.initMessageSource();
            this.applicationContextInited = true;
        }
    }

    public static Properties fillProperties() throws IOException {
        return SimpleStringUtil.getProperties((String)AOP_PROPERTIES_PATH, BaseApplicationContext.class);
    }

    public static Properties fillHotLoadProperties() throws IOException {
        try {
            return SimpleStringUtil.getProperties((String)"/hotload.properties", BaseApplicationContext.class);
        }
        catch (IOException e) {
            return BaseApplicationContext.fillProperties();
        }
    }

    public static String[] getAopWebserviceScope() {
        if (aop_webservice_scope == null) {
            Properties pro = null;
            try {
                pro = BaseApplicationContext.fillProperties();
                String aop_webservice_scope_ = pro.getProperty(aop_webservice_scope_key);
                if (aop_webservice_scope_ != null && !aop_webservice_scope_.trim().equals("")) {
                    aop_webservice_scope = aop_webservice_scope_.split(",");
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                aop_webservice_scope = aop_webservice_scope_default;
            }
        }
        return aop_webservice_scope;
    }

    public static String getAOPProxyType() {
        if (aop_proxy_type == null) {
            Properties pro = null;
            try {
                pro = BaseApplicationContext.fillProperties();
                aop_proxy_type = pro.getProperty(aop_proxy_type_key, "cglib");
                aop_proxy_type = aop_proxy_type.equals("cglib") ? "cglib" : "cglib";
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                aop_proxy_type = "cglib";
            }
        }
        return aop_proxy_type;
    }

    public static long getSQLFileRefreshInterval() {
        Properties pro = null;
        try {
            pro = BaseApplicationContext.fillHotLoadProperties();
            String SQLFileRefreshInterval = pro.getProperty("sqlfile.refresh_interval", "5000");
            return Long.parseLong(SQLFileRefreshInterval);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getResourceFileRefreshInterval() {
        if (resourcefileRefreshInterval != null) {
            return resourcefileRefreshInterval;
        }
        Class<BaseApplicationContext> clazz = BaseApplicationContext.class;
        synchronized (BaseApplicationContext.class) {
            if (resourcefileRefreshInterval != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return resourcefileRefreshInterval;
            }
            Properties pro = null;
            try {
                pro = BaseApplicationContext.fillHotLoadProperties();
                String ResourceFileRefreshInterval = pro.getProperty("resourcefile.refresh_interval", "5000");
                resourcefileRefreshInterval = Long.parseLong(ResourceFileRefreshInterval);
                // ** MonitorExit[var0] (shouldn't be in output)
                return resourcefileRefreshInterval;
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                resourcefileRefreshInterval = -1L;
                // ** MonitorExit[var0] (shouldn't be in output)
                return resourcefileRefreshInterval;
            }
        }
    }

    public ParserError getParserError() {
        return this.parserError;
    }

    public void setParserError(ParserError parserError) {
        this.parserError = parserError;
    }

    @Deprecated
    public static void shutdown() {
        ShutdownUtil.shutdown();
    }

    private static void _shutdown() {
        try {
            if (applicationContexts != null) {
                for (Map.Entry<String, BaseApplicationContext> entry : applicationContexts.entrySet()) {
                    try {
                        entry.getValue().destroy();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                applicationContexts.clear();
            }
            if (rootFiles != null) {
                rootFiles.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void addShutdownHook(Runnable destroyVMHook, int proir) {
        ShutdownUtil.addShutdownHook((Runnable)destroyVMHook, (int)proir);
    }

    @Deprecated
    public static void addShutdownHook(Runnable destroyVMHook) {
        BaseApplicationContext.addShutdownHook(destroyVMHook, -1);
    }

    public synchronized void destroySingleBeans() {
        if (this.singleDestorys != null && this.singleDestorys.size() > 0) {
            for (DisposableBean et : this.singleDestorys) {
                try {
                    et.destroy();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.destroyServiceMethods != null && this.destroyServiceMethods.size() > 0) {
            for (DestroyMethod entry : this.destroyServiceMethods) {
                Object value = entry.getInstance();
                String method = entry.getDestroyMethod();
                try {
                    ClassUtil.ClassInfo iclass = ClassUtil.getClassInfo(value.getClass());
                    Method m = iclass.getDeclaredMethod(method);
                    if (m != null) {
                        m.invoke(value, new Object[0]);
                        continue;
                    }
                    log.info("Destroy Bean failed:" + value.getClass().getCanonicalName() + "." + method + " do not exist.");
                }
                catch (SecurityException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void registDisableBean(DisposableBean disposableBean) {
        this.singleDestorys.add(disposableBean);
    }

    public void registDestroyMethod(String destroyMethod, Object instance) {
        DestroyMethod destoryMethod = new DestroyMethod(destroyMethod, instance);
        this.destroyServiceMethods.add(destoryMethod);
    }

    public static Object createInf(final CallContext callcontext, final BaseTXManager providerManagerInfo, Object delegate) {
        if (BaseApplicationContext.getAOPProxyType() != "cglib") {
            return ProxyFactory.createProxy((InvocationHandler)new InvocationHandler(delegate){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return CGLibUtil.invoke(this.delegate, method, args, null, callcontext, providerManagerInfo);
                }
            });
        }
        CGLibProxy proxy = new CGLibProxy(delegate, callcontext, providerManagerInfo);
        return CGLibUtil.getBeanInstance(delegate.getClass(), delegate.getClass(), proxy);
    }

    public static Object createInf(final Pro providerManagerInfo, Object delegate) {
        if (BaseApplicationContext.getAOPProxyType() != "cglib") {
            return ProxyFactory.createProxy((InvocationHandler)new InvocationHandler(delegate){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return CGLibUtil.invoke(this.delegate, method, args, null, providerManagerInfo);
                }
            });
        }
        SimpleCGLibProxy proxy = new SimpleCGLibProxy(delegate, providerManagerInfo);
        return CGLibUtil.getBeanInstance(delegate.getClass(), delegate.getClass(), proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proxyObject(Pro providerManagerInfo, Object refvalue, String refid) {
        if (providerManagerInfo.enableTransaction() || providerManagerInfo.enableAsyncCall() || providerManagerInfo.usedCustomInterceptor()) {
            if (refid != null && providerManagerInfo.isSinglable()) {
                Object provider = this.servicProviders.get(refid);
                if (provider != null) {
                    return provider;
                }
                Map<String, Object> map = this.servicProviders;
                synchronized (map) {
                    provider = this.servicProviders.get(refid);
                    if (provider != null) {
                        return provider;
                    }
                    provider = BaseApplicationContext.createInf(providerManagerInfo, refvalue);
                    this.servicProviders.put(refid, provider);
                }
                return provider;
            }
            refvalue = BaseApplicationContext.createInf(providerManagerInfo, refvalue);
            return refvalue;
        }
        return refvalue;
    }

    protected static Object createTXInf(CallContext callcontext, BaseTXManager providerManagerInfo, Object delegate) {
        return BaseApplicationContext.createInf(callcontext, providerManagerInfo, delegate);
    }

    protected static Object createSynInf(final CallContext callcontext, final ProviderManagerInfo providerManagerInfo, Object delegate) {
        if (BaseApplicationContext.getAOPProxyType() != "cglib") {
            return ProxyFactory.createProxy((InvocationHandler)new InvocationHandler(delegate){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return CGLibUtil.invokeSyn(this.delegate, method, args, null, callcontext, providerManagerInfo);
                }
            });
        }
        SynCGLibProxy proxy = new SynCGLibProxy(delegate, providerManagerInfo, callcontext);
        return CGLibUtil.getBeanInstance(delegate.getClass(), delegate.getClass(), proxy);
    }

    protected static Object createSynTXInf(final CallContext callcontext, final ProviderManagerInfo providerManagerInfo, Object delegate) {
        if (BaseApplicationContext.getAOPProxyType() != "cglib") {
            return ProxyFactory.createProxy((InvocationHandler)new InvocationHandler(delegate){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return CGLibUtil.invokeSynTX(this.delegate, method, args, null, callcontext, providerManagerInfo);
                }
            });
        }
        SynTXCGLibProxy proxy = new SynTXCGLibProxy(delegate, providerManagerInfo, callcontext);
        return CGLibUtil.getBeanInstance(delegate.getClass(), delegate.getClass(), proxy);
    }

    public Object getProvider(String providerManagerType) throws SPIException {
        return this.getProvider(providerManagerType, null);
    }

    public Object getProvider() throws SPIException {
        return this.getProvider(null, null);
    }

    public Object getProvider(String providerManagerType, String sourceType) throws SPIException {
        return this.getProvider(null, providerManagerType, sourceType, false);
    }

    public Object getProvider(CallContext parent, String providerManagerType, String sourceType) throws SPIException {
        return this.getProvider(parent, providerManagerType, sourceType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getProvider(CallContext callContext, String providerManagerType, String sourceType, boolean frombeanobject) throws SPIException {
        String _name = providerManagerType;
        if (callContext == null) {
            callContext = new LocalCallContextImpl(this);
        }
        ProviderManagerInfo providerManagerInfo = null;
        if (providerManagerType != null) {
            providerManagerInfo = this.providerManager.getProviderManagerInfo(providerManagerType);
        } else {
            providerManagerInfo = this.providerManager.getDefaultProviderManagerInfo();
            providerManagerType = providerManagerInfo.getId();
        }
        if (providerManagerInfo == null) {
            if (frombeanobject) {
                throw new SPIException("\u5bb9\u5668[" + this.getConfigfile() + "]\uff0cSPI[" + providerManagerType + "] in " + callContext.getLoopContext() + " does not exist.");
            }
            return this.getBeanObject(callContext, _name, null, true);
        }
        if (sourceType == null || sourceType.equals("")) {
            sourceType = providerManagerInfo.getDefaulProviderInfo().getType();
        }
        String key = providerManagerType + ":" + sourceType;
        Object finalsynProvider = null;
        if (providerManagerInfo.isSinglable() && (finalsynProvider = this.servicProviders.get(key)) != null) {
            return finalsynProvider;
        }
        Object provider = null;
        provider = providerManagerInfo.getSecurityProviderInfoByType(sourceType).getProvider(callContext);
        if (provider == null) {
            throw new SPIException("\u5bb9\u5668[" + this.getConfigfile() + "]\uff0c\u7ba1\u7406\u670d\u52a1[" + key + "]\u4e3anull,\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002");
        }
        finalsynProvider = provider;
        try {
            if (providerManagerInfo.enableTransaction() && providerManagerInfo.isSynchronizedEnabled()) {
                finalsynProvider = providerManagerInfo.getProviderInfoQueue().size() > 1 ? BaseApplicationContext.createSynTXInf(callContext, providerManagerInfo, finalsynProvider) : BaseApplicationContext.createTXInf(callContext, providerManagerInfo, finalsynProvider);
            } else if (providerManagerInfo.enableTransaction()) {
                finalsynProvider = BaseApplicationContext.createTXInf(callContext, providerManagerInfo, finalsynProvider);
            } else if (providerManagerInfo.isSynchronizedEnabled()) {
                if (providerManagerInfo.getProviderInfoQueue().size() > 1) {
                    finalsynProvider = BaseApplicationContext.createSynInf(callContext, providerManagerInfo, finalsynProvider);
                } else if (providerManagerInfo.usedCustomInterceptor()) {
                    finalsynProvider = BaseApplicationContext.createInf(callContext, providerManagerInfo, finalsynProvider);
                }
            } else if (providerManagerInfo.usedCustomInterceptor() || providerManagerInfo.enableAsyncCall()) {
                finalsynProvider = BaseApplicationContext.createInf(callContext, providerManagerInfo, finalsynProvider);
            }
        }
        catch (Exception e) {
            throw new SPIException(e);
        }
        if (providerManagerInfo.isSinglable() && (providerManagerInfo.enableTransaction() || providerManagerInfo.enableAsyncCall() || providerManagerInfo.isSynchronizedEnabled() || providerManagerInfo.usedCustomInterceptor()) && callContext == null) {
            Map<String, Object> map = this.servicProviders;
            synchronized (map) {
                Object temp = this.servicProviders.get(key);
                if (temp != null) {
                    return temp;
                }
                this.servicProviders.put(key, finalsynProvider);
            }
        }
        return finalsynProvider;
    }

    public static void main(String[] args) {
        long s = System.currentTimeMillis();
        for (int i = 0; i < 600000; ++i) {
            System.out.println(i);
        }
        long end = System.currentTimeMillis();
        System.out.println(end - s + "s");
    }

    public String getProperty(String name) {
        return this.providerManager.getProperty(name);
    }

    public Set<String> getPropertyKeys() {
        return this.providerManager.getPropertyKeys();
    }

    public int getIntProperty(String name) {
        return this.providerManager.getIntProperty(name);
    }

    public long getLongProperty(String name) {
        return this.providerManager.getLongProperty(name);
    }

    public long getLongProperty(String name, long defaultvalue) {
        return this.providerManager.getLongProperty(name, defaultvalue);
    }

    public boolean getBooleanProperty(String name) {
        return this.providerManager.getBooleanProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.providerManager.getProperty(name, defaultValue);
    }

    public Object getObjectProperty(String name) {
        return this.getObjectProperty(name, null);
    }

    public Object getObjectProperty(String name, String defaultValue) {
        return this.providerManager.getObjectProperty(name, defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.providerManager.getIntProperty(name, defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.providerManager.getBooleanProperty(name, defaultValue);
    }

    public Object getBeanObject(String name) {
        return this.getBeanObject(name, null);
    }

    public <T> T getTBeanObject(String name, Class<T> clazz) {
        return (T)this.getBeanObject(name, null);
    }

    public Object getBeanObject(String name, Object defaultValue) {
        return this.getBeanObject(null, name, defaultValue, false);
    }

    public <T> T getTBeanObject(String name, T defaultValue, Class<T> clazz) {
        return this.getTBeanObject(null, name, defaultValue, clazz);
    }

    public ProSet getSetProperty(String name) {
        return this.providerManager.getSetProperty(name);
    }

    public ProSet getSetProperty(String name, ProSet defaultValue) {
        return this.providerManager.getSetProperty(name, defaultValue);
    }

    public ProList getListProperty(String name) {
        return this.providerManager.getListProperty(name);
    }

    public ProList getListProperty(String name, ProList defaultValue) {
        return this.providerManager.getListProperty(name, defaultValue);
    }

    public ProMap getMapProperty(String name) {
        return this.providerManager.getMapProperty(name);
    }

    public ProProperties getProProperties(String name) {
        return this.providerManager.getProProperties(name);
    }

    public ProMap getMapProperty(String name, ProMap defaultValue) {
        return this.providerManager.getMapProperty(name, defaultValue);
    }

    public ProArray getArrayProperty(String name) {
        return this.providerManager.getArrayProperty(name);
    }

    public ProArray getProArrayProperty(String name, ProArray defaultValue) {
        return this.providerManager.getArrayProperty(name, defaultValue);
    }

    public Object getBeanObject(CallContext context, String name, Object defaultValue) {
        return this.getBeanObject(context, name, defaultValue, false);
    }

    public Object getBeanObjectFromRefID(CallContext context, RefID name, String strrefid, Object defaultValue) {
        Pro providerManagerInfo;
        if (context == null) {
            context = new LocalCallContextImpl(this);
        }
        if ((providerManagerInfo = this.providerManager.getInnerPropertyBean(name, strrefid)) == null) {
            if (defaultValue == null) {
                this.throwUndefineException(this.getConfigfile(), strrefid);
            } else {
                return defaultValue;
            }
        }
        Object finalsynProvider = providerManagerInfo.getTrueValue(context, defaultValue);
        return this.proxyObject(providerManagerInfo, finalsynProvider, providerManagerInfo.getXpath());
    }

    protected void throwUndefineException(String configfile, String name) {
        StringBuilder message = new StringBuilder();
        message.append("\u5bb9\u5668[").append(configfile).append("]\u6ca1\u6709\u5b9a\u4e49\u540d\u79f0\u4e3a[").append(name).append("]\u7684bean\u5bf9\u8c61\u3002\u8bf7\u68c0\u67e5\u540d\u79f0\u5927\u5c0f\u5199\u95ee\u9898\u6216\u8005\u68c0\u67e5\u7ec4\u4ef6[").append(name).append("]\u662f\u5426\u914d\u7f6e\u6b63\u786e!\u5df2\u6b63\u786e\u52a0\u8f7d\u7ec4\u4ef6\u6e05\u5355\u5982\u4e0b\uff1a\r\n");
        this.providerManager.getKeysString(message);
        String msg = message.toString();
        throw new SPIException(msg);
    }

    protected Object getBeanObject(CallContext context, String name, Object defaultValue, boolean fromprovider) {
        Pro providerManagerInfo;
        String _name = name;
        if (context == null) {
            context = new LocalCallContextImpl(this);
        }
        if ((providerManagerInfo = this.providerManager.getPropertyBean(name)) == null) {
            if (!fromprovider) {
                ProviderManagerInfo providerManagerInfo_ = null;
                providerManagerInfo_ = this.providerManager.getProviderManagerInfo(name);
                if (providerManagerInfo_ == null) {
                    if (defaultValue == null) {
                        this.throwUndefineException(this.getConfigfile(), name);
                    } else {
                        return defaultValue;
                    }
                }
                return this.getProvider(context, _name, null, true);
            }
            if (defaultValue == null) {
                this.throwUndefineException(this.getConfigfile(), name);
            } else {
                return defaultValue;
            }
        }
        return this.getBeanObject(context, providerManagerInfo, defaultValue);
    }

    protected <T> T getTBeanObject(CallContext context, String name, T defaultValue, Class<T> interfaceclazz) {
        Pro providerManagerInfo;
        String _name = name;
        if (context == null) {
            context = new LocalCallContextImpl(this);
        }
        if ((providerManagerInfo = this.providerManager.getPropertyBean(name)) == null) {
            this.throwUndefineException(this.getConfigfile(), name);
        }
        return (T)this.getBeanObject(context, providerManagerInfo, null);
    }

    public Object getBeanObject(CallContext context, String name) {
        return this.getBeanObject(context, name, null, false);
    }

    public Pro getProBean(String name) {
        return this.providerManager.getPropertyBean(name);
    }

    public Object getBeanObject(CallContext context, Pro providerManagerInfo) {
        return this.getBeanObject(context, providerManagerInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBeanObject(CallContext context, Pro providerManagerInfo, Object defaultValue) {
        if (providerManagerInfo == null) {
            throw new SPIException("\u5bb9\u5668[" + this.getConfigfile() + "]bean\u5bf9\u8c61\u4e3a\u7a7a\u3002");
        }
        String key = providerManagerInfo.getName();
        if (providerManagerInfo.isRefereced()) {
            Object retvalue = providerManagerInfo.getTrueValue(context, defaultValue);
            return retvalue;
        }
        Object finalsynProvider = null;
        finalsynProvider = this.providerManager.getBeanObject(context, providerManagerInfo, defaultValue);
        if (providerManagerInfo.enableTransaction() || providerManagerInfo.enableAsyncCall() || providerManagerInfo.usedCustomInterceptor()) {
            if (providerManagerInfo.isSinglable()) {
                if (context != null) {
                    Object provider = this.servicProviders.get(key);
                    if (provider != null) {
                        return provider;
                    }
                    Map<String, Object> map = this.servicProviders;
                    synchronized (map) {
                        provider = this.servicProviders.get(key);
                        if (provider != null) {
                            return provider;
                        }
                        provider = BaseApplicationContext.createInf(context, providerManagerInfo, finalsynProvider);
                        this.servicProviders.put(key, provider);
                    }
                    return provider;
                }
                finalsynProvider = BaseApplicationContext.createInf(context, providerManagerInfo, finalsynProvider);
                return finalsynProvider;
            }
            finalsynProvider = BaseApplicationContext.createInf(context, providerManagerInfo, finalsynProvider);
            return finalsynProvider;
        }
        return finalsynProvider;
    }

    protected Object getBeanObjectFromRefID(CallContext context, Pro providerManagerInfo, Object defaultValue) {
        if (providerManagerInfo == null) {
            throw new SPIException("\u5bb9\u5668[" + this.getConfigfile() + "]bean\u5bf9\u8c61\u4e3a\u7a7a\u3002");
        }
        if (providerManagerInfo.isRefereced()) {
            Object retvalue = providerManagerInfo.getTrueValue(context, defaultValue);
            return retvalue;
        }
        Object finalsynProvider = null;
        finalsynProvider = this.providerManager.getBeanObject(context, providerManagerInfo, defaultValue);
        return this.proxyObject(providerManagerInfo, finalsynProvider, providerManagerInfo.getXpath());
    }

    public String getStringExtendAttribute(String name, String extendName) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return null;
        }
        return pro.getStringExtendAttribute(extendName);
    }

    public String getStringExtendAttribute(String name, String extendName, String defaultValue) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return defaultValue;
        }
        return pro.getStringExtendAttribute(extendName);
    }

    public Object getExtendAttribute(String name, String extendName) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return null;
        }
        return pro.getExtendAttribute(extendName);
    }

    public Object getExtendAttribute(String name, String extendName, Object defaultValue) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return defaultValue;
        }
        return pro.getExtendAttribute(extendName, defaultValue);
    }

    public int getIntExtendAttribute(String name, String extendName) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return -1;
        }
        return pro.getIntExtendAttribute(extendName);
    }

    public int getIntExtendAttribute(String name, String extendName, int defaultValue) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return defaultValue;
        }
        return pro.getIntExtendAttribute(extendName, defaultValue);
    }

    public long getLongExtendAttribute(String name, String extendName) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return -1L;
        }
        return pro.getLongExtendAttribute(extendName);
    }

    public long getLongExtendAttribute(String name, String extendName, long defaultValue) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return defaultValue;
        }
        return pro.getLongExtendAttribute(extendName, defaultValue);
    }

    public boolean getBooleanExtendAttribute(String name, String extendName) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return false;
        }
        return pro.getBooleanExtendAttribute(extendName);
    }

    public boolean getBooleanExtendAttribute(String name, String extendName, boolean defauleValue) {
        Pro pro = this.getProBean(name);
        if (pro == null) {
            return defauleValue;
        }
        return pro.getBooleanExtendAttribute(extendName);
    }

    public List getTraceFiles() {
        return this.providerManager.getTraceFiles();
    }

    public LinkConfigFile getLinkConfigFile(String id) {
        return this.providerManager.getLinkConfigFile(id);
    }

    public Map getManagers() {
        return this.providerManager.getManagers();
    }

    public ServiceProviderManager getServiceProviderManager() {
        return this.providerManager;
    }

    public String getConfigfile() {
        return this.configfile;
    }

    public static String getRealPath(String parent, String file) {
        StringBuilder ret = new StringBuilder();
        if (parent.endsWith("/")) {
            if (!file.startsWith("/")) {
                ret.append(parent).append(file);
            } else {
                ret.append(parent).append(file.substring(1));
            }
            return ret.toString();
        }
        if (!file.startsWith("/")) {
            ret.append(parent).append("/").append(file);
        } else {
            ret.append(parent).append(file);
        }
        return ret.toString();
    }

    public boolean isSingleton(String beanname) {
        Pro pro = this.getProBean(beanname);
        Assert.notNull((Object)pro);
        return pro.isSinglable();
    }

    @Override
    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, null, defaultMessage, locale);
    }

    @Override
    public String getMessage(String code, Locale locale) {
        return this.getMessageSource().getMessage(code, null, null, locale);
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessageSource().getMessage(code, null, defaultMessage, null);
    }

    @Override
    public String getMessage(String code) {
        return this.getMessageSource().getMessage(code, null, null, null);
    }

    @Override
    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(code, args, locale);
    }

    @Override
    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(resolvable, locale);
    }

    private MessageSource getMessageSource() throws IllegalStateException {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized - call 'refresh' before accessing messages via the context: " + this);
        }
        return this.messageSource;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            return ((ResourcePatternResolver)this.resourceLoader).getResources(locationPattern);
        }
        return this.resourcePatternResolver.getResources(locationPattern);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PathMatchingResourcePatternResolver((ResourceLoader)this);
    }

    public Resource getResource(String location) {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getResource(location);
        }
        return super.getResource(location);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public boolean containsBean(String themeSourceBeanName) {
        return this.providerManager.containsBean(themeSourceBeanName);
    }

    public <T> T createBean(Class<? extends T> clazz) throws BeanInstanceException {
        return this.createBean(clazz, null);
    }

    public Object createBean(String clazz) throws BeanInstanceException {
        Class<?> clss = null;
        try {
            clss = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new BeanInstanceException((Throwable)e);
        }
        return this.createBean(clss, null);
    }

    public <T> T createBean(Class<? extends T> clazz, BeanInf providerManagerInfo) throws BeanInstanceException {
        try {
            T ret = clazz.newInstance();
            return this.initBean(ret, providerManagerInfo);
        }
        catch (InstantiationException e) {
            throw new BeanInstanceException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BeanInstanceException((Throwable)e);
        }
        catch (BeanInstanceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanInstanceException((Throwable)e);
        }
    }

    public <T> T initBean(T bean, BeanInf providerManagerInfo) throws BeanInstanceException {
        try {
            BeanAccembleHelper.initBean(bean, providerManagerInfo, this);
            return bean;
        }
        catch (BeanInstanceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanInstanceException((Throwable)e);
        }
    }

    public Object initBean(Object bean, String beanName) throws BeanInstanceException {
        try {
            BeanAccembleHelper.initBean(bean, beanName, this);
            return bean;
        }
        catch (BeanInstanceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanInstanceException((Throwable)e);
        }
    }

    protected void initMessageSource() {
        DelegatingMessageSource dms = new DelegatingMessageSource();
        dms.setParentMessageSource(this.getInternalParentMessageSource());
        this.messageSource = dms;
        if (log.isDebugEnabled()) {
            log.debug("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource.getClass().getCanonicalName() + "]");
        }
    }

    protected MessageSource getInternalParentMessageSource() {
        HotDeployResourceBundleMessageSource messagesource = new HotDeployResourceBundleMessageSource();
        if (this.configfile != null && !this.configfile.equals("")) {
            int index = this.configfile.lastIndexOf("/");
            if (index > 0) {
                String parent = this.configfile.substring(0, index);
                messagesource.setBasename(BaseApplicationContext.getRealPath(parent, DEFAULT_MESSAGE_BASENAME));
            } else {
                messagesource.setBasename(DEFAULT_MESSAGE_BASENAME);
            }
        } else {
            messagesource.setBasename(DEFAULT_MESSAGE_BASENAME);
        }
        messagesource.setBundleClassLoader(this.getClassLoader());
        messagesource.setUseCodeAsDefaultMessage(true);
        return messagesource;
    }

    public String[] getStringArray(String key) {
        return this.providerManager.getStringArray(key);
    }

    public String[] getStringArray(String key, String[] defaultValues) {
        return this.providerManager.getStringArray(key, defaultValues);
    }

    public Pro getInnerPro(String parent, String name) {
        if (parent == null || parent.equals("")) {
            return this.getProBean(name);
        }
        String[] nodes = parent.split("\\#\\!\\#");
        Pro pro = null;
        String nodetype = null;
        String nodename = null;
        String oldnodetype = null;
        String oldnodename = null;
        for (int i = 0; i < nodes.length; ++i) {
            List<Pro> referencesList;
            List<Pro> constructionList;
            Serializable array;
            ProMap map;
            int position;
            ProList list;
            String nodewithtype = nodes[i];
            String[] nodeinfo = nodewithtype.split("\\^\\^");
            if (pro == null) {
                nodetype = nodeinfo[1];
                nodename = nodeinfo[0];
                pro = this.getProBean(nodename);
                if (i != nodes.length - 1) continue;
                if (nodetype.equals("list")) {
                    list = pro.getList();
                    position = Integer.parseInt(name);
                    return list.getPro(position);
                }
                if (nodetype.equals("map")) {
                    map = pro.getMap();
                    return map.getPro(name);
                }
                if (nodetype.equals("array")) {
                    array = pro.getArray();
                    position = Integer.parseInt(name);
                    return ((ProArray)array).getPro(position);
                }
                if (nodetype.equals("set")) {
                    array = pro.getSet();
                    position = Integer.parseInt(name);
                    return ((ProSet)array).getPro(position);
                }
                if (nodetype.equals("construction")) {
                    constructionList = pro.getConstructorParams();
                    position = Integer.parseInt(name);
                    return constructionList.get(position);
                }
                if (nodetype.equals("reference")) {
                    referencesList = pro.getReferences();
                    position = Integer.parseInt(name);
                    return referencesList.get(position);
                }
                throw new NullPointerException(this.getConfigfile() + "\u4e2d\u4e0d\u5b58\u5728[" + parent + "," + name + "]\uff0c\u7c7b\u578b\u4e3a" + nodetype + "\u7684\u5185\u90e8property\u8282\u70b9");
            }
            oldnodetype = nodetype;
            oldnodename = nodename;
            nodetype = nodeinfo[1];
            nodename = nodeinfo[0];
            if (oldnodetype.equals("list")) {
                list = pro.getList();
                pro = list.getPro(Integer.parseInt(nodename));
            } else if (oldnodetype.equals("map")) {
                map = pro.getMap();
                pro = map.getPro(nodename);
            } else if (oldnodetype.equals("array")) {
                array = pro.getArray();
                position = Integer.parseInt(nodename);
                pro = ((ProArray)array).getPro(position);
            } else if (oldnodetype.equals("set")) {
                ProSet set = pro.getSet();
                position = Integer.parseInt(nodename);
                pro = set.getPro(position);
            } else if (oldnodetype.equals("reference")) {
                referencesList = pro.getReferences();
                position = Integer.parseInt(oldnodename);
                pro = referencesList.get(position);
            } else if (oldnodetype.equals("construction")) {
                referencesList = pro.getConstructorParams();
                position = Integer.parseInt(oldnodename);
                pro = referencesList.get(position);
            } else if (nodetype.equals("construction")) {
                constructionList = pro.getConstructorParams();
                position = Integer.parseInt(nodename);
                pro = constructionList.get(position);
            } else if (nodetype.equals("reference")) {
                referencesList = pro.getReferences();
                position = Integer.parseInt(nodename);
                pro = referencesList.get(position);
            } else {
                throw new NullPointerException(this.getConfigfile() + "\u4e2d\u4e0d\u5b58\u5728[oldnodetype=" + oldnodetype + ",oldnodename=" + oldnodename + ",nodetype=" + nodetype + ",nodename=" + nodename + "]\u7684\u5185\u90e8property\u8282\u70b9");
            }
            if (i != nodes.length - 1) continue;
            if (nodetype.equals("list")) {
                list = pro.getList();
                position = Integer.parseInt(name);
                return list.getPro(position);
            }
            if (nodetype.equals("map")) {
                map = pro.getMap();
                return map.getPro(name);
            }
            if (nodetype.equals("array")) {
                array = pro.getArray();
                position = Integer.parseInt(name);
                return ((ProArray)array).getPro(position);
            }
            if (nodetype.equals("set")) {
                array = pro.getSet();
                position = Integer.parseInt(name);
                return ((ProSet)array).getPro(position);
            }
            if (nodetype.equals("construction")) {
                constructionList = pro.getConstructorParams();
                position = Integer.parseInt(name);
                return constructionList.get(position);
            }
            if (nodetype.equals("reference")) {
                referencesList = pro.getReferences();
                position = Integer.parseInt(name);
                return referencesList.get(position);
            }
            throw new NullPointerException(this.getConfigfile() + "\u4e2d\u4e0d\u5b58\u5728[" + parent + "," + name + "]\uff0c\u7c7b\u578b\u4e3a" + nodetype + "\u7684\u5185\u90e8property\u8282\u70b9");
        }
        throw new NullPointerException(this.getConfigfile() + "\u4e2d\u4e0d\u5b58\u5728[" + parent + "," + name + "]\uff0c\u7c7b\u578b\u4e3a" + nodetype + "\u7684\u5185\u90e8property\u8282\u70b9");
    }

    public String[] getDependenciesForBean(String beanName) {
        return this.providerManager.getDependenciesForBean(beanName);
    }

    public String[] getDependentBeans(String beanName) {
        return this.providerManager.getDependentBeans(beanName);
    }

    public String[] getBeanNamesForType(Class<Lifecycle> class1, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.providerManager.getBeanNamesForType(class1, includeNonSingletons, allowEagerInit);
    }

    public boolean isFactoryBean(String beanNameToRegister) {
        return this.providerManager.isFactoryBean(beanNameToRegister);
    }

    public boolean containsSingleton(String beanNameToRegister) {
        return this.singleDestorys.contains(beanNameToRegister);
    }

    public Class<?> getType(String beanNameToCheck) {
        return this.providerManager.getType(beanNameToCheck);
    }

    @Override
    public String getExternalProperty(String property) {
        return this.providerManager.getExternalProperty(property);
    }

    @Override
    public Object getExternalObjectProperty(String property) {
        return this.providerManager.getExternalProperty(property);
    }

    @Override
    public Map getAllExternalProperties() {
        return this.providerManager.getAllExternalProperties();
    }

    @Override
    public String getSystemEnvProperty(String property) {
        return this.providerManager.getSystemEnvProperty(property);
    }

    @Override
    public Object getExternalObjectProperty(String property, Object defaultValue) {
        return this.providerManager.getExternalObjectProperty(property, defaultValue);
    }

    @Override
    public String getExternalProperty(String property, String defaultValue) {
        return this.providerManager.getExternalProperty(property, defaultValue);
    }

    public boolean isEmptyContext() {
        return this.providerManager == null || this.providerManager.isEmpty();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getClass().getCanonicalName()).append(":").append(this.getConfigfile());
        return ret.toString();
    }

    public BaseApplicationContext removeCacheContext() {
        return applicationContexts.remove(this.getConfigfile());
    }

    public void restoreCacheContext() {
        applicationContexts.put(this.getConfigfile(), this);
    }

    public void start(Starter starter) {
        Set<String> beanNames = this.getPropertyKeys();
        if (beanNames == null || beanNames.size() == 0) {
            return;
        }
        Iterator<String> beanNamesItr = beanNames.iterator();
        Pro pro = null;
        while (beanNamesItr.hasNext()) {
            String beanName = beanNamesItr.next();
            pro = this.getProBean(beanName);
            if (pro == null) continue;
            try {
                starter.start(pro, this);
            }
            catch (Throwable e) {
                starter.failed(pro, this, e);
            }
        }
    }

    @Override
    public synchronized void reset() {
    }

    @Override
    public boolean getExternalBooleanProperty(String property, boolean defaultValue) {
        Object value = this.getExternalObjectProperty(property, null);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value.equals("true");
        }
        return true;
    }

    static {
        try {
            ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    BaseApplicationContext._shutdown();
                }
            }, (int)0x7FFFFFF5);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        container_type_simple = 0;
        container_type_application = 1;
        container_type_soa = 2;
        container_type_soafile = 3;
        container_type_mvc = 4;
        mvccontainer_identifier = "webmvc";
        applicationContexts = new HashMap<String, BaseApplicationContext>();
        rootFiles = new ArrayList<String>();
        getApplicationContextMethod = null;
        lock_getApplicationContextMethod = new Object();
        lock = new Object();
        aop_proxy_type = null;
        aop_webservice_scope_default = new String[]{"mvc", "application", "default"};
        aop_webservice_scope = aop_webservice_scope_default;
    }

    private static class DestroyMethod {
        private final String destroyMethod;
        private final Object instance;

        public DestroyMethod(String destroyMethod, Object instance) {
            this.destroyMethod = destroyMethod;
            this.instance = instance;
        }

        public String getDestroyMethod() {
            return this.destroyMethod;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

