/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble.callback;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.frameworkset.spi.assemble.callback.AssembleCallback;

public class ClasspathAssembleCallback
implements AssembleCallback {
    private String docbaseType = "classpath::";

    @Override
    public String getDocbasePath(String path) {
        return path == null ? "" : path;
    }

    @Override
    public String getDocbaseType() {
        return this.docbaseType;
    }

    @Override
    public String getRootPath() {
        return "";
    }

    private static File computeApplicationDir(URL location, File defaultDir) {
        if (location == null) {
            System.out.println("Warning: Cannot locate the program directory. Assuming default.");
            return defaultDir;
        }
        if (!"file".equalsIgnoreCase(location.getProtocol())) {
            System.out.println("Warning: Unrecognized location type. Assuming default.");
            return new File(".");
        }
        String file = location.getFile();
        if (!file.endsWith(".jar") && !file.endsWith(".zip")) {
            try {
                return new File(URLDecoder.decode(location.getFile(), "UTF-8")).getParentFile();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: Unrecognized location type. Assuming default.");
                return new File(location.getFile());
            }
        }
        try {
            return new File(URLDecoder.decode(location.toExternalForm().substring(6), "UTF-8")).getParentFile();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println("Warning: Unrecognized location type. Assuming default.");
            return new File(location.getFile());
        }
    }

    private static File computeApplicationClassesDir(URL location, File defaultDir) {
        if (location == null) {
            System.out.println("Warning: Cannot locate the program directory. Assuming default.");
            return defaultDir;
        }
        if (!"file".equalsIgnoreCase(location.getProtocol())) {
            System.out.println("Warning: Unrecognized location type. Assuming default.");
            return new File(".");
        }
        String file = location.getFile();
        if (!file.endsWith(".jar") && !file.endsWith(".zip")) {
            try {
                return new File(URLDecoder.decode(location.getFile(), "UTF-8")).getAbsoluteFile();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: Unrecognized location type. Assuming default.");
                return new File(location.getFile());
            }
        }
        try {
            return new File(new File(URLDecoder.decode(location.toExternalForm().substring(6), "UTF-8")).getParentFile().getAbsolutePath(), "classes");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println("Warning: Unrecognized location type. Assuming default.");
            return new File(location.getFile());
        }
    }
}

