/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.ValueCastUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.AOPValueHandler;
import org.frameworkset.spi.assemble.AbstractGetProperties;
import org.frameworkset.spi.assemble.AssembleException;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.assemble.LinkConfigFile;
import org.frameworkset.spi.assemble.MacroParserException;
import org.frameworkset.spi.assemble.PropertiesInterceptor;
import org.frameworkset.spi.assemble.PropertyContext;
import org.frameworkset.spi.assemble.ProviderParser;
import org.frameworkset.spi.assemble.ServiceProviderManager;
import org.frameworkset.spi.assemble.ValueContainer;
import org.frameworkset.spi.assemble.plugin.PropertiesFilePlugin;
import org.frameworkset.spi.support.EnvUtil;
import org.frameworkset.util.io.ClassPathResource;
import org.frameworkset.util.tokenizer.TextGrammarParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesContainer
extends AbstractGetProperties {
    private static Logger logger = LoggerFactory.getLogger(PropertiesContainer.class);
    public static boolean showPassword = false;
    protected List<String> configPropertiesFiles;
    protected Map<Object, Object> allProperties;
    private Map<String, PropertiesInterceptor> propertiesInterceptors = new LinkedHashMap<String, PropertiesInterceptor>();
    protected Map<Object, Object> sonAndParentProperties;
    private static Logger log = LoggerFactory.getLogger(PropertiesContainer.class);
    protected PropertiesFilePlugin propertiesFilePlugin;
    public static final String propertiesInterceptorKey = "propertiesInterceptor";
    protected String namespace;
    protected String configChangeListener;
    protected boolean changeReload;

    public void afterLoaded(GetProperties getProperties) {
        if (this.propertiesFilePlugin != null) {
            this.propertiesFilePlugin.afterLoaded(getProperties, this);
        }
    }

    private void scanPropertiesInterceptor(Map<Object, Object> properties) {
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String value;
                String key = String.valueOf(entry.getKey());
                if (!key.equals(propertiesInterceptorKey) || this.propertiesInterceptors.containsKey(value = String.valueOf(entry.getValue()).trim())) continue;
                try {
                    Class<?> clz = Class.forName(value);
                    PropertiesInterceptor propertiesInterceptor = (PropertiesInterceptor)clz.newInstance();
                    this.propertiesInterceptors.put(value, propertiesInterceptor);
                }
                catch (ClassNotFoundException e) {
                    log.error(key + "=" + value, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error(key + "=" + value, (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error(key + "=" + value, (Throwable)e);
                }
            }
        }
    }

    public Object interceptorValues(Object bean) {
        if (bean == null) {
            return bean;
        }
        for (Map.Entry<String, PropertiesInterceptor> propertiesInterceptorEntry : this.propertiesInterceptors.entrySet()) {
            PropertiesInterceptor propertiesInterceptor = propertiesInterceptorEntry.getValue();
            PropertyContext propertyContext = new PropertyContext();
            propertyContext.setValue(bean);
            bean = propertiesInterceptor.convert(propertyContext);
        }
        return bean;
    }

    public Map interceptorValues(Map evaledProperties) {
        if (evaledProperties == null || evaledProperties.size() == 0) {
            return evaledProperties;
        }
        this.scanPropertiesInterceptor(evaledProperties);
        LinkedHashMap newEvaledProperties = new LinkedHashMap(evaledProperties.size());
        if (this.propertiesInterceptors.size() > 0) {
            for (Map.Entry entry : evaledProperties.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                for (Map.Entry<String, PropertiesInterceptor> propertiesInterceptorEntry : this.propertiesInterceptors.entrySet()) {
                    PropertiesInterceptor propertiesInterceptor = propertiesInterceptorEntry.getValue();
                    PropertyContext propertyContext = new PropertyContext();
                    propertyContext.setValue(value);
                    propertyContext.setProperty(key);
                    value = propertiesInterceptor.convert(propertyContext);
                    newEvaledProperties.put(key, value);
                }
            }
            return newEvaledProperties;
        }
        return evaledProperties;
    }

    public void addConfigPropertiesFile(String configPropertiesFile, LinkConfigFile linkfile) {
        String[] configPropertiesFiles;
        if (this.configPropertiesFiles == null) {
            this.configPropertiesFiles = new ArrayList<String>();
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        Properties currentProperties = new Properties();
        for (String file_ : configPropertiesFiles = configPropertiesFile.split(",")) {
            this.configPropertiesFiles.add(file_);
            this.evalfile(currentProperties, file_, linkfile);
        }
        Map evaledProperties = EnvUtil.evalEnvVariable(this.allProperties, currentProperties);
        if (evaledProperties != null && (evaledProperties = this.interceptorValues(evaledProperties)) != null && evaledProperties.size() > 0) {
            this.allProperties.putAll(evaledProperties);
        }
        if (linkfile != null) {
            this.loopback(linkfile);
        }
    }

    public void addAll(Map properties) {
        this.addAll(properties, true);
    }

    public void addAll(Map properties, boolean interceptor) {
        if (interceptor) {
            properties = this.interceptorValues(properties);
        }
        if (this.configPropertiesFiles == null) {
            this.configPropertiesFiles = new ArrayList<String>();
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        if (properties != null && properties.size() > 0) {
            this.allProperties.putAll(properties);
        }
    }

    @Override
    public String getExternalProperty(String property) {
        return this.getPropertyFromSelf2ndSons(property);
    }

    @Override
    public String getExternalProperty(String property, String defaultValue) {
        String value = this.getPropertyFromSelf2ndSons(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Object getExternalObjectProperty(String property) {
        return this.getExternalObjectProperty(property, null);
    }

    @Override
    public Object getExternalObjectProperty(String property, Object defaultValue) {
        Object value = null;
        value = this.sonAndParentProperties == null ? null : this.sonAndParentProperties.get(property);
        if (value == null) {
            value = this.getObjectProperty(property);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addConfigPropertiesFromPlugin(String configPropertiesPlugin, LinkConfigFile linkfile, BaseApplicationContext applicationContext, Map<String, String> extendsAttributes) {
        if (this.configPropertiesFiles == null) {
            this.configPropertiesFiles = new ArrayList<String>();
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        try {
            Class<?> clazz = Class.forName(configPropertiesPlugin.trim());
            Class<PropertiesFilePlugin> clazz2 = PropertiesFilePlugin.class;
            synchronized (PropertiesFilePlugin.class) {
                PropertiesFilePlugin propertiesFilePlugin = (PropertiesFilePlugin)clazz.newInstance();
                try {
                    Map configProperties = null;
                    if (propertiesFilePlugin.getInitType(applicationContext, extendsAttributes, this) != 1) {
                        String configPropertiesFile = propertiesFilePlugin.getFiles(applicationContext, extendsAttributes, this);
                        if (SimpleStringUtil.isNotEmpty((String)configPropertiesFile)) {
                            configProperties = new LinkedHashMap();
                            this.loadPropertiesFromFiles(configProperties, configPropertiesFile, linkfile);
                        }
                    } else {
                        configProperties = propertiesFilePlugin.getConfigProperties(applicationContext, extendsAttributes, this);
                    }
                    if (configProperties != null && configProperties.size() > 0) {
                        configProperties = EnvUtil.evalEnvVariable(this.allProperties, configProperties);
                        if ((configProperties = this.interceptorValues(configProperties)) != null && configProperties.size() > 0) {
                            this.allProperties.putAll(configProperties);
                        }
                    }
                }
                finally {
                    propertiesFilePlugin.restore(applicationContext, extendsAttributes, this);
                    this.propertiesFilePlugin = propertiesFilePlugin;
                }
                // ** MonitorExit[var6_7] (shouldn't be in output)
                if (linkfile == null) return;
                this.loopback(linkfile);
                return;
            }
        }
        catch (Exception e) {
            if (!log.isErrorEnabled()) return;
            log.error("Add Config Properties for[" + applicationContext.getConfigfile() + "] From plugin failed: " + SimpleStringUtil.object2json(extendsAttributes), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addConfigPropertiesFromPlugin(PropertiesFilePlugin propertiesFilePlugin, LinkConfigFile linkfile, BaseApplicationContext applicationContext, Map<String, String> extendsAttributes) {
        if (this.configPropertiesFiles == null) {
            this.configPropertiesFiles = new ArrayList<String>();
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        try {
            Class<PropertiesFilePlugin> clazz = PropertiesFilePlugin.class;
            synchronized (PropertiesFilePlugin.class) {
                try {
                    Map configProperties = null;
                    if (propertiesFilePlugin.getInitType(applicationContext, extendsAttributes, this) != 1) {
                        String configPropertiesFile = propertiesFilePlugin.getFiles(applicationContext, extendsAttributes, this);
                        if (SimpleStringUtil.isNotEmpty((String)configPropertiesFile)) {
                            configProperties = new LinkedHashMap();
                            this.loadPropertiesFromFiles(configProperties, configPropertiesFile, linkfile);
                        }
                    } else {
                        configProperties = propertiesFilePlugin.getConfigProperties(applicationContext, extendsAttributes, this);
                    }
                    if (configProperties != null && configProperties.size() > 0) {
                        configProperties = EnvUtil.evalEnvVariable(this.allProperties, configProperties);
                        if ((configProperties = this.interceptorValues(configProperties)) != null && configProperties.size() > 0) {
                            this.allProperties.putAll(configProperties);
                        }
                    }
                }
                finally {
                    propertiesFilePlugin.restore(applicationContext, extendsAttributes, this);
                    this.propertiesFilePlugin = propertiesFilePlugin;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                if (linkfile == null) return;
                this.loopback(linkfile);
                return;
            }
        }
        catch (Exception e) {
            if (applicationContext == null) return;
            throw new AssembleException("Add Config Properties for[" + applicationContext.getConfigfile() + "]:plugin[" + propertiesFilePlugin.getClass().getCanonicalName() + "] From plugin failed: " + SimpleStringUtil.object2json(extendsAttributes), e);
        }
    }

    public void addConfigPropertiesFromApollo(String namespace, String configChangeListener) {
        this.namespace = namespace;
        this.configChangeListener = configChangeListener;
        HashMap<String, String> pros = new HashMap<String, String>();
        pros.put("apolloNamespace", namespace);
        if (configChangeListener != null) {
            pros.put("configChangeListener", configChangeListener);
        }
        this.addConfigPropertiesFromApollo(namespace, null, null, pros);
    }

    @Override
    public synchronized void reset() {
        this.configPropertiesFiles = null;
        this.allProperties = null;
        this.addConfigPropertiesFromApollo(this.namespace, this.changeReload);
        this.afterLoaded(this);
    }

    public void addConfigPropertiesFromApollo(String namespace, boolean changeReload) {
        this.namespace = namespace;
        this.changeReload = changeReload;
        HashMap<String, String> pros = new HashMap<String, String>();
        pros.put("apolloNamespace", namespace);
        pros.put("changeReload", changeReload ? "true" : "false");
        if (changeReload) {
            pros.put("configChangeListener", "org.frameworkset.apollo.PropertiesContainerChangeListener");
        }
        this.addConfigPropertiesFromApollo(namespace, null, null, pros);
    }

    public void addConfigPropertiesFromApollo(String namespace) {
        HashMap<String, String> pros = new HashMap<String, String>();
        pros.put("apolloNamespace", namespace);
        this.addConfigPropertiesFromApollo(namespace, null, null, pros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigPropertiesFromApollo(String namespace, LinkConfigFile linkfile, BaseApplicationContext applicationContext, Map<String, String> extendsAttributes) {
        Map<Object, Object> allProperties;
        block18: {
            if (this.configPropertiesFiles == null) {
                this.configPropertiesFiles = new ArrayList<String>();
            }
            allProperties = new LinkedHashMap<Object, Object>();
            String configPropertiesPlugin = "org.frameworkset.apollo.ApolloPropertiesFilePlugin";
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName(configPropertiesPlugin);
                synchronized (clazz2) {
                    Map evaledProperties;
                    PropertiesFilePlugin propertiesFilePlugin = (PropertiesFilePlugin)clazz.newInstance();
                    Map configProperties = propertiesFilePlugin.getConfigProperties(applicationContext, extendsAttributes, this);
                    if (configProperties != null && configProperties.size() > 0) {
                        allProperties.putAll(configProperties);
                    }
                    if ((evaledProperties = EnvUtil.evalEnvVariable(this.allProperties, allProperties)) != null) {
                        allProperties.putAll(evaledProperties);
                    }
                    this.propertiesFilePlugin = propertiesFilePlugin;
                }
                if (linkfile != null) {
                    this.loopback(linkfile);
                }
            }
            catch (ClassNotFoundException e) {
                if (log.isErrorEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    if (applicationContext != null) {
                        msg.append("Add Config Properties for[").append(applicationContext.getConfigfile()).append("] From Apollo failed: ").append(SimpleStringUtil.object2json(extendsAttributes));
                    } else {
                        msg.append("Add Config Properties From Apollo failed: ").append(SimpleStringUtil.object2json(extendsAttributes));
                    }
                    msg.append(", Add compile dependency to build.gradle in gralde project: \r\napi \"com.bbossgroups.plugins:bboss-plugin-apollo:{lastVersion}\"").append(" \r\nor Add compile dependency to pom.xml in maven project: \r\n    ").append("    <dependency>\n").append("            <groupId>com.bbossgroups.plugins</groupId>\n").append("            <artifactId>bboss-plugin-apollo</artifactId>\n").append("            <version>{lastVersion}</version>\n").append("        </dependency>");
                    log.error(msg.toString(), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block18;
                if (applicationContext != null) {
                    log.error("Add Config Properties for[" + applicationContext.getConfigfile() + "] From Apollo failed: " + SimpleStringUtil.object2json(extendsAttributes), (Throwable)e);
                }
                log.error("Add Config Properties From Apollo failed: " + SimpleStringUtil.object2json(extendsAttributes), (Throwable)e);
            }
        }
        if (allProperties != null && allProperties.size() > 0) {
            allProperties = this.interceptorValues(allProperties);
        }
        if (this.allProperties == null) {
            this.allProperties = allProperties;
        } else if (allProperties != null && allProperties.size() > 0) {
            this.allProperties.putAll(allProperties);
        }
    }

    private void loadPropertiesFromFiles(Map configProperties, String configPropertiesFile, LinkConfigFile linkfile) {
        String[] configPropertiesFiles;
        for (String file_ : configPropertiesFiles = configPropertiesFile.split(",")) {
            this.configPropertiesFiles.add(file_);
            this.evalfile(configProperties, file_, linkfile);
        }
    }

    public String evalValue(List<String> parentLinks, String value, ProviderParser providerParser) {
        BaseApplicationContext context;
        if (SimpleStringUtil.isEmpty((String)value)) {
            return value;
        }
        ServiceProviderManager valueHandler = null;
        ProviderParser valueContainer = providerParser;
        if (providerParser != null && (context = providerParser.getApplicationContext()) != null) {
            valueHandler = context.getServiceProviderManager();
        }
        return this.evalValue(parentLinks, value, valueHandler, valueContainer);
    }

    public void checkLoopNode(String name, List<String> parentLinks) {
        if (parentLinks == null) {
            return;
        }
        boolean looped = false;
        for (int i = 0; i < parentLinks.size(); ++i) {
            String node = parentLinks.get(i);
            if (!node.equals(name)) continue;
            looped = true;
            break;
        }
        if (looped) {
            StringBuilder msg = new StringBuilder();
            msg.append("Loop macro reference: ");
            for (int i = 0; parentLinks != null && i < parentLinks.size(); ++i) {
                String node = parentLinks.get(i);
                msg.append(node).append("->");
            }
            msg.append(name);
            throw new MacroParserException(msg.toString());
        }
        parentLinks.add(name);
    }

    public String evalValue(List<String> parentLinks, String value, AOPValueHandler valueHandler, ValueContainer valueContainer) {
        if (SimpleStringUtil.isEmpty((String)value)) {
            return value;
        }
        String varpre = null;
        String varend = null;
        boolean findVariableFromSelf = false;
        if (valueHandler != null) {
            varpre = valueHandler.getVarpre();
            varend = valueHandler.getVarend();
            findVariableFromSelf = valueHandler.findVariableFromSelf();
        }
        if (varpre == null) {
            varpre = "${";
        }
        if (varend == null) {
            varend = "}";
        }
        List tokens = TextGrammarParser.parser((String)value, (String)varpre, (char)varend.charAt(0));
        StringBuilder re = new StringBuilder();
        for (int i = 0; tokens != null && i < tokens.size(); ++i) {
            TextGrammarParser.GrammarToken token = (TextGrammarParser.GrammarToken)tokens.get(i);
            if (token.texttoken()) {
                re.append(token.getText());
                continue;
            }
            String varvalue = this.getProperty(token.getText());
            if (varvalue == null) {
                this.checkLoopNode(token.getText(), parentLinks);
                varvalue = valueContainer.getMacroVariableValue(parentLinks, token.getText());
            }
            if (varvalue != null) {
                re.append(varvalue);
                continue;
            }
            if (token.getDefaultValue() != null) {
                re.append(token.getDefaultValue());
                continue;
            }
            re.append(varpre).append(token.getText()).append(varend);
        }
        return re.toString();
    }

    public String escapeValue(String value, ProviderParser providerParser, boolean escapeQuoted) {
        BaseApplicationContext context;
        if (SimpleStringUtil.isEmpty((String)value)) {
            return value;
        }
        ServiceProviderManager serviceProviderManager = null;
        if (providerParser != null && (context = providerParser.getApplicationContext()) != null) {
            serviceProviderManager = context.getServiceProviderManager();
        }
        return this.escapeValue(value, serviceProviderManager, escapeQuoted);
    }

    public String escapeValue(String value, AOPValueHandler valueHandler, boolean escapeQuoted) {
        TextGrammarParser.GrammarToken token;
        int i;
        StringBuilder re;
        List tokens;
        boolean escapeRN;
        if (SimpleStringUtil.isEmpty((String)value)) {
            return value;
        }
        String escapePre = null;
        String escapeEnd = null;
        String escapeRNPre = null;
        String escapeRNEnd = null;
        if (valueHandler != null) {
            escapePre = valueHandler.getEscapePre();
            escapeEnd = valueHandler.getEscapeEnd();
            escapeRNPre = valueHandler.getEscapeRNPre();
            escapeRNEnd = valueHandler.getEscapeRNEnd();
        }
        boolean escape = !SimpleStringUtil.isEmpty(escapeEnd) && !SimpleStringUtil.isEmpty((String)escapePre);
        boolean bl = escapeRN = !SimpleStringUtil.isEmpty(escapeRNPre) && !SimpleStringUtil.isEmpty(escapeRNEnd);
        if (escapeRN) {
            tokens = TextGrammarParser.parser((String)value, (String)escapeRNPre, (String)escapeRNEnd);
            re = new StringBuilder();
            for (i = 0; tokens != null && i < tokens.size(); ++i) {
                token = (TextGrammarParser.GrammarToken)tokens.get(i);
                if (token.texttoken()) {
                    re.append(token.getText());
                    continue;
                }
                if (escapeQuoted) {
                    re.append("\"");
                }
                valueHandler.escapeRN(token.getText(), re);
                if (!escapeQuoted) continue;
                re.append("\"");
            }
            value = re.toString();
        }
        if (escape) {
            tokens = TextGrammarParser.parser((String)value, (String)escapePre, (String)escapeEnd);
            re = new StringBuilder();
            for (i = 0; tokens != null && i < tokens.size(); ++i) {
                token = (TextGrammarParser.GrammarToken)tokens.get(i);
                if (token.texttoken()) {
                    re.append(token.getText());
                    continue;
                }
                if (escapeQuoted) {
                    re.append("\"");
                }
                valueHandler.escapeValue(token.getText(), re);
                if (!escapeQuoted) continue;
                re.append("\"");
            }
            value = re.toString();
        }
        return value;
    }

    public void addConfigPropertiesFile(String configPropertiesFile) {
        this.addConfigPropertiesFile(configPropertiesFile, null);
    }

    private void loopback(LinkConfigFile linkfile) {
        linkfile.loopback(this);
    }

    private void handleIncludeFiles(List<Properties> includeProperties, Properties currentProperties, String configPropertiesFile, LinkConfigFile linkfile) {
        Iterator<Map.Entry<Object, Object>> iterator = currentProperties.entrySet().iterator();
        ArrayList<String> removeKeys = new ArrayList<String>();
        while (iterator.hasNext()) {
            String[] configPropertiesFiles;
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.equals("include.files")) continue;
            removeKeys.add(key);
            if (value.trim().equals("")) continue;
            for (String file_ : configPropertiesFiles = value.split(",")) {
                if ((file_ = file_.trim()).equals("") || this.contain(file_)) continue;
                logger.info("load properties from {} included by {}", (Object)file_, (Object)configPropertiesFile);
                this.evalfileInner(includeProperties, file_, linkfile);
            }
        }
        if (removeKeys.size() > 0) {
            for (String key : removeKeys) {
                currentProperties.remove(key);
            }
        }
    }

    private boolean contain(String file) {
        boolean contain = false;
        for (String ofile : this.configPropertiesFiles) {
            if (!ofile.equals(file)) continue;
            contain = true;
            break;
        }
        return contain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalfile(Map currentProperties, String configPropertiesFile, LinkConfigFile linkfile) {
        Properties properties = new Properties();
        InputStream input = null;
        Reader read = null;
        try {
            block37: {
                StringBuilder builder;
                if (!configPropertiesFile.startsWith("file:")) {
                    ClassPathResource resource = new ClassPathResource(configPropertiesFile);
                    try {
                        input = resource.getInputStream();
                        if (log.isInfoEnabled()) {
                            log.info("load config Properties File :" + resource.getURL());
                        }
                        break block37;
                    }
                    catch (Exception e) {
                        if (linkfile == null) {
                            if (log.isInfoEnabled()) {
                                log.info("load config Properties File :" + configPropertiesFile + " does not exist,Ignore load.");
                            }
                        } else if (log.isInfoEnabled()) {
                            builder = new StringBuilder();
                            builder.append("load config Properties File :").append(configPropertiesFile).append(" in ");
                            linkfile.toString(builder);
                            builder.append(" does not exist,Ignore load.");
                            log.info(builder.toString());
                        }
                        break block37;
                    }
                }
                String _configPropertiesFile = configPropertiesFile.substring("file:".length());
                File configFile = new File(_configPropertiesFile);
                if (configFile.exists()) {
                    input = new FileInputStream(configFile);
                    if (log.isInfoEnabled()) {
                        log.info("load config Properties File :" + _configPropertiesFile);
                    }
                } else if (linkfile == null) {
                    if (log.isInfoEnabled()) {
                        log.info("load config Properties File :" + configPropertiesFile + " does not exist,Ignore load.");
                    } else if (log.isInfoEnabled()) {
                        builder = new StringBuilder();
                        builder.append("load config Properties File :").append(configPropertiesFile).append(" in ");
                        linkfile.toString(builder);
                        builder.append(" does not exist,Ignore load.");
                        log.info(builder.toString());
                    }
                }
            }
            if (input != null) {
                read = new InputStreamReader(input, "UTF-8");
                properties.load(read);
            }
            if (!properties.isEmpty()) {
                ArrayList<Properties> propertiesList = new ArrayList<Properties>();
                this.handleIncludeFiles(propertiesList, properties, configPropertiesFile, linkfile);
                for (Properties properties_ : propertiesList) {
                    this.mergeProperties(properties, properties_);
                }
                currentProperties.putAll(properties);
            }
        }
        catch (Exception e) {
            log.error("load config Properties File failed:", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void mergeProperties(Properties properties, Properties includeProperties) {
        for (Map.Entry<Object, Object> entry : includeProperties.entrySet()) {
            Object key = entry.getKey();
            if (properties.containsKey(key)) continue;
            Object value = entry.getValue();
            properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalfileInner(List<Properties> propertiesList, String configPropertiesFile, LinkConfigFile linkfile) {
        Properties properties = new Properties();
        InputStream input = null;
        Reader read = null;
        try {
            block37: {
                StringBuilder builder;
                if (!configPropertiesFile.startsWith("file:")) {
                    ClassPathResource resource = new ClassPathResource(configPropertiesFile);
                    try {
                        input = resource.getInputStream();
                        if (log.isInfoEnabled()) {
                            log.info("load config Properties File :" + resource.getURL());
                        }
                        break block37;
                    }
                    catch (Exception e) {
                        if (linkfile == null) {
                            if (log.isInfoEnabled()) {
                                log.info("load config Properties File :" + configPropertiesFile + " does not exist,Ignore load.");
                            }
                        } else if (log.isInfoEnabled()) {
                            builder = new StringBuilder();
                            builder.append("load config Properties File :").append(configPropertiesFile).append(" in ");
                            linkfile.toString(builder);
                            builder.append(" does not exist,Ignore load.");
                            log.info(builder.toString());
                        }
                        break block37;
                    }
                }
                String _configPropertiesFile = configPropertiesFile.substring("file:".length());
                File configFile = new File(_configPropertiesFile);
                if (configFile.exists()) {
                    input = new FileInputStream(configFile);
                    if (log.isInfoEnabled()) {
                        log.info("load config Properties File :" + _configPropertiesFile);
                    }
                } else if (linkfile == null) {
                    if (log.isInfoEnabled()) {
                        log.info("load config Properties File :" + configPropertiesFile + " does not exist,Ignore load.");
                    } else if (log.isInfoEnabled()) {
                        builder = new StringBuilder();
                        builder.append("load config Properties File :").append(configPropertiesFile).append(" in ");
                        linkfile.toString(builder);
                        builder.append(" does not exist,Ignore load.");
                        log.info(builder.toString());
                    }
                }
            }
            if (input != null) {
                read = new InputStreamReader(input, "UTF-8");
                properties.load(read);
            }
            if (!properties.isEmpty()) {
                ArrayList<Properties> innerpropertiesList = new ArrayList<Properties>();
                this.handleIncludeFiles(innerpropertiesList, properties, configPropertiesFile, linkfile);
                for (Properties properties_ : innerpropertiesList) {
                    this.mergeProperties(properties, properties_);
                }
                propertiesList.add(properties);
            }
        }
        catch (Exception e) {
            log.error("load config Properties File failed:", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void mergeParentConfigProperties(PropertiesContainer parent) {
        if (parent == this) {
            return;
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        this.allProperties.putAll(parent.getAllProperties());
    }

    public void mergeSonConfigProperties(PropertiesContainer son) {
        if (this.sonAndParentProperties == null) {
            this.sonAndParentProperties = new Properties();
        }
        if (son.getAllProperties() != null) {
            this.sonAndParentProperties.putAll(son.getAllProperties());
        }
    }

    @Deprecated
    public Map getAllProperties() {
        return this.allProperties;
    }

    public String getProperty(String property) {
        if (this.allProperties == null) {
            return null;
        }
        Object value = this.allProperties.get(property);
        if (value == null) {
            return null;
        }
        return value instanceof String ? (String)value : String.valueOf(value);
    }

    public String getProperty(String property, String defaultValue) {
        if (this.allProperties == null) {
            return defaultValue;
        }
        Object value = this.allProperties.get(property);
        if (value == null) {
            return defaultValue;
        }
        return value instanceof String ? (String)value : String.valueOf(value);
    }

    public Object getObjectProperty(String property) {
        if (this.allProperties == null) {
            return null;
        }
        Object value = this.allProperties.get(property);
        return value;
    }

    @Override
    public String getSystemEnvProperty(String property) {
        String value = this.getProperty(property);
        if (value == null && (value = System.getProperty(property)) == null) {
            value = System.getenv(property);
        }
        return value;
    }

    public String getSystemEnvProperty(String property, String defaultValue) {
        String value = this.getSystemEnvProperty(property);
        return value != null ? value : defaultValue;
    }

    public Boolean getBooleanSystemEnvProperty(String property) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return null;
        }
        if (value.equals("true")) {
            return true;
        }
        return false;
    }

    public boolean getBooleanSystemEnvProperty(String property, boolean defaultValue) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public boolean getBooleanProperty(String property, boolean defaultValue) {
        if (this.allProperties == null) {
            return defaultValue;
        }
        Object value = this.allProperties.get(property);
        return ValueCastUtil.toBoolean((Object)value, (boolean)defaultValue);
    }

    public int getIntSystemEnvProperty(String property, int defaultValue) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getIntSystemEnvProperty failed:" + property + "=" + value);
        }
    }

    public Integer getIntSystemEnvProperty(String property) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getIntSystemEnvProperty failed:" + property + "=" + value);
        }
    }

    public int getIntProperty(String property, int defaultValue) {
        if (this.allProperties == null) {
            return defaultValue;
        }
        Object value = this.allProperties.get(property);
        try {
            return ValueCastUtil.toInt((Object)value, (int)defaultValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getIntProperty failed:" + property + "=" + value);
        }
    }

    @Override
    public Map getAllExternalProperties() {
        return this.getAllProperties();
    }

    public long getLongSystemEnvProperty(String property, long defaultValue) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getLongSystemEnvProperty failed:" + property + "=" + value);
        }
    }

    public Long getLongSystemEnvProperty(String property) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getLongSystemEnvProperty failed:" + property + "=" + value);
        }
    }

    public long getLongProperty(String property, long defaultValue) {
        if (this.allProperties == null) {
            return defaultValue;
        }
        Object value = this.allProperties.get(property);
        try {
            return ValueCastUtil.toLong((Object)value, (long)defaultValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getLongProperty failed:" + property + "=" + value);
        }
    }

    public String getPropertyFromSelf2ndSons(String property) {
        Object value = null;
        value = this.sonAndParentProperties == null ? null : this.sonAndParentProperties.get(property);
        if (value == null) {
            value = this.getObjectProperty(property);
        }
        return ValueCastUtil.toString((Object)value, null);
    }

    public int size() {
        if (this.allProperties == null) {
            return 0;
        }
        return this.allProperties.size();
    }

    public static void main(String[] args) {
        String _configPropertiesFile = "file:/opt/local/xxx.propertis".substring("file:".length());
        System.out.println(_configPropertiesFile);
    }
}

