/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.async;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.frameworkset.spi.ApplicationContext;
import org.frameworkset.spi.BaseSPIManager2;
import org.frameworkset.spi.assemble.ProMap;
import org.frameworkset.spi.async.AsyncCallException;
import org.frameworkset.spi.async.CallService;
import org.frameworkset.spi.async.annotation.Result;
import org.frameworkset.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCall {
    private static Logger log = LoggerFactory.getLogger(AsyncCall.class);
    private ThreadPoolExecutor callexecutor = null;
    private ThreadPoolExecutor callbackexecutor = null;
    private Object lock = new Object();
    private boolean started = false;
    private CallHandler callHandler;
    private CallBackHandler callBackHandler;
    private LinkedBlockingQueue<CallService> callblockqueue = new LinkedBlockingQueue(BaseSPIManager2.getIntProperty("component.asynccall.block.size", 200));
    private LinkedBlockingQueue<CallService> callbackblockqueue = new LinkedBlockingQueue(BaseSPIManager2.getIntProperty("component.asynccallback.block.size", 200));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.started) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.initCallExecutor();
            this.initCallBackExecutor();
            this.callHandler = new CallHandler();
            new Thread((Runnable)this.callHandler, "callHandler").start();
            this.callBackHandler = new CallBackHandler();
            new Thread((Runnable)this.callBackHandler, "callBackHandler").start();
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.stopCallExecutor();
            this.stopCallBackExecutor();
            this.started = false;
        }
    }

    private void stopCallExecutor() {
        if (this.callexecutor != null) {
            this.callexecutor.shutdown();
        }
    }

    private void stopCallBackExecutor() {
        if (this.callbackexecutor != null) {
            this.callbackexecutor.shutdown();
        }
    }

    private void initCallExecutor() {
        ProMap proMap = BaseSPIManager2.getMapProperty("component.asynccall.threadpool");
        if (proMap == null || proMap.size() == 0) {
            this.callexecutor = new ThreadPoolExecutor(5, 20, 40L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(BaseSPIManager2.getIntProperty("component.asynccall.block.size", 200) / 2), new ThreadPoolExecutor.CallerRunsPolicy());
        } else {
            String timeUnit = proMap.getString("timeUnit", "TimeUnit.SECONDS");
            TimeUnit timeUnit_ = TimeUtil.getTimeUnitByName((String)timeUnit, (TimeUnit)TimeUnit.SECONDS);
            this.callexecutor = new ThreadPoolExecutor(proMap.getInt("corePoolSize", 5), proMap.getInt("maximumPoolSize", 20), (long)proMap.getInt("keepAliveTime", 40), timeUnit_, new LinkedBlockingQueue<Runnable>(BaseSPIManager2.getIntProperty("component.asynccall.block.size", 200) / 2), new ThreadPoolExecutor.CallerRunsPolicy());
        }
    }

    private void initCallBackExecutor() {
        ProMap proMap = BaseSPIManager2.getMapProperty("component.asynccallback.threadpool");
        if (proMap == null || proMap.size() == 0) {
            this.callbackexecutor = new ThreadPoolExecutor(5, 20, 40L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(ApplicationContext.getApplicationContext().getIntProperty("component.asynccallback.block.size", 200) / 2), new ThreadPoolExecutor.CallerRunsPolicy());
        } else {
            String timeUnit = proMap.getString("timeUnit", "TimeUnit.SECONDS");
            TimeUnit timeUnit_ = TimeUtil.getTimeUnitByName((String)timeUnit, (TimeUnit)TimeUnit.SECONDS);
            this.callbackexecutor = new ThreadPoolExecutor(proMap.getInt("corePoolSize", 5), proMap.getInt("maximumPoolSize", 20), (long)proMap.getInt("keepAliveTime", 40), timeUnit_, new LinkedBlockingQueue<Runnable>(ApplicationContext.getApplicationContext().getIntProperty("component.asynccallback.block.size", 200) / 2), new ThreadPoolExecutor.CallerRunsPolicy());
        }
    }

    public boolean started() {
        return this.started;
    }

    public void putCallService(CallService callService) throws InterruptedException {
        this.callblockqueue.put(callService);
    }

    public void putCallBackService(CallService callService) throws InterruptedException {
        this.callbackblockqueue.put(callService);
    }

    public Object runCallService(CallService task) throws Exception {
        if (!this.started()) {
            throw new AsyncCallException("\u5f02\u6b65\u8c03\u7528\u670d\u52a1\u5df2\u7ecf\u88ab\u505c\u6b62\uff0c\u62d2\u7edd\u63a5\u53d7\u65b0\u7684\u5f02\u6b65\u670d\u52a1\u8c03\u7528");
        }
        if (task != null) {
            if (task.getAsyncMethod().getAsyncResultMode() == Result.YES) {
                if (task.getAsyncMethod().getAsyncCallback() == null) {
                    if (task.getAsyncMethod().getAsyncTimeout() > 0L) {
                        FutureTask f = new FutureTask(task);
                        this.callexecutor.execute(f);
                        return f.get(task.getAsyncMethod().getAsyncTimeout(), TimeUnit.MICROSECONDS);
                    }
                    FutureTask f = new FutureTask(task);
                    this.callexecutor.execute(f);
                    return f.get();
                }
                this.putCallBackService(task);
            } else {
                this.putCallService(task);
            }
            return null;
        }
        throw new AsyncCallException("\u5f02\u6b65\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a\u670d\u52a1\u4e3anull");
    }

    class CallBackHandler
    implements Runnable {
        CallBackHandler() {
        }

        @Override
        public void run() {
            CallService callService = null;
            while (true) {
                try {
                    while (true) {
                        callService = (CallService)AsyncCall.this.callbackblockqueue.take();
                        AsyncCall.this.callbackexecutor.execute(new AsynCallbackRunnable(callService));
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class CallHandler
    implements Runnable {
        CallHandler() {
        }

        @Override
        public void run() {
            CallService callService = null;
            while (true) {
                try {
                    while (true) {
                        callService = (CallService)AsyncCall.this.callblockqueue.take();
                        AsyncCall.this.callexecutor.execute(new AsynRunnable(callService));
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    public static class AsynCallbackRunnable
    implements Runnable {
        CallService task;

        AsynCallbackRunnable(CallService task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (this.task.getAsyncMethod().getAsyncTimeout() <= 0L) {
                    final Object ret = this.task.call();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            task.getCallBackService().getCallBack().handleResult(ret);
                        }
                    }).start();
                } else {
                    FutureTask t = new FutureTask(this.task);
                    new Thread(t).start();
                    final Object ret = t.get(this.task.getAsyncMethod().getAsyncTimeout(), TimeUnit.MICROSECONDS);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            task.getCallBackService().getCallBack().handleResult(ret);
                        }
                    }).start();
                }
            }
            catch (InvocationTargetException e) {
                final Throwable throwable = e.getTargetException();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        task.getCallBackService().getCallBack().handleError(throwable);
                    }
                }).start();
            }
            catch (Exception e) {
                final Exception throwable = e;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        task.getCallBackService().getCallBack().handleError(throwable);
                    }
                }).start();
            }
        }
    }

    public static class AsynRunnable
    implements Runnable {
        CallService task;

        AsynRunnable(CallService task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                if (this.task.getAsyncMethod().getAsyncTimeout() <= 0L) {
                    this.task.call();
                } else {
                    FutureTask t = new FutureTask(this.task);
                    new Thread(t).start();
                    t.get(this.task.getAsyncMethod().getAsyncTimeout(), TimeUnit.MICROSECONDS);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

