/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import com.frameworkset.util.SimpleStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.util.EntityUtils;
import org.frameworkset.spi.remote.http.proxy.HttpProxyRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtil {
    private static Logger logger = LoggerFactory.getLogger(ResponseUtil.class);

    public static <K, T> Map<K, T> handleMapResponse(String url, HttpResponse response, Class<K> keyType, Class<T> beanType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? ResponseUtil.converJson2Map(entity, keyType, beanType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException("Request url:" + url + ",error:" + EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static <T> List<T> handleListResponse(String url, HttpResponse response, Class<T> resultType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? ResponseUtil.converJson2List(entity, resultType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException("Request url:" + url + ",error:" + EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static <T> Set<T> handleSetResponse(String url, HttpResponse response, Class<T> resultType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? ResponseUtil.converJson2Set(entity, resultType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException("Request url:" + url + ",error:" + EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static String handleStringResponse(String url, HttpResponse response) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            throw new HttpProxyRequestException("send request to " + url + " failed:" + EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("send request to " + url + ",Unexpected response status: " + status);
    }

    public static <T> T handleResponse(String url, HttpResponse response, Class<T> resultType) throws ClientProtocolException, IOException {
        int status;
        if (resultType != null) {
            if (resultType.isAssignableFrom(String.class)) {
                return (T)ResponseUtil.handleStringResponse(url, response);
            }
            if (resultType.isAssignableFrom(Integer.class)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return null;
                }
                return (T)Integer.valueOf(Integer.parseInt(value));
            }
            if (resultType.isAssignableFrom(Integer.TYPE)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return (T)new Integer(0);
                }
                return (T)Integer.valueOf(Integer.parseInt(value));
            }
            if (resultType.isAssignableFrom(Long.class)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return null;
                }
                return (T)Long.valueOf(Long.parseLong(value));
            }
            if (resultType.isAssignableFrom(Long.TYPE)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return (T)new Long(0L);
                }
                return (T)Long.valueOf(Long.parseLong(value));
            }
            if (resultType.isAssignableFrom(Short.class)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return null;
                }
                return (T)Short.valueOf(Short.parseShort(value));
            }
            if (resultType.isAssignableFrom(Short.TYPE)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return (T)new Short(0);
                }
                return (T)Short.valueOf(Short.parseShort(value));
            }
            if (resultType.isAssignableFrom(Float.class)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return null;
                }
                return (T)Float.valueOf(Float.parseFloat(value));
            }
            if (resultType.isAssignableFrom(Float.TYPE)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return (T)new Float(0.0f);
                }
                return (T)Float.valueOf(Float.parseFloat(value));
            }
            if (resultType.isAssignableFrom(Double.class)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return null;
                }
                return (T)Double.valueOf(Double.parseDouble(value));
            }
            if (resultType.isAssignableFrom(Double.TYPE)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return (T)new Double(0.0);
                }
                return (T)Double.valueOf(Double.parseDouble(value));
            }
            if (resultType.isAssignableFrom(Boolean.class)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return null;
                }
                return (T)Boolean.valueOf(Boolean.parseBoolean(value));
            }
            if (resultType.isAssignableFrom(Boolean.TYPE)) {
                String value = ResponseUtil.handleStringResponse(url, response);
                if (value == null) {
                    return (T)new Boolean(false);
                }
                return (T)Boolean.valueOf(Boolean.parseBoolean(value));
            }
        }
        if ((status = response.getStatusLine().getStatusCode()) >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? (T)ResponseUtil.converJson(entity, resultType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException("Request url:" + url + ",error:" + EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static <D, T> D handleResponse(String url, HttpResponse response, Class<D> containType, Class<T> resultType) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? (D)ResponseUtil.converJson(entity, containType, resultType) : null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Request url:" + url + ",status:" + status);
            }
            throw new HttpProxyRequestException("Request url:" + url + ",error:" + EntityUtils.toString((HttpEntity)entity));
        }
        throw new HttpProxyRequestException("Request url:" + url + ",Unexpected response status: " + status);
    }

    public static boolean entityEmpty(HttpEntity entity, InputStream inputStream) throws IOException {
        return inputStream instanceof EmptyInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T converJson(HttpEntity entity, Class<T> clazz) throws IOException {
        Object var4;
        try (InputStream inputStream = null;){
            inputStream = entity.getContent();
            if (ResponseUtil.entityEmpty(entity, inputStream)) {
                T t = null;
                return t;
            }
            var4 = SimpleStringUtil.json2Object((InputStream)inputStream, clazz);
        }
        return (T)var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <D, T> D converJson(HttpEntity entity, Class<D> containType, Class<T> clazz) throws IOException {
        Object var4;
        try (InputStream inputStream = null;){
            inputStream = entity.getContent();
            if (ResponseUtil.entityEmpty(entity, inputStream)) {
                D d = null;
                return d;
            }
            var4 = SimpleStringUtil.json2TypeObject((InputStream)inputStream, containType, clazz);
        }
        return (D)var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> converJson2List(HttpEntity entity, Class<T> clazz) throws IOException {
        List var4 = null;
        try (InputStream inputStream = null;){
            inputStream = entity.getContent();
            if (ResponseUtil.entityEmpty(entity, inputStream)) {
                List<T> list = null;
                return list;
            }
            var4 = SimpleStringUtil.json2ListObject((InputStream)inputStream, clazz);
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<T> converJson2Set(HttpEntity entity, Class<T> clazz) throws IOException {
        Set var4;
        try (InputStream inputStream = null;){
            inputStream = entity.getContent();
            if (ResponseUtil.entityEmpty(entity, inputStream)) {
                Set<T> set = null;
                return set;
            }
            var4 = SimpleStringUtil.json2LSetObject((InputStream)inputStream, clazz);
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, T> Map<K, T> converJson2Map(HttpEntity entity, Class<K> keyType, Class<T> beanType) throws IOException {
        Map var4;
        try (InputStream inputStream = null;){
            inputStream = entity.getContent();
            if (ResponseUtil.entityEmpty(entity, inputStream)) {
                Map<K, T> map = null;
                return map;
            }
            var4 = SimpleStringUtil.json2LHashObject((InputStream)inputStream, keyType, beanType);
        }
        return var4;
    }
}

