/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import com.frameworkset.util.SimpleStringUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class TimeUtil {
    private static DateTimeFormatter dateTimeFormatter;
    private static DateTimeFormatter dateTimeFormatterDefault;
    private static Map<String, DateTimeFormatter> dateTimeFormatterMap;
    private static Object lock;

    public static LocalDateTime localDateTime(String localDateTime) {
        DateTimeFormatter dateTimeFormatter = TimeUtil.getDateTimeFormatter();
        LocalDateTime date = LocalDateTime.parse(localDateTime, dateTimeFormatter);
        return date;
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTimeFormatter getDateTimeFormatter() {
        if (dateTimeFormatter != null) {
            return dateTimeFormatter;
        }
        Object object = lock;
        synchronized (object) {
            DateTimeFormatter dateTimeFormatter_;
            if (dateTimeFormatter != null) {
                return dateTimeFormatter;
            }
            DateTimeFormatter ISO_LOCAL_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).optionalStart().appendLiteral('/').optionalEnd().optionalStart().appendLiteral('-').optionalEnd().optionalStart().appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('/').optionalEnd().optionalStart().appendLiteral('-').optionalEnd().optionalStart().appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
            DateTimeFormatter ISO_LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalStart().appendZoneId().toFormatter();
            dateTimeFormatter = dateTimeFormatter_ = new DateTimeFormatterBuilder().append(ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendOptional(ISO_LOCAL_TIME).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.SIMPLIFIED_CHINESE);
            return dateTimeFormatter;
        }
    }

    public static String changeLocalDateTime2String(LocalDateTime localDateTime) {
        return localDateTime.format(dateTimeFormatterDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTimeFormatter getDateTimeFormatter(String dateFormat) {
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterMap.get(dateFormat);
        if (dateTimeFormatter != null) {
            return dateTimeFormatter;
        }
        Map<String, DateTimeFormatter> map = dateTimeFormatterMap;
        synchronized (map) {
            dateTimeFormatter = dateTimeFormatterMap.get(dateFormat);
            if (dateTimeFormatter != null) {
                return dateTimeFormatter;
            }
            dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat);
            dateTimeFormatterMap.put(dateFormat, dateTimeFormatter);
            return dateTimeFormatter;
        }
    }

    public static String changeLocalDateTime2String(LocalDateTime localDateTime, String dateFormat) {
        if (SimpleStringUtil.isNotEmpty((String)dateFormat)) {
            return localDateTime.format(TimeUtil.getDateTimeFormatter(dateFormat));
        }
        return localDateTime.format(dateTimeFormatterDefault);
    }

    public static String changeLocalDate2String(LocalDate localDateTime, String dateFormat) {
        if (SimpleStringUtil.isNotEmpty((String)dateFormat)) {
            return localDateTime.format(TimeUtil.getDateTimeFormatter(dateFormat));
        }
        return localDateTime.format(dateTimeFormatterDefault);
    }

    static {
        dateTimeFormatterDefault = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'");
        dateTimeFormatterMap = new LinkedHashMap<String, DateTimeFormatter>();
        lock = new Object();
    }
}

