/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy;

import java.util.ArrayList;
import java.util.List;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.HttpHost;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHostsConfig;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpHostDiscover
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(HttpHostDiscover.class);
    private long discoverInterval = 10000L;
    private HttpServiceHosts httpServiceHosts;
    boolean stop = false;

    public HttpHostDiscover() {
        super("Http HostDiscover Thread");
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                HttpHostDiscover.this.stopCheck();
            }
        });
        this.setDaemon(true);
    }

    public synchronized void stopCheck() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void handleDiscoverHosts(List<HttpHost> _hosts) {
        this.handleDiscoverHosts(_hosts, null);
    }

    public synchronized void changeRouting(String newCurrentRounte) {
        this.httpServiceHosts.routingGroup(false, newCurrentRounte);
    }

    public synchronized void handleDiscoverHosts(List<HttpHost> _hosts, String newCurrentRounte) {
        ArrayList<HttpHost> hosts = null;
        hosts = _hosts != null && _hosts.size() > 0 ? new ArrayList<HttpHost>(_hosts) : new ArrayList();
        ArrayList<HttpAddress> newAddress = new ArrayList<HttpAddress>();
        boolean changed = this.httpServiceHosts.recoverRemovedNodes(hosts);
        HttpHost httpHost = null;
        String health = this.httpServiceHosts.getHttpServiceHostsConfig().getHealth();
        for (int i = 0; hosts != null && i < hosts.size(); ++i) {
            httpHost = (HttpHost)hosts.get(i);
            HttpAddress address = new HttpAddress(httpHost.getOrigineAddress(), httpHost.getHostAddress(), httpHost.getRouting(), health);
            address.setAttributes(httpHost.getAttributes());
            if (this.httpServiceHosts.containAddress(address)) continue;
            newAddress.add(address);
        }
        if (newAddress.size() > 0) {
            if (!changed) {
                changed = true;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Discovery new Http pool[" + this.httpServiceHosts.getClientConfiguration().getBeanName() + "] servers " + newAddress + ".");
            }
            this.httpServiceHosts.addAddresses(newAddress);
        }
        this.httpServiceHosts.handleRemoved(hosts);
        if (changed) {
            this.httpServiceHosts.routingGroup(true, newCurrentRounte);
        } else if (newCurrentRounte != null) {
            this.httpServiceHosts.routingGroup(false, newCurrentRounte);
        }
    }

    protected abstract List<HttpHost> discover(HttpServiceHostsConfig var1, ClientConfiguration var2, GetProperties var3);

    @Override
    public void run() {
        while (!this.stop) {
            this.doDiscover();
            try {
                HttpHostDiscover.sleep(this.discoverInterval);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void doDiscover() {
        block7: {
            try {
                List<HttpHost> httpHosts;
                if (logger.isDebugEnabled()) {
                    logger.debug("Discovery Http pool[" + this.httpServiceHosts.getClientConfiguration().getBeanName() + "] servers.");
                }
                if ((httpHosts = this.discover(this.httpServiceHosts.getHttpServiceHostsConfig(), this.httpServiceHosts.getClientConfiguration(), this.httpServiceHosts.getClientConfiguration().getContextProperties())) == null || httpHosts.size() == 0) {
                    Boolean handleNullOrEmptyHostsByDiscovery = this.handleNullOrEmptyHostsByDiscovery();
                    if (handleNullOrEmptyHostsByDiscovery == null) {
                        handleNullOrEmptyHostsByDiscovery = this.httpServiceHosts.getHandleNullOrEmptyHostsByDiscovery();
                    }
                    if (handleNullOrEmptyHostsByDiscovery == null || !handleNullOrEmptyHostsByDiscovery.booleanValue()) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Discovery " + this.httpServiceHosts.getClientConfiguration().getBeanName() + " servers : ignore with httpHosts == null || httpHosts.size() == 0");
                        }
                        return;
                    }
                }
                this.handleDiscoverHosts(httpHosts);
            }
            catch (Exception e) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info("Discovery " + this.httpServiceHosts.getClientConfiguration().getBeanName() + " servers failed:", (Throwable)e);
            }
        }
    }

    public void setHttpServiceHosts(HttpServiceHosts httpServiceHosts) {
        this.httpServiceHosts = httpServiceHosts;
        if (this.httpServiceHosts.getDiscoverServiceInterval() > 0L) {
            this.discoverInterval = this.httpServiceHosts.getDiscoverServiceInterval();
        }
        String threadName = "Http pool[" + httpServiceHosts.getClientConfiguration().getBeanName() + "] HostDiscover Thread";
        this.setName(threadName);
        if (logger.isInfoEnabled()) {
            logger.info("HttpServiceHosts dicover thread:" + threadName);
        }
    }

    @Override
    public void start() {
        if (logger.isInfoEnabled()) {
            logger.info("First doDiscovery Http pool[" + this.httpServiceHosts.getClientConfiguration().getBeanName() + "] servers at start time.");
        }
        this.doDiscover();
        super.start();
    }

    protected Boolean handleNullOrEmptyHostsByDiscovery() {
        return null;
    }
}

