/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.kerberos;

import com.frameworkset.util.SimpleStringUtil;
import com.sun.security.auth.login.ConfigFile;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.HttpRuntimeException;
import org.frameworkset.spi.remote.http.kerberos.KerberosConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosHelper.class);

    public static AppConfigurationEntry[] readAppConfigurationEntryFromFile(KerberosConfig kerberosConfig) {
        AppConfigurationEntry[] entries = null;
        File jaasConfigFile = new File(kerberosConfig.getLoginConfig());
        if (jaasConfigFile.exists() && jaasConfigFile.isFile()) {
            ConfigFile configFile = new ConfigFile(jaasConfigFile.toURI());
            LOG.info(String.format(Locale.ENGLISH, "Get application configuration entry use by application name %s.", kerberosConfig.getLoginContextName()));
            entries = configFile.getAppConfigurationEntry(kerberosConfig.getLoginContextName());
            if (entries == null || entries.length <= 0) {
                LOG.info(String.format(Locale.ENGLISH, "Get application configuration entry use by application name %s.", "Client"));
            }
        }
        return entries;
    }

    public static AppConfigurationEntry[] getAppConfigurationEntry(final KerberosConfig kerberosConfig) {
        if (kerberosConfig.getConfigMode() == 2) {
            return KerberosHelper.readAppConfigurationEntryFromFile(kerberosConfig);
        }
        return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap<String, Object>(){
            {
                this.put("useTicketCache", kerberosConfig.getUseTicketCache());
                if (SimpleStringUtil.isNotEmpty((String)kerberosConfig.getKeytab())) {
                    this.put("useKeyTab", "true");
                }
                this.put("keyTab", kerberosConfig.getKeytab());
                this.put("refreshKrb5Config", kerberosConfig.getRefreshKrb5Config());
                this.put("principal", kerberosConfig.getPrincipal());
                this.put("storeKey", kerberosConfig.getStoreKey());
                this.put("doNotPrompt", kerberosConfig.getDoNotPrompt());
                this.put("isInitiator", kerberosConfig.getIsInitiator());
                this.put("debug", kerberosConfig.getDebug());
                if (kerberosConfig.getExts() != null && !kerberosConfig.getExts().isEmpty()) {
                    this.putAll(kerberosConfig.getExts());
                }
            }
        })};
    }

    public static KerberosConfig buildKerberosConfig(String name, GetProperties context, String healthPoolname, StringBuilder log) throws Exception {
        Map<String, Object> kerberosConfigs = ClientConfiguration._getValuesWithPrex(name, "http.kerberos", context);
        KerberosConfig kerberosConfig = null;
        if (kerberosConfigs != null && !kerberosConfigs.isEmpty()) {
            log.append(",kerberosConfigs=").append(SimpleStringUtil.object2json(kerberosConfigs));
            kerberosConfig = new KerberosConfig();
            for (Map.Entry<String, Object> entry : kerberosConfigs.entrySet()) {
                String key = entry.getKey();
                if (key.equals("principal")) {
                    kerberosConfig.setPrincipal((String)entry.getValue());
                    continue;
                }
                if (key.equals("serverRealmPath")) {
                    kerberosConfig.setServerRealmPath((String)entry.getValue());
                    continue;
                }
                if (key.equals("serverRealm")) {
                    kerberosConfig.setServerRealm((String)entry.getValue());
                    continue;
                }
                if (key.equals("loginContextName")) {
                    kerberosConfig.setLoginContextName((String)entry.getValue());
                    continue;
                }
                if (key.equals("useSubjectCredsOnly")) {
                    kerberosConfig.setUseSubjectCredsOnly((String)entry.getValue());
                    continue;
                }
                if (key.equals("keytab")) {
                    kerberosConfig.setKeytab((String)entry.getValue());
                    continue;
                }
                if (key.equals("krb5Location")) {
                    kerberosConfig.setKrb5Location((String)entry.getValue());
                    continue;
                }
                if (key.equals("useTicketCache")) {
                    kerberosConfig.setUseTicketCache((String)entry.getValue());
                    continue;
                }
                if (key.equals("useKeyTab")) {
                    kerberosConfig.setUseKeyTab((String)entry.getValue());
                    continue;
                }
                if (key.equals("refreshKrb5Config")) {
                    kerberosConfig.setRefreshKrb5Config((String)entry.getValue());
                    continue;
                }
                if (key.equals("storeKey")) {
                    kerberosConfig.setStoreKey((String)entry.getValue());
                    continue;
                }
                if (key.equals("doNotPrompt")) {
                    kerberosConfig.setDoNotPrompt((String)entry.getValue());
                    continue;
                }
                if (key.equals("isInitiator")) {
                    kerberosConfig.setIsInitiator((String)entry.getValue());
                    continue;
                }
                if (key.equals("debug")) {
                    kerberosConfig.setDebug((String)entry.getValue());
                    continue;
                }
                if (key.equals("loginConfig")) {
                    kerberosConfig.setLoginConfig((String)entry.getValue());
                    continue;
                }
                kerberosConfig.addProperty(key, (String)entry.getValue());
            }
        }
        if (kerberosConfig != null) {
            KerberosHelper.validateKerberosConfig(kerberosConfig);
        }
        return kerberosConfig;
    }

    private static void validateKerberosConfig(KerberosConfig kerberosConfig) {
        if (SimpleStringUtil.isNotEmpty((String)kerberosConfig.getPrincipal()) && SimpleStringUtil.isNotEmpty((String)kerberosConfig.getKrb5Location()) && SimpleStringUtil.isNotEmpty((String)kerberosConfig.getKeytab())) {
            kerberosConfig.setConfigMode(1);
            return;
        }
        if (SimpleStringUtil.isNotEmpty((String)kerberosConfig.getLoginConfig()) && SimpleStringUtil.isNotEmpty((String)kerberosConfig.getKrb5Location())) {
            kerberosConfig.setConfigMode(2);
            return;
        }
        throw new HttpRuntimeException("Kerberos set check failed: \n1. Principal and Krb5Location and Keytab must been setted. \n or \n 2.LoginConfig and Krb5Location must be setted.");
    }
}

