/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.kerberos.serverrealm;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.security.auth.Subject;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.kerberos.serverrealm.ServerRealmKerberosUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRealmClientHelper {
    private Logger logger = LoggerFactory.getLogger(ServerRealmClientHelper.class);
    private String cookieNow;
    private Object cookieLock = new Object();
    private long tokenValidityPeriod;
    private long tokenWillExpireTime;
    private long createSTTime;
    private ServerRealmKerberosUtil serverRealmKerberosUtil;

    public ServerRealmClientHelper(ClientConfiguration clientConfiguration) {
        this.serverRealmKerberosUtil = new ServerRealmKerberosUtil(clientConfiguration);
    }

    public void authenticate() {
        this.serverRealmKerberosUtil.authenticate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCookie() {
        Object object = this.cookieLock;
        synchronized (object) {
            return this.cookieNow;
        }
    }

    public Subject getSubject() {
        return this.serverRealmKerberosUtil.getSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCookie(String cookie) {
        Object object = this.cookieLock;
        synchronized (object) {
            this.cookieNow = cookie;
        }
    }

    public void close() {
        this.serverRealmKerberosUtil.close();
    }

    private long getTokenExpireTime(String cookie) {
        long expireTime;
        block6: {
            expireTime = -1L;
            if (null == cookie) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Cookie is null.");
                }
                return expireTime;
            }
            String[] cookieSplit = cookie.split("&e=");
            if (cookieSplit.length < 2) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Cookie format is wrong.");
                }
                return expireTime;
            }
            try {
                expireTime = Long.parseLong(cookieSplit[1].split("&s")[0]);
            }
            catch (Exception exception) {
                if (!this.logger.isErrorEnabled()) break block6;
                this.logger.error("Cookie format is wrong,", (Throwable)exception);
            }
        }
        return expireTime;
    }

    public void setCookie(HttpResponse response) {
        String cookie;
        Header header = response.getFirstHeader("set-cookie");
        String string = cookie = header == null ? null : header.getValue();
        if (cookie != null && !cookie.isEmpty()) {
            this.tokenWillExpireTime = this.getTokenExpireTime(cookie);
            if (System.currentTimeMillis() < this.tokenWillExpireTime - 30000L) {
                this.setCookie(cookie);
            }
            this.tokenValidityPeriod = this.tokenWillExpireTime - this.createSTTime;
        }
    }

    private boolean tokenWillExpire() {
        if (this.tokenValidityPeriod > 0L && this.tokenWillExpireTime > 0L && this.tokenWillExpireTime > System.currentTimeMillis()) {
            boolean tokenExpire;
            double leftTime = (double)this.tokenValidityPeriod * 0.25;
            double tokenLeftTime = 7200000.0 > leftTime ? 7200000.0 : leftTime;
            boolean bl = tokenExpire = (double)(this.tokenWillExpireTime - System.currentTimeMillis()) < tokenLeftTime;
            if (tokenExpire && this.logger.isDebugEnabled()) {
                this.logger.debug("Token will expire.");
            }
            return tokenExpire;
        }
        return true;
    }

    public void addSecurityHeaders(HttpMessage abstractHttpMessage) {
        String cookieNow = this.getCookie();
        if (cookieNow != null && !this.tokenWillExpire()) {
            abstractHttpMessage.addHeader("Authorization", "Negotiate ");
            abstractHttpMessage.addHeader("cookie", cookieNow);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Success to add securityToken and cookie in request header.");
            }
        } else {
            String tokenNew = this.getNewToken();
            abstractHttpMessage.removeHeaders("Authorization");
            abstractHttpMessage.removeHeaders("cookie");
            abstractHttpMessage.addHeader("Authorization", "Negotiate " + tokenNew);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Success to add new securityToken in request header.");
            }
        }
    }

    private String getNewToken() {
        byte[] tokenN = this.serverRealmKerberosUtil.initiateSecurityContext(this.serverRealmKerberosUtil.getSubject(), this.serverRealmKerberosUtil.getServerRealm());
        for (int times = 0; null == tokenN && times < 3; ++times) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("InitiateSecurityContext again.");
            }
            tokenN = this.serverRealmKerberosUtil.initiateSecurityContext(this.serverRealmKerberosUtil.getSubject(), this.serverRealmKerberosUtil.getServerRealm());
        }
        if (null == tokenN) {
            throw new IllegalArgumentException("Get security token failed.");
        }
        this.createSTTime = System.currentTimeMillis();
        return new String(Base64.getEncoder().encode(tokenN), StandardCharsets.UTF_8);
    }
}

