/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheck
implements Runnable {
    private final List<HttpAddress> esAddresses;
    private static final Logger logger = LoggerFactory.getLogger(HealthCheck.class);
    private long checkInterval = 5000L;
    private List<HCRunable> checkThreads;
    private final String poolName;
    private final String healthPoolName;

    public HealthCheck(String poolName, List<HttpAddress> esAddresses, long checkInterval) {
        this.esAddresses = esAddresses;
        this.checkInterval = checkInterval;
        this.poolName = poolName;
        this.healthPoolName = ClientConfiguration.getHealthPoolName(poolName);
    }

    public void stopCheck() {
        HCRunable t = null;
        for (int i = 0; i < this.checkThreads.size(); ++i) {
            t = this.checkThreads.get(i);
            t.stopRun();
        }
    }

    public void checkNewAddresses(List<HttpAddress> addresses) {
        HCRunable t = null;
        for (int i = 0; i < addresses.size(); ++i) {
            HttpAddress address = addresses.get(i);
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
    }

    @Override
    public void run() {
        Iterator<HttpAddress> iterable = this.esAddresses.iterator();
        this.checkThreads = new ArrayList<HCRunable>();
        HCRunable t = null;
        HttpAddress address = null;
        while (iterable.hasNext()) {
            address = iterable.next();
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
    }

    public void addNewAddress(List<HttpAddress> addresses) {
        Iterator<HttpAddress> iterable = addresses.iterator();
        HCRunable t = null;
        HttpAddress address = null;
        while (iterable.hasNext()) {
            address = iterable.next();
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
    }

    class HCRunable
    extends Thread {
        HttpAddress address;
        boolean stop;

        public HCRunable(HttpAddress address) {
            super("Http pool[" + HealthCheck.this.poolName + "] server[" + address.toString() + "] health check");
            this.stop = false;
            address.setHealthCheck(this);
            this.address = address;
            this.setDaemon(true);
        }

        public synchronized void stopRun() {
            if (this.stop) {
                return;
            }
            this.stop = true;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                HCRunable e4;
                if (this.address.failedCheck()) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Check downed Http pool[" + HealthCheck.this.poolName + "] server[" + this.address.toString() + "] status.");
                        }
                        HttpRequestUtil.httpGet(HealthCheck.this.healthPoolName, this.address.getHealthPath(), null, new ResponseHandler<Void>(){

                            public Void handleResponse(HttpResponse response) throws IOException {
                                int status = response.getStatusLine().getStatusCode();
                                if (ResponseUtil.isHttpStatusOK(status)) {
                                    if (logger.isInfoEnabled()) {
                                        logger.info("Downed Http pool[" + HealthCheck.this.poolName + "] server[" + HCRunable.this.address.toString() + "] recovered to normal server.");
                                    }
                                    HCRunable.this.address.onlySetStatus(0);
                                } else {
                                    HCRunable.this.address.onlySetStatus(1);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e2) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Down Http  pool[" + HealthCheck.this.poolName + "] Server health check use [" + this.address.getHealthPath() + "] failed:" + " Http server[" + this.address.toString() + "] is down.");
                        }
                        this.address.onlySetStatus(1);
                    }
                    if (this.stop) break;
                    if (this.address.failedCheck()) {
                        try {
                            HCRunable.sleep(HealthCheck.this.checkInterval);
                            continue;
                        }
                        catch (InterruptedException e3) {
                            break;
                        }
                    }
                    try {
                        e4 = this;
                        synchronized (e4) {
                            this.wait();
                            continue;
                        }
                    }
                    catch (InterruptedException e4) {
                        break;
                    }
                }
                try {
                    e4 = this;
                    synchronized (e4) {
                        this.wait();
                    }
                }
                catch (InterruptedException e5) {
                    break;
                }
            }
        }
    }
}

