/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.util;

import com.frameworkset.common.poolman.management.BaseTableManager;
import com.frameworkset.common.poolman.management.PoolManBootstrap;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.common.poolman.util.PoolManager;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.common.poolman.util.TempConf;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.transaction.TXDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLManager
extends PoolManager {
    private static Logger log = LoggerFactory.getLogger(SQLManager.class);
    private static SQLManager myself = new SQLManager();
    private String configFile = "poolman.xml";

    public static void destroy() {
        if (myself != null) {
            myself.destroyPools();
            myself = null;
        }
    }

    public static SQLManager getInstance() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLManager getInstance(String confFile) {
        if (confFile.equals(myself.getConfigFile())) return myself;
        Class<SQLManager> clazz = SQLManager.class;
        synchronized (SQLManager.class) {
            if (confFile.equals(myself.getConfigFile())) return myself;
            myself = null;
            myself = new SQLManager();
            myself.setConfigFile(confFile);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return myself;
        }
    }

    @Override
    public List<String> getAllPoolNames() {
        this.assertLoaded();
        return super.getAllPoolNames();
    }

    public List<String> getAllPoolNamesIfExist() {
        return super.getAllPoolNames();
    }

    private SQLManager() {
    }

    public JDBCPool createPool(JDBCPoolMetaData metad) {
        try {
            JDBCPool pool = this.getPoolIfExist(metad.getDbname());
            if (pool != null) {
                pool.stopPool();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JDBCPool jpool = new JDBCPool(metad);
        this.addPool(metad.getName(), jpool);
        return jpool;
    }

    public void setConfigFile(String filename) {
        this.configFile = filename;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assertLoaded() {
        try {
            if (this.pools.size() >= 1) return;
            Class<SQLManager> clazz = SQLManager.class;
            synchronized (SQLManager.class) {
                if (this.pools.size() >= 1) return;
                new PoolManBootstrap(this.configFile).start();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal Error while attempting  to Configure PoolMan: " + e.getMessage() + " " + e.toString());
        }
    }

    public static DataSource getDatasourceByDBName(String dbname) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbname);
        if (pool != null) {
            return pool.getDataSource();
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25\uff1a" + dbname + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6poolman.xml\u4e2d\u662f\u5426\u914d\u7f6e\u4e86\u76f8\u5e94\u7684\u6570\u636e\u6e90\u3002");
    }

    public static DataSource getDatasource() {
        JDBCPool pool = SQLManager.getInstance().getPool(null);
        if (pool != null) {
            return pool.getDataSource();
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6poolman.xml\u4e2d\u662f\u5426\u914d\u7f6e\u4e86\u76f8\u5e94\u7684\u6570\u636e\u6e90\u3002");
    }

    public static DataSource getTXDatasourceByDBName(String dbname) {
        JDBCPool pool = SQLManager.getInstance().getPool(dbname);
        if (pool != null) {
            DataSource datasource = pool.getDataSource();
            if (!(datasource instanceof TXDataSource)) {
                return new TXDataSource(pool.getDataSource(), pool);
            }
            return datasource;
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25\uff1a" + dbname + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6poolman.xml\u4e2d\u662f\u5426\u914d\u7f6e\u4e86\u76f8\u5e94\u7684\u6570\u636e\u6e90\u3002");
    }

    public static DataSource getTXDatasource() {
        JDBCPool pool = SQLManager.getInstance().getPool(null);
        if (pool != null) {
            DataSource datasource = pool.getDataSource();
            if (!(datasource instanceof TXDataSource)) {
                return new TXDataSource(pool.getDataSource(), pool);
            }
            return datasource;
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6poolman.xml\u4e2d\u662f\u5426\u914d\u7f6e\u4e86\u76f8\u5e94\u7684\u6570\u636e\u6e90\u3002");
    }

    public static DataSource getTXDatasource(DataSource ds) {
        if (ds != null) {
            if (ds instanceof TXDataSource) {
                return ds;
            }
            return new TXDataSource(ds, null);
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25\uff1ads is null");
    }

    @Override
    public JDBCPool getPool(String name) {
        return this.getPool(name, true);
    }

    public JDBCPool getPool(String name, boolean needcheckStart) {
        if (needcheckStart) {
            this.assertLoaded();
        }
        return super.getPool(name);
    }

    @Override
    public JDBCPool getPoolIfExist(String name) {
        if (name == null) {
            name = this.getDefaultDBNameIfExist();
        }
        return super.getPoolIfExist(name);
    }

    public JDBCPool getPoolByJNDIName(String name, boolean needcheckStart) {
        if (needcheckStart) {
            this.assertLoaded();
        }
        for (Map.Entry e : this.pools.entrySet()) {
            JDBCPool jpool = (JDBCPool)e.getValue();
            String name_ = jpool.getJDBCPoolMetadata().getJNDIName();
            if (name_ == null || !name_.equals(name)) continue;
            return jpool;
        }
        String errorString = "pool with jndiname[" + name + "] does not exist or this is container datasource.  Please check your " + "poolman.xml";
        log.warn(errorString);
        return null;
    }

    public JDBCPool getPoolByJNDIName(String name) {
        return this.getPoolByJNDIName(name, true);
    }

    public void checkCredentials(String dbname, String user, String passwd) throws SQLException {
        this.assertLoaded();
        JDBCPool pool = this.getPool(dbname);
        pool.checkCredentials(user, passwd);
    }

    public Connection requestConnection() throws SQLException {
        this.assertLoaded();
        try {
            JDBCPool pool = this.defaultpool;
            return pool.requestConnection();
        }
        catch (NullPointerException ne) {
            throw new SQLException("No default pool! Check your poolman.xml");
        }
    }

    public void returnConnection(Connection con) {
        try {
            con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Connection requestConnection(String dbname) throws SQLException {
        if (dbname == null || dbname.equals("")) {
            return this.requestConnection();
        }
        this.assertLoaded();
        try {
            JDBCPool pool = (JDBCPool)this.pools.get(dbname);
            return pool.requestConnection();
        }
        catch (NullPointerException ne) {
            throw new SQLException("No pool named " + dbname + "! Check your poolman.xml\n** DEBUG: If the StackTrace contains an InstanceAlreadyExistsException, then you have  encountered a ClassLoader linkage problem.  Please email yin-bp@163.com **");
        }
    }

    public Map getPools() {
        return this.pools;
    }

    public void returnConnection(String dbname, Connection con) {
        this.returnConnection(con);
    }

    public static void closeResources(Statement statement, ResultSet resultSet) {
        SQLManager.closeResultSet(resultSet);
        SQLManager.closeStatement(statement);
    }

    public void collectResources(Statement s, ResultSet r) {
        SQLManager.closeResources(s, r);
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            rs = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getDefaultDBName() {
        this.assertLoaded();
        if (this.defaultpool == null) {
            throw new NullPointerException("\u83b7\u53d6\u9ed8\u8ba4\u6570\u636e\u6e90\u540d\u79f0\u5931\u8d25\uff1a\u8bf7\u786e\u4fdd\u6570\u636e\u6e90\u6b63\u5e38\u542f\u52a8\uff0c\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u914d\u7f6e\u6b63\u786e.");
        }
        return this.defaultpool.getInterceptor().getDefaultDBName();
    }

    public String getDefaultDBNameIfExist() {
        if (this.defaultpool == null) {
            return null;
        }
        return this.defaultpool.getInterceptor().getDefaultDBName();
    }

    public DB getDBAdapter() {
        return this.getDBAdapter(null);
    }

    public DB getDBAdapter(String dbName) {
        return this.getPool(dbName).getDbAdapter();
    }

    public static String getRealDBNameFromExternalDBName(String externalName) {
        if (externalName == null) {
            return null;
        }
        JDBCPool pool = SQLManager.getInstance().getPool(externalName);
        if (pool == null) {
            return externalName;
        }
        if (!pool.isExternal()) {
            return pool.getDBName();
        }
        String dbname = pool.getExternalDBName();
        if (dbname == null) {
            return pool.getDBName();
        }
        return SQLManager.getRealDBNameFromExternalDBName(dbname);
    }

    public static String getRealDBNameFromExternalDBNameIfExist(String externalName) {
        JDBCPool pool = SQLManager.getInstance().getPoolIfExist(externalName);
        if (pool == null) {
            return externalName;
        }
        if (!pool.isExternal()) {
            return pool.getDBName();
        }
        String dbname = pool.getExternalDBName();
        if (dbname == null) {
            return pool.getDBName();
        }
        return SQLManager.getRealDBNameFromExternalDBNameIfExist(dbname);
    }

    public void stopPool(String dbname) throws Exception {
        JDBCPool pool = this.getPoolIfExist(dbname);
        if (pool != null) {
            if (!pool.isExternal() || pool.getExternalDBName() == null) {
                pool.stopPool();
            } else {
                log.warn("\u5ffd\u7565\u5916\u90e8\u6570\u636e\u6e90[" + dbname + "]\u7684\u505c\u6b62\u64cd\u4f5c");
            }
        }
        BaseTableManager.removePrimaryKeyCache(dbname);
    }

    public String statusCheck(String dbname) {
        JDBCPool pool = this.getPoolIfExist(dbname);
        if (pool != null) {
            return pool.statusChecker();
        }
        return "unloaded";
    }

    public static void startPool(String poolname) throws Exception {
        JDBCPool pool = SQLUtil.getSQLManager().getPoolIfExist(poolname);
        if (pool != null && pool.getStatus().equals("start")) {
            log.warn("\u8fde\u63a5\u6c60[" + pool.getDBName() + "]\u5df2\u7ecf\u542f\u52a8\u3002\u65e0\u9700\u518d\u542f\u52a8,\u6216\u8005\u8bf7\u505c\u6b62\u540e\u518d\u542f\u52a8.");
            return;
        }
        PoolManBootstrap boot = new PoolManBootstrap();
        boot.startDB(poolname);
    }

    public static void startRealDBNameFromExternalDBName(String dbname) throws Exception {
        JDBCPool pool = SQLUtil.getSQLManager().getPoolIfExist(dbname);
        if (pool != null) {
            if (pool.isExternal() && pool.getExternalDBName() != null) {
                SQLManager.startRealDBNameFromExternalDBName(pool.getExternalDBName());
            }
            if (!pool.getStatus().equals("start")) {
                PoolManBootstrap boot = new PoolManBootstrap();
                boot.startDB(dbname);
            }
            return;
        }
        PoolManBootstrap boot = new PoolManBootstrap();
        boot.startDB(dbname);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String validationQuery) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, readOnly, validationQuery, false);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String validationQuery, int fetchsize) {
        TempConf tempConf = new TempConf();
        tempConf.setPoolname(poolname);
        tempConf.setDriver(driver);
        tempConf.setJdbcurl(jdbcurl);
        tempConf.setUsername(username);
        tempConf.setPassword(password);
        tempConf.setValidationQuery(validationQuery);
        tempConf.setJndiName("jndi-" + poolname);
        tempConf.setInitialConnections(10);
        tempConf.setMinimumSize(10);
        tempConf.setMaximumSize(20);
        tempConf.setUsepool(true);
        tempConf.setExternal(false);
        tempConf.setEncryptdbinfo(false);
        tempConf.setShowsql(false);
        tempConf.setQueryfetchsize(fetchsize);
        SQLManager.startPool(tempConf);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String validationQuery) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, validationQuery, 0);
    }

    public static void startNoPool(String poolname, String driver, String jdbcurl, String username, String password, String validationQuery) {
        SQLManager.startNoPool(poolname, driver, jdbcurl, username, password, validationQuery, 0);
    }

    public static void startNoPool(String poolname, String driver, String jdbcurl, String username, String password, String validationQuery, int fetchsize) {
        TempConf tempConf = new TempConf();
        tempConf.setPoolname(poolname);
        tempConf.setDriver(driver);
        tempConf.setJdbcurl(jdbcurl);
        tempConf.setUsername(username);
        tempConf.setPassword(password);
        tempConf.setReadOnly(null);
        tempConf.setValidationQuery(validationQuery);
        tempConf.setJndiName("jndi-" + poolname);
        tempConf.setInitialConnections(10);
        tempConf.setMinimumSize(10);
        tempConf.setMaximumSize(20);
        tempConf.setUsepool(false);
        tempConf.setExternal(false);
        tempConf.setExternaljndiName(null);
        tempConf.setShowsql(false);
        tempConf.setEncryptdbinfo(false);
        tempConf.setQueryfetchsize(fetchsize);
        SQLManager.startPool(tempConf);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String validationQuery, boolean encryptdbinfo) {
        TempConf tempConf = new TempConf();
        tempConf.setPoolname(poolname);
        tempConf.setDriver(driver);
        tempConf.setJdbcurl(jdbcurl);
        tempConf.setUsername(username);
        tempConf.setPassword(password);
        tempConf.setReadOnly(readOnly);
        tempConf.setValidationQuery(validationQuery);
        tempConf.setJndiName("jndi-" + poolname);
        tempConf.setInitialConnections(10);
        tempConf.setMinimumSize(10);
        tempConf.setMaximumSize(20);
        tempConf.setUsepool(false);
        tempConf.setExternal(false);
        tempConf.setExternaljndiName(null);
        tempConf.setShowsql(false);
        tempConf.setEncryptdbinfo(encryptdbinfo);
        tempConf.setQueryfetchsize(0);
        SQLManager.startPool(tempConf);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String txIsolationLevel, String validationQuery, String jndiName, int initialConnections, int minimumSize, int maximumSize, boolean usepool, boolean external, String externaljndiName, boolean showsql, boolean encryptdbinfo) {
        TempConf tempConf = new TempConf();
        tempConf.setPoolname(poolname);
        tempConf.setDriver(driver);
        tempConf.setJdbcurl(jdbcurl);
        tempConf.setUsername(username);
        tempConf.setPassword(password);
        tempConf.setReadOnly(readOnly);
        tempConf.setTxIsolationLevel(txIsolationLevel);
        tempConf.setValidationQuery(validationQuery);
        tempConf.setJndiName(jndiName);
        tempConf.setInitialConnections(initialConnections);
        tempConf.setMinimumSize(minimumSize);
        tempConf.setMaximumSize(maximumSize);
        tempConf.setUsepool(usepool);
        tempConf.setExternal(external);
        tempConf.setExternaljndiName(externaljndiName);
        tempConf.setShowsql(showsql);
        tempConf.setEncryptdbinfo(encryptdbinfo);
        tempConf.setQueryfetchsize(0);
        SQLManager.startPool(tempConf);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String txIsolationLevel, String validationQuery, String jndiName, int initialConnections, int minimumSize, int maximumSize, boolean usepool, boolean external, String externaljndiName, boolean showsql, boolean encryptdbinfo, int queryfetchsize) {
        JDBCPool pool = SQLUtil.getSQLManager().getPoolIfExist(poolname);
        if (pool != null && pool.getStatus().equals("start")) {
            log.debug("\u8fde\u63a5\u6c60[" + poolname + "]\u5df2\u7ecf\u542f\u52a8\u3002\u65e0\u9700\u518d\u542f\u52a8,\u6216\u8005\u8bf7\u505c\u6b62\u540e\u518d\u542f\u52a8.");
            return;
        }
        TempConf temConf = new TempConf();
        temConf.setPoolname(poolname);
        temConf.setDriver(driver);
        temConf.setJdbcurl(jdbcurl);
        temConf.setUsername(username);
        temConf.setPassword(password);
        temConf.setReadOnly(readOnly);
        temConf.setTxIsolationLevel(txIsolationLevel);
        temConf.setValidationQuery(validationQuery);
        temConf.setJndiName(jndiName);
        temConf.setInitialConnections(initialConnections);
        temConf.setMinimumSize(minimumSize);
        temConf.setMaximumSize(maximumSize);
        temConf.setUsepool(usepool);
        temConf.setExternal(external);
        temConf.setExternaljndiName(externaljndiName);
        temConf.setShowsql(showsql);
        temConf.setEncryptdbinfo(encryptdbinfo);
        temConf.setQueryfetchsize(queryfetchsize);
        SQLManager.startPool(temConf);
    }

    public static void startPool(TempConf temConf) {
        JDBCPool pool = SQLUtil.getSQLManager().getPoolIfExist(temConf.getPoolname());
        if (pool != null && pool.getStatus().equals("start")) {
            log.debug("\u8fde\u63a5\u6c60[" + temConf.getPoolname() + "]\u5df2\u7ecf\u542f\u52a8\u3002\u65e0\u9700\u518d\u542f\u52a8,\u6216\u8005\u8bf7\u505c\u6b62\u540e\u518d\u542f\u52a8.");
            return;
        }
        if (temConf.getTxIsolationLevel() == null) {
            temConf.setTxIsolationLevel("");
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("dbname", temConf.getPoolname());
        if (temConf.getJndiName() != null && !temConf.getJndiName().equals("")) {
            values.put("dbname_datasource_jndiname", temConf.getJndiName());
            values.put("enablejta", "true");
        } else {
            values.put("dbname_datasource_jndiname", "");
        }
        values.put("driver", temConf.getDriver());
        values.put("jdbcurl", temConf.getJdbcurl());
        if (temConf.getUsername() == null) {
            values.put("username", "");
        } else {
            values.put("username", temConf.getUsername());
        }
        if (temConf.getPassword() == null) {
            values.put("password", "");
        } else {
            values.put("password", temConf.getPassword());
        }
        boolean cachequerymetadata = true;
        values.put("cachequerymetadata", cachequerymetadata + "");
        if (temConf.getReadOnly() == null) {
            values.put("readOnly", "");
        } else {
            values.put("readOnly", temConf.getReadOnly());
        }
        if (temConf.getTxIsolationLevel() != null) {
            values.put("txIsolationLevel", temConf.getTxIsolationLevel());
        } else {
            values.put("txIsolationLevel", "");
        }
        if (temConf.getValidationQuery() != null) {
            values.put("validationQuery", temConf.getValidationQuery());
        } else {
            values.put("validationQuery", "");
        }
        if (temConf.getInitialConnections() >= 0) {
            values.put("initialConnections", "" + temConf.getInitialConnections());
        } else {
            values.put("initialConnections", "2");
        }
        if (temConf.getMinimumSize() >= 0) {
            values.put("minimumSize", "" + temConf.getMinimumSize());
        } else {
            values.put("minimumSize", "2");
        }
        if (temConf.getMaximumSize() > 0) {
            values.put("maximumSize", "" + temConf.getMaximumSize());
        } else {
            values.put("maximumSize", "10");
        }
        int maxWait = 60;
        if (maxWait > 0) {
            values.put("maxWait", "" + (maxWait *= 1000));
        } else {
            values.put("maxWait", "60000");
        }
        boolean maximumSoft = false;
        values.put("maximumSoft", "" + maximumSoft);
        values.put("usepool", temConf.isUsepool() + "");
        values.put("external", temConf.isExternal() + "");
        values.put("showsql", temConf.isShowsql() + "");
        values.put("encryptdbinfo", temConf.isEncryptdbinfo() + "");
        boolean testWhileidle = true;
        values.put("testWhileidle", testWhileidle + "");
        int shrinkBy = 5;
        values.put("shrinkBy", shrinkBy + "");
        int connectionTimeout = 36000000;
        values.put("connectionTimeout", connectionTimeout + "");
        int skimmerFrequency = 180000;
        values.put("skimmerFrequency", skimmerFrequency + "");
        boolean logAbandoned = true;
        values.put("logAbandoned", logAbandoned + "");
        int userTimeout = 300;
        values.put("userTimeout", userTimeout + "");
        boolean removeAbandoned = false;
        values.put("removeAbandoned", removeAbandoned + "");
        if (temConf.getExternaljndiName() != null && !temConf.getExternaljndiName().equals("")) {
            values.put("externaljndiName", temConf.getExternaljndiName());
        }
        values.put("queryfetchsize", temConf.getQueryfetchsize());
        PoolManBootstrap.startFromTemplte(values);
    }

    public static void startPool(String poolname, String driver, String jdbcurl, String username, String password, String readOnly, String txIsolationLevel, String validationQuery, String jndiName, int initialConnections, int minimumSize, int maximumSize, boolean usepool, boolean external, String externaljndiName, boolean showsql) {
        SQLManager.startPool(poolname, driver, jdbcurl, username, password, readOnly, txIsolationLevel, validationQuery, jndiName, initialConnections, minimumSize, maximumSize, usepool, external, externaljndiName, showsql, false);
    }

    public JDBCPoolMetaData getJDBCPoolMetaData(String dbname) {
        try {
            JDBCPool pool = this.getPool(dbname);
            if (pool == null) {
                return null;
            }
            return pool.getJDBCPoolMetadata();
        }
        catch (Exception e) {
            return null;
        }
    }
}

