/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2;

import com.frameworkset.commons.dbcp2.DelegatingConnection;
import com.frameworkset.commons.dbcp2.PoolableConnection;
import com.frameworkset.commons.dbcp2.PoolableConnectionFactory;
import com.frameworkset.commons.dbcp2.Utils;
import com.frameworkset.commons.pool2.ObjectPool;
import com.frameworkset.commons.pool2.impl.GenericObjectPool;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingDataSource<C extends Connection>
implements DataSource {
    private static final Logger log = LoggerFactory.getLogger(PoolingDataSource.class);
    private boolean accessToUnderlyingConnectionAllowed = false;
    private PrintWriter _logWriter = null;
    private final ObjectPool<C> _pool;

    public PoolingDataSource(ObjectPool<C> pool) {
        if (null == pool) {
            throw new NullPointerException("Pool must not be null.");
        }
        this._pool = pool;
        if (this._pool instanceof GenericObjectPool) {
            PoolableConnectionFactory pcf = (PoolableConnectionFactory)((GenericObjectPool)this._pool).getFactory();
            if (pcf == null) {
                throw new NullPointerException("PoolableConnectionFactory must not be null.");
            }
            if (pcf.getPool() != this._pool) {
                log.warn(Utils.getMessage("poolingDataSource.factoryConfig"));
                ObjectPool<PoolableConnection> p = this._pool;
                pcf.setPool(p);
            }
        }
    }

    public void close() throws Exception {
        try {
            this._pool.close();
        }
        catch (RuntimeException rte) {
            throw new RuntimeException(Utils.getMessage("pool.close.fail"), rte);
        }
        catch (Exception e) {
            throw new SQLException(Utils.getMessage("pool.close.fail"), e);
        }
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("PoolingDataSource is not a wrapper.");
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Connection conn = (Connection)this._pool.borrowObject();
            if (conn == null) {
                return null;
            }
            return new PoolGuardConnectionWrapper(this, conn);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (NoSuchElementException e) {
            throw new SQLException("Cannot get a connection, pool error " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Cannot get a connection, general error", e);
        }
    }

    @Override
    public Connection getConnection(String uname, String passwd) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this._logWriter = out;
    }

    protected ObjectPool<C> getPool() {
        return this._pool;
    }

    private static class PoolGuardConnectionWrapper<D extends Connection>
    extends DelegatingConnection<D> {
        final /* synthetic */ PoolingDataSource this$0;

        PoolGuardConnectionWrapper(D delegate) {
            this.this$0 = var1_1;
            super(delegate);
        }

        @Override
        public D getDelegate() {
            if (this.this$0.isAccessToUnderlyingConnectionAllowed()) {
                return (D)super.getDelegate();
            }
            return null;
        }

        @Override
        public Connection getInnermostDelegate() {
            if (this.this$0.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }

        @Override
        public void close() throws SQLException {
            if (this.getDelegateInternal() != null) {
                super.close();
                super.setDelegate(null);
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            if (this.getDelegateInternal() == null) {
                return true;
            }
            return super.isClosed();
        }
    }
}

