/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.listener;

import com.frameworkset.orm.transaction.TransactionManager;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BSServletRequestListener
implements ServletRequestListener {
    private static final Logger log = LoggerFactory.getLogger(BSServletRequestListener.class);

    public void requestDestroyed(ServletRequestEvent requestEvent) {
        if (requestEvent.getServletRequest() instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
            String uri = request.getRequestURI();
            boolean state = TransactionManager.destroyTransaction();
            if (state) {
                log.warn("A DB transaction leaked in Page [" + uri + "] has been forcibly destoried. ");
            }
        }
    }

    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (requestEvent.getServletRequest() instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
            String uri = request.getRequestURI();
            boolean state = TransactionManager.destroyTransaction();
            if (state) {
                log.warn("A DB transaction leaked before Page [" + uri + "] has been forcibly destoried. ");
            }
        }
    }
}

