/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.util;

import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.interceptor.DummyInterceptor;
import com.frameworkset.common.poolman.interceptor.InterceptorInf;
import com.frameworkset.common.poolman.jndi.ContextUtil;
import com.frameworkset.common.poolman.jndi.DummyContextFactory;
import com.frameworkset.common.poolman.monitor.AbandonedTraceExt;
import com.frameworkset.common.poolman.security.DBInfoEncrypt;
import com.frameworkset.common.poolman.sql.BBossUuidGenerator;
import com.frameworkset.common.poolman.sql.ColumnMetaData;
import com.frameworkset.common.poolman.sql.ForeignKeyMetaData;
import com.frameworkset.common.poolman.sql.IdGenerator;
import com.frameworkset.common.poolman.sql.PoolManDataSource;
import com.frameworkset.common.poolman.sql.PrimaryKeyMetaData;
import com.frameworkset.common.poolman.sql.TableMetaData;
import com.frameworkset.common.poolman.util.DatasourceUtil;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.commons.dbcp.BasicDataSourceFactory;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.adapter.DBFactory;
import com.frameworkset.orm.transaction.JDBCTransaction;
import com.frameworkset.orm.transaction.TXDataSource;
import com.frameworkset.orm.transaction.TransactionManager;
import com.frameworkset.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPool {
    private static Logger log = LoggerFactory.getLogger(JDBCPool.class);
    public static String TABLE_TYPE_VIEW = "VIEW";
    public static String TABLE_TYPE_TABLE = "TABLE";
    public static String TABLE_TYPE_ALL = "ALL";
    private DataSource datasource;
    private boolean deployedDataSource;
    private JDBCPoolMetaData info;
    private long startTime;
    private long stopTime;
    private Context ctx = null;
    private Context dummyctx = null;
    private boolean initcontexted = false;
    private IdGenerator idGenerator;
    private Map tableMetaDatasindexByTablename = new ConcurrentHashMap();
    private Set tableMetaDatas = new TreeSet();
    public static final InterceptorInf defaultInterceptor = new DummyInterceptor();
    private InterceptorInf interceptor = defaultInterceptor;
    public static final String defaultInterceptor_s = "com.frameworkset.common.poolman.interceptor.DummyInterceptor";
    private DB dbAdapter;
    private String status = "unknown";
    private String externalDBName = null;
    private boolean inited = false;

    private static Context buildContext(JDBCPoolMetaData meta) {
        Context ctx = null;
        if (meta != null && (meta.getJNDIName() == null || meta.getJNDIName().equals("")) && (meta.getExternaljndiName() == null || meta.getExternaljndiName().equals(""))) {
            return null;
        }
        if (meta != null && meta.getJndiclass() != null) {
            Hashtable<String, String> environment = new Hashtable<String, String>();
            environment.put("java.naming.factory.initial", meta.getJndiclass());
            if (meta.getJndiurl() != null) {
                environment.put("java.naming.provider.url", meta.getJndiurl());
            }
            if (meta.getJndiuser() != null) {
                environment.put("java.naming.security.principal", meta.getJndiuser());
            }
            if (meta.getJndipassword() != null) {
                environment.put("java.naming.security.credentials", meta.getJndipassword());
            }
            ctx = ContextUtil.finaContext(environment, JDBCPool.class.getClassLoader());
        } else {
            ctx = ContextUtil.finaContext(null, JDBCPool.class.getClassLoader());
        }
        return ctx;
    }

    private void initctx(JDBCPoolMetaData meta) {
        if (this.ctx == null) {
            this.ctx = JDBCPool.buildContext(meta);
            if (meta.getJNDIName() != null && !meta.getJNDIName().equals("")) {
                try {
                    this.dummyctx = new DummyContextFactory().getInitialContext((Hashtable)null);
                }
                catch (NamingException e) {
                    log.info(e.getMessage());
                }
            }
            this.initcontexted = true;
        }
    }

    public TableMetaData getTableMetaData(String tableName) {
        return this.getTableMetaData(null, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetaData getTableMetaData(Connection con, String tableName) {
        if (this.externalDBName == null) {
            TableMetaData table = (TableMetaData)this.tableMetaDatasindexByTablename.get(tableName.toLowerCase());
            if (table == null && this.info.getLoadmetadata().equalsIgnoreCase("false")) {
                Map map = this.tableMetaDatasindexByTablename;
                synchronized (map) {
                    table = (TableMetaData)this.tableMetaDatasindexByTablename.get(tableName.toLowerCase());
                    if (table == null) {
                        table = this.getTableMetaDataFromDatabase(con, tableName);
                    }
                }
            }
            return table;
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getTableMetaData(con, tableName);
    }

    public ColumnMetaData getColumnMetaData(Connection con, String tableName, String columnName) {
        TableMetaData table = this.getTableMetaData(con, tableName);
        if (table != null) {
            if (columnName == null || columnName.equals("")) {
                return null;
            }
            return table.getColumnMetaData(columnName);
        }
        return null;
    }

    public ColumnMetaData getColumnMetaData(String tableName, String columnName) {
        return this.getColumnMetaData(null, tableName, columnName);
    }

    public Set getColumnMetaDatas(String tableName) {
        return this.getColumnMetaDatas(null, tableName);
    }

    public Set getColumnMetaDatas(Connection con, String tableName) {
        TableMetaData table = this.getTableMetaData(con, tableName);
        if (table != null) {
            return table.getColumns();
        }
        return null;
    }

    public ForeignKeyMetaData getForeignKeyMetaData(String tableName, String columnName) {
        return this.getForeignKeyMetaData(null, tableName, columnName);
    }

    public ForeignKeyMetaData getForeignKeyMetaData(Connection con, String tableName, String columnName) {
        TableMetaData table = this.getTableMetaData(con, tableName);
        if (table != null) {
            return table.getForeignKeyMetaData(columnName);
        }
        return null;
    }

    public Set getForeignKeyMetaDatas(String tableName) {
        return this.getForeignKeyMetaDatas(null, tableName);
    }

    public Set getForeignKeyMetaDatas(Connection con, String tableName) {
        TableMetaData table = this.getTableMetaData(con, tableName);
        if (table != null) {
            return table.getForeignKeys();
        }
        return null;
    }

    public PrimaryKeyMetaData getPrimaryKeyMetaData(String tableName, String columnName) {
        return this.getPrimaryKeyMetaData(null, tableName, columnName);
    }

    public PrimaryKeyMetaData getPrimaryKeyMetaData(Connection con, String tableName, String columnName) {
        TableMetaData table = this.getTableMetaData(con, tableName);
        if (table != null) {
            return table.getPrimaryKeyMetaData(columnName);
        }
        return null;
    }

    public Set getPrimaryKeyMetaDatas(String tableName) {
        return this.getPrimaryKeyMetaDatas(null, tableName);
    }

    public Set getPrimaryKeyMetaDatas(Connection con, String tableName) {
        TableMetaData table = this.getTableMetaData(con, tableName);
        if (table != null) {
            return table.getPrimaryKeys();
        }
        return null;
    }

    private void _initAdaptor() {
        String dbtype = this.info.getDbtype();
        String driver = this.info.getDriver();
        if (dbtype == null) {
            try {
                log.debug("Init DBAdapter from driver:" + driver);
                this.dbAdapter = DBFactory.create(driver);
            }
            catch (InstantiationException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        } else {
            try {
                log.debug("Init DBAdapter from dbtype:" + dbtype);
                this.dbAdapter = DBFactory.create(dbtype);
            }
            catch (InstantiationException ex1) {
                log.error(ex1.getMessage(), (Throwable)ex1);
            }
        }
    }

    private void initDBAdapter() {
        if (!this.info.isExternal()) {
            this._initAdaptor();
        } else {
            String external = this.info.getExternaljndiName();
            JDBCPool ep = null;
            ep = DBUtil.getJDBCPoolByJNDIName(external, false);
            if (ep == null) {
                this._initAdaptor();
            } else {
                this.externalDBName = ep.getDBName();
                JDBCPool pool = SQLManager.getInstance().getPool(this.externalDBName, false);
                this.info.setExtenalInfo(pool.getJDBCPoolMetadata());
            }
        }
        this.info.setDbtype(this.getDbAdapter().getDBTYPE());
    }

    private Properties getProperties() {
        String TxIsolationLevel;
        Properties p = new Properties();
        p.setProperty("driverClassName", this.info.getDriver());
        DBInfoEncrypt dbInfoEncrypt = this.info.getDbInfoEncrypt();
        if (dbInfoEncrypt != null) {
            p.setProperty("url", dbInfoEncrypt.decryptDBUrl(this.info.getURL()));
        } else {
            p.setProperty("url", this.info.getURL());
        }
        if (this.info.getPassword() != null) {
            if (dbInfoEncrypt != null) {
                p.setProperty("password", dbInfoEncrypt.decryptDBPassword(this.info.getPassword()));
            } else {
                p.setProperty("password", this.info.getPassword());
            }
        }
        if (this.info.getUserName() != null) {
            if (dbInfoEncrypt != null) {
                p.setProperty("username", dbInfoEncrypt.decryptDBUser(this.info.getUserName()));
            } else {
                p.setProperty("username", this.info.getUserName());
            }
        }
        p.setProperty("maxActive", this.info.getMaximumSize() + "");
        p.setProperty("initialSize", this.info.getInitialConnections() + "");
        p.setProperty("maxIdle", this.info.getMaximumSize() + "");
        p.setProperty("minIdle", this.info.getMinimumSize() + "");
        p.setProperty("timeBetweenEvictionRunsMillis", this.info.getSkimmerFrequency() + "");
        p.setProperty("numTestsPerEvictionRun", this.info.getShrinkBy() + "");
        p.setProperty("minEvictableIdleTimeMillis", this.info.getConnectionTimeout() + "");
        p.setProperty("maxWait", this.info.getMaxWait());
        p.setProperty("removeAbandoned", this.info.getRemoveAbandoned());
        p.setProperty("removeAbandonedTimeout", this.info.getUserTimeout() + "");
        p.setProperty("testWhileIdle", this.info.isTestWhileidle() + "");
        p.setProperty("testOnBorrow", "true");
        if (this.info.getValidationQuery() != null && !this.info.getValidationQuery().equals("")) {
            p.setProperty("validationQuery", this.info.getValidationQuery());
        }
        p.setProperty("logAbandoned", this.info.isLogAbandoned() + "");
        p.setProperty("defaultAutoCommit", "true");
        if (this.info.isReadOnly() != null) {
            p.setProperty("defaultReadOnly", this.info.isReadOnly() + "");
        }
        if ((TxIsolationLevel = this.info.getTxIsolationLevel()) != null && !TxIsolationLevel.equals("")) {
            p.setProperty("defaultTransactionIsolation", TxIsolationLevel);
        }
        p.setProperty("poolPreparedStatements", this.info.isPoolPreparedStatements() + "");
        p.setProperty("maxOpenPreparedStatements", this.info.getMaxOpenPreparedStatements() + "");
        p.setProperty("usepool", this.info.isUsepool() + "");
        return p;
    }

    private void initPoolDatasource() throws Exception {
        DataSource _datasource = null;
        if (StringUtil.isEmpty((String)this.info.getDatasourceFile())) {
            Properties p = this.getProperties();
            _datasource = BasicDataSourceFactory.createDBCP2DataSource(p);
        } else {
            _datasource = DatasourceUtil.getDataSource(this.info.getDatasourceFile());
        }
        this.datasource = this.info.getJNDIName() != null && !this.info.getJNDIName().equals("") ? new PoolManDataSource(_datasource, this.info.getDbname(), this.info.getJNDIName()) : _datasource;
        if (this.info.isEnablejta()) {
            this.datasource = new TXDataSource(this.datasource, this);
        }
    }

    public void setUpCommonPool() throws Exception {
        if (!this.info.isExternal()) {
            this.initPoolDatasource();
        } else {
            try {
                DataSource _datasource;
                if (this.externalDBName == null && (_datasource = JDBCPool.find(this.info.getExternaljndiName(), this.info)) != null) {
                    this.datasource = this.info.getJNDIName() != null && !this.info.getJNDIName().equals("") ? new PoolManDataSource(_datasource, this.info.getDbname(), this.info.getJNDIName()) : _datasource;
                    if (this.info.isEnablejta() && !(_datasource instanceof TXDataSource)) {
                        this.datasource = new TXDataSource(this.datasource, this);
                    }
                }
            }
            catch (NamingException e) {
                log.warn("\u901a\u8fc7JNDI\u540d\u79f0[" + this.info.getExternaljndiName() + "]\u83b7\u53d6\u5916\u90e8\u6570\u636e\u6e90\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public DataSource find_(String jndiName) throws NamingException {
        DataSource _datasource;
        if (this.ctx == null && this.dummyctx == null) {
            return null;
        }
        DataSource dataSource = _datasource = this.ctx != null ? (DataSource)this.ctx.lookup(jndiName) : null;
        if (_datasource != null) {
            return _datasource;
        }
        if (this.dummyctx != null) {
            _datasource = (DataSource)this.dummyctx.lookup(jndiName);
        }
        return _datasource;
    }

    public static DataSource find(String jndiName, JDBCPoolMetaData meta) throws NamingException {
        Map pools = SQLManager.getInstance().getPools();
        if (pools != null && pools.size() > 0) {
            Iterator its = pools.entrySet().iterator();
            String name = ContextUtil.handleJndiName(jndiName);
            Object ctx = null;
            while (its.hasNext()) {
                try {
                    Map.Entry ent = its.next();
                    JDBCPool pool = (JDBCPool)ent.getValue();
                    DataSource _datasource = pool.find_(name);
                    if (_datasource == null) continue;
                    return _datasource;
                }
                catch (NamingException e) {
                    log.warn("", (Throwable)e);
                }
            }
            return null;
        }
        try {
            Context ctx = JDBCPool.buildContext(meta);
            DataSource _datasource = (DataSource)ctx.lookup(ContextUtil.handleJndiName(jndiName));
            return _datasource;
        }
        catch (NamingException e) {
            log.warn("", (Throwable)e);
            throw e;
        }
    }

    public static DataSource find(String jndiName) throws NamingException {
        Map pools = SQLManager.getInstance().getPools();
        if (pools != null && pools.size() > 0) {
            Iterator its = pools.entrySet().iterator();
            String name = ContextUtil.handleJndiName(jndiName);
            Context ctx = null;
            while (its.hasNext()) {
                try {
                    DataSource _datasource;
                    Map.Entry ent = its.next();
                    JDBCPool pool = (JDBCPool)ent.getValue();
                    ctx = pool.ctx;
                    if (ctx == null || (_datasource = (DataSource)ctx.lookup(name)) == null) continue;
                    return _datasource;
                }
                catch (NamingException e) {
                    log.warn("", (Throwable)e);
                }
            }
            return null;
        }
        Context ctx = JDBCPool.buildContext(null);
        DataSource _datasource = (DataSource)ctx.lookup(ContextUtil.handleJndiName(jndiName));
        return _datasource;
    }

    public JDBCPool(JDBCPoolMetaData metad) {
        this.initctx(metad);
        this.deployedDataSource = false;
        this.info = metad;
        if (StringUtil.isNotEmpty((String)this.info.getIdGenerator())) {
            try {
                this.idGenerator = (IdGenerator)Class.forName(this.info.getIdGenerator()).newInstance();
            }
            catch (Exception e) {
                log.info("\u521d\u59cb\u5316\u4e3b\u952e\u751f\u6210\u4e2a\u5668\u5931\u8d25\uff1a" + this.info.getIdGenerator() + ",\u4f7f\u7528\u9ed8\u8ba4com.frameworkset.common.poolman.sql.BBossUuidGenerator.");
                this.idGenerator = new BBossUuidGenerator();
            }
        } else {
            this.idGenerator = new BBossUuidGenerator();
        }
        if (null == this.info.getJNDIName() || this.info.getJNDIName().equals("")) {
            log.debug("JDBCPool[" + this.info.getDbname() + "]: No JNDI name specified, The DataSource will not be binded to NamingContext.");
        } else {
            log.debug("JDBCPool[" + this.info.getDbname() + "]:INNER JNDI Name is " + this.info.getJNDIName());
        }
        if (this.info.getInterceptor() != null && !this.info.getInterceptor().equals("") && !this.info.getInterceptor().equals(defaultInterceptor_s)) {
            try {
                this.interceptor = (InterceptorInf)Class.forName(this.info.getInterceptor()).newInstance();
            }
            catch (InstantiationException e) {
                log.warn(this.info.getInterceptor(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn(this.info.getInterceptor(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.warn(this.info.getInterceptor(), (Throwable)e);
            }
        }
        this.startPool();
    }

    public String statusChecker() {
        return this.status;
    }

    public void startPool() {
        if (this.status.equals("start")) {
            return;
        }
        if (!(this.status.equals("stop") || this.status.equals("unknown") || this.status.equals("failed"))) {
            return;
        }
        this.initDBAdapter();
        if (this.datasource != null) {
            try {
                DatasourceUtil.closeDS(this.datasource);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.datasource = null;
        }
        try {
            this.setUpCommonPool();
            this.startTime = System.currentTimeMillis();
            this.status = "start";
            this.init();
            this.initDBProductInfo();
            log.debug("Load Database Meta Data=" + this.info.getLoadmetadata());
            if (this.info.getLoadmetadata() != null && this.info.getLoadmetadata().equalsIgnoreCase("true") && !this.inited) {
                log.debug("Load Database[" + this.info.getName() + "] Meta Data beginning.....");
                if (this.externalDBName == null) {
                    try {
                        this.initDatabaseMetaData(null);
                    }
                    finally {
                        this.inited = true;
                    }
                } else {
                    this.inited = true;
                }
                log.debug("Load Database[" + this.info.getName() + "] Meta Data success.");
            } else {
                log.debug("Ignore Load Database[" + this.info.getName() + "] Meta Data .");
            }
        }
        catch (Exception e) {
            this.status = "failed";
            log.error("initializing JDBCPool[" + this.info.getName() + "] failed:", (Throwable)e);
        }
    }

    private void initDBProductInfo() {
        Connection conn = null;
        try {
            conn = this.requestConnection();
            DatabaseMetaData md = conn.getMetaData();
            this.info.setDatabaseProductName(md.getDatabaseProductName());
            this.info.setDatabaseProductVersion(md.getDatabaseProductVersion());
            this.info.setDriverName(md.getDriverName());
            this.info.setDriverVersion(md.getDriverVersion());
            md = null;
        }
        catch (Exception e) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.warn("con close failed:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTableMetaData(String tableName) {
        if (this.externalDBName == null) {
            Connection con = null;
            ResultSet rs = null;
            ResultSet columnrs = null;
            ResultSet primaryKeysrs = null;
            DatabaseMetaData metaData = null;
            ResultSet foreignrs = null;
            try {
                con = this.requestConnection();
                metaData = con.getMetaData();
                String schemaName = this.getSchemaName_(metaData, this.getDbAdapter().getSchema(this.info));
                TableMetaData tableMetaData = null;
                String catalog = this.getDbAdapter().getDBCatalog(con);
                rs = metaData.getTables(catalog, schemaName, tableName.toUpperCase(), new String[]{"TABLE", "VIEW"});
                while (rs.next()) {
                    tableName = rs.getString("TABLE_NAME");
                    String tableType = rs.getString("TABLE_TYPE");
                    tableMetaData = new TableMetaData();
                    tableMetaData.setTableName(tableName);
                    tableMetaData.setTableType(tableType);
                    try {
                        String tableRemark = rs.getString("REMARKS");
                        tableRemark = this.getDbAdapter().getTableRemarks(con, tableName, tableRemark);
                        tableMetaData.setRemarks(tableRemark);
                    }
                    catch (Exception tableRemark) {
                        // empty catch block
                    }
                    columnrs = metaData.getColumns(catalog, schemaName, tableName, "%");
                    while (columnrs.next()) {
                        ColumnMetaData column = new ColumnMetaData(this.getDbAdapter());
                        try {
                            column.setColumnName(columnrs.getString("COLUMN_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            column.setColunmSize(columnrs.getInt("COLUMN_SIZE"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            column.setTypeName(columnrs.getString("TYPE_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            column.setIsNullable(columnrs.getString("IS_NULLABLE"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            column.setDECIMAL_DIGITS(columnrs.getInt("DECIMAL_DIGITS"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            column.setColumnDefaultValue(columnrs.getString("COLUMN_DEF"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            column.setNumPrecRadix(columnrs.getInt("NUM_PREC_RADIX"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            column.setDataType(columnrs.getInt("DATA_TYPE"), column.getTypeName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            column.setCHAR_OCTET_LENGTH(columnrs.getInt("CHAR_OCTET_LENGTH"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            String remarks_c = columnrs.getString("REMARKS");
                            remarks_c = this.getDbAdapter().getColumnRemarks(con, tableName, column.getColumnName(), remarks_c);
                            column.setRemarks(remarks_c);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        tableMetaData.addColumns(column);
                    }
                    columnrs.close();
                    primaryKeysrs = metaData.getPrimaryKeys(catalog, schemaName, tableName);
                    while (primaryKeysrs.next()) {
                        PrimaryKeyMetaData primaryKeyMetaData = new PrimaryKeyMetaData(this.getDbAdapter());
                        try {
                            primaryKeyMetaData.setColumnName(primaryKeysrs.getString("COLUMN_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            primaryKeyMetaData.setPkName(primaryKeysrs.getString("PK_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            primaryKeyMetaData.setKeySEQ(primaryKeysrs.getInt("KEY_SEQ"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        primaryKeyMetaData.setColumn(tableMetaData.getColumnMetaData(primaryKeyMetaData.getColumnName().toLowerCase()));
                        tableMetaData.addPrimaryKey(primaryKeyMetaData);
                    }
                    primaryKeysrs.close();
                    foreignrs = metaData.getImportedKeys(catalog, schemaName, tableName);
                    while (foreignrs.next()) {
                        ForeignKeyMetaData foreignKeyMetaData = new ForeignKeyMetaData(this.getDbAdapter());
                        try {
                            foreignKeyMetaData.setPKTABLE_NAME(foreignrs.getString("PKTABLE_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setPKCOLUMN_NAME(foreignrs.getString("PKCOLUMN_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setFKTABLE_NAME(foreignrs.getString("FKTABLE_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setFKCOLUMN_NAME(foreignrs.getString("FKCOLUMN_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setColumnName(foreignrs.getString("FKCOLUMN_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setKEY_SEQ(foreignrs.getString("KEY_SEQ"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setUPDATE_RULE(foreignrs.getInt("UPDATE_RULE"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setDELETE_RULE(foreignrs.getInt("DELETE_RULE"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setFK_NAME(foreignrs.getString("FK_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setPK_NAME(foreignrs.getString("PK_NAME"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            foreignKeyMetaData.setDEFERRABILITY(foreignrs.getString("DEFERRABILITY"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        foreignKeyMetaData.setColumn(tableMetaData.getColumnMetaData(foreignKeyMetaData.getColumnName().toLowerCase()));
                        tableMetaData.addForeignKey(foreignKeyMetaData);
                    }
                    foreignrs.close();
                    this.tableMetaDatasindexByTablename.put(tableName.toLowerCase(), tableMetaData);
                    this.tableMetaDatas.add(tableMetaData);
                }
                rs.close();
            }
            catch (SQLException e) {
                log.warn("", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (columnrs != null) {
                        columnrs.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (primaryKeysrs != null) {
                        primaryKeysrs.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (foreignrs != null) {
                        foreignrs.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception e) {}
            }
        } else {
            SQLManager.getInstance().getPool(this.externalDBName).updateTableMetaData(tableName);
        }
    }

    public String getDatabaseSchema(DatabaseMetaData databaseMetaData) throws Throwable {
        return this.getSchemaName_(databaseMetaData, this.getDbAdapter().getSchema(this.info));
    }

    public void refreshDatabaseMetaData() {
        this.refreshDatabaseMetaData(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDatabaseMetaData(int limit) {
        ResultSet rs = null;
        DatabaseMetaData metaData = null;
        Connection con = null;
        try {
            this.tableMetaDatasindexByTablename.clear();
            this.tableMetaDatas.clear();
            con = this.requestConnection();
            metaData = con.getMetaData();
            String schemaName = this.getSchemaName_(metaData, this.getDbAdapter().getSchema(this.info));
            rs = metaData.getTables(this.getDbAdapter().getDBCatalog(con), schemaName, "%", new String[]{"TABLE", "VIEW"});
            int count = 0;
            while (rs.next() && (limit <= 0 || count <= limit)) {
                String tableName = rs.getString("TABLE_NAME");
                if (tableName.startsWith("BIN$")) continue;
                if (this.tableMetaDatasindexByTablename.containsKey(tableName.toLowerCase())) {
                    log.info("table [" + tableName + "] \u5df2\u7ecf\u52a0\u8f7d\uff0c\u5ffd\u7565\uff01");
                    continue;
                }
                log.debug("load table[" + tableName + "]'s metadata.");
                TableMetaData tableMetaData = this.buildTableMetaData(con, rs, metaData, true);
                if (tableMetaData == null) continue;
                this.tableMetaDatasindexByTablename.put(tableName.toLowerCase(), tableMetaData);
                this.tableMetaDatas.add(tableMetaData);
                ++count;
            }
            rs.close();
        }
        catch (SQLException e) {
            log.warn("", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void initDatabaseMetaData(Connection con) {
        this.initDatabaseMetaData(con, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabaseMetaData(Connection con, int limit) {
        ResultSet rs = null;
        DatabaseMetaData metaData = null;
        try {
            if (con == null) {
                con = this.requestConnection();
            }
            metaData = con.getMetaData();
            String schemaName = this.getSchemaName_(metaData, this.getDbAdapter().getSchema(this.info));
            rs = metaData.getTables(this.getDbAdapter().getDBCatalog(con), schemaName, "%", new String[]{"TABLE", "VIEW"});
            int count = 0;
            while (rs.next() && (limit <= 0 || count <= limit)) {
                String tableName = rs.getString("TABLE_NAME");
                if (tableName.startsWith("BIN$")) continue;
                if (this.tableMetaDatasindexByTablename.containsKey(tableName.toLowerCase())) {
                    log.info("table [" + tableName + "] \u5df2\u7ecf\u52a0\u8f7d\uff0c\u5ffd\u7565\uff01");
                    continue;
                }
                log.debug("load table[" + tableName + "]'s metadata.");
                TableMetaData tableMetaData = this.buildTableMetaData(con, rs, metaData, true);
                if (tableMetaData == null) continue;
                this.tableMetaDatasindexByTablename.put(tableName.toLowerCase(), tableMetaData);
                this.tableMetaDatas.add(tableMetaData);
                ++count;
            }
            rs.close();
        }
        catch (SQLException e) {
            log.warn("", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public TableMetaData getTableMetaDataFromDatabase(String tableName) {
        return this.getTableMetaDataFromDatabase(null, tableName);
    }

    private String[] convertTableTypes(String[] tableTypes) {
        if (tableTypes == null || tableTypes.length == 0) {
            return new String[]{"TABLE", "VIEW"};
        }
        for (int i = 0; i < tableTypes.length; ++i) {
            if (!tableTypes[i].equals(TABLE_TYPE_ALL)) continue;
            return new String[]{"TABLE", "VIEW"};
        }
        return tableTypes;
    }

    public List<TableMetaData> getTablesFromDatabase(String tableNamePattern) {
        return this.getTablesFromDatabase(null, tableNamePattern);
    }

    public List<TableMetaData> getTablesFromDatabase(String tableNamePattern, String[] tableTypes) {
        return this.getTablesFromDatabase(null, tableNamePattern, tableTypes);
    }

    public List<TableMetaData> getTablesFromDatabase(Connection con) {
        return this.getTablesFromDatabase(con, (String)null);
    }

    public List<TableMetaData> getTablesFromDatabase(Connection con, String[] tabletypes) {
        return this.getTablesFromDatabase(con, (String)null, tabletypes);
    }

    public List<TableMetaData> getTablesFromDatabase(Connection con, String tableNamePattern) {
        return this.getTablesFromDatabase(con, tableNamePattern, null);
    }

    public List<TableMetaData> getTablesFromDatabase(Connection con, String tableNamePattern, String[] tableTypes) {
        return this.getTablesFromDatabase(con, tableNamePattern, tableTypes, false);
    }

    public List<TableMetaData> getTablesFromDatabase() {
        return this.getTablesFromDatabase((Connection)null);
    }

    public List<TableMetaData> getTablesFromDatabase(String[] tabletypes) {
        return this.getTablesFromDatabase((Connection)null, tabletypes);
    }

    public List<TableMetaData> getTablesFromDatabase(String tableNamePattern, boolean loadColumns) {
        return this.getTablesFromDatabase(null, tableNamePattern, loadColumns);
    }

    public List<TableMetaData> getTablesFromDatabase(String tableNamePattern, String[] tableTypes, boolean loadColumns) {
        return this.getTablesFromDatabase(null, tableNamePattern, tableTypes, loadColumns);
    }

    public List<TableMetaData> getTablesFromDatabase(Connection con, boolean loadColumns) {
        return this.getTablesFromDatabase(con, (String)null, loadColumns);
    }

    public List<TableMetaData> getTablesFromDatabase(Connection con, String[] tabletypes, boolean loadColumns) {
        return this.getTablesFromDatabase(con, null, tabletypes, loadColumns);
    }

    public List<TableMetaData> getTablesFromDatabase(Connection con, String tableNamePattern, boolean loadColumns) {
        return this.getTablesFromDatabase(con, tableNamePattern, null, loadColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableMetaData> getTablesFromDatabase(Connection con, String tableNamePattern, String[] tableTypes, boolean loadColumns) {
        ArrayList<TableMetaData> tableMetaDatas = new ArrayList<TableMetaData>();
        ResultSet rs = null;
        DatabaseMetaData metaData = null;
        boolean outcon = true;
        JDBCTransaction tx = null;
        try {
            if (con == null) {
                tx = TransactionManager.getTransaction();
                con = tx == null ? this.requestConnection() : tx.getConnection(this.getDBName());
                outcon = false;
            }
            metaData = con.getMetaData();
            String schemaName = this.getSchemaName_(metaData, this.getDbAdapter().getSchema(this.info));
            String temp = this.getDbAdapter().getSchemaTableTableName(this.info, tableNamePattern);
            rs = metaData.getTables(this.getDbAdapter().getDBCatalog(con), schemaName, temp == null ? "%" : temp, this.convertTableTypes(tableTypes));
            while (rs.next()) {
                TableMetaData tableMetaData = this.buildTableMetaData(con, rs, metaData, loadColumns);
                if (tableMetaData == null) continue;
                tableMetaDatas.add(tableMetaData);
            }
            rs.close();
        }
        catch (SQLException e) {
            log.warn("", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (con != null && !outcon && tx == null) {
                    con.close();
                }
            }
            catch (Exception e) {}
            con = null;
        }
        return tableMetaDatas;
    }

    public List<TableMetaData> getTablesFromDatabase(boolean loadColumns) {
        return this.getTablesFromDatabase((Connection)null, loadColumns);
    }

    public List<TableMetaData> getTablesFromDatabase(String[] tabletypes, boolean loadColumns) {
        return this.getTablesFromDatabase((Connection)null, tabletypes, loadColumns);
    }

    private TableMetaData buildTableMetaData(Connection con, ResultSet rs, DatabaseMetaData metaData, boolean loadColumns) throws SQLException {
        ResultSet columnrs = null;
        ResultSet primaryKeysrs = null;
        ResultSet foreignrs = null;
        String tableName = rs.getString("TABLE_NAME");
        if (tableName.startsWith("BIN$")) {
            return null;
        }
        log.debug("load table[" + tableName + "]'s metadata.");
        String tableType = rs.getString("TABLE_TYPE");
        TableMetaData tableMetaData = new TableMetaData();
        tableMetaData.setTableName(tableName);
        tableMetaData.setTableType(tableType);
        try {
            String tableRemark = rs.getString("REMARKS");
            tableRemark = this.getDbAdapter().getTableRemarks(con, tableName, tableRemark);
            tableMetaData.setRemarks(tableRemark);
        }
        catch (Exception tableRemark) {
            // empty catch block
        }
        String schemaName = this.getSchemaName_(metaData, this.getDbAdapter().getSchema(this.info));
        String catalog = this.getDbAdapter().getDBCatalog(con);
        if (loadColumns) {
            try {
                columnrs = metaData.getColumns(catalog, schemaName, tableName, "%");
                while (columnrs.next()) {
                    ColumnMetaData column = new ColumnMetaData(this.getDbAdapter());
                    try {
                        column.setColumnName(columnrs.getString("COLUMN_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setColunmSize(columnrs.getInt("COLUMN_SIZE"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setTypeName(columnrs.getString("TYPE_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setIsNullable(columnrs.getString("IS_NULLABLE"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setColumnDefaultValue(columnrs.getString("COLUMN_DEF"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setNumPrecRadix(columnrs.getInt("NUM_PREC_RADIX"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setDataType(columnrs.getInt("DATA_TYPE"), column.getTypeName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setDECIMAL_DIGITS(columnrs.getInt("DECIMAL_DIGITS"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        column.setNumPrecRadix(columnrs.getInt("NUM_PREC_RADIX"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        String remarks_c = columnrs.getString("REMARKS");
                        remarks_c = this.getDbAdapter().getColumnRemarks(con, tableName, column.getColumnName(), remarks_c);
                        column.setRemarks(remarks_c);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    tableMetaData.addColumns(column);
                }
                columnrs.close();
            }
            catch (Exception e) {
                columnrs.close();
                columnrs = null;
                log.warn("", (Throwable)e);
            }
            try {
                primaryKeysrs = metaData.getPrimaryKeys(catalog, schemaName, tableName);
                while (primaryKeysrs.next()) {
                    PrimaryKeyMetaData primaryKeyMetaData = new PrimaryKeyMetaData(this.getDbAdapter());
                    try {
                        primaryKeyMetaData.setColumnName(primaryKeysrs.getString("COLUMN_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        primaryKeyMetaData.setPkName(primaryKeysrs.getString("PK_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        primaryKeyMetaData.setKeySEQ(primaryKeysrs.getInt("KEY_SEQ"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    primaryKeyMetaData.setColumn(tableMetaData.getColumnMetaData(primaryKeyMetaData.getColumnName().toLowerCase()));
                    tableMetaData.addPrimaryKey(primaryKeyMetaData);
                }
                primaryKeysrs.close();
                primaryKeysrs = null;
            }
            catch (Exception e) {
                primaryKeysrs.close();
                primaryKeysrs = null;
                log.warn("", (Throwable)e);
            }
            try {
                foreignrs = metaData.getImportedKeys(catalog, schemaName, tableName);
                while (foreignrs.next()) {
                    ForeignKeyMetaData foreignKeyMetaData = new ForeignKeyMetaData(this.getDbAdapter());
                    try {
                        foreignKeyMetaData.setPKTABLE_NAME(foreignrs.getString("PKTABLE_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setPKCOLUMN_NAME(foreignrs.getString("PKCOLUMN_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setFKTABLE_NAME(foreignrs.getString("FKTABLE_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setFKCOLUMN_NAME(foreignrs.getString("FKCOLUMN_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setColumnName(foreignrs.getString("FKCOLUMN_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setKEY_SEQ(foreignrs.getString("KEY_SEQ"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setUPDATE_RULE(foreignrs.getInt("UPDATE_RULE"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setDELETE_RULE(foreignrs.getInt("DELETE_RULE"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setFK_NAME(foreignrs.getString("FK_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setPK_NAME(foreignrs.getString("PK_NAME"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        foreignKeyMetaData.setDEFERRABILITY(foreignrs.getString("DEFERRABILITY"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    foreignKeyMetaData.setColumn(tableMetaData.getColumnMetaData(foreignKeyMetaData.getColumnName().toLowerCase()));
                    tableMetaData.addForeignKey(foreignKeyMetaData);
                }
                foreignrs.close();
            }
            catch (Exception e) {
                foreignrs.close();
                foreignrs = null;
                log.warn("", (Throwable)e);
            }
        }
        return tableMetaData;
    }

    private String getSchemaName_(DatabaseMetaData metaData, String schemaName) throws SQLException {
        if (schemaName == null) {
            schemaName = metaData.getUserName();
        } else if (schemaName == "NULL_SCHEMA") {
            schemaName = null;
        }
        return schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetaData getTableMetaDataFromDatabase(Connection con, String tableName) {
        if (this.externalDBName == null) {
            ResultSet rs = null;
            DatabaseMetaData metaData = null;
            TableMetaData tableMetaData = null;
            boolean outcon = true;
            JDBCTransaction tx = null;
            try {
                if (con == null) {
                    tx = TransactionManager.getTransaction();
                    con = tx == null ? this.requestConnection() : tx.getConnection(this.getDBName());
                    outcon = false;
                }
                metaData = con.getMetaData();
                String schemaName = this.getSchemaName_(metaData, this.getDbAdapter().getSchema(this.info));
                rs = metaData.getTables(this.getDbAdapter().getDBCatalog(con), schemaName, this.getDbAdapter().getSchemaTableTableName(this.info, tableName), new String[]{"TABLE", "VIEW"});
                while (rs.next()) {
                    tableMetaData = this.buildTableMetaData(con, rs, metaData, true);
                    if (tableMetaData == null) continue;
                    this.tableMetaDatasindexByTablename.put(tableMetaData.getTableName().toLowerCase(), tableMetaData);
                    this.tableMetaDatas.add(tableMetaData);
                }
                rs.close();
            }
            catch (SQLException e) {
                log.warn("", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (con != null && !outcon && tx == null) {
                        con.close();
                    }
                }
                catch (Exception e) {}
                con = null;
            }
            return tableMetaData;
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getTableMetaDataFromDatabase(con, tableName);
    }

    public void init() throws Exception {
        this.deployDataSource();
    }

    public void setDataSource(PoolManDataSource ds) {
        this.datasource = ds;
    }

    public DataSource getDataSource() {
        if (this.datasource == null) {
            log.info(this.info.getDbname() + " has no associated DataSource.");
            throw new NullPointerException(this.info.getDbname() + " has no associated DataSource.");
        }
        return this.datasource;
    }

    public void deployDataSource() {
        if (this.datasource == null || this.info.getJNDIName() == null || this.info.getJNDIName().equals("")) {
            return;
        }
        try {
            log.debug("Bind the DataSource view of this pool to JNDI");
            String jndiName = this.info.getJNDIName();
            if (!this.exist(this.ctx, jndiName, this.info)) {
                this.bind(this.ctx, jndiName, this.datasource, this.info);
            }
            this.deployedDataSource = true;
            log.info("DataSource bound to JNDI under name[" + jndiName + "]");
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Context ctx, String name, Object val, JDBCPoolMetaData meta) throws NamingException {
        try {
            this.initctx(meta);
            ctx.rebind(name, val);
            log.debug("binding datasource  to container context  with: " + name);
        }
        catch (Exception e) {
            Name n = ctx.getNameParser("").parse(name);
            while (n.size() > 1) {
                String ctxName = n.get(0);
                Context subctx = null;
                try {
                    log.debug("lookup: " + ctxName);
                    subctx = (Context)ctx.lookup(ctxName);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                if (subctx != null) {
                    log.debug("Found subcontext: " + ctxName);
                    ctx = subctx;
                } else {
                    log.info("Creating subcontext: " + ctxName);
                    ctx = ctx.createSubcontext(ctxName);
                }
                n = n.getSuffix(1);
            }
            log.debug("binding: " + n);
            ctx.rebind(n, val);
        }
        finally {
            this.dummyctx.rebind(name, val);
            log.debug("Bound name " + name + " to dummy context.");
        }
    }

    private boolean exist(Context ctx, String jndiName, JDBCPoolMetaData meta) {
        try {
            this.initctx(meta);
            ctx = this.ctx;
            DataSource datasource = this.find_(ContextUtil.handleJndiName(jndiName));
            if (datasource == null) {
                return false;
            }
            log.info("DataSource bound to JNDI under name[{}]", (Object)jndiName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void undeployDataSource() throws Exception {
        if (this.datasource == null || this.info.getJNDIName() == null || this.info.getJNDIName().equals("")) {
            return;
        }
        try {
            DatasourceUtil.closeDS(this.datasource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.ctx != null) {
                this.ctx.unbind(this.info.getJNDIName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.deployedDataSource = false;
    }

    public boolean isDataSourceDeployed() {
        return this.deployedDataSource;
    }

    public boolean usingCache() {
        return true;
    }

    public void refreshCache() {
    }

    public String getDriver() {
        return this.info.getDriver();
    }

    public String getURL() {
        if (this.externalDBName == null) {
            return this.info.getURL();
        }
        JDBCPoolMetaData meta = SQLManager.getInstance().getJDBCPoolMetaData(this.externalDBName);
        if (meta != null) {
            return meta.getURL();
        }
        return this.info.getURL();
    }

    public String getUserName() {
        if (this.externalDBName == null) {
            return this.info.getUserName();
        }
        JDBCPoolMetaData meta = SQLManager.getInstance().getJDBCPoolMetaData(this.externalDBName);
        if (meta != null) {
            return meta.getUserName();
        }
        return this.info.getUserName();
    }

    public String getPassword() {
        if (this.externalDBName == null) {
            return this.info.getPassword();
        }
        JDBCPoolMetaData meta = SQLManager.getInstance().getJDBCPoolMetaData(this.externalDBName);
        if (meta != null) {
            return meta.getPassword();
        }
        return this.info.getPassword();
    }

    public int getTransactionIsolation() {
        if (this.externalDBName == null) {
            return this.info.getIsolationLevel();
        }
        JDBCPoolMetaData meta = SQLManager.getInstance().getJDBCPoolMetaData(this.externalDBName);
        if (meta != null) {
            return meta.getIsolationLevel();
        }
        return this.info.getIsolationLevel();
    }

    public String getKeygenerate() {
        if (this.externalDBName == null) {
            return this.info.getKeygenerate();
        }
        JDBCPoolMetaData meta = SQLManager.getInstance().getJDBCPoolMetaData(this.externalDBName);
        if (meta != null) {
            return meta.getKeygenerate();
        }
        return this.info.getKeygenerate();
    }

    public String getDBType() {
        return this.getDbAdapter().getDBTYPE();
    }

    public boolean isUsingNativeResults() {
        return this.info.isNativeResults();
    }

    public void checkCredentials(String username, String password) throws SQLException {
        if (this.externalDBName == null) {
            if (this.info.getUserName().equals(username) && this.info.getPassword().equals(password)) {
                log.debug("Invalid Username/Password: " + username + "/" + password);
                throw new SQLException("Invalid Username/Password: " + username + "/" + password);
            }
        } else {
            SQLManager.getInstance().getPool(this.externalDBName).checkCredentials(username, password);
        }
    }

    public Connection requestConnection() throws SQLException {
        if (this.datasource != null) {
            if (!(this.datasource instanceof TXDataSource)) {
                return this.datasource.getConnection();
            }
            return ((TXDataSource)this.datasource).getSRCDataSource().getConnection();
        }
        if (this.isExternal()) {
            if (this.externalDBName == null) {
                throw new NestedSQLException("Request Connection failed:DB Pool[dbname=" + this.info.getDbname() + ",jndiname=" + this.info.getJNDIName() + ",extenerjndiname=" + this.info.getExternaljndiName() + "] is stopped or not inited. Please restarted the pool.");
            }
            return SQLManager.getInstance().getPool(this.externalDBName).requestConnection();
        }
        throw new NestedSQLException("Request Connection failed:DB Pool[" + this.info.getDbname() + "] is stopped. Please restarted the pool.");
    }

    public int getNumActive() {
        if (this.externalDBName == null) {
            return DatasourceUtil.getNumActive(this.datasource);
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getNumActive();
    }

    public List<AbandonedTraceExt> getGoodTraceObjects() {
        if (this.externalDBName == null) {
            return DatasourceUtil.getGoodTraceObjects(this.datasource);
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getGoodTraceObjects();
    }

    private DataSource getSRCDataSource(TXDataSource ds) {
        return ds.getSRCDataSource();
    }

    public int getMaxNumActive() {
        if (this.externalDBName == null) {
            return DatasourceUtil.getMaxNumActive(this.datasource);
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getMaxNumActive();
    }

    public long getMaxActiveNumTime() {
        if (this.externalDBName == null) {
            return DatasourceUtil.getMaxActiveNumTime(this.datasource);
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getMaxActiveNumTime();
    }

    public int getNumIdle() {
        if (this.externalDBName == null) {
            return DatasourceUtil.getNumIdle(this.datasource);
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getNumIdle();
    }

    public void stopPool() throws Exception {
        this.closeAllResources();
    }

    public void closeAllResources() throws Exception {
        if (this.status.equals("stop")) {
            return;
        }
        if (!this.status.equals("start")) {
            return;
        }
        log.debug("Shutdown datasource[" + this.getDBName() + "] start.");
        this.undeployDataSource();
        this.stopTime = System.currentTimeMillis();
        this.status = "stop";
        if (this.tableMetaDatas != null) {
            try {
                this.tableMetaDatas.clear();
                this.tableMetaDatas = new TreeSet();
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
        }
        if (this.tableMetaDatasindexByTablename != null) {
            this.tableMetaDatasindexByTablename.clear();
        }
        this.datasource = null;
        this.inited = false;
        log.debug("Shutdown datasource[" + this.getDBName() + "] ok.");
    }

    public static void closeResources(Connection con, Statement statement, ResultSet resultset) {
        JDBCPool.closeResultSet(resultset);
        JDBCPool.closeStatement(statement);
        JDBCPool.closeConnection(con);
    }

    public static void closeResources(Statement statement, ResultSet resultSet) {
        JDBCPool.closeResultSet(resultSet);
        JDBCPool.closeStatement(statement);
    }

    public static void closeConnection(Connection con) {
        try {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        con = null;
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement = null;
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        rs = null;
    }

    public DB getDbAdapter() {
        if (this.externalDBName == null) {
            return this.dbAdapter;
        }
        return SQLManager.getInstance().getDBAdapter(this.externalDBName);
    }

    public String getDBName() {
        return this.info.getDbname();
    }

    public Set getTableMetaDatas() {
        return this.getTableMetaDatas(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTableMetaDatas(int limit) {
        if (this.externalDBName == null) {
            String load = this.info.getLoadmetadata();
            if (load.equalsIgnoreCase("false") && !this.inited) {
                Set set = this.tableMetaDatas;
                synchronized (set) {
                    if (!this.inited) {
                        try {
                            this.initDatabaseMetaData(null, limit);
                            this.inited = true;
                        }
                        catch (Exception e) {
                            this.inited = true;
                        }
                    }
                }
            }
            return this.tableMetaDatas;
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getTableMetaDatas(limit);
    }

    public boolean isRobotQuery() {
        return this.info.isRobotquery();
    }

    public JDBCPoolMetaData getJDBCPoolMetadata() {
        return this.info;
    }

    public String getStatus() {
        if (this.externalDBName == null) {
            return this.status;
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getStatus();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getStartTime() {
        if (this.externalDBName == null) {
            return this.startTime;
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getStartTime();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStopTime() {
        if (this.externalDBName == null) {
            return this.stopTime;
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getStopTime();
    }

    public InterceptorInf getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(InterceptorInf interceptor) {
        this.interceptor = interceptor;
    }

    public boolean isExternal() {
        return this.getJDBCPoolMetadata().isExternal();
    }

    public String getExternalDBName() {
        return this.externalDBName;
    }

    public boolean isAutoprimarykey() {
        return this.info.getAutoprimarykey();
    }

    public boolean showsql() {
        return this.info.isShowsql();
    }

    public boolean showsqlParams() {
        return this.info.isShowsqlParams();
    }

    public IdGenerator getIdGenerator() {
        if (this.externalDBName == null) {
            return this.idGenerator;
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getIdGenerator();
    }

    public boolean getRETURN_GENERATED_KEYS() {
        if (this.externalDBName == null) {
            return this.info.getRETURN_GENERATED_KEYS();
        }
        return SQLManager.getInstance().getPool(this.externalDBName).getRETURN_GENERATED_KEYS();
    }

    public void increamentMaxTotalConnections(int nums) {
        if (this.datasource != null) {
            DatasourceUtil.increamentMaxTotalConnections(this.datasource, nums);
        }
    }
}

